/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.sun.identity.tools.bundles.CopyUtils;
import com.sun.identity.tools.bundles.GeneralFileFilter;
import com.sun.identity.tools.bundles.SetupConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SetupUtils
implements SetupConstants {
    private SetupUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName) throws IOException {
        Properties prop = new Properties();
        FileInputStream propIn = new FileInputStream(fileName);
        try {
            prop.load(propIn);
        }
        finally {
            ((InputStream)propIn).close();
        }
        return prop;
    }

    public static String getUserInput(String message) throws IOException {
        String userInput = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(message);
        userInput = in.readLine();
        return userInput;
    }

    public static Properties getTokens(ResourceBundle bundle, Properties confProp) {
        String currentOS = SetupUtils.determineOS();
        String tokenString = bundle.getString(currentOS + ".token");
        int tokensOffset = 0;
        int commaIndex = tokenString.indexOf(",", tokensOffset);
        String tempVarName = null;
        String tempVarValue = null;
        Properties tokens = new Properties();
        while (true) {
            if (commaIndex <= tokensOffset) {
                if (tokensOffset >= tokenString.length() || (tempVarName = tokenString.substring(tokensOffset, tokenString.length()).trim()).length() <= 0) break;
                try {
                    tempVarValue = bundle.getString(currentOS + "." + tempVarName);
                }
                catch (MissingResourceException ex) {
                    tempVarValue = bundle.getString(tempVarName);
                }
                tempVarValue = SetupUtils.evaluatePropertiesValue(tempVarValue, confProp);
                if (tempVarValue == null) break;
                tokens.setProperty(tempVarName, tempVarValue);
                break;
            }
            tempVarName = tokenString.substring(tokensOffset, commaIndex).trim();
            try {
                tempVarValue = bundle.getString(currentOS + "." + tempVarName);
            }
            catch (MissingResourceException ex) {
                tempVarValue = bundle.getString(tempVarName);
            }
            tempVarValue = SetupUtils.evaluatePropertiesValue(tempVarValue, confProp);
            if (tempVarValue != null) {
                tokens.setProperty(tempVarName, tempVarValue);
            }
            tokensOffset = commaIndex + 1;
            commaIndex = tokenString.indexOf(",", tokensOffset);
        }
        return tokens;
    }

    public static String evaluatePropertiesValue(String value, Properties lookupProp) {
        if (value == null) {
            return null;
        }
        String returnValue = value;
        if (lookupProp != null) {
            boolean offset = false;
            int refPrefix = 0;
            int refSuffix = 0;
            String key = null;
            String realValue = null;
            while ((refPrefix = returnValue.indexOf("${")) >= 0 && (refSuffix = returnValue.indexOf("}")) > refPrefix) {
                key = returnValue.substring(refPrefix + "${".length(), refSuffix);
                if (lookupProp != null && lookupProp.containsKey(key)) {
                    realValue = lookupProp.getProperty(key);
                } else if (key.equals("BaseDir")) {
                    try {
                        realValue = new File(".").getCanonicalPath();
                    }
                    catch (IOException ignored) {}
                } else {
                    realValue = System.getProperty(key);
                }
                if (realValue == null) continue;
                if (realValue.indexOf("\\") >= 0) {
                    realValue = realValue.replaceAll("\\\\", "/");
                }
                returnValue = returnValue.replaceAll("[$]\\{" + key + "\\}", realValue);
            }
        }
        return returnValue;
    }

    public static void getFiles(File fromDir, File toDir, String fromFilePattern, String toFilePattern, LinkedList fromFilesList, LinkedList toFilesList) {
        File[] fromFiles = fromDir.listFiles(new GeneralFileFilter(fromFilePattern));
        for (int i = 0; i < fromFiles.length; ++i) {
            fromFilesList.addLast(fromFiles[i]);
            if (fromFiles[i].isDirectory()) {
                toFilesList.addLast(new File(toDir, fromFiles[i].getName()));
                SetupUtils.getFiles(fromFiles[i], new File(toDir, fromFiles[i].getName()), fromFilePattern, toFilePattern, fromFilesList, toFilesList);
                continue;
            }
            toFilesList.addLast(new File(toDir, SetupUtils.transformFileName(fromFilePattern, toFilePattern, fromFiles[i])));
        }
    }

    public static String determineOS() {
        if (OS_ARCH.toLowerCase().indexOf("86") >= 0) {
            if (OS_NAME.toLowerCase().indexOf("windows") >= 0) {
                return "windows";
            }
            if (OS_NAME.toLowerCase().indexOf("sunos") >= 0) {
                return "x86solaris";
            }
            return "linux";
        }
        return "solaris";
    }

    public static String transformFileName(String from, String to, File file) {
        return SetupUtils.transformFileName(from, to, file, '*');
    }

    public static String transformFileName(String from, String to, File file, char wildCard) {
        int i;
        if (file.isDirectory()) {
            return file.getName();
        }
        String fileName = file.getName();
        LinkedList<String> tokensToKeep = new LinkedList<String>();
        StringBuffer nameToReturn = new StringBuffer();
        String tempFrom = from.trim();
        String tempTo = to.trim();
        int fileNameOffset = 0;
        boolean matched = true;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < tempFrom.length(); ++i) {
            if (tempFrom.charAt(i) != wildCard) {
                buffer.append(tempFrom.charAt(i));
            }
            if (i != tempFrom.length() - 1 && tempFrom.charAt(i) != wildCard || buffer.length() <= 0) continue;
            int matchedIndex = fileName.indexOf(buffer.toString(), fileNameOffset);
            if (matchedIndex >= fileNameOffset) {
                if (matchedIndex != fileNameOffset) {
                    tokensToKeep.addLast(fileName.substring(fileNameOffset, matchedIndex));
                } else if (tempFrom.charAt(i) == wildCard && i == tempFrom.length() - 1 && matchedIndex + buffer.toString().length() < fileName.length()) {
                    tokensToKeep.addLast(fileName.substring(matchedIndex + buffer.toString().length(), fileName.length()));
                }
                if (i != tempFrom.length() - 1) {
                    fileNameOffset = matchedIndex + buffer.length();
                } else if (tempFrom.charAt(i) != wildCard && fileName.substring(matchedIndex).length() != buffer.length()) {
                    matched = false;
                    break;
                }
            } else {
                matched = false;
                break;
            }
            buffer = new StringBuffer();
        }
        if (matched) {
            for (i = 0; i < tempTo.length(); ++i) {
                if (tempTo.charAt(i) != wildCard) {
                    nameToReturn.append(tempTo.charAt(i));
                    continue;
                }
                if (tokensToKeep.size() <= 0) continue;
                nameToReturn.append(tokensToKeep.removeFirst());
            }
            return nameToReturn.toString();
        }
        return null;
    }

    public static void unzip(String srcFile, String destDir, boolean overwrite) throws IOException {
        File jmqDir = new File(destDir);
        if (!jmqDir.exists() || overwrite) {
            jmqDir.mkdirs();
            ZipFile zf = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            byte[] buffer = new byte[8192];
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) {
                    new File(destDir, ze.getName()).mkdirs();
                    continue;
                }
                File destFile = new File(destDir, ze.getName());
                File destParentFile = new File(destFile.getParent());
                destParentFile.mkdirs();
                FileOutputStream fout = new FileOutputStream(destFile);
                InputStream in = zf.getInputStream(ze);
                int byteRead = 0;
                while ((byteRead = in.read(buffer)) != -1) {
                    fout.write(buffer, 0, byteRead);
                }
                in.close();
                fout.close();
            }
        }
    }

    public static void ungzip(String srcFile, String destDir) throws IOException {
        String tempDestFileName = srcFile.substring(0, srcFile.lastIndexOf("."));
        tempDestFileName = tempDestFileName.substring(srcFile.lastIndexOf(FILE_SEPARATOR) + 1);
        File bdbDir = new File(destDir);
        if (!bdbDir.exists()) {
            bdbDir.mkdir();
            byte[] buffer = new byte[8192];
            GZIPInputStream gzin = new GZIPInputStream(new FileInputStream(srcFile));
            FileOutputStream fout = new FileOutputStream(new File(destDir, tempDestFileName));
            int byteRead = 0;
            while ((byteRead = gzin.read(buffer)) != -1) {
                fout.write(buffer, 0, byteRead);
            }
            gzin.close();
            fout.close();
        }
    }

    public static void printUsage(ResourceBundle bundle) {
        System.out.println(bundle.getString("message.info.usage"));
    }

    public static void evaluateBundleValues(ResourceBundle bundle, Properties lookupProp) {
        Enumeration<String> propNames = bundle.getKeys();
        while (propNames.hasMoreElements()) {
            String name = propNames.nextElement();
            String value = SetupUtils.evaluatePropertiesValue(bundle.getString(name), lookupProp);
            if (value == null) continue;
            lookupProp.setProperty(name, value);
        }
    }

    public static void copyAndFilterScripts(ResourceBundle bundle, Properties lookupProp) throws IOException {
        String currentOS = SetupUtils.determineOS();
        String fromFilePattern = lookupProp.getProperty(currentOS + ".fromfile");
        String toFilePattern = lookupProp.getProperty(currentOS + ".tofile");
        String tempFromDir = lookupProp.getProperty(currentOS + ".fromdir");
        String tempToDir = lookupProp.getProperty(currentOS + ".todir");
        File fromDir = new File(tempFromDir);
        File toDir = new File(tempToDir);
        if (toDir.isAbsolute()) {
            toDir = new File(toDir.getName());
        }
        Properties tokens = SetupUtils.getTokens(bundle, lookupProp);
        LinkedList fromFilesList = new LinkedList();
        LinkedList toFilesList = new LinkedList();
        SetupUtils.getFiles(fromDir, toDir, fromFilePattern, toFilePattern, fromFilesList, toFilesList);
        ListIterator srcIter = fromFilesList.listIterator();
        ListIterator destIter = toFilesList.listIterator();
        while (srcIter.hasNext() && destIter.hasNext()) {
            File srcFile = (File)srcIter.next();
            File destFile = (File)destIter.next();
            CopyUtils.copyFile(srcFile, destFile, tokens, true, false);
        }
        if (!currentOS.equals("windows")) {
            Process proc = Runtime.getRuntime().exec("/bin/chmod -R +x " + toDir.getName());
            try {
                if (proc.waitFor() != 0) {
                    System.out.println(bundle.getString("message.info.permission.scripts"));
                }
            }
            catch (InterruptedException ex) {
                System.out.println(bundle.getString("message.info.permission.scripts"));
            }
        }
        System.out.println(bundle.getString("message.info.success") + " " + new File(".").getCanonicalPath() + FILE_SEPARATOR + toDir.getName());
    }
}

