/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LDAPEventManager
implements IDSEventListener {
    protected static String listenerID;
    protected static ServerInstance serInstance;
    protected static Map changeListeners;
    protected static Debug eventDebug;
    Map listeners = null;
    protected static final int OPERATIONS = 15;
    protected static final String OC_SERVICE = "sunService";
    protected static final String OC_SERVICE_COMP = "sunServiceComponent";
    protected static final String SEARCH_FILTER = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";
    protected static Principal adminPrincipal;
    protected static boolean initialized;

    static void initialize() {
        try {
            serInstance = DSConfigMgr.getDSConfigMgr().getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            if (eventDebug.messageEnabled()) {
                eventDebug.message("LDAPEventManager:initialize Initialized LDAPEvent listener");
            }
            initialized = true;
        }
        catch (Exception e) {
            eventDebug.error("LDAPEventManager:initialize Unable to init LDAP listener", (Throwable)e);
        }
    }

    public LDAPEventManager() {
        if (!initialized) {
            LDAPEventManager.initialize();
        }
    }

    static synchronized String addObjectChangeListener(SMSObjectListener changeListener) {
        String id = SMSUtils.getUniqueID();
        if (!initialized) {
            LDAPEventManager.initialize();
        }
        changeListeners.put(id, changeListener);
        return id;
    }

    static synchronized void removeObjectChangeListener(String id) {
        changeListeners.remove(id);
    }

    public synchronized void entryChanged(DSEvent dsEvent) {
        int event = dsEvent.getEventType();
        String dn = dsEvent.getID();
        switch (event) {
            case 1: {
                event = 0;
                break;
            }
            case 2: 
            case 8: {
                event = 1;
                break;
            }
            case 4: {
                event = 3;
            }
        }
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEventListener::entry changed for: " + dn + " sending object changed notifications");
        }
        SMSEntry.objectChanged(dn, event);
    }

    public void eventError(String errorStr) {
        eventDebug.error("SMSEventListener.eventError(): " + errorStr);
    }

    public void allEntriesChanged() {
        eventDebug.error("LDAPEventManager: received all entries changed event from EventService");
        Iterator items = changeListeners.values().iterator();
        while (items.hasNext()) {
            SMSObjectListener ocl = (SMSObjectListener)items.next();
            ocl.allObjectsChanged();
        }
    }

    public String getBase() {
        return serInstance.getBaseDN();
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map listener) {
        this.listeners = listener;
    }

    static {
        changeListeners = new HashMap();
        eventDebug = Debug.getInstance((String)"amSMSEvent");
        adminPrincipal = new AuthPrincipal((String)AccessController.doPrivileged(new AdminDNAction()));
    }
}

