/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginSchema {
    protected PluginSchemaImpl psi;
    protected SSOToken token;
    protected String serviceName;
    protected String version;
    protected String pluginName;

    private PluginSchema() {
    }

    protected PluginSchema(SSOToken token, String serviceName, String version, String pluginName, String iName, String orgName) throws SMSException {
        this.psi = PluginSchemaImpl.getInstance(token, serviceName, version, pluginName, iName, orgName);
        if (this.psi == null) {
            throw new SMSException("amSDK", "sms-plugin-schema-name-not-found", null);
        }
        this.token = token;
        this.serviceName = serviceName;
        this.version = version;
        this.pluginName = pluginName;
    }

    public String getName() {
        return this.pluginName;
    }

    public String getInterfaceName() {
        return this.psi.getInterfaceName();
    }

    public String getClassName() {
        return this.psi.getClassName();
    }

    public String getJarURL() {
        return this.psi.getJarURL();
    }

    public String getI18NJarURL() {
        return this.psi.getI18NJarURL();
    }

    public String getI18NFileName() {
        return this.psi.getI18NFileName();
    }

    public String getPropertiesViewBeanURL() {
        return this.psi.getPropertiesViewBeanURL();
    }

    public void setPropertiesViewBeanURL(String url) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.psi.getPropertiesViewBeanURL();
        Document pluginDoc = this.getDocumentCopy();
        Node pNode = XMLUtils.getRootNode((Document)pluginDoc, (String)"PluginSchema");
        ((Element)pNode).setAttribute("propertiesViewBeanURL", url);
        pluginDoc.importNode(pNode, true);
        this.replacePluginSchema(pluginDoc);
        this.psi.viewBeanURL = url;
    }

    public String getI18NKey() {
        return this.psi.getI18NKey();
    }

    public Set getAttributeSchemaNames() {
        return this.psi.getAttributeSchemaNames();
    }

    public AttributeSchema getAttributeSchema(String attributeSchemaName) {
        AttributeSchemaImpl asi = this.psi.getAttributeSchema(attributeSchemaName);
        if (asi != null) {
            return new AttributeSchema(asi, this);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("PluginSchema name: " + this.getName()).append("\n\tInterface name: " + this.getInterfaceName()).append("\n\tClass name: " + this.getClassName()).append("\n\tJar URL: " + this.getJarURL()).append("\n\tI18N URL: " + this.getI18NJarURL()).append("\n\tI18N File name: " + this.getI18NFileName()).append("\n\tI18N Key: " + this.getI18NKey());
        Iterator i = this.getAttributeSchemaNames().iterator();
        while (i.hasNext()) {
            sb.append("\n").append(this.getAttributeSchema((String)i.next()));
        }
        return sb.toString();
    }

    protected Document getDocumentCopy() throws SMSException {
        return this.psi.getDocumentCopy();
    }

    protected Node getPluginSchemaNode(Document doc) throws SMSException {
        NodeList nodes = doc.getElementsByTagName("PluginSchema");
        if (nodes == null || nodes.getLength() == 0) {
            throw new SMSException("amSDK", "sms-invalid-plugin-schema-document", null);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!XMLUtils.getNodeAttributeValue((Node)nodes.item(i), (String)"name").equals(this.pluginName)) continue;
            return nodes.item(i);
        }
        return null;
    }

    protected void replacePluginSchema(Document document) throws SSOException, SMSException {
        SMSSchema smsSchema = new SMSSchema(document);
        String pSchema = smsSchema.getPluginSchema(this.pluginName);
        String[] attrs = new String[]{pSchema};
        CachedSMSEntry smsEntry = this.psi.getCachedSMSEntry();
        SMSEntry e = smsEntry.getClonedSMSEntry();
        e.setAttribute("sunPluginSchema", attrs);
        e.save(this.token);
        smsEntry.refresh(e);
    }

    static void createPluginSchema(SSOToken token, Node node, SMSSchema smsSchema) throws SMSException, SSOException {
        String name = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        String interfaceName = XMLUtils.getNodeAttributeValue((Node)node, (String)"interfaceName");
        String orgName = DNMapper.orgNameToDN(XMLUtils.getNodeAttributeValue((Node)node, (String)"organizationName"));
        ServiceSchemaManagerImpl ssmi = ServiceSchemaManagerImpl.getInstance(token, smsSchema.getServiceName(), smsSchema.getServiceVersion());
        if (!ssmi.getPluginInterfaceNames().contains(interfaceName)) {
            throw new SMSException("amSDK", "sms-invalid-plugin-interface-name", null);
        }
        CreateServiceConfig.checkBaseNodesForOrg(token, orgName, smsSchema.getServiceName(), smsSchema.getServiceVersion());
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou=").append(interfaceName).append(",").append("ou=PluginConfig,").append("ou=").append(smsSchema.getServiceVersion()).append(",").append("ou=").append(smsSchema.getServiceName()).append(",").append("ou=services").append(",").append(orgName);
        CreateServiceConfig.checkAndCreateOrgUnitNode(token, sb.toString());
        String dn = "ou=" + name + "," + sb.toString();
        CachedSMSEntry ce = CachedSMSEntry.getInstance(token, dn, null);
        SMSEntry e = ce.getClonedSMSEntry();
        if (!e.isNewEntry()) {
            throw new SMSException("plugin-schema-already-exists", "plugin-schema-already-exists");
        }
        e.addAttribute("objectclass", "top");
        e.addAttribute("objectclass", "sunService");
        e.addAttribute("sunPluginSchema", smsSchema.getPluginSchema(name));
        e.save(token);
        ce.refresh(e);
    }

    public String toXML() throws SMSException {
        Document pluginDoc = this.getDocumentCopy();
        return SMSSchema.nodeToString(XMLUtils.getRootNode((Document)pluginDoc, (String)"PluginSchema"));
    }
}

