/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class InvalidAttributeValueException
extends SMSException {
    private String resourceBundleName;
    private String rbName;
    private String attributeI18nKey;
    private String errCode;

    public InvalidAttributeValueException() {
    }

    public InvalidAttributeValueException(String s) {
        super(s);
    }

    public InvalidAttributeValueException(String rbName, String errorCode, Object[] args) {
        super(rbName, errorCode, args);
        this.resourceBundleName = rbName;
        this.errCode = errorCode;
        if (args.length > 2) {
            this.rbName = (String)args[1];
            this.attributeI18nKey = (String)args[2];
        }
    }

    public String getL10NMessage(java.util.Locale locale) {
        String message = this.errCode;
        if (this.resourceBundleName == null || locale == null || this.attributeI18nKey == null || this.rbName == null) {
            message = super.getL10NMessage(locale);
        } else {
            ResourceBundle bundle = this.amCache.getResBundle(this.resourceBundleName, locale);
            String mid = Locale.getString((ResourceBundle)bundle, (String)this.errCode, (Debug)this.debug);
            ResourceBundle serviceResouceBundle = this.amCache.getResBundle(this.rbName, locale);
            String localizedAttributeName = Locale.getString((ResourceBundle)serviceResouceBundle, (String)this.attributeI18nKey, (Debug)this.debug);
            String[] argsEx = new String[]{localizedAttributeName};
            message = MessageFormat.format(mid, argsEx);
        }
        return message;
    }
}

