/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationAlreadyExistsException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import org.w3c.dom.Node;

public class CreateServiceConfig {
    static final String GLOBAL_CONFIG_NODE = "ou=GlobalConfig,";
    static final String ORG_CONFIG_NODE = "ou=OrganizationConfig,";
    static final String PLUGIN_CONFIG_NODE = "ou=PluginConfig,";
    static final String INSTANCES_NODE = "ou=Instances,";

    static void createService(ServiceManager sm, String sName, String version, Node configNode) throws SMSException, SSOException {
        CreateServiceConfig.createService(sm, sName, version, configNode, false);
    }

    static void createService(ServiceManager sm, String sName, String version, Node configNode, boolean createRealms) throws SMSException, SSOException {
        SSOToken token = sm.getSSOToken();
        ServiceSchemaManagerImpl ssm = ServiceSchemaManagerImpl.getInstance(token, sName, version);
        String baseDN = ServiceManager.getServiceNameDN(sName, version);
        CreateServiceConfig.checkBaseNodes(token, baseDN);
        Iterator insNodes = XMLUtils.getChildNodes((Node)configNode, (String)"Instance").iterator();
        while (insNodes.hasNext()) {
            String insGroup;
            Node insNode = (Node)insNodes.next();
            Map insAttrs = null;
            String insName = XMLUtils.getNodeAttributeValue((Node)insNode, (String)"name");
            if (insName == null) {
                insName = "default";
            }
            if ((insGroup = XMLUtils.getNodeAttributeValue((Node)insNode, (String)"group")) == null) {
                insGroup = "default";
            }
            String insUri = XMLUtils.getNodeAttributeValue((Node)insNode, (String)"uri");
            insAttrs = CreateServiceConfig.getAttributeValuePairs(insNode);
            StringBuffer sb = new StringBuffer(100);
            sb.append("ou=").append(insName).append(",").append(INSTANCES_NODE).append(baseDN);
            CachedSMSEntry cEntry = CachedSMSEntry.getInstance(token, sb.toString(), null);
            SMSEntry insEntry = cEntry.getSMSEntry();
            if (insEntry.isNewEntry()) {
                insEntry = cEntry.getClonedSMSEntry();
                insEntry.addAttribute("objectclass", "top");
                insEntry.addAttribute("objectclass", "sunServiceComponent");
                insEntry.addAttribute("sunserviceID", insGroup);
                if (insUri != null) {
                    insEntry.addAttribute("labeledURI", insUri);
                }
                if (insAttrs != null) {
                    SMSUtils.setAttributeValuePairs(insEntry, insAttrs, Collections.EMPTY_SET);
                }
                insEntry.save(token);
                cEntry.refresh(insEntry);
                CreateServiceConfig.updateSubEntriesNode(token, insEntry.getDN());
                continue;
            }
            Object[] args = new Object[]{sName, version};
            throw new SMSException("amSDK", "sms-service_already_exists", args);
        }
        Iterator globalNodes = XMLUtils.getChildNodes((Node)configNode, (String)"GlobalConfiguration").iterator();
        while (globalNodes.hasNext()) {
            Node globalNode = (Node)globalNodes.next();
            ServiceSchemaImpl ss = ssm.getSchema(SchemaType.GLOBAL);
            String globalGroup = XMLUtils.getNodeAttributeValue((Node)globalNode, (String)"group");
            if (globalGroup == null) {
                globalGroup = "default";
            }
            StringBuffer sb = new StringBuffer(100);
            sb.append("ou=").append(globalGroup).append(",").append(GLOBAL_CONFIG_NODE).append(baseDN);
            CreateServiceConfig.createSubConfig(token, sb.toString(), globalNode, ss, baseDN);
        }
        Iterator orgNodes = XMLUtils.getChildNodes((Node)configNode, (String)"OrganizationConfiguration").iterator();
        while (orgNodes.hasNext()) {
            Node orgNode = (Node)orgNodes.next();
            ServiceSchemaImpl ss = ssm.getSchema(SchemaType.ORGANIZATION);
            String orgGroup = XMLUtils.getNodeAttributeValue((Node)orgNode, (String)"group");
            if (orgGroup == null) {
                orgGroup = "default";
            }
            String orgDN = SMSEntry.baseDN;
            String orgName = XMLUtils.getNodeAttributeValue((Node)orgNode, (String)"name");
            if (orgName != null) {
                if (DN.isDN((String)orgName)) {
                    orgDN = orgName;
                } else if (orgName.indexOf(47) != -1) {
                    orgDN = DNMapper.orgNameToDN(orgName);
                }
            }
            CreateServiceConfig.checkBaseNodesForOrg(token, orgDN, sName, version, createRealms);
            StringBuffer sb = new StringBuffer(100);
            sb.append("ou=").append(orgGroup).append(",").append(ORG_CONFIG_NODE).append("ou=").append(version).append(",ou=").append(sName).append(",ou=services,").append(orgDN);
            CreateServiceConfig.createSubConfig(token, sb.toString(), orgNode, ss, orgDN);
            Node orgAttrValuePairNode = XMLUtils.getChildNode((Node)orgNode, (String)"OrganizationAttributeValuePair");
            if (orgAttrValuePairNode == null) continue;
            Map attrs = CreateServiceConfig.getAttributeValuePairs(orgAttrValuePairNode);
            OrganizationConfigManager ocm = new OrganizationConfigManager(token, orgDN);
            ocm.setAttributes(sName, attrs);
        }
        Iterator pNodes = XMLUtils.getChildNodes((Node)configNode, (String)"PluginConfiguration").iterator();
        while (pNodes.hasNext()) {
            Node pNode = (Node)pNodes.next();
            String pName = XMLUtils.getNodeAttributeValue((Node)pNode, (String)"name");
            String schemaName = XMLUtils.getNodeAttributeValue((Node)pNode, (String)"pluginSchemaName");
            String intName = XMLUtils.getNodeAttributeValue((Node)pNode, (String)"interfaceName");
            String orgName = DNMapper.orgNameToDN(XMLUtils.getNodeAttributeValue((Node)pNode, (String)"organizationName"));
            PluginSchemaImpl psi = PluginSchemaImpl.getInstance(token, sName, version, schemaName, intName, orgName);
            CreateServiceConfig.checkBaseNodesForOrg(token, orgName, sName, version);
            StringBuffer sb = new StringBuffer(100);
            sb.append("ou=").append(intName).append(",").append(PLUGIN_CONFIG_NODE).append("ou=").append(version).append(",ou=").append(sName).append(",ou=services,").append(orgName);
            CreateServiceConfig.checkAndCreateServiceNode(token, sb.toString());
            sb.insert(0, ",").insert(0, schemaName).insert(0, "ou=");
            CreateServiceConfig.checkAndCreateServiceNode(token, sb.toString());
            sb.insert(0, ",").insert(0, pName).insert(0, "ou=");
            CreateServiceConfig.createSubConfig(token, sb.toString(), pNode, psi, orgName);
        }
    }

    static void createSubConfig(SSOToken token, String dn, Node node, ServiceSchemaImpl ss, String orgdn) throws SMSException, SSOException {
        String id = XMLUtils.getNodeAttributeValue((Node)node, (String)"id");
        String priority = XMLUtils.getNodeAttributeValue((Node)node, (String)"priority");
        Map attrs = CreateServiceConfig.getAttributeValuePairs(node);
        CreateServiceConfig.createSubConfigEntry(token, dn, ss, id, priority, attrs, orgdn);
        Iterator subConfigs = XMLUtils.getChildNodes((Node)node, (String)"SubConfiguration").iterator();
        while (subConfigs.hasNext()) {
            Node subConfigNode = (Node)subConfigs.next();
            String subConfigName = XMLUtils.getNodeAttributeValue((Node)subConfigNode, (String)"name");
            String subConfigID = XMLUtils.getNodeAttributeValue((Node)subConfigNode, (String)"id");
            if (subConfigID == null) {
                subConfigID = subConfigName;
            }
            CreateServiceConfig.createSubConfig(token, "ou=" + subConfigName + "," + dn, subConfigNode, ss.getSubSchema(subConfigID), orgdn);
        }
    }

    static void createSubConfigEntry(SSOToken token, String dn, ServiceSchemaImpl ss, String id, String priority, Map attrs, String orgDN) throws SMSException, SSOException {
        CachedSMSEntry cEntry = CachedSMSEntry.getInstance(token, dn, null);
        SMSEntry entry = cEntry.getClonedSMSEntry();
        if (ss == null || !entry.isNewEntry()) {
            SMSEntry.debug.error("CreateServiceConfig.createSubConfigEntry: Entry already exists: " + dn);
            throw new ServiceAlreadyExistsException("amSDK", "sms-service_already_exists1", null);
        }
        entry.addAttribute("objectclass", "top");
        entry.addAttribute("objectclass", "sunServiceComponent");
        if (attrs != null) {
            ss.validateAttributes(token, attrs, true, orgDN);
            SMSUtils.setAttributeValuePairs(entry, attrs, ss.getSearchableAttributeNames());
        }
        if (id != null) {
            entry.addAttribute("sunserviceID", id);
        }
        if (priority != null) {
            entry.addAttribute("sunsmspriority", priority);
        }
        entry.save(token);
        cEntry.refresh(entry);
        CreateServiceConfig.updateSubEntriesNode(token, entry.getDN());
    }

    static void checkBaseNodesForOrg(SSOToken token, String orgDN, String sName, String version) throws SMSException, SSOException {
        CreateServiceConfig.checkBaseNodesForOrg(token, orgDN, sName, version, false);
    }

    static void checkBaseNodesForOrg(SSOToken token, String orgDN, String sName, String version, boolean createRealms) throws SMSException, SSOException {
        SMSEntry entry = new SMSEntry(token, orgDN);
        if (entry.isNewEntry()) {
            if (createRealms) {
                CreateServiceConfig.createOrganization(token, orgDN);
            } else {
                Object[] args = new Object[]{orgDN};
                throw new SMSException("amSDK", "sms-org-doesnot-exist", args);
            }
        }
        String dn = "ou=services," + orgDN;
        CreateServiceConfig.checkAndCreateOrgUnitNode(token, dn);
        dn = "ou=" + sName + "," + dn;
        CreateServiceConfig.checkAndCreateServiceNode(token, dn);
        dn = "ou=" + version + "," + dn;
        CreateServiceConfig.checkAndCreateServiceVersionNode(token, dn, sName);
        CreateServiceConfig.checkBaseNodes(token, dn);
    }

    static void checkBaseNodes(SSOToken t, String baseDN) throws SMSException, SSOException {
        CreateServiceConfig.checkAndCreateOrgUnitNode(t, GLOBAL_CONFIG_NODE + baseDN);
        CreateServiceConfig.checkAndCreateOrgUnitNode(t, ORG_CONFIG_NODE + baseDN);
        CreateServiceConfig.checkAndCreateServiceNode(t, PLUGIN_CONFIG_NODE + baseDN);
        CreateServiceConfig.checkAndCreateOrgUnitNode(t, INSTANCES_NODE + baseDN);
    }

    static void checkAndCreateOrgUnitNode(SSOToken token, String dn) throws SMSException, SSOException {
        SMSEntry e = new SMSEntry(token, dn);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CreateServiceConfig.checkAndCreateOrgUnitNode() creating entry: " + dn);
        }
        if (e.isNewEntry()) {
            e.addAttribute("objectclass", "top");
            e.addAttribute("objectclass", "organizationalunit");
            e.save();
        }
    }

    static void checkAndCreateServiceNode(SSOToken token, String dn) throws SMSException, SSOException {
        int ndx;
        SMSEntry e = new SMSEntry(token, dn);
        if (e.isNewEntry() && (ndx = dn.indexOf("ou=services")) >= 0) {
            if (dn.indexOf("ou=services", ndx + 11) >= 0) {
                e.addAttribute("objectclass", "top");
                e.addAttribute("objectclass", "sunService");
            } else {
                e.addAttribute("objectclass", "top");
                e.addAttribute("objectclass", "sunServiceComponent");
            }
        }
        e.save();
    }

    static void checkAndCreateServiceVersionNode(SSOToken t, String dn, String serviceName) throws SMSException, SSOException {
        int ndx;
        SMSEntry e = new SMSEntry(t, dn);
        if (e.isNewEntry() && (ndx = dn.indexOf("ou=services")) >= 0) {
            String firstSvc = dn.substring(ndx);
            if (firstSvc.indexOf("ou=services") >= 0) {
                e.addAttribute("objectclass", "top");
                e.addAttribute("objectclass", "sunService");
            } else {
                e.addAttribute("objectclass", "top");
                e.addAttribute("objectclass", "sunService");
                e.addAttribute("ou", serviceName);
            }
        }
        e.save();
    }

    static void updateSubEntriesNode(SSOToken token, String sdn) throws SMSException {
        DN dn = new DN(sdn);
        String name = dn.explodeDN(true)[0];
        DN parent = dn.getParent();
        CachedSubEntries subEntries = CachedSubEntries.getInstance(token, parent.toRFCString());
        subEntries.add(name);
    }

    public static Map getAttributeValuePairs(Node n) {
        if (n == null) {
            return null;
        }
        HashMap<String, Set> answer = null;
        Iterator attrNodes = XMLUtils.getChildNodes((Node)n, (String)"AttributeValuePair").iterator();
        while (attrNodes.hasNext()) {
            Node attrValuePair = (Node)attrNodes.next();
            Node attrNode = XMLUtils.getChildNode((Node)attrValuePair, (String)"Attribute");
            if (attrNode == null) continue;
            String attrName = XMLUtils.getNodeAttributeValue((Node)attrNode, (String)"name");
            Set values = XMLUtils.getAttributeValuePair((Node)attrValuePair);
            if (answer == null) {
                answer = new HashMap<String, Set>();
            }
            answer.put(attrName, values);
        }
        return answer;
    }

    static void createOrganization(SSOToken token, String orgDN) throws SMSException {
        try {
            Object[] args1 = new Object[]{orgDN};
            orgDN = new DN(orgDN).toRFCString();
            if (orgDN.length() == 0) {
                SMSEntry.debug.error("CreateServiceConfig.createOrganization() : Detected invalid characters. Invalid realm name: " + args1[0]);
                throw new SMSException("amSDK", "sms-invalid-org-name", args1);
            }
            CachedSMSEntry cEntry = CachedSMSEntry.getInstance(token, orgDN, null);
            SMSEntry e = cEntry.getClonedSMSEntry();
            if (!e.isNewEntry()) {
                SMSEntry.debug.error("Organization already exists: " + orgDN);
                throw new OrganizationAlreadyExistsException("amSDK", "sms-organization_already_exists1", null);
            }
            String[] dns = LDAPDN.explodeDN((String)orgDN, (boolean)false);
            String partdn = dns[dns.length - 1];
            int index = dns.length - 1;
            while (index > 0 && !partdn.equalsIgnoreCase(DNMapper.serviceDN)) {
                partdn = dns[--index] + "," + partdn;
            }
            while (index >= 1) {
                if (!(e = (cEntry = CachedSMSEntry.getInstance(token, partdn = dns[--index] + "," + partdn, null)).getClonedSMSEntry()).isNewEntry()) continue;
                e.addAttribute("objectclass", "sunRealmService");
                e.addAttribute("objectclass", "top");
                e.save(token);
                cEntry.refresh(e);
            }
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("CreateServiceConfig: Unable to create organization ", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }
}

