/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.enterprise.registration.StartRegister;
import com.sun.identity.authentication.UI.LoginLogoutMapping;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.common.DebugPropertiesObserver;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ConfigurationObserver;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.setup.AMSetupDSConfig;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.BootstrapCreator;
import com.sun.identity.setup.BootstrapData;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.ConfiguratorPlugin;
import com.sun.identity.setup.ConfigureData;
import com.sun.identity.setup.EmbeddedOpenDS;
import com.sun.identity.setup.HttpServletRequestWrapper;
import com.sun.identity.setup.HttpServletResponseWrapper;
import com.sun.identity.setup.IHttpServletRequest;
import com.sun.identity.setup.IHttpServletResponse;
import com.sun.identity.setup.RegisterServices;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.setup.UserIdRepo;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AMSetupServlet
extends HttpServlet {
    private static ServletContext servletCtx = null;
    private static boolean isConfiguredFlag = false;
    private static final String SMS_STR = "sms";
    private static SSOToken adminToken = null;
    private static final String LEGACY_PROPERTIES = "legacy";
    static final String BOOTSTRAP_EXTRA = "bootstrap";
    static final String BOOTSTRAP_FILE_LOC = "bootstrap.file";
    static final String OPENDS_DIR = "/opends";
    private static String errorMessage = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.setProperty("file.separator", "/");
        if (servletCtx == null) {
            servletCtx = config.getServletContext();
        }
        AMSetupServlet.checkConfigProperties();
        LoginLogoutMapping.setProductInitialized(isConfiguredFlag);
        if (isConfiguredFlag && !ServerConfiguration.isLegacy()) {
            try {
                BootstrapCreator.createBootstrap();
            }
            catch (ConfigurationException e) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet,init", (Throwable)e);
            }
        }
    }

    public static boolean isConfigured() {
        return isConfiguredFlag;
    }

    public static void checkConfigProperties() {
        String overrideAMC = SystemProperties.get("com.sun.identity.overrideAMC");
        boolean bl = isConfiguredFlag = overrideAMC == null || overrideAMC.equalsIgnoreCase("false");
        if (!isConfiguredFlag && servletCtx != null) {
            String baseDir = AMSetupServlet.getBaseDir();
            try {
                String bootstrapFile = AMSetupServlet.getBootStrapFile();
                if (bootstrapFile != null) {
                    isConfiguredFlag = Bootstrap.load(new BootstrapData(baseDir), false);
                } else if (baseDir != null) {
                    isConfiguredFlag = AMSetupServlet.loadAMConfigProperties(baseDir + "/" + "AMConfig.properties");
                }
            }
            catch (ConfiguratorException e) {
            }
            catch (Exception e) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.checkConfigProperties", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadAMConfigProperties(String fileLocation) throws IOException {
        boolean loaded = false;
        File test = new File(fileLocation);
        if (test.exists()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(fileLocation);
                if (fin != null) {
                    Properties props = new Properties();
                    props.load(fin);
                    SystemProperties.initializeProperties(props);
                    loaded = true;
                }
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return loaded;
    }

    public static boolean checkInitState(ServletContext servletctx) {
        return isConfiguredFlag;
    }

    public static boolean processRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpServletRequestWrapper req = new HttpServletRequestWrapper(request);
        HttpServletResponseWrapper res = new HttpServletResponseWrapper(response);
        return AMSetupServlet.processRequest(req, res);
    }

    public static boolean processRequest(IHttpServletRequest request, IHttpServletResponse response) {
        ServicesDefaultValues.setServiceConfigValues(request);
        Map map = ServicesDefaultValues.getDefaultValues();
        Map siteMap = (Map)map.remove("SITE_CONFIGURATION_MAP");
        Map userRepo = (Map)map.remove("UserStore");
        try {
            isConfiguredFlag = AMSetupServlet.configure(map, userRepo);
            if (isConfiguredFlag) {
                AMSetupServlet.postInitialize(AMSetupServlet.getAdminSSOToken());
            }
            LoginLogoutMapping.setProductInitialized(isConfiguredFlag);
            if (isConfiguredFlag) {
                boolean legacy = ServerConfiguration.isLegacy();
                Map bootstrapRes = AMSetupServlet.createBootstrapResource(legacy);
                String url = BootstrapData.createBootstrapResource(bootstrapRes, legacy);
                String basedir = (String)map.get("BASE_DIR");
                String fileBootstrap = AMSetupServlet.getBootstrapLocator();
                if (fileBootstrap != null) {
                    AMSetupServlet.writeToFileEx(fileBootstrap, basedir);
                }
                if (!legacy) {
                    AMSetupServlet.writeBootstrapFile(url);
                    HashMap mapBootstrap = new HashMap(2);
                    HashSet<String> set = new HashSet<String>(2);
                    set.add(fileBootstrap);
                    mapBootstrap.put(BOOTSTRAP_FILE_LOC, set);
                    if (fileBootstrap == null) {
                        set.add(AMSetupServlet.getPresetConfigDir());
                    } else {
                        set.add(fileBootstrap);
                    }
                    String serverInstanceName = SystemProperties.getServerInstanceName();
                    SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    ServerConfiguration.setServerInstance(adminToken, serverInstanceName, mapBootstrap);
                    if (siteMap != null && !siteMap.isEmpty()) {
                        Set sites;
                        String site = (String)siteMap.get("wizardLoadBalancerSiteName");
                        String primaryURL = (String)siteMap.get("wizardLoadBalancerURL");
                        if (primaryURL != null && primaryURL.length() > 0 && !(sites = SiteConfiguration.getSites(adminToken)).contains(site)) {
                            SiteConfiguration.createSite(adminToken, site, primaryURL, Collections.EMPTY_SET);
                        }
                        if (!ServerConfiguration.belongToSite(adminToken, serverInstanceName, site)) {
                            ServerConfiguration.addToSite(adminToken, serverInstanceName, site);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processRequest: error.", (Throwable)e);
            e.printStackTrace();
        }
        return isConfiguredFlag;
    }

    private static boolean configure(Map map, Map userRepo) {
        boolean configured = false;
        boolean existingConfiguration = false;
        try {
            boolean bUseExtUMDS;
            String basedir = (String)map.get("BASE_DIR");
            File baseDirectory = new File(basedir);
            if (!baseDirectory.exists()) {
                baseDirectory.mkdirs();
            } else {
                SetupProgress.reportStart("emb.checkingbasedir", basedir);
                File bootstrapFile = new File(basedir + "/" + BOOTSTRAP_EXTRA);
                File opendsDir = new File(basedir + OPENDS_DIR);
                if (bootstrapFile.exists() || opendsDir.exists()) {
                    SetupProgress.reportEnd("emb.basedirfailed", null);
                    throw new ConfiguratorException("Base directory specified :" + basedir + " cannot be used - has preexisting config data.");
                }
                SetupProgress.reportEnd("emb.success", null);
            }
            boolean isDITLoaded = ((String)map.get("DIT_LOADED")).equals("true");
            String dataStore = (String)map.get("DATA_STORE");
            boolean embedded = dataStore.equals("embedded");
            boolean isDSServer = false;
            boolean isADServer = false;
            if (embedded) {
                isDSServer = true;
            } else {
                isDSServer = dataStore.equals("dirServer");
                isADServer = dataStore.equals("activeDir");
            }
            if (embedded) {
                try {
                    EmbeddedOpenDS.setup(map, servletCtx);
                    AMSetupDSConfig dsConfig = AMSetupDSConfig.getInstance();
                    int sleepTime = 10;
                    while (!dsConfig.isDServerUp() && sleepTime-- > 0) {
                        Thread.sleep(1000L);
                    }
                    if (!dsConfig.isDServerUp()) {
                        Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processRequest:OpenDS conn failed.");
                        return false;
                    }
                    if (EmbeddedOpenDS.isMultiServer(map)) {
                        List schemaFiles = AMSetupServlet.getSchemaFiles(dataStore);
                        AMSetupServlet.writeSchemaFiles(basedir, schemaFiles);
                        EmbeddedOpenDS.setupReplication(map);
                        isDITLoaded = true;
                    }
                }
                catch (Exception ex) {
                    Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: embedded = true", (Throwable)ex);
                    ex.printStackTrace();
                    throw new ConfiguratorException("Error setting up Embedded Directory Server: " + ex.getLocalizedMessage());
                }
            }
            if ((isDSServer || isADServer) && !isDITLoaded) {
                List schemaFiles = AMSetupServlet.getSchemaFiles(dataStore);
                AMSetupServlet.writeSchemaFiles(basedir, schemaFiles);
            }
            String serverURL = (String)map.get("SERVER_URL");
            String deployuri = (String)map.get("SERVER_URI");
            String serverInstanceName = serverURL + deployuri;
            AMSetupServlet.setupSecurIDDirs(basedir, deployuri);
            AMSetupServlet.setupSafeWordDirs(basedir, deployuri);
            Map mapFileNameToConfig = AMSetupServlet.initializeConfigProperties();
            String strAMConfigProperties = (String)mapFileNameToConfig.get("AMConfig.properties");
            String strServerConfigXML = (String)mapFileNameToConfig.get("serverconfig.xml");
            Properties propAMConfig = ServerConfiguration.getProperties(strAMConfigProperties);
            AMSetupServlet.reInitConfigProperties(serverInstanceName, propAMConfig, strServerConfigXML);
            SSOToken adminSSOToken = AMSetupServlet.getAdminSSOToken();
            boolean bl = bUseExtUMDS = userRepo != null && !userRepo.isEmpty();
            if (!isDITLoaded) {
                RegisterServices regService = new RegisterServices();
                regService.registers(adminSSOToken, bUseExtUMDS);
                AMSetupServlet.processDataRequests("/WEB-INF/template/sms");
            }
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                Map mapProp = ServerConfiguration.getDefaultProperties();
                mapProp.putAll(propAMConfig);
                AMSetupServlet.appendLegacyProperties(mapProp);
                Properties tmp = new Properties();
                tmp.putAll((Map<?, ?>)mapProp);
                SystemProperties.initializeProperties(tmp, true, false);
                AMSetupServlet.writeToFile(basedir + "/" + "AMConfig.properties", AMSetupServlet.mapToString(mapProp));
                AMSetupServlet.writeToFile(basedir + "/serverconfig.xml", strServerConfigXML);
                String hostname = (String)map.get("SERVER_HOST");
                AMSetupServlet.updatePlatformServerList(serverURL + deployuri, hostname);
            } else {
                try {
                    if (!isDITLoaded) {
                        ServerConfiguration.createDefaults(adminSSOToken);
                    }
                    if (!isDITLoaded || !ServerConfiguration.isServerInstanceExist(adminSSOToken, serverInstanceName)) {
                        ServerConfiguration.createServerInstance(adminSSOToken, serverInstanceName, ServerConfiguration.getPropertiesSet(strAMConfigProperties), strServerConfigXML);
                    }
                }
                catch (UnknownPropertyNameException ex) {
                    // empty catch block
                }
                ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMPlatformService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                scm.addListener(ConfigurationObserver.getInstance());
            }
            if (embedded) {
                try {
                    String serverID = WebtopNaming.getAMServerID();
                    String entry = map.get("DIRECTORY_SERVER") + ":" + map.get("DIRECTORY_PORT") + "|" + serverID;
                    String orgName = (String)map.get("SM_CONFIG_ROOT_SUFFIX");
                    AMSetupServlet.updateEmbeddedIdRepo(orgName, "embedded", entry);
                }
                catch (Exception ex) {
                    Debug.getInstance((String)"amSetupServlet").error("EmbeddedDS : failed to setup serverid", (Throwable)ex);
                    throw new ConfiguratorException("EmbeddedDS : failed to gsetup serverid;ex=" + ex);
                }
            }
            SystemProperties.setServerInstanceName(serverInstanceName);
            AMSetupServlet.handlePostPlugins(adminSSOToken);
            AMSetupServlet.postInitialize(adminSSOToken);
            try {
                ServiceConfig sc;
                if (!isDITLoaded && userRepo != null && !userRepo.isEmpty() && (sc = UserIdRepo.getOrgConfig(adminSSOToken)) != null) {
                    CachedSMSEntry cEntry = CachedSMSEntry.getInstance(adminSSOToken, "ou=" + userRepo.get("userStoreHostName") + "," + sc.getDN(), null);
                    SMSEntry entry = cEntry.getClonedSMSEntry();
                    if (entry.isNewEntry()) {
                        UserIdRepo.getInstance().configure(userRepo, basedir, servletCtx, adminSSOToken);
                    } else {
                        existingConfiguration = true;
                    }
                }
            }
            catch (Exception e) {
                throw new ConfiguratorException(e.getMessage());
            }
            AMSetupServlet.createPasswordFiles(basedir, deployuri);
            if (!isDITLoaded) {
                if (userRepo == null || userRepo.isEmpty()) {
                    AMSetupServlet.createDemoUser();
                }
                if (!existingConfiguration) {
                    AMSetupServlet.createIdentitiesForWSSecurity(serverURL, deployuri);
                }
            }
            String aceDataDir = basedir + "/" + deployuri + "/auth/ace/data";
            AMSetupServlet.copyAuthSecurIDFiles(aceDataDir);
            AMSetupServlet.startRegistrationProcess(basedir, deployuri);
            isConfiguredFlag = true;
            configured = true;
        }
        catch (FileNotFoundException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (ConfigurationException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (SecurityException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (LDAPServiceException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (SMSException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (PolicyException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (ConfiguratorException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (SSOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)((Object)e));
            e.printStackTrace();
            errorMessage = e.getMessage();
        }
        catch (IdRepoException idrepoe) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)idrepoe);
            idrepoe.printStackTrace();
            errorMessage = idrepoe.getMessage();
        }
        return configured;
    }

    public static String getErrorMessage() {
        return errorMessage != null ? errorMessage : "";
    }

    private static void appendLegacyProperties(Map prop) {
        ResourceBundle res = ResourceBundle.getBundle(LEGACY_PROPERTIES);
        Enumeration<String> i = res.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            prop.put(key, res.getString(key));
        }
    }

    private static void postInitialize(SSOToken adminSSOToken) throws SSOException, SMSException {
        AMAuthenticationManager.reInitializeAuthServices();
        AMIdentityRepository.clearCache();
        ServiceManager svcMgr = new ServiceManager(adminSSOToken);
        svcMgr.clearCache();
        LoginLogoutMapping lmp = new LoginLogoutMapping();
        lmp.initializeAuth(servletCtx);
        LoginLogoutMapping.setProductInitialized(true);
    }

    private static Map createBootstrapResource(boolean legacy) throws IOException {
        HashMap<String, String> initMap = new HashMap<String, String>();
        Map map = ServicesDefaultValues.getDefaultValues();
        String serverURL = (String)map.get("SERVER_URL");
        String basedir = (String)map.get("BASE_DIR");
        String deployuri = (String)map.get("SERVER_URI");
        String dataStore = (String)map.get("DATA_STORE");
        if (legacy) {
            initMap.put("ffbasedir", basedir);
        } else if (dataStore.equals("flatfile")) {
            initMap.put("protocol", "file://");
            initMap.put("ffbasedir", basedir + deployuri + "/" + SMS_STR);
            initMap.put("pwd", (String)map.get("ADMIN_PWD"));
            initMap.put("basedir", basedir);
        } else {
            String tmp = (String)map.get("DIRECTORY_SSL");
            boolean ssl = tmp != null && tmp.equals("SSL");
            initMap.put("protocol", ssl ? "ldaps://" : "ldap://");
            initMap.put("dshost", (String)map.get("DIRECTORY_SERVER"));
            initMap.put("dsport", (String)map.get("DIRECTORY_PORT"));
            initMap.put("dsbasedn", (String)map.get("ROOT_SUFFIX"));
            initMap.put("dsmgr", (String)map.get("DS_DIRMGRDN"));
            initMap.put("pwd", (String)map.get("ADMIN_PWD"));
            initMap.put("dspwd", (String)map.get("DS_DIRMGRPASSWD"));
        }
        initMap.put("serverinstance", serverURL + deployuri);
        return initMap;
    }

    private static void writeBootstrapFile(String url) throws IOException {
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        String deployuri = (String)map.get("SERVER_URI");
        String fileName = basedir + "/" + BOOTSTRAP_EXTRA;
        AMSetupServlet.writeToFile(fileName, url);
        if (System.getProperty("path.separator").equals(":")) {
            Runtime.getRuntime().exec("/bin/chmod 400 " + fileName);
        }
    }

    private static void handlePostPlugins(SSOToken adminSSOToken) {
        List plugins = AMSetupServlet.getConfigPluginClasses();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            ConfiguratorPlugin plugin = (ConfiguratorPlugin)i.next();
            plugin.doPostConfiguration(servletCtx, adminSSOToken);
        }
    }

    private static List getConfigPluginClasses() {
        ArrayList<ConfiguratorPlugin> plugins = new ArrayList<ConfiguratorPlugin>();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("configuratorPlugins");
            String strPlugins = rb.getString("configurator.plugins");
            if (strPlugins != null) {
                StringTokenizer st = new StringTokenizer(strPlugins);
                while (st.hasMoreTokens()) {
                    String className = st.nextToken();
                    Class<?> clazz = Class.forName(className);
                    plugins.add((ConfiguratorPlugin)clazz.newInstance());
                }
            }
        }
        catch (IllegalAccessException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            e.printStackTrace();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return plugins;
    }

    private static void reInitConfigProperties(String serverName, Properties prop, String strServerConfigXML) throws FileNotFoundException, SMSException, IOException, SSOException, LDAPServiceException {
        SystemProperties.initializeProperties(prop, true, false);
        Crypt.reinitialize();
        AMSetupServlet.initDSConfigMgr(strServerConfigXML);
        AdminUtils.initialize();
        SMSAuthModule.initialize();
        SystemProperties.initializeProperties(prop, true, true);
        DebugPropertiesObserver.getInstance().notifyChanges();
        List plugins = AMSetupServlet.getConfigPluginClasses();
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            ConfiguratorPlugin plugin = (ConfiguratorPlugin)i.next();
            plugin.reinitConfiguratioFile(basedir);
        }
    }

    public static String getPresetConfigDir() {
        String configDir;
        block3: {
            configDir = null;
            try {
                ResourceBundle rb = ResourceBundle.getBundle(BOOTSTRAP_EXTRA);
                configDir = rb.getString("configuration.dir");
                if (configDir == null || configDir.length() <= 0) break block3;
                String realPath = AMSetupServlet.getNormalizedRealPath(servletCtx);
                if (realPath != null) {
                    configDir = configDir.replaceAll("@REAL_PATH@", realPath);
                    break block3;
                }
                throw new ConfiguratorException("cannot get configuration path");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return configDir;
    }

    static String getBootStrapFile() throws ConfiguratorException {
        File test;
        String bootstrap = null;
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            bootstrap = configDir + "/bootstrap";
        } else {
            String locator = AMSetupServlet.getBootstrapLocator();
            FileReader frdr = null;
            try {
                frdr = new FileReader(locator);
                BufferedReader brdr = new BufferedReader(frdr);
                bootstrap = brdr.readLine() + "/bootstrap";
            }
            catch (IOException e) {
                throw new ConfiguratorException(e.getMessage());
            }
            finally {
                if (frdr != null) {
                    try {
                        frdr.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (bootstrap != null && !(test = new File(bootstrap)).exists()) {
            bootstrap = null;
        }
        return bootstrap;
    }

    private static String getBootstrapLocator() throws ConfiguratorException {
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            return null;
        }
        if (servletCtx != null) {
            String path = AMSetupServlet.getNormalizedRealPath(servletCtx);
            if (path != null) {
                return System.getProperty("user.home") + "/" + "AccessManager" + "/" + "AMConfig" + path;
            }
            throw new ConfiguratorException("Cannot read the bootstrap path");
        }
        throw new ConfiguratorException("Servlet Context is null");
    }

    private static String getBaseDir() {
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            return configDir;
        }
        if (servletCtx != null) {
            String path = AMSetupServlet.getNormalizedRealPath(servletCtx);
            if (path != null) {
                String bootstrap = System.getProperty("user.home") + "/" + "AccessManager" + "/" + "AMConfig" + path;
                File test = new File(bootstrap);
                if (!test.exists()) {
                    return null;
                }
                FileReader frdr = null;
                try {
                    frdr = new FileReader(bootstrap);
                    BufferedReader brdr = new BufferedReader(frdr);
                    String string = brdr.readLine();
                    return string;
                }
                catch (IOException e) {
                    throw new ConfiguratorException(e.getMessage());
                }
                finally {
                    if (frdr != null) {
                        try {
                            frdr.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            throw new ConfiguratorException("Cannot read the bootstrap path");
        }
        throw new ConfiguratorException("Servlet Context is null");
    }

    public static String getNormalizedRealPath(ServletContext servletCtx) {
        String path = null;
        if (servletCtx != null && (path = AMSetupServlet.getAppResource(servletCtx)) != null) {
            String realPath = servletCtx.getRealPath("/");
            if (realPath != null && realPath.length() > 0) {
                realPath = realPath.replace('\\', '/');
                path = realPath.replaceAll("/", "_");
            } else {
                path = path.replaceAll("/", "_");
            }
            int idx = path.indexOf(":");
            if (idx != -1) {
                path = path.substring(idx + 1);
            }
        }
        return path;
    }

    private static String getAppResource(ServletContext servletCtx) {
        if (servletCtx != null) {
            try {
                URL turl = servletCtx.getResource("/");
                return turl.getPath();
            }
            catch (MalformedURLException mue) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getAppResource: Cannot access the resource", (Throwable)mue);
            }
        } else {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getAppResource: Context is null");
        }
        return null;
    }

    private static void processDataRequests(String xmlBaseDir) throws SMSException, SSOException, IOException, PolicyException {
        SSOToken ssoToken = AMSetupServlet.getAdminSSOToken();
        try {
            Map map = ServicesDefaultValues.getDefaultValues();
            String hostname = (String)map.get("SERVER_HOST");
            ConfigureData configData = new ConfigureData(xmlBaseDir, servletCtx, hostname, ssoToken);
            configData.configure();
        }
        catch (SMSException e) {
            e.printStackTrace();
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)e);
            throw e;
        }
        catch (SSOException e) {
            e.printStackTrace();
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)((Object)e));
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)e);
            throw e;
        }
    }

    private static SSOToken getAdminSSOToken() {
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return adminToken;
    }

    private static Map initializeConfigProperties() throws SecurityException, IOException {
        HashMap<String, String> mapFileNameToContent = new HashMap<String, String>();
        List dataFiles = AMSetupServlet.getTagSwapConfigFiles();
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        String deployuri = (String)map.get("SERVER_URI");
        try {
            File fhm = new File(basedir + deployuri + "/" + SMS_STR);
            fhm.mkdirs();
        }
        catch (SecurityException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.initializeConfigProperties", (Throwable)e);
            throw e;
        }
        Iterator i = dataFiles.iterator();
        while (i.hasNext()) {
            String absFile;
            String file = (String)i.next();
            StringBuffer sbuf = null;
            try {
                sbuf = AMSetupServlet.readFile(file);
            }
            catch (IOException ioex) {
                break;
            }
            int idx = file.lastIndexOf("/");
            String string = absFile = idx != -1 ? file.substring(idx + 1) : file;
            if (absFile.equalsIgnoreCase("AMConfig.properties")) {
                int idx1;
                String dbOption = (String)map.get("DATA_STORE");
                boolean embedded = dbOption.equals("embedded");
                boolean dbSunDS = false;
                boolean dbMsAD = false;
                if (embedded) {
                    dbSunDS = true;
                } else {
                    dbSunDS = dbOption.equals("dirServer");
                    dbMsAD = dbOption.equals("activeDir");
                }
                if ((dbSunDS || dbMsAD) && (idx1 = sbuf.indexOf("SMS_OBJECT_CLASS")) != -1) {
                    sbuf.replace(idx1, idx1 + "SMS_OBJECT_CLASS".length(), "DS_OBJECT_CLASS");
                }
            }
            if (AMSetupServlet.determineOS() == "linux") {
                map.put("PAM_SERVICE_NAME", "password");
            }
            String swapped = ServicesDefaultValues.tagSwap(sbuf.toString(), file.endsWith("xml"));
            if (absFile.equalsIgnoreCase("AMConfig.properties") || absFile.equalsIgnoreCase("serverconfig.xml")) {
                mapFileNameToContent.put(absFile, swapped);
                continue;
            }
            if (absFile.equalsIgnoreCase("rsa_api.properties")) {
                AMSetupServlet.writeToFile(basedir + deployuri + "/auth/ace/data/" + absFile, swapped);
                continue;
            }
            AMSetupServlet.writeToFile(basedir + "/" + absFile, swapped);
        }
        return mapFileNameToContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer readFile(String file) throws IOException {
        InputStreamReader fin = null;
        StringBuffer sbuf = new StringBuffer();
        InputStream is = null;
        try {
            int len;
            is = servletCtx.getResourceAsStream(file);
            if (is == null) {
                throw new IOException(file + " not found");
            }
            fin = new InputStreamReader(is);
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception ex) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return sbuf;
    }

    private static void writeToFileEx(String fileName, String content) throws IOException {
        File btsFile = new File(fileName);
        if (!btsFile.getParentFile().exists()) {
            btsFile.getParentFile().mkdirs();
        }
        AMSetupServlet.writeToFile(fileName, content);
    }

    static void writeToFile(String fileName, String content) throws IOException {
        FileWriter fout = null;
        try {
            fout = new FileWriter(fileName);
            fout.write(content);
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeToFile", (Throwable)e);
            throw e;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static String getRandomString() {
        String randomStr = null;
        try {
            byte[] bytes = new byte[24];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(bytes);
            randomStr = Base64.encode((byte[])bytes).trim();
        }
        catch (Exception e) {
            randomStr = null;
            Debug.getInstance((String)"amSetupServlet").message("AMSetupServlet.getRandomString:Exception in generating encryption key.", (Throwable)e);
            e.printStackTrace();
        }
        return randomStr != null ? randomStr : "KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt";
    }

    public static int getUnusedPort(String hostname, int start, int incr) {
        int defaultPort = -1;
        for (int i = start; i < 65500 && defaultPort == -1; i += incr) {
            if (!AMSetupServlet.canUseAsPort(hostname, i)) continue;
            defaultPort = i;
        }
        return defaultPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUseAsPort(String hostname, int port) {
        boolean canUseAsPort = false;
        ServerSocket serverSocket = null;
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
            serverSocket = new ServerSocket();
            serverSocket.bind(socketAddress);
            canUseAsPort = true;
            serverSocket.close();
            Socket s = null;
            s = new Socket();
            s.connect(socketAddress, 1000);
            canUseAsPort = false;
            if (s == null) return canUseAsPort;
            try {
                s.close();
                return canUseAsPort;
            }
            catch (Throwable t) {}
            return canUseAsPort;
            catch (Throwable t) {
                if (s == null) return canUseAsPort;
                try {
                    s.close();
                    return canUseAsPort;
                }
                catch (Throwable t2) {}
                return canUseAsPort;
                catch (Throwable throwable) {
                    if (s == null) throw throwable;
                    try {
                        s.close();
                        throw throwable;
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            canUseAsPort = false;
            return canUseAsPort;
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static Map getRemoteServerInfo(String server, String userid, String pwd) {
        HttpURLConnection conn = null;
        try {
            String line;
            String data = "IDToken1=" + URLEncoder.encode(userid, "UTF-8") + "&IDToken2=" + URLEncoder.encode(pwd, "UTF-8");
            URL url = new URL(server + "/getServerInfo.jsp");
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Map info = null;
            while ((line = rd.readLine()) != null) {
                if (line.length() == 0) continue;
                info = BootstrapData.queryStringToMap(line);
            }
            wr.close();
            rd.close();
            return info;
        }
        catch (SSLHandshakeException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, Locale.getDefault());
        }
        catch (IllegalArgumentException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, Locale.getDefault());
        }
        catch (MalformedURLException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, Locale.getDefault());
        }
        catch (UnknownHostException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, Locale.getDefault());
        }
        catch (FileNotFoundException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("701", null, Locale.getDefault());
        }
        catch (ConnectException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, Locale.getDefault());
        }
        catch (IOException e) {
            ConfiguratorException cex = null;
            int status = 0;
            if (conn != null) {
                try {
                    status = conn.getResponseCode();
                }
                catch (Exception ig) {
                    // empty catch block
                }
            }
            cex = status == 401 || status == 400 || status == 405 || status == 408 ? new ConfiguratorException("" + status, null, Locale.getDefault()) : new ConfiguratorException(e.getMessage());
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw cex;
        }
    }

    private static List getSchemaFiles(String dataStore) throws MissingResourceException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ResourceBundle rb = ResourceBundle.getBundle("schemaNames");
        boolean embedded = dataStore.equals("embedded");
        boolean isDSServer = false;
        String strFiles = embedded ? rb.getString("opendsSmsSchema") : rb.getString("dsSmsSchema");
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            fileNames.add(st.nextToken());
        }
        return fileNames;
    }

    private static List getTagSwapConfigFiles() throws MissingResourceException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ResourceBundle rb = ResourceBundle.getBundle("configuratorTagSwap");
        String strFiles = rb.getString("tagswap.files");
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            fileNames.add(st.nextToken());
        }
        return fileNames;
    }

    private static boolean isIPAddress(String hostname) {
        boolean isIPAddr;
        StringTokenizer st = new StringTokenizer(hostname, ".");
        boolean bl = isIPAddr = st.countTokens() == 4;
        if (isIPAddr) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int node = Integer.parseInt(token);
                    isIPAddr = node >= 0 && node < 256;
                }
                catch (NumberFormatException e) {
                    isIPAddr = false;
                }
            }
        }
        return isIPAddr;
    }

    private static void writeSchemaFiles(String basedir, List schemaFiles) throws IOException {
        Iterator i = schemaFiles.iterator();
        while (i.hasNext()) {
            int len;
            String file = (String)i.next();
            InputStreamReader fin = new InputStreamReader(servletCtx.getResourceAsStream(file));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
            OutputStreamWriter fout = null;
            try {
                int idx = file.lastIndexOf("/");
                String absFile = idx != -1 ? file.substring(idx + 1) : file;
                fout = new FileWriter(basedir + "/" + absFile);
                String inpStr = sbuf.toString();
                fout.write(ServicesDefaultValues.tagSwap(inpStr));
            }
            catch (IOException ioex) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeSchemaFiles: Exception in writing schema files:", (Throwable)ioex);
                throw ioex;
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
                if (fout == null) continue;
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
        AMSetupDSConfig dsConfig = AMSetupDSConfig.getInstance();
        dsConfig.loadSchemaFiles(schemaFiles);
    }

    private static void updateSTSwsdl(String basedir, String deployuri) throws IOException {
        URL url = servletCtx.getResource("/WEB-INF/lib/fam.jar");
        String webAppLocation = url.toString().substring(5);
        int index = webAppLocation.indexOf("WEB-INF");
        webAppLocation = webAppLocation.substring(0, index - 1);
        String contentWSDL = AMSetupServlet.getFileContent("/WEB-INF/wsdl/famsts.wsdl");
        contentWSDL = contentWSDL.replaceAll("@KEYSTORE_LOCATION@", basedir + deployuri);
        BufferedWriter outWSDL = new BufferedWriter(new FileWriter(webAppLocation + "/WEB-INF/wsdl/famsts.wsdl"));
        outWSDL.write(contentWSDL);
        outWSDL.close();
    }

    private static String getFileContent(String fileName) throws IOException {
        InputStream in = servletCtx.getResourceAsStream(fileName);
        if (in == null) {
            throw new IOException("Unable to open " + fileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buff = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buff.append(line).append("\n");
            line = reader.readLine();
        }
        reader.close();
        return buff.toString();
    }

    private static void createPasswordFiles(String basedir, String deployuri) throws IOException {
        String pwd = Crypt.encrypt((String)"secret");
        String location = basedir + deployuri + "/";
        AMSetupServlet.writeContent(location + ".keypass", pwd);
        AMSetupServlet.writeContent(location + ".storepass", pwd);
        InputStream in = servletCtx.getResourceAsStream("/WEB-INF/template/keystore/keystore.jks");
        byte[] b = new byte[2007];
        in.read(b);
        in.close();
        FileOutputStream fos = new FileOutputStream(location + "keystore.jks");
        fos.write(b);
        fos.flush();
        fos.close();
    }

    private static void writeContent(String fName, String content) throws IOException {
        OutputStreamWriter fout = null;
        try {
            fout = new FileWriter(new File(fName));
            fout.write(content);
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeContent: Exception in creating password files:", (Throwable)ioex);
            throw ioex;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static void updateEmbeddedIdRepo(String orgName, String configName, String entry) throws SMSException, SSOException {
        ServiceConfig subConfig;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
        ServiceConfig sc = scm.getOrganizationConfig(orgName, null);
        if (sc != null && (subConfig = sc.getSubConfig(configName)) != null) {
            Map configMap = subConfig.getAttributes();
            Set vals = (Set)configMap.get("sun-idrepo-ldapv3-config-ldap-server");
            vals.add(entry);
            HashMap<String, Set> mp = new HashMap<String, Set>(2);
            mp.put("sun-idrepo-ldapv3-config-ldap-server", vals);
            subConfig.setAttributes(mp);
        }
    }

    private static void updatePlatformServerList(String serverURL, String hostName) throws SMSException, SSOException {
        SSOToken token = AMSetupServlet.getAdminSSOToken();
        ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPlatformService", token);
        ServiceSchema ss = ssm.getGlobalSchema();
        AttributeSchema as = ss.getAttributeSchema("iplanet-am-platform-server-list");
        HashSet<String> values = as.getDefaultValues();
        if (!AMSetupServlet.isInPlatformList(values, serverURL)) {
            String instanceName = AMSetupServlet.getNextAvailableServerId(values);
            values.add(serverURL + "|" + instanceName);
            as.setDefaultValues(values);
            OrganizationConfigManager ocm = new OrganizationConfigManager(token, "/");
            Map attrs = ocm.getAttributes("sunIdentityRepositoryService");
            Set origValues = (Set)attrs.get("sunOrganizationAliases");
            if (!origValues.contains(hostName)) {
                values = new HashSet<String>();
                values.add(hostName);
                ocm.addAttributeValues("sunIdentityRepositoryService", "sunOrganizationAliases", values);
            }
        }
    }

    private static String getNextAvailableServerId(Set values) {
        boolean instanceNumber = true;
        int maxNumber = 1;
        Iterator items = values.iterator();
        while (items.hasNext()) {
            String item = (String)items.next();
            int index1 = item.indexOf(124);
            if (index1 == -1) continue;
            int index2 = item.indexOf(124, index1 + 1);
            item = index2 == -1 ? item.substring(index1 + 1) : item.substring(index1 + 1, index2);
            try {
                int n = Integer.parseInt(item);
                if (n <= maxNumber) continue;
                maxNumber = n;
            }
            catch (NumberFormatException nfe) {}
        }
        String instanceName = Integer.toString(maxNumber + 1);
        if (instanceName.length() == 1) {
            instanceName = "0" + instanceName;
        }
        return instanceName;
    }

    private static boolean isInPlatformList(Set values, String hostname) {
        boolean found = false;
        Iterator items = values.iterator();
        while (items.hasNext() && !found) {
            String item = (String)items.next();
            int idx = item.indexOf(124);
            if (idx == -1) continue;
            String svr = item.substring(0, idx);
            found = svr.equals(hostname);
        }
        return found;
    }

    private static boolean isAgentServiceLoad(SSOToken token) {
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", token);
            return ssm != null;
        }
        catch (SSOException ex) {
            return false;
        }
        catch (SMSException ex) {
            return false;
        }
    }

    private static void createDemoUser() {
        HashMap attributes = new HashMap();
        HashSet<String> setSN = new HashSet<String>(2);
        setSN.add("demo");
        attributes.put("sn", setSN);
        HashSet<String> setCN = new HashSet<String>(2);
        setCN.add("demo");
        attributes.put("cn", setCN);
        HashSet<String> setPwd = new HashSet<String>(2);
        setPwd.add("changeit");
        attributes.put("userpassword", setPwd);
        HashSet<String> setStatus = new HashSet<String>(2);
        setStatus.add("Active");
        attributes.put("inetuserstatus", setStatus);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(AMSetupServlet.getAdminSSOToken(), "/");
            amir.createIdentity(IdType.USER, "demo", attributes);
        }
        catch (IdRepoException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.createDemoUser", (Throwable)e);
        }
        catch (SSOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.createDemoUser", (Throwable)((Object)e));
        }
    }

    private static void createIdentitiesForWSSecurity(String serverURL, String deployuri) throws IdRepoException, SSOException {
        SSOToken token = AMSetupServlet.getAdminSSOToken();
        if (!AMSetupServlet.isAgentServiceLoad(token)) {
            return;
        }
        AMIdentityRepository idrepo = new AMIdentityRepository(token, "/");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("sunIdentityServerDeviceStatus", "Active");
        config.put("SecurityMech", "urn:sun:wss:security:null:UserNameToken");
        config.put("UserCredential", "UserName:test|UserPassword:test");
        config.put("useDefaultStore", "true");
        config.put("privateKeyAlias", "test");
        config.put("publicKeyAlias", "test");
        config.put("isRequestSign", "true");
        config.put("keepSecurityHeaders", "true");
        config.put("WSPEndpoint", "default");
        config.put("AgentType", "WSCAgent");
        AMSetupServlet.createAgent(token, idrepo, "wsc", "WSC", "", config);
        config.remove("AgentType");
        config.put("AgentType", "WSPAgent");
        config.remove("SecurityMech");
        config.put("SecurityMech", "urn:sun:wss:security:null:UserNameToken,urn:sun:wss:security:null:SAML2Token-HK,urn:sun:wss:security:null:SAML2Token-SV,urn:sun:wss:security:null:X509Token");
        AMSetupServlet.createAgent(token, idrepo, "wsp", "WSP", "", config);
        config.remove("AgentType");
        config.put("AgentType", "STSAgent");
        config.remove("SecurityMech");
        config.remove("UserCredential");
        config.remove("keepSecurityHeaders");
        config.remove("WSPEndpoint");
        config.put("SecurityMech", "urn:sun:wss:security:null:X509Token");
        config.put("STSEndpoint", serverURL + deployuri + "/sts");
        config.put("STSMexEndpoint", serverURL + deployuri + "/sts/mex");
        AMSetupServlet.createAgent(token, idrepo, "SecurityTokenService", "STS", "", config);
    }

    private static void createUser(AMIdentityRepository idrepo, String uid, String gn, String sn) throws IdRepoException, SSOException {
        HashMap attributes = new HashMap();
        HashSet<String> values = new HashSet<String>();
        values.add(uid);
        attributes.put("uid", values);
        values = new HashSet();
        values.add(gn);
        attributes.put("givenname", values);
        values = new HashSet();
        values.add(sn);
        attributes.put("sn", values);
        values = new HashSet();
        values.add(gn + " " + sn);
        attributes.put("cn", values);
        values = new HashSet();
        values.add(uid);
        attributes.put("userPassword", values);
        AMIdentity id = idrepo.createIdentity(IdType.USER, uid, attributes);
        id.assignService("sunIdentityServerDiscoveryService", Collections.EMPTY_MAP);
    }

    private static void createAgent(SSOToken adminToken, AMIdentityRepository idrepo, String name, String type, String desc, Map config) throws IdRepoException, SSOException {
        AMIdentity amid = new AMIdentity(adminToken, name, IdType.AGENTONLY, "/", null);
        if (!amid.isExists()) {
            HashMap attributes = new HashMap();
            HashSet<String> values = new HashSet<String>();
            values.add(name);
            attributes.put("userpassword", values);
            Iterator i = config.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)config.get(key);
                values = new HashSet();
                if (value.indexOf(",") != -1) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        values.add(st.nextToken());
                    }
                } else {
                    values.add(value);
                }
                attributes.put(key, values);
            }
            idrepo.createIdentity(IdType.AGENTONLY, name, attributes);
        }
    }

    private static void startRegistrationProcess(String basedir, String deployuri) {
        String libRegDir = basedir + "/" + deployuri + "/lib/registration";
        File reglibDir = new File(libRegDir);
        if (reglibDir.mkdirs()) {
            if (AMSetupServlet.copyRegFiles(libRegDir)) {
                StartRegister sr = new StartRegister();
                sr.servicetagTransfer();
            } else {
                Debug.getInstance((String)"amSetupServlet").error("configure: failed to copy registration files to " + reglibDir.getPath());
            }
        } else {
            Debug.getInstance((String)"amSetupServlet").error("configure: failed to create registration lib directory");
        }
    }

    private static boolean copyRegFiles(String destDir) {
        String[] jarFiles = new String[]{"scn_stprs_util.jar", "commons-codec-1.3.jar", "opensso-register.jar"};
        String[] xmlFiles = new String[]{"servicetag-registry.xml"};
        try {
            int i;
            for (i = 0; i < jarFiles.length; ++i) {
                AMSetupServlet.copyCtxFile("/WEB-INF/lib/", jarFiles[i], destDir);
            }
            for (i = 0; i < xmlFiles.length; ++i) {
                AMSetupServlet.copyCtxFile("/WEB-INF/classes/", xmlFiles[i], destDir);
            }
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.copyRegFiles:", (Throwable)ioex);
            return false;
        }
        return true;
    }

    private static void setupSecurIDDirs(String basedir, String deployuri) {
        String aceDataDir = basedir + "/" + deployuri + "/auth/ace/data";
        File dataAceDir = new File(aceDataDir);
        if (!dataAceDir.mkdirs()) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.setupSecurIDDirs: failed to create SecurID data directory");
        }
    }

    private static void copyAuthSecurIDFiles(String destDir) {
        String[] propFiles = new String[]{"log4j.properties"};
        try {
            for (int i = 0; i < propFiles.length; ++i) {
                AMSetupServlet.copyCtxFile("/WEB-INF/classes/", propFiles[i], destDir);
            }
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.copyAuthSecurIDFiles:", (Throwable)ioex);
        }
    }

    private static void setupSafeWordDirs(String basedir, String deployuri) {
        String safewordDir = basedir + "/" + deployuri + "/auth/safeword/serverVerification";
        File safewordFDir = new File(safewordDir);
        if (!safewordFDir.mkdirs()) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.setupSafeWordDirs: failed to create SafeWord verification directory");
        }
    }

    private static boolean copyCtxFile(String srcDir, String file, String destDir) throws IOException {
        FileOutputStream fos;
        InputStream in = servletCtx.getResourceAsStream(srcDir + file);
        if (in != null) {
            int len;
            fos = new FileOutputStream(destDir + "/" + file);
            byte[] b = new byte[2000];
            while ((len = in.read(b)) > 0) {
                fos.write(b, 0, len);
            }
        } else {
            return false;
        }
        fos.close();
        in.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDSConfigMgr(String str) throws LDAPServiceException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(str.getBytes());
            DSConfigMgr.initInstance(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String mapToString(Map map) {
        StringBuffer buff = new StringBuffer();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buff.append(key).append("=").append((String)map.get(key)).append("\n");
        }
        return buff.toString();
    }

    private static String determineOS() {
        String OS_ARCH = System.getProperty("os.arch");
        String OS_NAME = System.getProperty("os.name");
        if (OS_ARCH.toLowerCase().indexOf("86") >= 0) {
            if (OS_NAME.toLowerCase().indexOf("windows") >= 0) {
                return "windows";
            }
            if (OS_NAME.toLowerCase().indexOf("sunos") >= 0) {
                return "x86solaris";
            }
            return "linux";
        }
        return "solaris";
    }
}

