/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.protocol.https;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import sun.security.x509.GeneralName;
import sun.security.x509.X500Name;

public class AMHostnameVerifier
implements HostnameVerifier {
    public static boolean trustAllServerCerts = false;
    public static boolean checkSubjectAltName = false;
    public static boolean resolveIPAddress = false;
    public static HashSet sslTrustHosts = new HashSet();
    private static Debug debug = Debug.getInstance((String)"amJSSE");

    public boolean verify(String hostname, SSLSession session) {
        if (trustAllServerCerts) {
            return true;
        }
        boolean approve = true;
        X509Certificate peercert = null;
        String cn = null;
        try {
            X509Certificate[] peercerts = (X509Certificate[])session.getPeerCertificates();
            peercert = peercerts[0];
            String subjectDN = peercert.getSubjectDN().getName();
            cn = new X500Name(subjectDN).getCommonName();
        }
        catch (Exception ex) {
            debug.error("AMHostnameVerifier:" + ex.toString());
        }
        if (cn == null) {
            return false;
        }
        if (!sslTrustHosts.isEmpty() && sslTrustHosts.contains(cn.toLowerCase())) {
            return true;
        }
        if (resolveIPAddress) {
            try {
                approve = InetAddress.getByName(cn).getHostAddress().equals(InetAddress.getByName(hostname).getHostAddress());
            }
            catch (UnknownHostException ex) {
                if (debug.messageEnabled()) {
                    debug.message("AMHostnameVerifier:", (Throwable)ex);
                }
                approve = false;
            }
        } else {
            approve = false;
        }
        if (checkSubjectAltName && !approve) {
            try {
                Iterator<List<?>> i = peercert.getSubjectAlternativeNames().iterator();
                while (!approve && i.hasNext()) {
                    approve = this.compareHosts((GeneralName)((Object)i.next()), hostname);
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return approve;
    }

    private boolean compareHosts(GeneralName generalName, String hostname) {
        block3: {
            try {
                if (generalName.getType() == 2) {
                    String name = generalName.toString();
                    name = name.substring(name.indexOf(58) + 1).trim();
                    return InetAddress.getByName(name).equals(InetAddress.getByName(hostname));
                }
            }
            catch (UnknownHostException e) {
                if (!debug.messageEnabled()) break block3;
                debug.message(e.toString());
            }
        }
        return false;
    }

    private static void getSSLTrustHosts(String hostlist) {
        if (debug.messageEnabled()) {
            debug.message("AMHostnameVerifier  SSLTrustHostList = " + hostlist);
        }
        StringTokenizer st = new StringTokenizer(hostlist, ",");
        sslTrustHosts.clear();
        while (st.hasMoreTokens()) {
            sslTrustHosts.add(st.nextToken().trim().toLowerCase());
        }
    }

    static {
        String tmp = SystemProperties.get("com.iplanet.am.jssproxy.trustAllServerCerts");
        trustAllServerCerts = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.checkSubjectAltName");
        checkSubjectAltName = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.resolveIPAddress");
        resolveIPAddress = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.SSLTrustHostList", null);
        if (tmp != null) {
            AMHostnameVerifier.getSSLTrustHosts(tmp);
        }
        if (debug.messageEnabled()) {
            debug.message("AMHostnameVerifier trustAllServerCerts = " + trustAllServerCerts);
            debug.message("AMHostnameVerifier checkSubjectAltName = " + checkSubjectAltName);
            debug.message("AMHostnameVerifier  resolveIPAddress = " + resolveIPAddress);
            debug.message("AMHostnameVerifier  SSLTrustHostList = " + sslTrustHosts.toString());
        }
    }
}

