/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class SessionCondition
implements Condition {
    public static final String REQUEST_SESSION_CREATION_TIME = "requestSessionCreationTime";
    public static final String SESSION_CONDITION_ADVICE = "SessionConditionAdvice";
    public static final String ADVICE_TERMINATE_SESSION = "terminateSession";
    public static final String ADVICE_DENY = "deny";
    private static final String SSOTOKEN_PROPERTY_AUTHINSTANT = "authInstant";
    private static final String SESSION_CONDITION_TRUE_VALUE = "session_condition_true_value";
    private static final String SESSION_CONDITION_FALSE_VALUE = "session_condition_false_value";
    private Map properties;
    private long maxSessionTime;
    private boolean terminateSession;
    private static Debug debug = Debug.getInstance((String)"amPolicy");
    private static List propertyNames = new ArrayList(2);
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        if (property.equals("TerminateSession")) {
            return Syntax.SINGLE_CHOICE;
        }
        return Syntax.ANY;
    }

    public String getDisplayName(String property, java.util.Locale locale) throws PolicyException {
        ResourceBundle rb = amCache.getResBundle("amPolicy", locale);
        return Locale.getString((ResourceBundle)rb, (String)property);
    }

    public Set getValidValues(String property) throws PolicyException {
        if (property.equals("TerminateSession")) {
            OrderedSet values = new OrderedSet();
            values.add(SESSION_CONDITION_FALSE_VALUE);
            values.add(SESSION_CONDITION_TRUE_VALUE);
            return values;
        }
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        long tokenCreationTime;
        boolean allowed = false;
        Long requestSessionCreationTime = null;
        if (token == null) {
            return new ConditionDecision(true, Long.MAX_VALUE);
        }
        if (env != null) {
            try {
                requestSessionCreationTime = (Long)env.get(REQUEST_SESSION_CREATION_TIME);
            }
            catch (ClassCastException e) {
                Object[] args = new String[]{REQUEST_SESSION_CREATION_TIME};
                throw new PolicyException("amPolicy", "property_is_not_a_Long", args, null);
            }
        }
        if (requestSessionCreationTime != null) {
            tokenCreationTime = requestSessionCreationTime;
        } else {
            try {
                tokenCreationTime = DateUtils.stringToDate((String)token.getProperty(SSOTOKEN_PROPERTY_AUTHINSTANT)).getTime();
            }
            catch (ParseException e) {
                throw new PolicyException("amPolicy", "unable_to_parse_ssotoken_authinstant", null, e);
            }
        }
        long currentTime = System.currentTimeMillis();
        long timeToLive = Long.MAX_VALUE;
        long expiredTime = tokenCreationTime + this.maxSessionTime;
        if (debug.messageEnabled()) {
            debug.message("SessionCondition.getConditionDecision():" + "\n  currentTime: " + currentTime + "\n  expiredTime: " + expiredTime);
        }
        ConditionDecision conditionDecision = null;
        if (currentTime < expiredTime) {
            allowed = true;
            timeToLive = expiredTime;
            conditionDecision = new ConditionDecision(allowed, timeToLive);
        } else {
            HashSet<String> adviceMessages;
            HashMap advices;
            block16: {
                advices = new HashMap(1);
                adviceMessages = null;
                if (this.terminateSession) {
                    adviceMessages = new HashSet<String>(2);
                    adviceMessages.add(ADVICE_DENY);
                    adviceMessages.add(ADVICE_TERMINATE_SESSION);
                    try {
                        SSOTokenManager.getInstance().destroyToken(token);
                        if (debug.messageEnabled()) {
                            debug.message("SessionCondition.getConditionDecision(): successfully terminated user session!");
                        }
                        break block16;
                    }
                    catch (SSOException ssoEx) {
                        if (debug.warningEnabled()) {
                            debug.warning("SessionCondition.getConditionDecision(): failed to terminate user session!", (Throwable)((Object)ssoEx));
                        }
                        break block16;
                    }
                }
                adviceMessages = new HashSet(1);
                adviceMessages.add(ADVICE_DENY);
            }
            advices.put(SESSION_CONDITION_ADVICE, adviceMessages);
            conditionDecision = new ConditionDecision(allowed, timeToLive, advices);
        }
        return conditionDecision;
    }

    public Object clone() {
        SessionCondition theClone = null;
        try {
            theClone = (SessionCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SessionCondition.validateProperties(): properties: " + this.properties);
        }
        String value = this.getPropertyStringValue("MaxSessionTime", true);
        try {
            int i = Integer.parseInt(value);
            if (i <= 0) {
                Object[] args = new String[]{"MaxSessionTime", value};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            this.maxSessionTime = i * 60000;
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{"MaxSessionTime"};
            throw new PolicyException("amPolicy", "property_is_not_an_Integer", args, null);
        }
        value = this.getPropertyStringValue("TerminateSession", false);
        if (value != null && value.equals(SESSION_CONDITION_TRUE_VALUE)) {
            this.terminateSession = true;
        }
        return true;
    }

    private String getPropertyStringValue(String propertyName, boolean required) throws PolicyException {
        Set values = (Set)this.properties.get(propertyName);
        if (values == null || values.isEmpty()) {
            if (required) {
                Object[] args = new String[]{propertyName};
                throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
            }
            return null;
        }
        return (String)values.iterator().next();
    }

    static {
        propertyNames.add("MaxSessionTime");
        propertyNames.add("TerminateSession");
    }
}

