/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class LDAPRoles
implements Subject {
    static final String LDAP_OBJECT_CLASS = "objectclass";
    static final String LDAP_ROLE_ATTR = "nsroledefinition";
    static final String LDAP_USER_ROLE_ATTR = "nsrole";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    public static Map userLDAPRoleCache = Collections.synchronizedMap(new HashMap());
    private boolean initialized = false;
    private Set selectedRoleDNs = Collections.EMPTY_SET;
    private Set selectedRFCRoleDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String roleSearchFilter;
    private int roleSearchScope = 2;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String roleRDNAttrName;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private LDAPConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    private String ldapServer;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map configParams) throws PolicyException {
        if (configParams == null) {
            throw new PolicyException("amPolicy", "ldaproles_initialization_failed", null, null);
        }
        String configuredLdapServer = (String)configParams.get("iplanet-am-policy-config-ldap-server");
        if (configuredLdapServer == null) {
            debug.error("LDAPRoles.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = configuredLdapServer.toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)configParams.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)configParams.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)configParams.get("iplanet-am-policy-config-ldap-bind-password");
        if (this.authpw != null) {
            this.authpw = PolicyUtils.decrypt(this.authpw);
        }
        this.baseDN = (String)configParams.get("iplanet-am-policy-config-ldap-base-dn");
        this.roleSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-roles-search-filter");
        String scope = (String)configParams.get("iplanet-am-policy-config-ldap-roles-search-scope");
        this.roleSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.roleRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-roles-search-attribute");
        this.userSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-filter");
        scope = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException nfe) {
            throw new PolicyException(nfe);
        }
        String ssl = (String)configParams.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = ssl.equalsIgnoreCase("true");
        Set orgNameSet = (Set)configParams.get("OrganizationName");
        if (orgNameSet != null && orgNameSet.size() != 0) {
            Iterator items = orgNameSet.iterator();
            this.orgName = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.initialize(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nroleSearchFilter: " + this.roleSearchFilter + "\nroleRDNAttrName: " + this.roleRDNAttrName + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldaproles_subject_not_yet_initialized", null, null);
        }
        String searchFilter = null;
        searchFilter = pattern != null && pattern.trim().length() != 0 ? "(&" + this.roleSearchFilter + "(" + this.roleRDNAttrName + "=" + pattern + "))" : this.roleSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.getValidValues(): role search filter is: " + searchFilter);
        }
        String[] attrs = new String[]{this.roleRDNAttrName};
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> validRoleDNs = new HashSet<String>();
        int status = 0;
        try {
            ld.authenticate(this.authid, this.authpw);
            LDAPSearchResults res = ld.search(this.baseDN, this.roleSearchScope, searchFilter, attrs, false, constraints);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    validRoleDNs.add(entry.getDN());
                    if (!debug.messageEnabled()) continue;
                    debug.message("LDAPRoles.getValidValues(): found role name=" + entry.getDN());
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    String[] objs = new String[]{this.orgName};
                    int resultCode = le.getLDAPResultCode();
                    if (resultCode == 4) {
                        debug.warning("LDAPRoles.getValidValues(): exceeded the size limit");
                        status = 1;
                        continue;
                    }
                    if (resultCode != 3) throw new PolicyException(le);
                    debug.warning("LDAPRoles.getValidValues(): exceeded the time limit");
                    status = 2;
                    continue;
                    return new ValidValues(status, validRoleDNs);
                }
            }
        }
        catch (LDAPException lde) {
            int ldapErrorCode = lde.getLDAPResultCode();
            if (ldapErrorCode == 49) {
                throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
            }
            if (ldapErrorCode == 32) {
                Object[] objs = new String[]{this.baseDN};
                throw new PolicyException("amPolicy", "no_such_ldap_base_dn", objs, null);
            }
            String errorMsg = lde.getLDAPErrorMessage();
            String additionalMsg = lde.errorCodeToString();
            if (additionalMsg == null) throw new PolicyException(errorMsg);
            throw new PolicyException(errorMsg + ": " + additionalMsg);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        finally {
            this.connPool.close(ld);
        }
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(value);
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.getValues() gets called");
        }
        return this.selectedRoleDNs;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            debug.error("LDAPRoles.setValues() Invalid names");
            throw new InvalidNameException("amPolicy", "ldaproles_subject_invalid_group_names", null, null, 5);
        }
        this.selectedRoleDNs = new HashSet();
        this.selectedRoleDNs.addAll(names);
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.setValues(): selected role names=" + this.selectedRoleDNs);
        }
        this.selectedRFCRoleDNs = new HashSet();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.selectedRFCRoleDNs.add(new DN((String)it.next()).toRFCString().toLowerCase());
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        boolean roleMatch = false;
        String userLocalDN = token.getPrincipal().getName();
        if (this.selectedRFCRoleDNs.size() > 0) {
            LDAPEntry userEntry = null;
            Set userRoles = null;
            boolean listenerAdded = false;
            String tokenID = ((Object)token.getTokenID()).toString();
            Iterator items = this.selectedRFCRoleDNs.iterator();
            while (items.hasNext()) {
                String roleName = (String)items.next();
                Boolean matchFound = null;
                matchFound = SubjectEvaluationCache.isMember(tokenID, this.ldapServer, roleName);
                if (matchFound != null) {
                    boolean result;
                    if (debug.messageEnabled()) {
                        debug.message("LDAPRoles.isMember():Got membership from cache of " + userLocalDN + " in LDAP role " + roleName + " :" + matchFound);
                    }
                    if (!(result = matchFound.booleanValue())) continue;
                    return result;
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPRoles.isMember():did not find entry  for " + roleName + " in SubjectEvaluation " + "cache,  getting from LDAPRole cache");
                }
                if (userEntry == null && (userEntry = this.getUserEntry(token)) == null) {
                    if (debug.messageEnabled()) {
                        debug.message("LDAPRoles.isMember(): User " + userLocalDN + " is not found in the directory");
                    }
                    return false;
                }
                if (userRoles == null) {
                    userRoles = this.getUserRoles(token, userEntry);
                }
                if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
                    token.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPRoles.isMember(): sso listener added .\n");
                    }
                    listenerAdded = true;
                }
                if (userRoles != null && userRoles.size() > 0 && userRoles.contains(roleName)) {
                    roleMatch = true;
                }
                if (debug.messageEnabled()) {
                    String member = roleMatch ? "is member of" : "is not a member of";
                    debug.message("LDAPRoles.isMember(): User " + userLocalDN + " " + member + " the LDAPRole " + roleName + ", adding to Subject eval cache");
                }
                SubjectEvaluationCache.addEntry(tokenID, this.ldapServer, roleName, roleMatch);
                if (!roleMatch) continue;
                break;
            }
        }
        if (debug.messageEnabled()) {
            if (!roleMatch) {
                debug.message("LDAPRoles.isMember(): User " + userLocalDN + " is not a member of this LDAPRoles object");
            } else {
                debug.message("LDAPRoles.isMember(): User " + userLocalDN + " is a member of this LDAPRoles object");
            }
        }
        return roleMatch;
    }

    public int hashCode() {
        return ((Object)this.selectedRoleDNs).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LDAPRoles) {
            LDAPRoles roles = (LDAPRoles)o;
            if (this.selectedRoleDNs != null && roles.selectedRoleDNs != null && ((Object)this.selectedRoleDNs).equals(roles.selectedRoleDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPRoles theClone = null;
        try {
            theClone = (LDAPRoles)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.selectedRoleDNs != null) {
            theClone.selectedRoleDNs = new HashSet();
            theClone.selectedRoleDNs.addAll(this.selectedRoleDNs);
        }
        if (this.selectedRFCRoleDNs != null) {
            theClone.selectedRFCRoleDNs = new HashSet();
            theClone.selectedRFCRoleDNs.addAll(this.selectedRFCRoleDNs);
        }
        return theClone;
    }

    private Set getUserRoles(SSOToken token, LDAPEntry userEntry) throws SSOException, PolicyException {
        long currentTime;
        long timeToLive;
        Object[] element;
        if (token == null) {
            return null;
        }
        String tokenIDStr = ((Object)token.getTokenID()).toString();
        Map serverRoleMap = null;
        serverRoleMap = (Map)userLDAPRoleCache.get(tokenIDStr);
        if (serverRoleMap != null && (element = (Object[])serverRoleMap.get(this.ldapServer)) != null && (timeToLive = element[0] == null ? 0L : (Long)element[0]) > (currentTime = System.currentTimeMillis())) {
            if (debug.messageEnabled()) {
                debug.message("LDAPRoles.getUserRoles(): get the nsrole values from cache.\n");
            }
            return (Set)element[1];
        }
        HashSet<String> roles = new HashSet<String>();
        if (userEntry != null) {
            LDAPAttribute attribute = userEntry.getAttribute(LDAP_USER_ROLE_ATTR);
            if (attribute != null) {
                Enumeration enumVals = attribute.getStringValues();
                while (enumVals.hasMoreElements()) {
                    roles.add(new DN((String)enumVals.nextElement()).toRFCString().toLowerCase());
                }
            }
            Object[] elem = new Object[]{new Long(System.currentTimeMillis() + SubjectEvaluationCache.getSubjectEvalTTL()), roles};
            serverRoleMap = null;
            serverRoleMap = (Map)userLDAPRoleCache.get(tokenIDStr);
            if (serverRoleMap == null) {
                serverRoleMap = Collections.synchronizedMap(new HashMap());
                serverRoleMap.put(this.ldapServer, elem);
                userLDAPRoleCache.put(tokenIDStr, serverRoleMap);
            } else {
                serverRoleMap.put(this.ldapServer, elem);
            }
        }
        return roles;
    }

    /*
     * Exception decompiling
     */
    private LDAPEntry getUserEntry(SSOToken token) throws SSOException, PolicyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

