/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthSchemeCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    public static final String AUTH_SCHEME_CONDITION_ADVICE = "AuthSchemeConditionAdvice";
    public static final String APPLICATION_IDLE_TIMESOUT_AT_PREFIX = "am.protected.policy.AppIdleTimesoutAt.";
    public static final String FORCE_AUTH_ADVICE = "ForceAuth";
    public static final String TRUE = "true";
    public static final String MODULE_INSTANCE = "module_instance";
    private Map properties;
    private Set authSchemes = new HashSet();
    private int appIdleTimeout = Integer.MAX_VALUE;
    private String appName = null;
    private String appIdleTimesoutAtSessionKey = null;
    private boolean appIdleTimeoutEnabled = false;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.validateProperties();
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At AuthSchemeCondition.setProperties():authSchemes=" + this.authSchemes + ", appName=" + this.appName + ", appIdleTimeout millis=" + this.appIdleTimeout + ", appIdleTimeoutEnabled=" + this.appIdleTimeoutEnabled + ", appIdleTimesoutAtSessionKey" + this.appIdleTimesoutAtSessionKey);
        }
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    /*
     * Unable to fully structure code
     */
    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        if (AuthSchemeCondition.DEBUG.messageEnabled()) {
            AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():entering:authSchemes=" + this.authSchemes + ", appName=" + this.appName + ", appIdleTimeout=" + this.appIdleTimeout);
        }
        allowed = false;
        requestAuthSchemes = null;
        requestAuthSchemesIgnoreRealm = null;
        if (env != null && env.get("requestAuthSchemes") != null) {
            try {
                requestAuthSchemes = (Set)env.get("requestAuthSchemes");
                if (!AuthSchemeCondition.DEBUG.messageEnabled()) ** GOTO lbl21
                AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision(): requestAuthSchemes from env= " + requestAuthSchemes);
            }
            catch (ClassCastException e) {
                args = new String[]{"requestAuthSchemes"};
                throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
            }
        } else if (token != null) {
            requestAuthSchemes = AMAuthUtils.getRealmQualifiedAuthenticatedSchemes(token);
            requestAuthSchemesIgnoreRealm = AMAuthUtils.getAuthenticatedSchemes(token);
            if (AuthSchemeCondition.DEBUG.messageEnabled()) {
                AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision(): requestAuthSchemes from ssoToken= " + requestAuthSchemes);
                AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision(): requestAuthSchemesIgnoreRealm from ssoToken= " + requestAuthSchemesIgnoreRealm);
            }
        }
lbl21:
        // 7 sources

        if (requestAuthSchemes == null) {
            requestAuthSchemes = Collections.EMPTY_SET;
        }
        if (requestAuthSchemesIgnoreRealm == null) {
            requestAuthSchemesIgnoreRealm = Collections.EMPTY_SET;
        }
        authSchemesIter = this.authSchemes.iterator();
        authScheme = null;
        allowed = true;
        adviceMessages = new HashSet<String>(this.authSchemes.size());
        while (authSchemesIter.hasNext()) {
            authScheme = (String)authSchemesIter.next();
            if (requestAuthSchemes.contains(authScheme)) continue;
            realm = AMAuthUtils.getRealmFromRealmQualifiedData(authScheme);
            if (realm != null && realm.length() != 0) {
                allowed = false;
                adviceMessages.add(authScheme);
                if (!AuthSchemeCondition.DEBUG.messageEnabled()) break;
                AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():authScheme not satisfied = " + authScheme);
                break;
            }
            if (realm != null && realm.length() != 0 || requestAuthSchemesIgnoreRealm.contains(authScheme)) continue;
            allowed = false;
            adviceMessages.add(authScheme);
            if (!AuthSchemeCondition.DEBUG.messageEnabled()) break;
            AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():authScheme not satisfied = " + authScheme);
            break;
        }
        if (AuthSchemeCondition.DEBUG.messageEnabled()) {
            AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():authSchemes = " + this.authSchemes + "," + " requestAuthSchemes = " + requestAuthSchemes + ", " + " allowed before appIdleTimeout check = " + allowed);
        }
        advices = new HashMap<String, HashSet<E>>();
        if (!allowed) {
            advices.put("AuthSchemeConditionAdvice", adviceMessages);
        }
        timeToLive = 0x7FFFFFFFFFFFFFFFL;
        currentTimeMillis = System.currentTimeMillis();
        expiredAuthSchemes = new HashSet<E>();
        if (this.appIdleTimeoutEnabled) {
            if (allowed) {
                idleTimesOutAtMillis = this.getApplicationIdleTimesoutAt(token, expiredAuthSchemes, currentTimeMillis);
                if (idleTimesOutAtMillis <= currentTimeMillis) {
                    allowed = false;
                }
                if (AuthSchemeCondition.DEBUG.messageEnabled()) {
                    AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():currentTimeMillis = " + currentTimeMillis + ", idleTimesOutAtMillis = " + idleTimesOutAtMillis + ", expiredAuthSchemes = " + expiredAuthSchemes + ", allowed after appIdleTimeout check = " + allowed);
                }
            }
            if (allowed) {
                appIdleTimesoutAt = currentTimeMillis + (long)this.appIdleTimeout;
                token.setProperty(this.appIdleTimesoutAtSessionKey, Long.toString(appIdleTimesoutAt));
                timeToLive = appIdleTimesoutAt;
                if (AuthSchemeCondition.DEBUG.messageEnabled()) {
                    AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():app access allowed, revised appIdleTimesOutAt=" + appIdleTimesoutAt + ", currentTimeMillis=" + currentTimeMillis);
                }
            } else {
                adviceMessages.addAll(expiredAuthSchemes);
                advices.put("AuthSchemeConditionAdvice", adviceMessages);
                forceAuthAdvices = new HashSet<String>();
                forceAuthAdvices.add("true");
                advices.put("ForceAuth", forceAuthAdvices);
            }
        }
        if (AuthSchemeCondition.DEBUG.messageEnabled()) {
            AuthSchemeCondition.DEBUG.message("At AuthSchemeCondition.getConditionDecision():just before return:allowed = " + allowed + ", timeToLive = " + timeToLive + ", advices = " + advices);
        }
        return new ConditionDecision(allowed, timeToLive, advices);
    }

    public Object clone() {
        AuthSchemeCondition theClone = null;
        try {
            theClone = (AuthSchemeCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        Set appIdleTimeoutSet;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = this.properties.keySet();
        if (!keySet.contains("AuthScheme")) {
            Object[] args = new String[]{"AuthScheme"};
            throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
        }
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("AuthScheme".equals(key) || "ApplicationName".equals(key) || "ApplicationIdleTimeout".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", args, null);
        }
        Set authSchemeSet = (Set)this.properties.get("AuthScheme");
        if (authSchemeSet != null) {
            this.validateAuthSchemes(authSchemeSet);
        }
        this.appIdleTimeoutEnabled = false;
        this.appName = null;
        this.appIdleTimesoutAtSessionKey = null;
        Set appNameSet = (Set)this.properties.get("ApplicationName");
        if (appNameSet != null && !appNameSet.isEmpty()) {
            this.appName = (String)appNameSet.iterator().next();
            this.appName = this.appName.trim();
            if (this.appName.length() == 0) {
                this.appName = null;
            } else {
                this.appIdleTimesoutAtSessionKey = APPLICATION_IDLE_TIMESOUT_AT_PREFIX + this.appName;
            }
        }
        if ((appIdleTimeoutSet = (Set)this.properties.get("ApplicationIdleTimeout")) != null && !appIdleTimeoutSet.isEmpty()) {
            String appIdleTimeoutString = (String)appIdleTimeoutSet.iterator().next();
            if ((appIdleTimeoutString = appIdleTimeoutString.trim()).length() == 0) {
                appIdleTimeoutString = null;
            } else {
                try {
                    this.appIdleTimeout = Integer.parseInt(appIdleTimeoutString);
                    this.appIdleTimeout = this.appIdleTimeout * 60 * 1000;
                }
                catch (NumberFormatException nfe) {
                    if (DEBUG.warningEnabled()) {
                        DEBUG.warning("At AuthSchemeCondition.validateProperties():can not parse appIdleTeimoutdefaulting to 2147483647");
                    }
                    this.appIdleTimeout = Integer.MAX_VALUE;
                }
            }
        }
        if (this.appName != null && this.appIdleTimeout != Integer.MAX_VALUE) {
            this.appIdleTimeoutEnabled = true;
        }
        return true;
    }

    private boolean validateAuthSchemes(Set authSchemeSet) throws PolicyException {
        if (authSchemeSet.isEmpty()) {
            Object[] args = new String[]{"AuthScheme"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", args, null);
        }
        Iterator authSchemeSetIter = authSchemeSet.iterator();
        this.authSchemes.clear();
        while (authSchemeSetIter.hasNext()) {
            try {
                String authScheme = (String)authSchemeSetIter.next();
                this.authSchemes.add(authScheme);
            }
            catch (ClassCastException e) {
                Object[] args = new String[]{"AuthScheme"};
                throw new PolicyException("amPolicy", "property_is_not_a_String", args, null);
            }
        }
        return true;
    }

    private long getApplicationIdleTimesoutAt(SSOToken ssoToken, Set expiredAuthSchemes, long currentTimeMillis) throws SSOException, PolicyException {
        long idleTimesoutAtMillis = 0L;
        String idleTimesoutAtString = ssoToken.getProperty(this.appIdleTimesoutAtSessionKey);
        if (idleTimesoutAtString != null) {
            block8: {
                try {
                    idleTimesoutAtMillis = Long.parseLong(idleTimesoutAtString);
                }
                catch (NumberFormatException nfe) {
                    if (!DEBUG.warningEnabled()) break block8;
                    DEBUG.warning("At AuthSchemeCondition.getApplicationIdleTimesoutAt():can not parse idleTimeoutAtMillis, defaulting to 0");
                }
            }
            DEBUG.message("At AuthSchemeCondition.getApplicationIdleTimesoutAt():,idleTimeoutAtMillis based on last access=" + idleTimesoutAtMillis + ", currentTimeMillis=" + currentTimeMillis);
        } else if (DEBUG.messageEnabled()) {
            DEBUG.message("At AuthSchemeCondition.getApplicationIdleTimesoutAt():" + this.appIdleTimesoutAtSessionKey + " not set, " + "first visit to application");
        }
        if (idleTimesoutAtMillis <= currentTimeMillis) {
            Iterator authSchemesIter = this.authSchemes.iterator();
            while (authSchemesIter.hasNext()) {
                String authScheme = (String)authSchemesIter.next();
                long authInstant = AMAuthUtils.getAuthInstant(ssoToken, MODULE_INSTANCE, authScheme);
                idleTimesoutAtMillis = authInstant + (long)this.appIdleTimeout;
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("At AuthSchemeCondition.getApplicationIdleTimesoutAt():authScheme=" + authScheme + ",authInstant=" + authInstant + ",idleTimesoutAtMillis=" + idleTimesoutAtMillis + ",currentTimeMillis=" + currentTimeMillis);
                }
                if (idleTimesoutAtMillis > currentTimeMillis) continue;
                expiredAuthSchemes.add(authScheme);
                if (!DEBUG.messageEnabled()) break;
                DEBUG.message("At AuthSchemeCondition.getApplicationIdleTimesoutAt():expired authScheme=" + authScheme);
                break;
            }
        }
        return idleTimesoutAtMillis;
    }

    static {
        propertyNames.add("AuthScheme");
        propertyNames.add("ApplicationName");
        propertyNames.add("ApplicationIdleTimeout");
    }
}

