/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class Rule
implements Cloneable {
    public static final String EMPTY_RESOURCE_NAME = "";
    private String ruleName;
    private String serviceTypeName;
    private ServiceType serviceType;
    String resourceName = "";
    private Map actions;

    protected Rule() {
    }

    public Rule(String serviceName, String resourceName, Map actions) throws NameNotFoundException, InvalidNameException {
        this(null, serviceName, resourceName, actions);
    }

    public Rule(String serviceName, Map actions) throws NameNotFoundException, InvalidNameException {
        this(null, serviceName, null, actions);
    }

    public Rule(String ruleName, String serviceName, String resourceName, Map actions) throws NameNotFoundException, InvalidNameException {
        String string = this.ruleName = ruleName != null ? ruleName : "rule" + ServiceTypeManager.generateRandomName();
        if (resourceName == null || resourceName == EMPTY_RESOURCE_NAME) {
            resourceName = EMPTY_RESOURCE_NAME;
        }
        this.resourceName = resourceName.trim();
        this.checkAndSetServiceType(serviceName);
        this.serviceTypeName = serviceName;
        this.serviceType.validateActionValues(actions);
        this.actions = new HashMap(actions);
        try {
            this.resourceName = this.serviceType.canonicalize(resourceName);
        }
        catch (PolicyException pe) {
            throw new InvalidNameException(pe, resourceName, 2);
        }
    }

    protected Rule(Node ruleNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException {
        Node serviceNode;
        if (!ruleNode.getNodeName().equalsIgnoreCase("Rule")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid rule xml blob given to constructor");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_node", null, EMPTY_RESOURCE_NAME, 2);
        }
        this.ruleName = XMLUtils.getNodeAttributeValue((Node)ruleNode, (String)"name");
        if (this.ruleName == null) {
            this.ruleName = "rule" + ServiceTypeManager.generateRandomName();
        }
        if ((serviceNode = XMLUtils.getChildNode((Node)ruleNode, (String)"ServiceName")) == null || (this.serviceTypeName = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"name")) == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid service name in rule xml blob in constructor");
            }
            Object[] objs = new String[]{this.serviceTypeName == null ? "null" : this.serviceTypeName};
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_service_name", objs, this.ruleName, 2);
        }
        this.checkAndSetServiceType(this.serviceTypeName);
        Node resourceNode = XMLUtils.getChildNode((Node)ruleNode, (String)"ResourceName");
        if (resourceNode != null && (this.resourceName = XMLUtils.getNodeAttributeValue((Node)resourceNode, (String)"name")) == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid resource name in rule xml blob in constructor");
            }
            Object[] objs = new String[]{this.resourceName == null ? "null" : this.resourceName};
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_resource_name", objs, this.ruleName, 2);
        }
        if (this.resourceName != null) {
            this.resourceName = this.resourceName.trim();
            try {
                this.resourceName = this.serviceType.canonicalize(this.resourceName);
            }
            catch (PolicyException pe) {
                throw new InvalidNameException(pe, this.resourceName, 2);
            }
        }
        Set actionNodes = XMLUtils.getChildNodes((Node)ruleNode, (String)"AttributeValuePair");
        this.actions = new HashMap();
        if (actionNodes != null) {
            Iterator items = actionNodes.iterator();
            while (items.hasNext()) {
                String actionName = null;
                Set actionValues = null;
                Node node = (Node)items.next();
                Node attrNode = XMLUtils.getChildNode((Node)node, (String)"Attribute");
                if (attrNode == null || (actionName = XMLUtils.getNodeAttributeValue((Node)attrNode, (String)"name")) == null || (actionValues = XMLUtils.getAttributeValuePair((Node)node)) == null) {
                    Object[] objs = new String[]{actionName == null ? "null" : actionName};
                    throw new InvalidFormatException("amPolicy", "invalid_xml_rule_action_name", objs, this.ruleName, 2);
                }
                this.actions.put(actionName, actionValues);
            }
            this.serviceType.validateActionValues(this.actions);
        }
    }

    private void checkAndSetServiceType(String serviceTypeName) throws NameNotFoundException {
        ServiceTypeManager stm = null;
        try {
            stm = ServiceTypeManager.getServiceTypeManager();
            this.serviceType = stm.getServiceType(serviceTypeName);
        }
        catch (SSOException ssoe) {
            PolicyManager.debug.error("Unable to get admin SSO token" + (Object)((Object)ssoe));
            throw new NameNotFoundException((Throwable)((Object)ssoe), serviceTypeName, 3);
        }
    }

    public String getName() {
        return this.ruleName;
    }

    public void setName(String ruleName) throws InvalidNameException {
        this.ruleName = ruleName != null ? ruleName : "rule" + ServiceTypeManager.generateRandomName();
    }

    public String getServiceTypeName() {
        return this.serviceTypeName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Set getActionNames() {
        return new HashSet(this.actions.keySet());
    }

    public Set getActionValues(String actionName) throws NameNotFoundException {
        Set answer = (Set)this.actions.get(actionName);
        if (answer != null) {
            answer = (Set)((HashSet)answer).clone();
        }
        return answer;
    }

    public Map getActionValues() {
        return new HashMap(this.actions);
    }

    public void setActionValues(Map actionValues) throws InvalidNameException {
        this.serviceType.validateActionValues(actionValues);
        this.actions = new HashMap(actionValues);
    }

    public boolean equals(Object o) {
        if (o instanceof Rule) {
            Rule rule = (Rule)o;
            if (this.isResourceMatch(rule.serviceTypeName, rule.resourceName).equals(ResourceMatch.EXACT_MATCH)) {
                return ((Object)this.actions).equals(rule.actions);
            }
        }
        return false;
    }

    public ResourceMatch isResourceMatch(String serviceName, String resourceName) {
        ResourceMatch rm = null;
        rm = !serviceName.equalsIgnoreCase(this.serviceTypeName) ? ResourceMatch.NO_MATCH : this.serviceType.compare(resourceName, this.resourceName);
        return rm;
    }

    public String toXML() {
        StringBuffer answer = new StringBuffer(100);
        answer.append("\n").append("<Rule");
        if (this.ruleName != null) {
            answer.append(" name=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)this.ruleName));
            answer.append("\">");
        } else {
            answer.append(">");
        }
        answer.append("\n").append("<ServiceName name=\"");
        answer.append(XMLUtils.escapeSpecialCharacters((String)this.serviceTypeName));
        answer.append("\" />");
        if (this.resourceName != null) {
            answer.append("\n").append("<ResourceName name=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)this.resourceName));
            answer.append("\" />");
        }
        Iterator actionNameItems = this.actions.keySet().iterator();
        while (actionNameItems.hasNext()) {
            String actionName = (String)actionNameItems.next();
            answer.append("\n").append("<AttributeValuePair>");
            answer.append("\n").append("<Attribute name=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)actionName));
            answer.append("\" />");
            Set values = (Set)this.actions.get(actionName);
            if (values.size() > 0) {
                Iterator items = values.iterator();
                while (items.hasNext()) {
                    answer.append("\n").append("<Value>");
                    answer.append(XMLUtils.escapeSpecialCharacters((String)((String)items.next())));
                    answer.append("</Value>");
                }
            }
            answer.append("\n").append("</AttributeValuePair>");
        }
        answer.append("\n").append("</Rule>");
        return answer.toString();
    }

    protected ServiceType getServiceType() {
        return this.serviceType;
    }

    protected String toResourcesXml(String policyName) {
        StringBuffer beginning = new StringBuffer(100);
        beginning.append("<").append("PolicyCrossReferences").append(" ").append("name").append("=\"").append(this.serviceTypeName).append("\" ").append("type").append("=\"").append("Resources").append("\">");
        String normalizedResName = this.resourceName;
        if (this.resourceName == null || this.resourceName.length() == 0) {
            normalizedResName = "---EMPTY---";
        }
        String[] resources = this.serviceType.split(normalizedResName);
        int n = resources.length;
        StringBuffer middle = new StringBuffer(100);
        middle.append("<").append("Reference").append(" ").append("name").append("=\"").append(resources[n - 1]).append("\"><").append("PolicyName").append(" ").append("name").append("=\"").append(policyName).append("\"/></").append("Reference").append(">");
        String tmp = middle.toString();
        for (int i = n - 2; i >= 0; --i) {
            tmp = "<Reference name=\"" + resources[i] + "\">" + tmp + "</" + "Reference" + ">";
        }
        return beginning + tmp + "</" + "PolicyCrossReferences" + ">";
    }

    public String toString() {
        return this.toXML();
    }

    public Object clone() {
        Rule answer = null;
        try {
            answer = (Rule)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new Rule();
        }
        answer.ruleName = this.ruleName;
        answer.serviceTypeName = this.serviceTypeName;
        answer.serviceType = this.serviceType;
        answer.resourceName = this.resourceName;
        answer.actions = new HashMap();
        Iterator items = this.actions.keySet().iterator();
        while (items.hasNext()) {
            Object o = items.next();
            Set set = (Set)this.actions.get(o);
            HashSet aset = new HashSet();
            aset.addAll(set);
            answer.actions.put(o, aset);
        }
        return answer;
    }

    Map getActionValues(String resourceType, String resourceName, Set actionNames) throws NameNotFoundException {
        ResourceMatch rm;
        HashMap<String, Set> actionValues = null;
        String serviceTypeName = this.getServiceTypeName();
        if (serviceTypeName.equalsIgnoreCase(resourceType) && actionNames != null && (ResourceMatch.EXACT_MATCH.equals(rm = this.isResourceMatch(resourceType, resourceName)) || ResourceMatch.WILDCARD_MATCH.equals(rm))) {
            actionValues = new HashMap<String, Set>();
            Iterator actionIter = actionNames.iterator();
            while (actionIter.hasNext()) {
                String actionName = (String)actionIter.next();
                Set values = this.getActionValues(actionName);
                if (values == null) continue;
                actionValues.put(actionName, values);
            }
        }
        return actionValues;
    }
}

