/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.plugins.LDAPRoles;
import com.sun.identity.shared.debug.Debug;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PolicySSOTokenListener
implements SSOTokenListener {
    private static Map resultsCache = PolicyEvaluator.policyResultsCache;
    private static Debug debug = PolicyManager.debug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            SSOTokenID tokenId = evt.getToken().getTokenID();
            String tokenIdStr = ((Object)tokenId).toString();
            if (tokenIdStr == null) {
                debug.error("PolicySSOTokenListener: token id string is null");
                return;
            }
            Map map = PolicyEvaluator.policyResultsCache;
            synchronized (map) {
                if (!resultsCache.isEmpty()) {
                    Set svcInCache = resultsCache.keySet();
                    Iterator svcInCacheIter = svcInCache.iterator();
                    while (svcInCacheIter.hasNext()) {
                        String svcName = (String)svcInCacheIter.next();
                        Map svcValue = (Map)resultsCache.get(svcName);
                        if (svcValue == null || svcValue.isEmpty()) continue;
                        Set rscInCache = svcValue.keySet();
                        Iterator rscInCacheIter = rscInCache.iterator();
                        while (rscInCacheIter.hasNext()) {
                            String rscName = (String)rscInCacheIter.next();
                            Map rscValues = (Map)svcValue.get(rscName);
                            if (rscValues == null || rscValues.isEmpty() || rscValues.remove(tokenIdStr) == null || !debug.messageEnabled()) continue;
                            debug.message("cleaned up the policy results for an expired token " + tokenIdStr);
                        }
                    }
                }
            }
            PolicyEvaluator.userNSRoleCache.remove(tokenIdStr);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged():cleaned up user nsRole cache for an expired token " + tokenIdStr);
            }
            SubjectEvaluationCache.subjectEvaluationCache.remove(tokenIdStr);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged():cleaned up subject evaluation cache for an expired token " + tokenIdStr);
            }
            LDAPRoles.userLDAPRoleCache.remove(tokenIdStr);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged()cleaned up user role cache of LDAPRoles for an expired token " + tokenIdStr);
            }
            if (evt.getType() == 4) {
                if (debug.messageEnabled()) {
                    debug.message("PolicySSOTokenListener.ssoTokenChanged(): receieved sso token property change notification,  clearing cached subject result cache  for tokenIdStr XXXXXX");
                }
                PolicyCache.getInstance().clearSubjectResultCache(tokenIdStr);
            }
            PolicyEvaluator.ssoListenerRegistry.remove(tokenIdStr);
        }
        catch (Exception e) {
            debug.error("PolicySSOTokenListener.ssoTokenChanged():policy sso token listener", (Throwable)e);
        }
    }
}

