/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class PolicyConfig
implements ServiceListener {
    public static final String LDAP_SERVER = "iplanet-am-policy-config-ldap-server";
    public static final String LDAP_BASE_DN = "iplanet-am-policy-config-ldap-base-dn";
    public static final String LDAP_USERS_BASE_DN = "iplanet-am-policy-config-ldap-users-base-dn";
    public static final String LDAP_BIND_DN = "iplanet-am-policy-config-ldap-bind-dn";
    public static final String LDAP_BIND_PASSWORD = "iplanet-am-policy-config-ldap-bind-password";
    public static final String LDAP_ORG_SEARCH_FILTER = "iplanet-am-policy-config-ldap-organizations-search-filter";
    public static final String LDAP_ORG_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-organizations-search-scope";
    public static final String LDAP_GROUP_SEARCH_FILTER = "iplanet-am-policy-config-ldap-groups-search-filter";
    public static final String LDAP_GROUP_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-groups-search-scope";
    public static final String LDAP_USERS_SEARCH_FILTER = "iplanet-am-policy-config-ldap-users-search-filter";
    public static final String LDAP_USERS_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-users-search-scope";
    public static final String LDAP_ROLES_SEARCH_FILTER = "iplanet-am-policy-config-ldap-roles-search-filter";
    public static final String LDAP_ROLES_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-roles-search-scope";
    public static final String LDAP_ORG_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-organizations-search-attribute";
    public static final String LDAP_GROUP_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-groups-search-attribute";
    public static final String LDAP_USER_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-users-search-attribute";
    public static final String LDAP_ROLES_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-roles-search-attribute";
    public static final String LDAP_SEARCH_TIME_OUT = "iplanet-am-policy-config-search-timeout";
    public static final String LDAP_SEARCH_LIMIT = "iplanet-am-policy-config-search-limit";
    public static final String LDAP_CONNECTION_POOL_MIN_SIZE = "iplanet-am-policy-config-connection_pool_min_size";
    public static final String LDAP_CONNECTION_POOL_MAX_SIZE = "iplanet-am-policy-config-connection_pool_max_size";
    public static final String LDAP_SSL_ENABLED = "iplanet-am-policy-config-ldap-ssl-enabled";
    public static final String IS_ROLES_BASE_DN = "iplanet-am-policy-config-is-roles-base-dn";
    public static final String IS_ROLES_SEARCH_SCOPE = "iplanet-am-policy-config-is-roles-search-scope";
    public static final String SELECTED_SUBJECTS = "iplanet-am-policy-selected-subjects";
    public static final String SELECTED_REFERRALS = "iplanet-am-policy-selected-referrals";
    public static final String SELECTED_CONDITIONS = "iplanet-am-policy-selected-conditions";
    public static final String SELECTED_RESPONSE_PROVIDERS = "sun-am-policy-selected-responseproviders";
    public static final String SELECTED_DYNAMIC_ATTRIBUTES = "sun-am-policy-dynamic-response-attributes";
    public static final String USER_ALIAS_ENABLED = "iplanet-am-policy-config-user-alias-enabled";
    public static final String RESOURCE_COMPARATOR = "iplanet-am-policy-config-resource-comparator";
    public static final String RESOURCE_COMPARATOR_TYPE = "serviceType";
    public static final String RESOURCE_COMPARATOR_CLASS = "class";
    public static final String RESOURCE_COMPARATOR_DELIMITER = "delimiter";
    public static final String RESOURCE_COMPARATOR_WILDCARD = "wildcard";
    public static final String RESOURCE_COMPARATOR_ONE_LEVEL_WILDCARD = "oneLevelWildcard";
    public static final String RESOURCE_COMPARATOR_CASE_SENSITIVE = "caseSensitive";
    public static final String CONTINUE_EVALUATION_ON_DENY_DECISION = "iplanet-am-policy-config-continue-evaluation-on-deny-decision";
    public static final String ORG_ALIAS_MAPPED_RESOURCES_ENABLED = "sun-am-policy-config-org-alias-mapped-resources-enabled";
    public static final String ADVICES_HANDLEABLE_BY_AM = "sun-am-policy-config-advices-handleable-by-am";
    public static final String ORG_DN = "orgDN";
    public static final String SUBJECTS_RESULT_TTL = "iplanet-am-policy-config-subjects-result-ttl";
    public static final String POLICY_CONFIG_SERVICE = "iPlanetAMPolicyConfigService";
    public static final String ISDS_HOST = PolicyUtils.getISDSHostName();
    private static ServiceConfigManager scm = null;
    private static ServiceSchemaManager ssm = null;
    private static Map attrMap = new HashMap();
    private static Map resourceCompMap = new HashMap();
    private static PolicyCache policyCache;
    static boolean continueEvaluationOnDenyDecisionFlag;
    static Set advicesHandleableByAM;
    static boolean orgAliasMappedResourcesEnabledFlag;

    private PolicyConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getResourceCompareConfig(String service) throws PolicyException {
        Map config = null;
        if (scm == null || ssm == null) {
            try {
                scm = new ServiceConfigManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                ssm = new ServiceSchemaManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                PolicyConfig pcm = new PolicyConfig();
                scm.addListener(pcm);
                ssm.addListener(pcm);
            }
            catch (SMSException se) {
                PolicyManager.debug.error("getResourceCompareConfig: Unable to create ServiceConfigManager", (Throwable)se);
                throw new PolicyException(se);
            }
            catch (SSOException se) {
                PolicyManager.debug.error("getResourceCompareConfig: Unale to create ServiceConfigManager", (Throwable)((Object)se));
                throw new PolicyException((Throwable)((Object)se));
            }
        }
        ServiceSchema globalSchema = null;
        if (service == null || !resourceCompMap.containsKey(service)) {
            try {
                globalSchema = ssm.getGlobalSchema();
            }
            catch (SMSException se) {
                PolicyManager.debug.error("getResourceCompConfig: Unable to get ServiceConfig", (Throwable)se);
                throw new PolicyException(se);
            }
            if (globalSchema != null) {
                Map attributeDefaults = globalSchema.getAttributeDefaults();
                PolicyConfig.setContinueEvaluationOnDenyDecision(attributeDefaults);
                PolicyConfig.setOrgAliasMappedResourcesEnabled(attributeDefaults);
                PolicyConfig.setAdvicesHandleableByAM(attributeDefaults);
                PolicyConfig.processResourceMap(attributeDefaults);
            }
        }
        if (service != null) {
            Map map = resourceCompMap;
            synchronized (map) {
                config = (Map)resourceCompMap.get(service);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getPolicyConfig(String org) throws PolicyException {
        org = new DN(org).toRFCString().toLowerCase();
        if (policyCache == null) {
            policyCache = PolicyCache.getInstance();
        }
        if (scm == null) {
            try {
                scm = new ServiceConfigManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                ssm = new ServiceSchemaManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                PolicyConfig pcm = new PolicyConfig();
                scm.addListener(pcm);
                ssm.addListener(pcm);
            }
            catch (SMSException se) {
                PolicyManager.debug.error("getPolicyConfig: Unable to create ServiceConfigManager", (Throwable)se);
                throw new PolicyException(se);
            }
            catch (SSOException se) {
                PolicyManager.debug.error("getPolicyConfig Unable to create ServiceConfigManager", (Throwable)((Object)se));
                throw new PolicyException((Throwable)((Object)se));
            }
        }
        if (!attrMap.containsKey(org)) {
            ServiceConfig orgConfig = null;
            try {
                orgConfig = scm.getOrganizationConfig(org, null);
            }
            catch (SMSException se) {
                PolicyManager.debug.error("getPolicyConfig: Unable to get ServiceConfig", (Throwable)se);
                throw new PolicyException(se);
            }
            catch (SSOException se) {
                PolicyManager.debug.error("getPolicyConfig: Unable to get ServiceConfig", (Throwable)((Object)se));
                throw new PolicyException((Throwable)((Object)se));
            }
            if (orgConfig != null) {
                Map orgAttrMap = PolicyConfig.processOrgAttrMap(orgConfig.getAttributes());
                orgAttrMap.put(ORG_DN, org);
                Map map = attrMap;
                synchronized (map) {
                    attrMap.put(org, orgAttrMap);
                }
            }
        }
        Map map = attrMap;
        synchronized (map) {
            return (Map)attrMap.get(org);
        }
    }

    public void schemaChanged(String serviceName, String version) {
        ServiceSchema globalSchema = null;
        PolicyManager.debug.message("PolicyConfig.schemaChanged():entering");
        try {
            globalSchema = ssm.getGlobalSchema();
        }
        catch (SMSException se) {
            PolicyManager.debug.error("globalConfigChanged: Unable to get global config ", (Throwable)se);
            return;
        }
        if (globalSchema != null) {
            Map attributeDefaults = globalSchema.getAttributeDefaults();
            PolicyConfig.setContinueEvaluationOnDenyDecision(attributeDefaults);
            PolicyConfig.setOrgAliasMappedResourcesEnabled(attributeDefaults);
            PolicyConfig.setAdvicesHandleableByAM(attributeDefaults);
            PolicyConfig.setOrgAliasMappedResourcesEnabled(attributeDefaults);
            PolicyConfig.processResourceMap(attributeDefaults);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int changeType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int changeType) {
        Map orgAttrMap = null;
        ServiceConfig orgConfig = null;
        try {
            orgConfig = scm.getOrganizationConfig(orgName, null);
        }
        catch (SMSException se) {
            PolicyManager.debug.error("orgConfigChanged: Unable to get org config: " + orgName, (Throwable)se);
            return;
        }
        catch (SSOException se) {
            PolicyManager.debug.error("orgConfigChanged: Unable to get org config: " + orgName, (Throwable)((Object)se));
            return;
        }
        if (orgConfig != null) {
            orgAttrMap = PolicyConfig.processOrgAttrMap(orgConfig.getAttributes());
        }
        Map map = attrMap;
        synchronized (map) {
            attrMap.put(orgName, orgAttrMap);
        }
        if (policyCache != null) {
            policyCache.policyConfigChanged(orgName);
        }
    }

    private static Map processOrgAttrMap(Map orgConfigMap) {
        Set attrKeys = orgConfigMap.keySet();
        HashMap<String, Object> orgAttrMap = new HashMap<String, Object>();
        if (attrKeys != null && !attrKeys.isEmpty()) {
            Iterator keysIterator = attrKeys.iterator();
            while (keysIterator.hasNext()) {
                String attrName = (String)keysIterator.next();
                Set values = (Set)orgConfigMap.get(attrName);
                if (values == null || values.isEmpty()) continue;
                if (attrName.equals(SELECTED_SUBJECTS) || attrName.equals(SELECTED_REFERRALS) || attrName.equals(SELECTED_RESPONSE_PROVIDERS) || attrName.equals(SELECTED_DYNAMIC_ATTRIBUTES) || attrName.equals(SELECTED_CONDITIONS)) {
                    orgAttrMap.put(attrName, values);
                    continue;
                }
                if (attrName.equals(LDAP_SERVER)) {
                    orgAttrMap.put(attrName, CollectionHelper.getServerMapAttr((Map)orgConfigMap, (String)LDAP_SERVER));
                    continue;
                }
                Iterator valIterator = values.iterator();
                while (valIterator.hasNext()) {
                    String attrValue = (String)valIterator.next();
                    if (attrName == null || attrValue == null) continue;
                    orgAttrMap.put(attrName, attrValue);
                    if (attrName.equals(LDAP_BIND_PASSWORD)) {
                        attrValue = PolicyUtils.encrypt(attrValue);
                        orgAttrMap.put(attrName, attrValue);
                    }
                    if (!PolicyManager.debug.messageEnabled()) continue;
                    PolicyManager.debug.message("Attr Name = " + attrName + ";  Attr Value = " + attrValue);
                }
            }
        }
        return orgAttrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processResourceMap(Map attrs) {
        Set values = (Set)attrs.get(RESOURCE_COMPARATOR);
        if (values != null && !values.isEmpty()) {
            Iterator valIterator = values.iterator();
            while (valIterator.hasNext()) {
                String elemVal = (String)valIterator.next();
                if (elemVal == null) continue;
                StringTokenizer st = new StringTokenizer(elemVal, "|");
                String[] tokens = new String[6];
                int count = 0;
                while (st.hasMoreTokens()) {
                    tokens[count++] = st.nextToken();
                    if (count <= 5) continue;
                }
                HashMap<String, String> configMap = new HashMap<String, String>();
                String serviceType = null;
                for (int i = 0; i < count; ++i) {
                    int equal = tokens[i].indexOf("=");
                    String name = tokens[i].substring(0, equal);
                    String value = tokens[i].substring(equal + 1);
                    if (name == null) {
                        PolicyManager.debug.error("Resource comapartaor:  name is null");
                        continue;
                    }
                    if (value == null) {
                        PolicyManager.debug.error("Resource comapartaor:  value is null");
                        continue;
                    }
                    if (PolicyManager.debug.messageEnabled()) {
                        PolicyManager.debug.message("Attr Name = " + name + " Attr Value = " + value);
                    }
                    if (name.equalsIgnoreCase(RESOURCE_COMPARATOR_TYPE)) {
                        serviceType = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase(RESOURCE_COMPARATOR_CLASS)) {
                        configMap.put(RESOURCE_COMPARATOR_CLASS, value);
                        continue;
                    }
                    if (name.equalsIgnoreCase(RESOURCE_COMPARATOR_DELIMITER)) {
                        configMap.put(RESOURCE_COMPARATOR_DELIMITER, value);
                        continue;
                    }
                    if (name.equalsIgnoreCase(RESOURCE_COMPARATOR_WILDCARD)) {
                        configMap.put(RESOURCE_COMPARATOR_WILDCARD, value);
                        continue;
                    }
                    if (name.equalsIgnoreCase(RESOURCE_COMPARATOR_ONE_LEVEL_WILDCARD)) {
                        configMap.put(RESOURCE_COMPARATOR_ONE_LEVEL_WILDCARD, value);
                        continue;
                    }
                    if (!name.equalsIgnoreCase(RESOURCE_COMPARATOR_CASE_SENSITIVE)) continue;
                    configMap.put(RESOURCE_COMPARATOR_CASE_SENSITIVE, value);
                }
                if (PolicyManager.debug.messageEnabled()) {
                    PolicyManager.debug.message("PolicyConfig.processResourceMap():configMap.toString()" + ((Object)configMap).toString());
                }
                Map map = resourceCompMap;
                synchronized (map) {
                    resourceCompMap.put(serviceType, configMap);
                }
            }
        }
    }

    public static long getSubjectsResultTtl(Map policyConfig) {
        long subjectsResultTtl;
        block4: {
            String subjectsTtl = null;
            if (policyConfig != null) {
                subjectsTtl = (String)policyConfig.get(SUBJECTS_RESULT_TTL);
            }
            subjectsResultTtl = 0L;
            if (subjectsTtl != null) {
                try {
                    subjectsResultTtl = Integer.parseInt(subjectsTtl) * 60 * 1000;
                }
                catch (NumberFormatException nfe) {
                    if (!PolicyManager.debug.warningEnabled()) break block4;
                    PolicyManager.debug.warning("NumberFormatException while parsing  subjectsResultTtl defined in policyConfig  service  using default 600000");
                }
            }
        }
        return subjectsResultTtl;
    }

    static void setContinueEvaluationOnDenyDecision(Map attributes) {
        Set codSet;
        if (attributes != null && (codSet = (Set)attributes.get(CONTINUE_EVALUATION_ON_DENY_DECISION)) != null && !codSet.isEmpty()) {
            String codValue = (String)codSet.iterator().next();
            if (codValue != null) {
                continueEvaluationOnDenyDecisionFlag = Boolean.valueOf(codValue);
            }
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("PolicyConfig.setContinueEvaluationOnDenyDecision():global attribute  continueEvaluationOnDenyDecision=" + codValue);
            }
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.setContinueEvaluationOnDenyDecision():continueEvaluationOnDenyDecision=" + continueEvaluationOnDenyDecisionFlag);
        }
    }

    static void setOrgAliasMappedResourcesEnabled(Map attributes) {
        Set amreSet;
        if (attributes != null && (amreSet = (Set)attributes.get(ORG_ALIAS_MAPPED_RESOURCES_ENABLED)) != null && !amreSet.isEmpty()) {
            String amreValue = (String)amreSet.iterator().next();
            if (amreValue != null) {
                orgAliasMappedResourcesEnabledFlag = Boolean.valueOf(amreValue);
            }
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("PolicyConfig.setOrgAliasMappedResourcesEnabled():global attribute  orgAliasMappedResourcesEnabledFlag=" + amreValue);
            }
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.setOrgAliasMappedResourcesEnabled():orgAliasMappedResourcesEnabledFlag=" + orgAliasMappedResourcesEnabledFlag);
        }
    }

    static boolean continueEvaluationOnDenyDecision() {
        return continueEvaluationOnDenyDecisionFlag;
    }

    static boolean orgAliasMappedResourcesEnabled() {
        return orgAliasMappedResourcesEnabledFlag;
    }

    private static void setAdvicesHandleableByAM(Map attributes) {
        Set advices;
        if (attributes != null && (advices = (Set)attributes.get(ADVICES_HANDLEABLE_BY_AM)) != null) {
            advicesHandleableByAM = advices;
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.setAdvicesHandleableByAM():global attribute advicesHandleableByAM=" + advicesHandleableByAM);
        }
        if (advicesHandleableByAM == null) {
            advicesHandleableByAM = Collections.EMPTY_SET;
        }
    }

    public static Set getAdvicesHandleableByAM() throws PolicyException {
        if (advicesHandleableByAM == null) {
            PolicyConfig.getResourceCompareConfig(null);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.getAdvicesHandleableByAM():returning global attribute advicesHandleableByAM=" + advicesHandleableByAM);
        }
        return advicesHandleableByAM;
    }

    static {
        continueEvaluationOnDenyDecisionFlag = false;
        advicesHandleableByAM = null;
        orgAliasMappedResourcesEnabledFlag = false;
    }
}

