/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.ui.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.password.ui.model.PWResetException;
import com.sun.identity.password.ui.model.PWResetModelImpl;
import com.sun.identity.password.ui.model.PWResetUserValidationModel;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PWResetUserValidationModelImpl
extends PWResetModelImpl
implements PWResetUserValidationModel {
    private static final String PW_RESET_USER_VALIDATE_ATTR = "iplanet-am-password-reset-userValidate";
    private static final String PW_RESET_BASE_DN_ATTR = "iplanet-am-password-reset-baseDN";
    private static final String PW_RESET_SEARCH_FILTER_ATTR = "iplanet-am-password-reset-searchFilter";
    private static final String USER_SERVICE_LOGIN_STATUS = "iplanet-am-user-login-status";
    private static final String USER_SERVICE_ACCOUNT_LIFE = "iplanet-am-user-account-life";
    private static final String USER_SERVICE_NS_LOCKOUT = "nsaccountlock";
    public static final String STRING_FALSE = "false";
    private boolean realmFlag = false;
    private boolean validRealm = false;
    private String userRealm = null;

    public String getUserAttr(String orgDN) {
        try {
            return this.getAttributeValue(orgDN, PW_RESET_USER_VALIDATE_ATTR);
        }
        catch (SSOException e) {
            debug.warning("PWResetUserValidationModelImpl.getUserAttr", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetUserValidationModelImpl.getUserAttr", (Throwable)e);
        }
        return null;
    }

    public boolean isUserExists(String userAttrValue, String userAttrName, String realm) {
        boolean found = false;
        try {
            AMIdentityRepository amir = new AMIdentityRepository(this.ssoToken, realm);
            HashMap searchMap = new HashMap(2);
            HashSet<String> searchSet = new HashSet<String>(2);
            searchSet.add(userAttrValue);
            searchMap.put(userAttrName, searchSet);
            IdSearchControl isCtl = new IdSearchControl();
            isCtl.setSearchModifiers(IdSearchOpModifier.AND, searchMap);
            IdSearchResults isr = amir.searchIdentities(IdType.USER, "*", isCtl);
            Set results = isr.getSearchResults();
            if (results != null && !results.isEmpty()) {
                if (results.size() > 1) {
                    this.errorMsg = this.getLocalizedString("multipleUsersExists.message");
                } else {
                    AMIdentity amid = (AMIdentity)results.iterator().next();
                    this.userRealm = amid.getRealm();
                    this.userId = amid.getUniversalId();
                    found = true;
                }
            } else {
                this.errorMsg = this.getLocalizedString("userNotExists.message");
                this.writeLog("logUserNotExists.message", userAttrName);
            }
        }
        catch (SSOException e) {
            debug.error("PWResetUserValidationModelImpl.isUserExists", (Throwable)((Object)e));
            this.errorMsg = this.getErrorString((Exception)((Object)e));
        }
        catch (IdRepoException e) {
            debug.error("PWResetUserValidationModelImpl.isUserExists", (Throwable)e);
            this.errorMsg = this.getErrorString(e);
        }
        return found;
    }

    public String getUserValidateTitleString() {
        return this.getLocalizedString("userValidate.title");
    }

    public String getNextBtnLabel() {
        return this.getLocalizedString("next.button");
    }

    private String getBaseDN(String realm) {
        String baseDN = null;
        try {
            baseDN = this.getOrgAttributeValue(realm, PW_RESET_BASE_DN_ATTR);
        }
        catch (SSOException e) {
            debug.warning("PWResetUserValidationModelImpl.getBaseDN", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetUserValidationModelImpl.getBaseDN", (Throwable)e);
        }
        if (baseDN == null || baseDN.length() == 0) {
            if (this.realmFlag) {
                baseDN = realm;
            } else {
                try {
                    Set set = this.getDefaultAttrValues(this.getPWResetServiceSchema(), PW_RESET_BASE_DN_ATTR);
                    baseDN = PWResetUserValidationModelImpl.getFirstElement(set);
                }
                catch (SSOException e) {
                    debug.warning("PWResetUserValidationModelImpl.getBaseDN", (Throwable)((Object)e));
                }
                catch (SMSException e) {
                    debug.error("PWResetUserValidationModelImpl.getBaseDN", (Throwable)e);
                }
                if (baseDN == null || baseDN.length() == 0) {
                    baseDN = this.getRootSuffix();
                }
            }
        }
        return baseDN;
    }

    private String getOrgAttributeValue(String realm, String attrName) throws SSOException, SMSException {
        OrganizationConfigManager mgr = new OrganizationConfigManager(this.ssoToken, realm);
        Map attrValues = mgr.getAttributes("iPlanetAMPasswordResetService");
        Set values = (Set)attrValues.get(attrName);
        return values != null && !values.isEmpty() ? (String)values.iterator().next() : "";
    }

    public void setRealmFlag(boolean value) {
        this.realmFlag = value;
    }

    public boolean isValidRealm() {
        return this.validRealm;
    }

    public String getLocalizedStrForAttr(String attrName) {
        String str;
        block5: {
            str = attrName;
            try {
                AttributeSchema attrSchema;
                ServiceSchema schema;
                ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMUserService", this.ssoToken);
                if (mgr != null && (schema = mgr.getSchema(SchemaType.USER)) != null && (attrSchema = schema.getAttributeSchema(attrName)) != null) {
                    String key = attrSchema.getI18NKey();
                    str = this.getL10NAttributeName(mgr, key);
                }
            }
            catch (SSOException ssoe) {
                if (debug.warningEnabled()) {
                    debug.warning("Could not get localized string for attribute " + attrName, (Throwable)((Object)ssoe));
                }
            }
            catch (SMSException smse) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("Could not get localized string for attribute " + attrName, (Throwable)smse);
            }
        }
        return str;
    }

    public String getMissingUserAttrMessage(String userAttrName) {
        this.errorMsg = this.getLocalizedString("missingUserAttr.message");
        return this.errorMsg;
    }

    public boolean isUserActive(String realm) {
        boolean active = false;
        try {
            AMIdentity user = IdUtils.getIdentity(this.ssoToken, this.userId);
            String userStatus = this.getUserAttributeValue(user, "inetuserstatus");
            String loginStatus = this.getUserAttributeValue(user, USER_SERVICE_LOGIN_STATUS, "Active");
            String lockout = this.getUserAttributeValue(user, USER_SERVICE_NS_LOCKOUT, STRING_FALSE);
            if (!(userStatus.equalsIgnoreCase("Active") && loginStatus.equalsIgnoreCase("Active") && lockout.equalsIgnoreCase(STRING_FALSE))) {
                this.errorMsg = this.getLocalizedString("userNotActive.message");
                this.writeLog("accountInactive.message", this.userId);
            } else if (this.isAccountExpired(user)) {
                this.errorMsg = this.getLocalizedString("userAccountExpired.message");
                this.writeLog("accountExpired.message", this.userId);
            } else if (this.isUserLockout(this.userId, realm)) {
                String[] obj = new String[]{this.userId};
                this.informationMsg = this.getLocalizedString("lockoutMsg.message");
                this.writeLog("accountLocked.message", this.userId);
            } else {
                active = true;
            }
        }
        catch (SSOException e) {
            debug.warning("PWResetUserValidationModelImpl.isUserActive", (Throwable)((Object)e));
            this.errorMsg = this.getErrorString((Exception)((Object)e));
        }
        catch (IdRepoException e) {
            debug.warning("PWResetUserValidationModelImpl.isUserActive", (Throwable)e);
            this.errorMsg = this.getErrorString(e);
        }
        return active;
    }

    private String getUserAttributeValue(AMIdentity user, String attrName, String defaultValue) throws SSOException, IdRepoException {
        String value = this.getUserAttributeValue(user, attrName);
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    private boolean isAccountExpired(AMIdentity user) throws SSOException, IdRepoException {
        Date expDate;
        boolean expired = false;
        String accountLife = this.getUserAttributeValue(user, USER_SERVICE_ACCOUNT_LIFE);
        if (accountLife != null && accountLife.length() > 0 && (expDate = Locale.parseNormalizedDateString((String)accountLife)) != null) {
            expired = expDate.before(new Date());
        }
        return expired;
    }

    private String getUserAttributeValue(AMIdentity user, String attrName) throws SSOException, IdRepoException {
        Set set = user.getAttribute(attrName);
        return PWResetUserValidationModelImpl.getFirstElement(set);
    }

    public String getRealm(String realm) throws PWResetException {
        if (realm != null && realm.length() > 0) {
            try {
                OrganizationConfigManager mgr = new OrganizationConfigManager(this.ssoToken, realm);
            }
            catch (SMSException e) {
                debug.warning("PWResetUserValidationModelImpl.getRealm", (Throwable)e);
                this.errorMsg = this.getErrorString(e);
                throw new PWResetException(this.errorMsg);
            }
        } else {
            realm = "/";
        }
        this.setValidRealm(realm);
        return realm;
    }

    public void setValidRealm(String realm) {
        this.validRealm = true;
        this.readPWResetProfile(realm);
        this.localeContext.setOrgLocale(realm);
    }

    public String getUserRealm() {
        return this.userRealm;
    }
}

