/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.ui.model;

import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.password.plugins.NotifyPassword;
import com.sun.identity.password.plugins.PasswordGenerator;
import com.sun.identity.password.ui.model.PWResetAccountLockout;
import com.sun.identity.password.ui.model.PWResetException;
import com.sun.identity.password.ui.model.PWResetModelImpl;
import com.sun.identity.password.ui.model.PWResetQuestionModel;
import com.sun.identity.password.ui.model.PWResetResBundleCacher;
import com.sun.identity.security.DecryptAction;
import com.sun.identity.shared.Constants;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class PWResetQuestionModelImpl
extends PWResetModelImpl
implements PWResetQuestionModel,
Constants {
    private static final String TOKEN = "\t";
    private static final String PW_RESET_OPTION = "iplanet-am-password-reset-option";
    private static final String PW_RESET_NOTIFICATION = "iplanet-am-password-reset-notification";
    private static final String PW_RESET_BIND_DN = "iplanet-am-password-reset-bindDN";
    private static final String PW_RESET_BIND_PASSWORD = "iplanet-am-password-reset-bindPasswd";
    private static final String PW_RESET_QUESTION_ANSWER = "iplanet-am-user-password-reset-question-answer";
    private static final String PW_RESET_QUESTION = "iplanet-am-password-reset-question";
    private static final String PW_RESET_PERSONAL_ANSWER = "iplanet-am-password-reset-user-personal-question";
    private static final String USER_PASSWORD_ATTR = "userpassword";
    private static final String PASSWORD_RESET_FORCE_RESET = "iplanet-am-password-reset-force-reset";
    private static final String USER_PASSWORD_RESET_FORCE_RESET = "iplanet-am-user-password-reset-force-reset";
    private static final String PASSWORD_EXPIRATION_TIME_ATTR = "passwordExpirationTime";
    private static final int DEFAULT_QUESTION_ON = 1;
    private static final int PERSONAL_QUESTION_ON = 3;
    private Map secretQuestionsMap = null;
    private static G11NSettings g11nSettings = G11NSettings.getInstance();
    private static final String PASSWORD_EXPIRATION_TIME_VALUE = "19700101000000Z";

    private boolean isUserAnswersCorrect(Map map, AMIdentity user, String realm) throws SSOException, IdRepoException {
        Map optionMap = this.getSecretQuestions(user, realm);
        if (optionMap == null || optionMap.isEmpty() || map == null || map.isEmpty()) {
            return false;
        }
        Set set = map.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String answer;
            String attrName = (String)iter.next();
            String value = (String)map.get(attrName);
            if (value.equals(answer = (String)optionMap.get(attrName))) continue;
            return false;
        }
        return true;
    }

    private String getPasswordResetValue(String realm, AMIdentity user) {
        String password = null;
        Object obj = this.getPluginObject(realm, PW_RESET_OPTION);
        try {
            if (obj != null && obj instanceof PasswordGenerator) {
                PasswordGenerator pwGenerator = (PasswordGenerator)obj;
                password = pwGenerator.generatePassword(user);
            }
        }
        catch (PWResetException e) {
            debug.error("PWResetQuestionModelImpl.getPasswordResetValue", (Throwable)((Object)e));
        }
        return password;
    }

    private Object getPluginObject(String orgDN, String attribute) {
        Object obj = null;
        try {
            String plugin = this.getAttributeValue(orgDN, attribute);
            Class<?> c = Class.forName(plugin);
            obj = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            debug.error("PWResetQuestionModelImpl.getPluginObject", (Throwable)e);
        }
        catch (InstantiationException e) {
            debug.error("PWResetQuestionModelImpl.getPluginObject", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            debug.error("PWResetQuestionModelImpl.getPluginObject", (Throwable)e);
        }
        catch (SMSException e) {
            debug.error("PWResetQuestionModelImpl.getPluginObject", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PWResetQuestionModelImpl.getPluginObject", (Throwable)((Object)e));
        }
        return obj;
    }

    private NotifyPassword getNotifyPassword(String realm) {
        NotifyPassword passwordNotify = null;
        Object obj = this.getPluginObject(realm, PW_RESET_NOTIFICATION);
        if (obj != null && obj instanceof NotifyPassword) {
            passwordNotify = (NotifyPassword)obj;
        }
        return passwordNotify;
    }

    public void resetPassword(String uuid, String realm, Map map) throws PWResetException {
        this.populateLockoutValues(realm);
        PWResetAccountLockout pwResetLockout = new PWResetAccountLockout(this);
        try {
            this.localeContext.setOrgLocale(realm);
            AMIdentity user = IdUtils.getIdentity(this.getSSOToken(), uuid);
            this.sendAttemptEmail(user);
            if (this.isUserAnswersCorrect(map, user, realm)) {
                pwResetLockout.removeUserLockoutEntry(uuid);
                String password = this.getPasswordResetValue(realm, user);
                if (password != null && password.length() > 0) {
                    NotifyPassword passwordNotify = this.getNotifyPassword(realm);
                    if (passwordNotify != null) {
                        this.changePassword(user, password, passwordNotify, uuid, realm);
                        this.writeLog("pwResetSuccess.message", uuid);
                    } else {
                        this.errorMsg = this.getLocalizedString("passResetError.message");
                    }
                } else {
                    this.errorMsg = this.getLocalizedString("passResetError.message");
                }
            } else {
                pwResetLockout.invalidAnswer(user);
                if (!this.isLockoutWarning(pwResetLockout, uuid)) {
                    this.errorMsg = this.getLocalizedString("wrongAnswer.message");
                }
            }
        }
        catch (SSOException e) {
            debug.warning("PWResetQuestionModelImpl.resetPassword", (Throwable)((Object)e));
            this.errorMsg = this.getErrorString((Exception)((Object)e));
        }
        catch (IdRepoException e) {
            debug.warning("PWResetQuestionModelImpl.resetPassword", (Throwable)e);
            this.errorMsg = this.getErrorString(e);
        }
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            this.writeLog("pwResetFail.message", uuid);
            throw new PWResetException(this.errorMsg);
        }
        if (this.informationMsg != null && this.informationMsg.length() > 0) {
            this.writeLog("pwResetFail.message", uuid);
            throw new PWResetException(this.informationMsg);
        }
    }

    public Map getSecretQuestions(String uuid, String realm) {
        if (this.secretQuestionsMap == null) {
            try {
                AMIdentity user = IdUtils.getIdentity(this.getSSOToken(), uuid);
                this.getSecretQuestions(user, realm);
            }
            catch (SSOException e) {
                debug.warning("PWResetQuestionModelImp.getSecretQuestions", (Throwable)((Object)e));
            }
            catch (IdRepoException e) {
                debug.error("PWResetQuestionModelImp.getSecretQuestions", (Throwable)e);
            }
        }
        return this.secretQuestionsMap;
    }

    private Map getSecretQuestions(AMIdentity user, String realm) throws SSOException, IdRepoException {
        if (this.secretQuestionsMap == null) {
            try {
                Set set;
                Set defaults = this.getDefaultQuestions(realm);
                if (user != null && (set = user.getAttribute(PW_RESET_QUESTION_ANSWER)) != null && !set.isEmpty()) {
                    this.secretQuestionsMap = this.getQuestionsAnswers(set, defaults, realm);
                }
            }
            catch (SMSException e) {
                debug.error("PWResetQuestionModelImpl.getSecretQuestions", (Throwable)e);
            }
        }
        return this.secretQuestionsMap;
    }

    public String getLocalizedStrForQuestion(String question) {
        return this.getL10NAttributeName("iPlanetAMPasswordResetService", question);
    }

    private void sendAttemptEmail(AMIdentity user) {
        Set set = Collections.EMPTY_SET;
        Set localeSet = null;
        try {
            set = user.getAttribute("mail");
            localeSet = user.getAttribute("preferredlocale");
        }
        catch (SSOException e) {
            debug.error("PWResetQuestionModelImpl.sendAttemptEmail", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            debug.error("PWResetQuestionModelImpl.sendAttemptEmail", (Throwable)e);
        }
        java.util.Locale userLocale = null;
        if (localeSet != null && !localeSet.isEmpty()) {
            String localeStr = localeSet.iterator().next().toString();
            java.util.Locale locale = userLocale = localeStr != null ? Locale.getLocale(localeStr) : null;
        }
        if (userLocale == null) {
            userLocale = this.localeContext.getLocale();
        }
        ResourceBundle rb = PWResetResBundleCacher.getBundle("amPasswordResetModuleMsgs", userLocale);
        if (set != null && !set.isEmpty()) {
            String[] to = new String[]{(String)set.iterator().next()};
            String msg = rb.getString("attemptEmail.message");
            String subject = rb.getString("attemptSubject.message");
            String from = rb.getString("fromAddress.label");
            String charset = g11nSettings.getDefaultCharsetForLocale(userLocale);
            this.sendEmailToUser(from, to, subject, msg, charset);
        }
    }

    public String getPWQuestionTitleString(String attrValue) {
        Object[] obj = new String[]{attrValue};
        return MessageFormat.format(this.getLocalizedString("pwQuestion.title"), obj);
    }

    public String getOKBtnLabel() {
        return this.getLocalizedString("ok.button");
    }

    public String getPreviousBtnLabel() {
        return this.getLocalizedString("previous.button");
    }

    public void setNoQuestionsInfoMsg() {
        this.informationMsg = this.getLocalizedString("noQuestions.message");
    }

    private Map getQuestionsAnswers(Set set, Set defaults, String orgDN) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(set.size());
        Iterator iter = set.iterator();
        boolean enabled = this.isUserQuestionEnabled(orgDN);
        while (iter.hasNext()) {
            String value = (String)iter.next();
            String decryptStr = (String)AccessController.doPrivileged(new DecryptAction(value));
            StringTokenizer st = new StringTokenizer(decryptStr, TOKEN);
            if (st.countTokens() != 3) continue;
            String question = st.nextToken();
            String answer = st.nextToken();
            int dataStatus = Integer.parseInt(st.nextToken());
            if (enabled) {
                if (dataStatus == 3) {
                    map.put(question, answer);
                    continue;
                }
                if (dataStatus != 1 || !defaults.contains(question)) continue;
                map.put(question, answer);
                continue;
            }
            if (dataStatus != 1 || !defaults.contains(question)) continue;
            map.put(question, answer);
        }
        return map;
    }

    protected Set getDefaultQuestions(String realm) throws SSOException, SMSException {
        return this.getAttributeValues(realm, PW_RESET_QUESTION);
    }

    public boolean isUserQuestionEnabled(String orgDN) {
        boolean enabled = false;
        try {
            String value = this.getAttributeValue(orgDN, PW_RESET_PERSONAL_ANSWER);
            enabled = value != null && value.equalsIgnoreCase("true");
        }
        catch (SSOException e) {
            debug.warning("PWResetQuestionModelImpl.isUserQuestionEnabled", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetQuestionModelImpl.isUserQuestionEnabled", (Throwable)e);
        }
        return enabled;
    }

    private void changePassword(AMIdentity user, String password, NotifyPassword passwordNotify, String uuid, String orgDN) throws PWResetException, SSOException, IdRepoException {
        boolean forceReset = this.isForceReset(user, orgDN);
        SSOToken token = this.getSSOToken();
        if (token == null) {
            this.errorMsg = this.getLocalizedString("passResetError.message");
            throw new PWResetException(this.errorMsg);
        }
        this.ssoToken = token;
        user = IdUtils.getIdentity(token, uuid);
        this.changeUserAttribute(user, USER_PASSWORD_ATTR, password);
        if (forceReset) {
            this.setUserPasswordChangedEntry(uuid, password);
        }
        this.notifyUser(user, passwordNotify, password, orgDN);
    }

    private void notifyUser(AMIdentity user, NotifyPassword passwordNotify, String resetValue, String realm) {
        this.passwordResetMsg = this.getLocalizedString("emailNotify.message");
        try {
            passwordNotify.notifyPassword(user, resetValue, this.localeContext.getLocale());
        }
        catch (PWResetException e) {
            debug.warning("PWResetQuestionModelImpl.notifyUser", (Throwable)((Object)e));
            this.passwordResetMsg = e.getMessage();
        }
    }

    public String getMissingAnswerMessage() {
        this.errorMsg = this.getLocalizedString("missingAnswer.message");
        return this.errorMsg;
    }

    public boolean isQuestionAvailable(String uuid, String realm) {
        Map map = this.getSecretQuestions(uuid, realm);
        return map != null && !map.isEmpty();
    }

    private boolean isLockoutWarning(PWResetAccountLockout pwResetLockout, String uuid) {
        boolean warnUser = false;
        int warningCount = pwResetLockout.getWarnUserCount(uuid);
        if (warningCount < 0) {
            this.informationMsg = this.getLocalizedString("lockoutMsg.message");
            warnUser = true;
            this.writeLog("accountLockout.message", uuid);
        } else if (warningCount > 0) {
            Object[] obj = new String[]{String.valueOf(warningCount)};
            this.errorMsg = MessageFormat.format(this.getLocalizedString("lockoutWarning.message"), obj);
            warnUser = true;
        }
        return warnUser;
    }

    public boolean isUserLockout(String uuid, String realm) {
        return !this.isUserStatusActive(uuid) || super.isUserLockout(uuid, realm);
    }

    private boolean isUserStatusActive(String uuid) {
        boolean active = false;
        try {
            AMIdentity user = IdUtils.getIdentity(this.getSSOToken(), uuid);
            Set set = user.getAttribute("inetuserstatus");
            String userStatus = PWResetQuestionModelImpl.getFirstElement(set);
            active = userStatus.equalsIgnoreCase("Active");
        }
        catch (SSOException e) {
            debug.warning("PWResetQuestionModelImpl.isUserStatusActive", (Throwable)((Object)e));
            this.errorMsg = this.getErrorString((Exception)((Object)e));
        }
        catch (IdRepoException e) {
            debug.warning("PWResetQuestionModelImpl.isUserStatusActive", (Throwable)e);
            this.errorMsg = this.getErrorString(e);
        }
        return active;
    }

    private void changeUserAttribute(AMIdentity user, String attributeName, String value) throws SSOException, IdRepoException {
        HashMap map = new HashMap(2);
        HashSet<String> attribVals = new HashSet<String>(2);
        attribVals.add(value);
        map.put(attributeName, attribVals);
        user.setAttributes(map);
        user.store();
    }

    private boolean isForceReset(AMIdentity user, String realm) {
        boolean forceReset = false;
        try {
            forceReset = this.isAttributeSet(realm, PASSWORD_RESET_FORCE_RESET);
        }
        catch (SSOException e) {
            debug.warning("PWResetQuestionModelImpl.isForceReset", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetQuestionModelImpl.isForceReset", (Throwable)e);
        }
        if (!forceReset) {
            try {
                Set set = user.getAttribute(USER_PASSWORD_RESET_FORCE_RESET);
                String value = PWResetQuestionModelImpl.getFirstElement(set);
                forceReset = value != null && value.equalsIgnoreCase("true");
            }
            catch (SSOException e) {
                debug.error("PWResetQuestionModelImpl.isForceReset", (Throwable)((Object)e));
            }
            catch (IdRepoException e) {
                debug.error("PWResetQuestionModelImpl.isForceReset", (Throwable)e);
            }
        }
        return forceReset;
    }

    private void setUserPasswordChangedEntry(String uuid, String password) {
        try {
            SSOToken token = this.getSSOToken();
            if (token != null) {
                this.ssoToken = token;
                AMIdentity user = IdUtils.getIdentity(token, uuid);
                this.changeUserAttribute(user, PASSWORD_EXPIRATION_TIME_ATTR, PASSWORD_EXPIRATION_TIME_VALUE);
            } else {
                debug.error("PWResetQuestionModelImpl.setUserPasswordChangedEntry Cannot not get admin sso token");
            }
        }
        catch (SSOException e) {
            debug.error("PWResetQuestionModelImpl.setUserPasswordChangedEntry", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            debug.error("PWResetQuestionModelImpl.setUserPasswordChangedEntry", (Throwable)e);
        }
    }
}

