/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.shared.encode.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;

public class RemoteFormatter
extends Formatter {
    public String format(java.util.logging.LogRecord logRecord) {
        String logName = logRecord.getLoggerName();
        Map logInfoMap = ((LogRecord)logRecord).getLogInfoMap();
        String loggedBySid = (String)logInfoMap.get("LoggedBySid");
        if (loggedBySid == null) {
            if (Debug.warningEnabled()) {
                Debug.warning("RemoteFormatter : returning null because logRecord doesn't have loggedBySid");
            }
            return null;
        }
        Object[] parameters = logRecord.getParameters();
        StringBuffer xml = new StringBuffer();
        xml.append("<logRecWrite><log logName=\"");
        xml.append(logName);
        xml.append("\" sid=\"");
        xml.append(loggedBySid);
        xml.append("\"></log><logRecord><level>");
        xml.append(logRecord.getLevel().intValue());
        xml.append("</level><recMsg>");
        String msg = this.formatMessage(logRecord);
        msg = Base64.encode((byte[])msg.getBytes());
        xml.append(msg);
        xml.append("</recMsg>");
        Map logInfo = ((LogRecord)logRecord).getLogInfoMap();
        if (logInfo != null) {
            Set keys = logInfo.keySet();
            Iterator keysIter = keys.iterator();
            xml.append("<logInfoMap>");
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                xml.append("<logInfo> <infoKey>");
                xml.append(key);
                xml.append("</infoKey><infoValue>");
                String infoValue = (String)logInfo.get(key);
                if (key.equalsIgnoreCase("Data")) {
                    infoValue = Base64.encode((byte[])infoValue.getBytes());
                }
                xml.append(infoValue);
                xml.append("</infoValue></logInfo>");
            }
            xml.append("</logInfoMap>");
        }
        if (parameters != null && parameters.length > 0) {
            xml.append("<parameters>");
            for (int i = 0; i < parameters.length; ++i) {
                xml.append("<parameter><paramIndex>");
                xml.append(String.valueOf(i));
                xml.append("</paramIndex><paramValue>");
                xml.append(parameters[i].toString());
                xml.append("</paramValue></parameter>");
            }
            xml.append("</parameters>");
        }
        xml.append("</logRecord></logRecWrite>");
        if (Debug.messageEnabled()) {
            Debug.message("RemoteFormatter: XML Req string = " + xml);
        }
        return xml.toString();
    }
}

