/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.QueryElement;
import com.sun.identity.log.handlers.ReadDBHandler;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.util.LogRecordSorter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.LogManager;

public class LogReadDBHandler
implements ReadDBHandler {
    private String databaseURL;
    private String dbDriver;
    private boolean isMySQL = false;
    private String dbUserName;
    private String dbPassWord;
    private String maxRecordsStr = null;
    private int maxRecords = 0;
    private LogRecordSorter sorter = null;
    private String[][] queryResult;
    private ArrayList listOfValidRecords = new ArrayList();
    private Connection conn = null;

    public String[][] logRecRead(String tableName, LogQuery logQuery, LogManager logMgr, boolean sourceData) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, SQLException, Exception {
        String[][] tableResults;
        String selectStr;
        String sortField = null;
        this.cleaner();
        tableName = tableName.replace('.', '_');
        try {
            this.databaseURL = logMgr.getProperty("iplanet-am-logging-location");
            this.dbDriver = logMgr.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logMgr.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logMgr.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logMgr.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception e) {
            Debug.error("DBLogRecRead:config: ", e);
            throw e;
        }
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning("DBlogRecRead:assuming driver: '" + this.dbDriver + "' is Oracle-compatible.");
        }
        if (sourceData) {
            String temps = logQuery.getSortingField();
            if (temps != null) {
                sortField = temps.trim();
            }
            String columns = "*";
            ArrayList sCol = logQuery.getColumns();
            if (sCol != null) {
                StringBuffer colSB = new StringBuffer();
                int sSize = sCol.size();
                for (int i = 0; i < sSize; ++i) {
                    colSB.append((String)sCol.get(i));
                    if (i + 1 >= sSize) continue;
                    colSB.append(", ");
                }
                columns = colSB.toString();
            }
            selectStr = this.lq2Select(tableName, columns, logQuery);
            if (Debug.messageEnabled()) {
                Debug.message("logRecRead/4:selectStr = " + selectStr);
            }
        } else {
            selectStr = this.lq2Select(tableName, null, null);
            if (Debug.messageEnabled()) {
                Debug.message("logRecRead/4.2:selectStr = " + selectStr);
            }
        }
        try {
            this.maxRecords = Integer.parseInt(this.maxRecordsStr);
        }
        catch (NumberFormatException nfe) {
            if (Debug.warningEnabled()) {
                Debug.warning("DBlogRecRead: maxRecords error (" + this.maxRecordsStr + "), set to MAX");
            }
            this.maxRecords = 500;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sqe) {
            Debug.error("DBlogRecRead:connect:SQE:code=" + sqe.getErrorCode() + ", msg=" + sqe.getMessage());
            throw sqe;
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        String selStr = selectStr;
        Statement stmt = null;
        int numberOfRows = 0;
        try {
            int i;
            stmt = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:about to execute: " + selStr);
            }
            ResultSet rs = stmt.executeQuery(selStr);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:#columns = " + numberOfColumns);
            }
            String[] spltHdrStr = new String[numberOfColumns];
            for (int i2 = 1; i2 <= numberOfColumns; ++i2) {
                String tempstr = rsmd.getColumnName(i2);
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:col #" + i2 + " name = " + tempstr);
                }
                spltHdrStr[i2 - 1] = tempstr;
            }
            this.listOfValidRecords.add(spltHdrStr);
            while (rs.next()) {
                ++numberOfRows;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:#rows = " + numberOfRows);
            }
            if (numberOfRows == 0) {
                stmt.close();
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    Debug.error("DBlogRecRead:rows=0:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
                }
                int recSize = this.listOfValidRecords.size();
                if (recSize <= 0) {
                    return null;
                }
                this.queryResult = new String[recSize][];
                for (int i3 = 0; i3 < recSize; ++i3) {
                    this.queryResult[i3] = (String[])this.listOfValidRecords.get(i3);
                }
                return this.queryResult;
            }
            if (numberOfRows > this.maxRecords) {
                stmt.close();
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
                }
                throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
            }
            boolean isFirst = rs.first();
            if (!isFirst) {
                Debug.error("DBlogRecRead:first() is false!");
            }
            int rowsToAlloc = numberOfRows;
            if (logQuery.getNumRecordsWanted() == -1 && numberOfRows > this.maxRecords) {
                rowsToAlloc = this.maxRecords;
            }
            tableResults = new String[rowsToAlloc][numberOfColumns];
            String result = null;
            int rowCount = 0;
            int skipThisManyRecords = 0;
            if (logQuery.getNumRecordsWanted() == -1 && numberOfRows > this.maxRecords) {
                skipThisManyRecords = numberOfRows - this.maxRecords;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:skipThisMany = " + skipThisManyRecords);
            }
            for (i = 0; i < numberOfColumns; ++i) {
                tableResults[0][i] = result = rs.getString(i + 1);
            }
            rowCount = 1;
            while (rs.next()) {
                if (skipThisManyRecords-- > 0) continue;
                for (i = 0; i < numberOfColumns; ++i) {
                    tableResults[rowCount][i] = result = rs.getString(i + 1);
                }
                ++rowCount;
            }
            stmt.close();
        }
        catch (SQLException se) {
            Debug.error("DBlogRecRead:query:SQE:code=" + se.getErrorCode() + ", msg=" + se.getMessage());
            throw se;
        }
        try {
            this.getRecords(tableResults, sourceData);
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        int recSize = this.listOfValidRecords.size();
        if (recSize <= 0) {
            return null;
        }
        try {
            this.conn.close();
        }
        catch (SQLException ex) {
            Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
        }
        this.queryResult = new String[recSize][];
        for (int i = 0; i < recSize; ++i) {
            this.queryResult[i] = (String[])this.listOfValidRecords.get(i);
        }
        return this.queryResult;
    }

    public String[][] logRecRead(Set tableNames, LogQuery logQuery, LogManager logMgr, boolean sourceData) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, SQLException, Exception {
        String columns;
        String selectStr;
        String sortField = null;
        this.cleaner();
        HashSet<String> tblNames = new HashSet<String>();
        StringBuffer allTablesSB = new StringBuffer("");
        Iterator it = tableNames.iterator();
        while (it.hasNext()) {
            String ss = (String)it.next();
            String ss2 = ss.replace('.', '_');
            tblNames.add(ss2);
            allTablesSB.append(ss2);
        }
        try {
            this.databaseURL = logMgr.getProperty("iplanet-am-logging-location");
            this.dbDriver = logMgr.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logMgr.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logMgr.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logMgr.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception e) {
            Debug.error("DBLogRecReadSet:config: ", e);
            throw e;
        }
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning("DBlogRecRead:assuming driver: '" + this.dbDriver + "' is Oracle-compatible.");
        }
        try {
            this.maxRecords = Integer.parseInt(this.maxRecordsStr);
        }
        catch (NumberFormatException nfe) {
            if (Debug.warningEnabled()) {
                Debug.warning("DBlogRecRead(s): maxRecords error (" + this.maxRecordsStr + "), set to MAX");
            }
            this.maxRecords = 500;
        }
        if (!this.isMySQL) {
            String[][] tableResults;
            if (sourceData) {
                String temps = logQuery.getSortingField();
                if (temps != null) {
                    sortField = temps.trim();
                }
                String columns2 = "*";
                ArrayList sCol = logQuery.getColumns();
                if (sCol != null) {
                    StringBuffer colSB = new StringBuffer();
                    int sSize = sCol.size();
                    for (int i = 0; i < sSize; ++i) {
                        colSB.append((String)sCol.get(i));
                        if (i + 1 >= sSize) continue;
                        colSB.append(", ");
                    }
                    columns2 = colSB.toString();
                }
                selectStr = this.lq2Select(tblNames, columns2, logQuery);
                if (Debug.messageEnabled()) {
                    Debug.message("logRecRead/4:selectStr = " + selectStr);
                }
            } else {
                columns = "*";
                selectStr = this.lq2Select(tblNames, columns, null);
                if (Debug.messageEnabled()) {
                    Debug.message("logRecRead/4.2:selectStr = " + selectStr);
                }
            }
            try {
                this.connectToDatabase(this.dbUserName, this.dbPassWord);
            }
            catch (SQLException sqe) {
                Debug.error("DBlogRecRead:connect:SQE:code=" + sqe.getErrorCode() + ", msg=" + sqe.getMessage());
                throw sqe;
            }
            catch (ClassNotFoundException cnfe) {
                throw cnfe;
            }
            String selStr = selectStr;
            Statement stmt = null;
            int numberOfRows = 0;
            try {
                int i;
                stmt = this.conn.createStatement(1004, 1008);
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:about to execute: " + selStr);
                }
                ResultSet rs = stmt.executeQuery(selStr);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:#columns = " + numberOfColumns);
                }
                String[] spltHdrStr = new String[numberOfColumns];
                for (int i2 = 1; i2 <= numberOfColumns; ++i2) {
                    String tempstr = rsmd.getColumnName(i2);
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:col #" + i2 + " name = " + tempstr);
                    }
                    spltHdrStr[i2 - 1] = tempstr;
                }
                this.listOfValidRecords.add(spltHdrStr);
                while (rs.next()) {
                    ++numberOfRows;
                }
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:#rows = " + numberOfRows);
                }
                if (numberOfRows == 0) {
                    stmt.close();
                    try {
                        this.conn.close();
                    }
                    catch (SQLException ex) {
                        Debug.error("DBlogRecRead:rows=0:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
                    }
                    int recSize = this.listOfValidRecords.size();
                    if (recSize <= 0) {
                        return null;
                    }
                    this.queryResult = new String[recSize][];
                    for (int i3 = 0; i3 < recSize; ++i3) {
                        this.queryResult[i3] = (String[])this.listOfValidRecords.get(i3);
                    }
                    return this.queryResult;
                }
                if (numberOfRows > this.maxRecords) {
                    stmt.close();
                    try {
                        this.conn.close();
                    }
                    catch (SQLException ex) {
                        Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
                    }
                    throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
                }
                boolean isFirst = rs.first();
                if (!isFirst) {
                    Debug.error("DBlogRecRead:first() is false!");
                }
                int rowsToAlloc = numberOfRows;
                tableResults = new String[rowsToAlloc][numberOfColumns];
                String result = null;
                int rowCount = 0;
                for (i = 0; i < numberOfColumns; ++i) {
                    tableResults[0][i] = result = rs.getString(i + 1);
                }
                rowCount = 1;
                while (rs.next()) {
                    for (i = 0; i < numberOfColumns; ++i) {
                        tableResults[rowCount][i] = result = rs.getString(i + 1);
                    }
                    ++rowCount;
                }
                stmt.close();
            }
            catch (SQLException se) {
                Debug.error("DBlogRecRead:query:SQE:code=" + se.getErrorCode() + ", msg=" + se.getMessage());
                throw se;
            }
            try {
                this.getRecords(tableResults, sourceData);
            }
            catch (IOException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            int recSize = this.listOfValidRecords.size();
            if (recSize <= 0) {
                return null;
            }
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
            }
            this.queryResult = new String[recSize][];
            for (int i = 0; i < recSize; ++i) {
                this.queryResult[i] = (String[])this.listOfValidRecords.get(i);
            }
        } else {
            String sortByField;
            columns = null;
            if (sourceData) {
                String temps = logQuery.getSortingField();
                if (temps != null) {
                    sortField = temps.trim();
                }
                columns = "*";
                ArrayList sCol = logQuery.getColumns();
                if (sCol != null) {
                    StringBuffer colSB = new StringBuffer();
                    int sSize = sCol.size();
                    for (int i = 0; i < sSize; ++i) {
                        colSB.append((String)sCol.get(i));
                        if (i + 1 >= sSize) continue;
                        colSB.append(", ");
                    }
                    columns = colSB.toString();
                }
            } else {
                columns = "*";
            }
            boolean isFirstTable = true;
            int totalNumberOfRows = 0;
            int recSize = 0;
            Iterator it2 = tblNames.iterator();
            while (it2.hasNext()) {
                String thisTable = (String)it2.next();
                if (sourceData) {
                    selectStr = this.lq2Select(thisTable, columns, logQuery);
                    if (Debug.messageEnabled()) {
                        Debug.message("logRecRead/5:selectStr = " + selectStr);
                    }
                } else {
                    selectStr = this.lq2Select(thisTable, columns, null);
                    if (Debug.messageEnabled()) {
                        Debug.message("logRecRead/5.2:selectStr = " + selectStr);
                    }
                }
                String[][] tableResults = null;
                try {
                    this.connectToDatabase(this.dbUserName, this.dbPassWord);
                }
                catch (SQLException sqe) {
                    Debug.error("DBlogRecRead:connect:SQE:code=" + sqe.getErrorCode() + ", msg=" + sqe.getMessage());
                    throw sqe;
                }
                catch (ClassNotFoundException cnfe) {
                    throw cnfe;
                }
                String selStr = selectStr;
                Statement stmt = null;
                int numberOfRows = 0;
                try {
                    stmt = this.conn.createStatement(1004, 1008);
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:about to execute: " + selStr);
                    }
                    ResultSet rs = stmt.executeQuery(selStr);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int numberOfColumns = rsmd.getColumnCount();
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:#columns = " + numberOfColumns);
                    }
                    if (isFirstTable) {
                        String[] spltHdrStr = new String[numberOfColumns];
                        for (int i = 1; i <= numberOfColumns; ++i) {
                            String tempstr = rsmd.getColumnName(i);
                            if (Debug.messageEnabled()) {
                                Debug.message("DBlogRecRead:col #" + i + " name = " + tempstr);
                            }
                            spltHdrStr[i - 1] = tempstr;
                        }
                        this.listOfValidRecords.add(spltHdrStr);
                    }
                    numberOfRows = 0;
                    while (rs.next()) {
                        ++numberOfRows;
                    }
                    if ((totalNumberOfRows += numberOfRows) > this.maxRecords) {
                        stmt.close();
                        try {
                            this.conn.close();
                        }
                        catch (SQLException ex) {
                            Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
                        }
                        throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
                    }
                    if (numberOfRows > 0) {
                        boolean isFirst = rs.first();
                        if (!isFirst) {
                            Debug.error("DBlogRecRead:first() is false!");
                        }
                        tableResults = new String[numberOfRows][numberOfColumns];
                        String result = null;
                        int rowCount = 0;
                        do {
                            for (int i = 0; i < numberOfColumns; ++i) {
                                tableResults[rowCount][i] = result = rs.getString(i + 1);
                            }
                            ++rowCount;
                        } while (rs.next());
                    }
                    stmt.close();
                }
                catch (SQLException se) {
                    Debug.error("DBlogRecRead:query:SQE:code=" + se.getErrorCode() + ", msg=" + se.getMessage());
                    throw se;
                }
                if (numberOfRows > 0) {
                    try {
                        this.getRecords(tableResults, sourceData);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                }
                if (!isFirstTable) continue;
                isFirstTable = false;
            }
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                Debug.error("DBlogRecRead:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
            }
            if (logQuery != null && (sortByField = logQuery.getSortingField()) != null) {
                try {
                    this.sorter = new LogRecordSorter(sortByField, this.listOfValidRecords);
                    this.queryResult = this.sorter.getSortedRecords();
                }
                catch (NoSuchFieldException e) {
                    Debug.error("DBlogRecRead/5:sort:nsfe: " + e.getMessage());
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    Debug.error("DBlogRecRead/5:sort:iae: " + e.getMessage());
                    throw e;
                }
                catch (RuntimeException e) {
                    Debug.error("DBlogRecRead/5:sort:rte: " + e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    Debug.error("DBlogRecRead/5:sort:ex: " + e.getMessage());
                    throw e;
                }
                return this.queryResult;
            }
            recSize = this.listOfValidRecords.size();
            if (recSize <= 0) {
                return null;
            }
            this.queryResult = new String[recSize][];
            for (int i = 0; i < recSize; ++i) {
                this.queryResult[i] = (String[])this.listOfValidRecords.get(i);
            }
        }
        return this.queryResult;
    }

    public String[][] getTableNames(LogManager logMgr) {
        try {
            this.databaseURL = logMgr.getProperty("iplanet-am-logging-location");
            this.dbDriver = logMgr.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logMgr.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logMgr.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logMgr.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception e) {
            return null;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sqe) {
            Debug.error("DBgetTableNames:connect:SQE:code=" + sqe.getErrorCode() + ", msg=" + sqe.getMessage());
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("DBgetTableNames:connect:CNFE: " + cnfe.getMessage());
            return null;
        }
        this.isMySQL = false;
        String queryString = null;
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
            queryString = "select table_name from dba_all_tables where owner = '" + this.dbUserName.toUpperCase() + "'";
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
            queryString = "show tables";
        }
        Statement stmt = null;
        ResultSet rs = null;
        int numberOfColumns = 0;
        ResultSetMetaData rsmd = null;
        String[][] tableResults = null;
        try {
            boolean isFirst;
            stmt = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:about to execute: " + queryString);
            }
            rs = stmt.executeQuery(queryString);
            rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:#columns = " + numberOfColumns);
            }
            String[] spltHdrStr = new String[numberOfColumns];
            for (int i = 1; i <= numberOfColumns; ++i) {
                String tempstr;
                spltHdrStr[i - 1] = tempstr = rsmd.getColumnName(i);
            }
            int numberOfRows = 0;
            while (rs.next()) {
                ++numberOfRows;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:#rows = " + numberOfRows);
            }
            if (!(isFirst = rs.first())) {
                Debug.error("DBgetTableNames:first() is false!");
            }
            String result = null;
            tableResults = new String[numberOfRows][numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                tableResults[0][i] = result = rs.getString(i + 1);
            }
            int rowCount = 1;
            while (rs.next()) {
                for (int i = 0; i < numberOfColumns; ++i) {
                    tableResults[rowCount][i] = result = rs.getString(i + 1);
                    ++rowCount;
                }
            }
            stmt.close();
        }
        catch (SQLException se) {
            Debug.error("DBgetTableNames:query:SQE:code=" + se.getErrorCode() + ", msg=" + se.getMessage());
            return null;
        }
        try {
            this.conn.close();
        }
        catch (SQLException ex) {
            Debug.error("DBgetTableNames:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
        }
        return tableResults;
    }

    public long getNumberOfRows(LogManager logMgr, String fileName) {
        long li = 0L;
        try {
            this.databaseURL = logMgr.getProperty("iplanet-am-logging-location");
            this.dbDriver = logMgr.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logMgr.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logMgr.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logMgr.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception e) {
            return 0L;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sqe) {
            Debug.error("DBgetNumberOfRows:connect:SQE:code=" + sqe.getErrorCode() + ", msg=" + sqe.getMessage());
            return 0L;
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("DBgetgetNumberOfRows:connect:CNFE: " + cnfe.getMessage());
            return 0L;
        }
        String fName = fileName.replace('.', '_');
        String queryString = "select count(*) from " + fName;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String result = null;
        try {
            stmt = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBgetgetNumberOfRows:about to execute: " + queryString);
            }
            rs = stmt.executeQuery(queryString);
            rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBgetNumberOfRows:#columns = " + numberOfColumns);
            }
            while (rs.next()) {
                for (int i = 0; i < numberOfColumns; ++i) {
                    result = rs.getString(i + 1);
                }
            }
            stmt.close();
        }
        catch (SQLException se) {
            Debug.error("DBgetNumberOfRows:query:SQE:code=" + se.getErrorCode() + ", msg=" + se.getMessage());
            return 0L;
        }
        try {
            this.conn.close();
        }
        catch (SQLException ex) {
            Debug.error("DBgetNumberOfRows:conn.close (" + ex.getErrorCode() + "): " + ex.getMessage());
        }
        try {
            Long longval = new Long(result);
            li = longval;
        }
        catch (NumberFormatException nfe) {
            Debug.error("DBgetNumberOfRows:got " + result + " as number of rows, returning 0.");
        }
        return li;
    }

    private void displayResultSet(ResultSet myrs) {
        try {
            ResultSetMetaData rsmd = myrs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            Debug.error("displayRS:#columns = " + numberOfColumns);
            StringBuffer sbtemp = new StringBuffer(80);
            for (int i = 1; i <= numberOfColumns; ++i) {
                String tempstr = rsmd.getColumnName(i);
                sbtemp.append(tempstr).append("\t");
            }
            Debug.error("displayRS:columns =\n" + sbtemp.toString());
            boolean isFirst = myrs.first();
            int rowNum = 1;
            do {
                sbtemp = new StringBuffer(80);
                for (int i = 1; i <= numberOfColumns; ++i) {
                    sbtemp.append(myrs.getString(i)).append("\t");
                }
                Debug.error("displayRS:row #" + rowNum + " = " + sbtemp.toString());
                ++rowNum;
            } while (myrs.next());
            isFirst = myrs.first();
        }
        catch (SQLException ex) {
            Debug.error("displayRS:got SQLException: " + ex.getMessage());
        }
    }

    private boolean getRecords(String[][] tblResults, boolean isSourceData) throws IOException, RuntimeException {
        int numRows = Array.getLength(tblResults);
        for (int i = 0; i < numRows; ++i) {
            this.listOfValidRecords.add(tblResults[i]);
        }
        return true;
    }

    private void cleaner() {
        this.listOfValidRecords.clear();
        this.queryResult = null;
    }

    private void connectToDatabase(String userName, String password) throws SQLException, ClassNotFoundException {
        try {
            Class.forName(this.dbDriver);
            this.conn = DriverManager.getConnection(this.databaseURL, userName, password);
        }
        catch (ClassNotFoundException e) {
            Debug.error("DBlogRecRead:connect:ClassNotFoundException: " + e.getMessage());
            throw e;
        }
        catch (SQLException sqle) {
            Debug.error("DBlogRecRead:connect:SQLEx: " + sqle.getErrorCode() + "): " + sqle.getMessage());
            throw sqle;
        }
    }

    private String lq2Select(String tblName, String columns, LogQuery lq) {
        StringBuffer selectSBuf = null;
        String whatSBuf = "*";
        StringBuffer whereSBuf = null;
        String opStr = " and ";
        int lqMatchAny = 2;
        int qrySize = 0;
        String sortStr = null;
        boolean getAllRecs = false;
        selectSBuf = new StringBuffer("select ");
        if (columns != null && columns.length() > 0) {
            whatSBuf = columns;
        }
        int numRecs = 0;
        getAllRecs = false;
        String numRecsStr = null;
        String sortByField = null;
        if (lq != null) {
            numRecs = lq.getNumRecordsWanted();
            if (numRecs == -1 || numRecs == -2) {
                getAllRecs = true;
            } else {
                numRecsStr = Integer.toString(numRecs);
            }
            sortByField = lq.getSortingField();
        } else {
            getAllRecs = true;
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:getAllRecs = " + getAllRecs + ", numRecs = " + numRecs + ", sortByField = " + sortByField + ", numRecsStr = " + numRecsStr);
        }
        if (lq == null) {
            selectSBuf.append(whatSBuf).append(" from ").append(tblName);
            return selectSBuf.toString();
        }
        ArrayList queries = lq.getQueries();
        if (queries == null || (qrySize = queries.size()) == 0) {
            selectSBuf.append(whatSBuf).append(" from ").append(tblName);
            if (!getAllRecs) {
                if (this.isMySQL) {
                    selectSBuf.append(" limit ").append(numRecsStr);
                } else {
                    selectSBuf.append(" where rownum < ").append(numRecsStr);
                }
            }
            return selectSBuf.toString();
        }
        if (lq.getGlobalOperand() == lqMatchAny) {
            opStr = " or ";
        }
        selectSBuf.append(whatSBuf).append(" from ").append(tblName).append(" where ");
        if (!getAllRecs && !this.isMySQL) {
            selectSBuf.append("rownum < ").append(numRecsStr).append(" and ");
        }
        whereSBuf = new StringBuffer();
        boolean moreThanOneQuery = false;
        if (qrySize > 1) {
            moreThanOneQuery = true;
            whereSBuf.append("(");
        }
        for (int i = 0; i < qrySize; ++i) {
            String relation;
            QueryElement qe = (QueryElement)queries.get(i);
            String fldName = qe.getFieldName();
            String fldValue = qe.getFieldValue();
            int iRelation = qe.getRelation();
            switch (iRelation) {
                case 1: {
                    relation = " > ";
                    break;
                }
                case 2: {
                    relation = " < ";
                    break;
                }
                case 3: {
                    relation = " = ";
                    break;
                }
                case 4: {
                    relation = " != ";
                    break;
                }
                case 5: {
                    relation = " >= ";
                    break;
                }
                case 6: {
                    relation = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    relation = " like ";
                    break;
                }
                default: {
                    relation = " = ";
                }
            }
            if (fldName != null && fldName.length() > 0 && fldValue != null && fldValue.length() > 0) {
                if (moreThanOneQuery) {
                    whereSBuf.append(" (");
                }
                whereSBuf.append(fldName).append(relation);
                if (iRelation == 7) {
                    whereSBuf.append(" '%").append(fldValue).append("%'");
                } else if (iRelation == 8) {
                    whereSBuf.append(" '").append(fldValue).append("%'");
                } else if (iRelation == 9) {
                    whereSBuf.append(" '%").append(fldValue).append("'");
                } else {
                    whereSBuf.append(" '").append(fldValue).append("'");
                }
                if (moreThanOneQuery) {
                    whereSBuf.append(") ");
                }
            }
            if (i + 1 >= qrySize) continue;
            whereSBuf.append(opStr);
        }
        if (moreThanOneQuery) {
            whereSBuf.append(")");
        }
        selectSBuf.append(whereSBuf.toString());
        sortStr = lq.getSortingField();
        if (sortStr != null && sortStr.length() > 0) {
            selectSBuf.append(" order by ").append(sortStr);
        }
        if (!getAllRecs && this.isMySQL) {
            selectSBuf.append(" limit ").append(numRecsStr);
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:select = " + selectSBuf.toString());
        }
        return selectSBuf.toString();
    }

    private String lq2Select(Set tblNames, String columns, LogQuery lq) {
        String sStr;
        StringBuffer selectSBuf = null;
        String whatSBuf = "*";
        Object whereSBuf = null;
        StringBuffer tempSBuf = null;
        String opStr = " and ";
        int lqMatchAny = 2;
        int qrySize = 0;
        Object sortStr = null;
        boolean getAllRecs = false;
        String CR = " ";
        selectSBuf = new StringBuffer("select ");
        tempSBuf = new StringBuffer("select ");
        whatSBuf = columns;
        int numRecs = 0;
        getAllRecs = false;
        String numRecsStr = null;
        String sortByField = null;
        if (lq != null) {
            String ssbf;
            numRecs = lq.getNumRecordsWanted();
            if (numRecs == -1 || numRecs == -2) {
                getAllRecs = true;
            } else {
                numRecsStr = Integer.toString(numRecs);
            }
            if (!columns.equals("*") && (ssbf = lq.getSortingField()) != null && ssbf.length() > 0 && columns.indexOf(ssbf) != -1) {
                sortByField = ssbf;
            }
        } else {
            getAllRecs = true;
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:getAllRecs = " + getAllRecs + ", numRecs = " + numRecs + ", sortByField = " + sortByField + ", numRecsStr = " + numRecsStr);
        }
        if (lq == null) {
            String baseSelect = new String("select " + whatSBuf + " from ");
            Iterator it = tblNames.iterator();
            while (it.hasNext()) {
                selectSBuf.append(baseSelect).append(it.next());
                if (!it.hasNext()) continue;
                selectSBuf.append(" union ");
            }
            return selectSBuf.toString();
        }
        ArrayList queries = lq.getQueries();
        tempSBuf.append(whatSBuf).append(" from ");
        selectSBuf = new StringBuffer();
        if (queries == null || (qrySize = queries.size()) == 0) {
            sStr = tempSBuf.toString();
            Iterator it = tblNames.iterator();
            while (it.hasNext()) {
                selectSBuf.append(sStr).append(it.next());
                if (this.isMySQL) continue;
                if (!getAllRecs) {
                    selectSBuf.append(" where rownum < ").append(numRecsStr);
                }
                if (it.hasNext()) {
                    selectSBuf.append(" ").append("union").append(" ");
                    continue;
                }
                if (sortByField == null) continue;
                selectSBuf.append(" order by ").append(sortByField);
            }
            return selectSBuf.toString();
        }
        if (lq.getGlobalOperand() == lqMatchAny) {
            opStr = " or ";
        }
        if (this.isMySQL) {
            sStr = tempSBuf.toString();
            selectSBuf.append(sStr);
            Iterator it = tblNames.iterator();
            while (it.hasNext()) {
                selectSBuf.append((String)it.next());
                if (!it.hasNext()) continue;
                selectSBuf.append(", ");
            }
            selectSBuf.append(" where ");
            it = tblNames.iterator();
            while (it.hasNext()) {
                String tblStr = (String)it.next();
                String wherePart = this.doMySQLQueryElement(tblStr, queries, opStr);
                selectSBuf.append(wherePart);
                if (!it.hasNext()) continue;
                selectSBuf.append(" or ");
            }
            if (!getAllRecs && this.isMySQL) {
                selectSBuf.append(" limit ").append(numRecsStr);
            }
        } else {
            String wherePart = this.doOracleQueryElements(queries, numRecsStr, opStr, getAllRecs, sortByField);
            String sStr2 = tempSBuf.toString();
            Iterator it = tblNames.iterator();
            while (it.hasNext()) {
                selectSBuf.append(sStr2).append(it.next()).append(" where ").append(wherePart);
                if (it.hasNext()) {
                    selectSBuf.append(" ").append("union").append(" ");
                    continue;
                }
                if (sortByField == null) continue;
                selectSBuf.append(" order by ").append(sortByField);
            }
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:select = " + selectSBuf.toString());
        }
        return selectSBuf.toString();
    }

    private String doOracleQueryElements(ArrayList qes, String numRecsStr, String opStr, boolean getAllRecs, String sortStr) {
        int qrySize = qes.size();
        StringBuffer whereSBuf = new StringBuffer();
        boolean moreThanOneQuery = false;
        if (numRecsStr != null && numRecsStr.length() > 0) {
            whereSBuf.append("rownum < ").append(numRecsStr).append(" and ");
        }
        if (qrySize > 1) {
            moreThanOneQuery = true;
            whereSBuf.append("(");
        }
        for (int i = 0; i < qrySize; ++i) {
            String relation;
            QueryElement qe = (QueryElement)qes.get(i);
            String fldName = qe.getFieldName();
            String fldValue = qe.getFieldValue();
            int iRelation = qe.getRelation();
            switch (iRelation) {
                case 1: {
                    relation = " > ";
                    break;
                }
                case 2: {
                    relation = " < ";
                    break;
                }
                case 3: {
                    relation = " = ";
                    break;
                }
                case 4: {
                    relation = " != ";
                    break;
                }
                case 5: {
                    relation = " >= ";
                    break;
                }
                case 6: {
                    relation = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    relation = " like ";
                    break;
                }
                default: {
                    relation = " = ";
                }
            }
            if (fldName != null && fldName.length() > 0 && fldValue != null && fldValue.length() > 0) {
                if (moreThanOneQuery) {
                    whereSBuf.append(" (");
                }
                whereSBuf.append(fldName).append(relation);
                if (iRelation == 7) {
                    whereSBuf.append(" '%").append(fldValue).append("%'");
                } else if (iRelation == 8) {
                    whereSBuf.append(" '").append(fldValue).append("%'");
                } else if (iRelation == 9) {
                    whereSBuf.append(" '%").append(fldValue).append("'");
                } else {
                    whereSBuf.append(" '").append(fldValue).append("'");
                }
                if (moreThanOneQuery) {
                    whereSBuf.append(") ");
                }
            }
            if (i + 1 >= qrySize) continue;
            whereSBuf.append(opStr);
        }
        if (moreThanOneQuery) {
            whereSBuf.append(")");
        }
        if (Debug.messageEnabled()) {
            Debug.message("doQueryElements:returning " + whereSBuf.toString());
        }
        return whereSBuf.toString();
    }

    private String doMySQLQueryElement(String tblname, ArrayList qes, String opStr) {
        int qrySize = qes.size();
        boolean moreThanOneQuery = false;
        StringBuffer whereSBuf = new StringBuffer();
        if (qrySize > 1) {
            moreThanOneQuery = true;
            whereSBuf.append("(");
        }
        for (int i = 0; i < qrySize; ++i) {
            String relation;
            QueryElement qe = (QueryElement)qes.get(i);
            String fldName = tblname + "." + qe.getFieldName();
            String fldValue = qe.getFieldValue();
            int iRelation = qe.getRelation();
            switch (iRelation) {
                case 1: {
                    relation = " > ";
                    break;
                }
                case 2: {
                    relation = " < ";
                    break;
                }
                case 3: {
                    relation = " = ";
                    break;
                }
                case 4: {
                    relation = " != ";
                    break;
                }
                case 5: {
                    relation = " >= ";
                    break;
                }
                case 6: {
                    relation = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    relation = " like ";
                    break;
                }
                default: {
                    relation = " = ";
                }
            }
            if (fldName != null && fldName.length() > 0 && fldValue != null && fldValue.length() > 0) {
                if (moreThanOneQuery) {
                    whereSBuf.append(" (");
                }
                whereSBuf.append(fldName).append(relation);
                if (iRelation == 7) {
                    whereSBuf.append(" '%").append(fldValue).append("%'");
                } else if (iRelation == 8) {
                    whereSBuf.append(" '").append(fldValue).append("%'");
                } else if (iRelation == 9) {
                    whereSBuf.append(" '%").append(fldValue).append("'");
                } else {
                    whereSBuf.append(" '").append(fldValue).append("'");
                }
                if (moreThanOneQuery) {
                    whereSBuf.append(") ");
                }
            }
            if (i + 1 >= qrySize) continue;
            whereSBuf.append(opStr);
        }
        if (moreThanOneQuery) {
            whereSBuf.append(")");
        }
        return whereSBuf.toString();
    }
}

