/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.NullLocationException;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.spi.Debug;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class FileHandler
extends Handler {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private OutputStream output;
    private Writer writer;
    private MeteredStream meteredStream;
    private File[] files;
    private boolean headerWritten;
    private int count;
    private int maxFileSize;
    private String location;
    private Formatter formatter;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss.ddMMyyyy");
    private Date date;
    private String currentFileName;
    private String fileName;
    private int recCountLimit;
    private ArrayList recordBuffer;
    private TimeBufferingTask bufferTask;
    private boolean timeBufferingEnabled = false;
    private static String headerString = null;

    private void setOutputStream(OutputStream out) throws SecurityException, UnsupportedEncodingException {
        if (out == null && Debug.warningEnabled()) {
            Debug.warning(this.fileName + ":FileHandler: OutputStream is null");
        }
        this.output = out;
        this.headerWritten = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, encoding);
            }
            catch (UnsupportedEncodingException e) {
                Debug.error(this.fileName + ":FileHandler: Unsupported Encoding", e);
                throw new UnsupportedEncodingException(e.getMessage());
            }
        }
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.output == null) {
            return;
        }
        this.cleanup();
        this.writer = encoding == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, encoding);
    }

    private void configure() throws NullLocationException, FormatterInitException {
        String strCount;
        String status;
        String bufferSize = this.lmanager.getProperty("iplanet-am-logging-buffer-size");
        if (bufferSize != null && bufferSize.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(bufferSize);
            }
            catch (NumberFormatException nfe) {
                Debug.warning(this.fileName + ":FileHandler: NumberFormatException ", nfe);
                if (Debug.messageEnabled()) {
                    Debug.message(this.fileName + ":FileHandler: Setting buffer size to 1");
                }
                this.recCountLimit = 1;
            }
        } else {
            Debug.warning(this.fileName + ":FileHandler: Invalid buffer size: " + bufferSize);
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Setting buffer size to 1");
            }
            this.recCountLimit = 1;
        }
        if ((status = this.lmanager.getProperty("iplanet-am-logging-time-buffering-status")) != null && status.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.count = (strCount = this.lmanager.getProperty("iplanet-am-logging-num-hist-file")) == null || strCount.length() == 0 ? 0 : Integer.parseInt(strCount);
        String strMaxFileSize = this.lmanager.getProperty("iplanet-am-logging-max-file-size");
        this.maxFileSize = strMaxFileSize == null || strMaxFileSize.length() == 0 ? 0 : Integer.parseInt(strMaxFileSize);
        this.location = this.lmanager.getProperty("iplanet-am-logging-location");
        if (this.location == null || this.location.length() == 0) {
            throw new NullLocationException("Location Not Specified");
        }
        if (!this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        String strFormatter = this.lmanager.getProperty("iplanet-am-logging-elf-formatter");
        try {
            Class<?> clz = Class.forName(strFormatter);
            this.formatter = (Formatter)clz.newInstance();
        }
        catch (Exception e) {
            throw new FormatterInitException("Unable to initialize Formatter Class" + e);
        }
    }

    private void openFiles(String fileName) throws IOException {
        if (this.count < 0) {
            Debug.error(fileName + ":FileHandler: no. of history files negative " + this.count);
            this.count = 0;
        }
        if (this.maxFileSize < 0) {
            Debug.error(fileName + ":FileHandler: maxFileSize cannot be negative");
            this.maxFileSize = 0;
        }
        this.files = new File[this.count + 1];
        for (int i = 0; i < this.count + 1; ++i) {
            if (i != 0) {
                this.files[i] = new File(fileName + "-" + i);
                continue;
            }
            this.files[0] = new File(fileName);
        }
        this.open(this.files[0], true);
    }

    private void open(File fileName, boolean append) throws IOException {
        String filename = fileName.toString();
        int len = 0;
        len = (int)fileName.length();
        FileOutputStream fout = new FileOutputStream(filename, append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meteredStream = new MeteredStream(bout, len);
        this.setOutputStream(this.meteredStream);
        this.checkForHeaderWritten(fileName.toString());
    }

    public FileHandler(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        this.fileName = fileName;
        try {
            this.configure();
        }
        catch (NullLocationException nle) {
            Debug.error(fileName + ":FileHandler: Location not specified", nle);
        }
        catch (FormatterInitException fie) {
            Debug.error(fileName + ":FileHandler: could not instantiate Formatter", fie);
        }
        fileName = this.location + fileName;
        Logger logger = (Logger)Logger.getLogger(this.fileName);
        if (logger.getLevel() != Level.OFF) {
            try {
                this.openFiles(fileName);
            }
            catch (IOException ioe) {
                Debug.error(fileName + ":FileHandler: Unable to open Files", ioe);
            }
        }
        logger.setCurrentFile(this.fileName);
        this.recordBuffer = new ArrayList();
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    private void cleanup() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                Debug.error(this.fileName + ":FileHandler: Couldnot Flush Output", ex);
            }
        }
    }

    public void close() {
        this.flush();
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                Debug.error(this.fileName + ":FileHandler: Error closing writer", e);
            }
        }
        this.stopBufferTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publish(LogRecord lrecord) {
        if (this.maxFileSize <= 0) {
            return;
        }
        if (!this.isLoggable(lrecord)) {
            return;
        }
        String message = this.getFormatter().format(lrecord);
        ArrayList arrayList = this.recordBuffer;
        synchronized (arrayList) {
            this.recordBuffer.add(message);
        }
        if (this.recordBuffer.size() >= this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler.publish(): got " + this.recordBuffer.size() + " records, writing all");
            }
            this.flush();
        }
    }

    private String getHeaderString() {
        if (headerString == null) {
            headerString = this.getFormatter().getHead(this);
        }
        return headerString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (this.recordBuffer.size() <= 0) {
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler.flush: no records in buffer to write");
            }
            return;
        }
        if (this.writer == null) {
            Debug.error(this.fileName + ":FileHandler: Writer is null");
            ArrayList arrayList = this.recordBuffer;
            synchronized (arrayList) {
                this.recordBuffer.clear();
            }
            return;
        }
        if (Debug.messageEnabled()) {
            Debug.message(this.fileName + ":FileHandler.flush: writing " + "buffered records (" + this.recordBuffer.size() + " records)");
        }
        ArrayList arrayList = this.recordBuffer;
        synchronized (arrayList) {
            int rbsz = this.recordBuffer.size();
            for (int i = 0; i < rbsz; ++i) {
                String message = (String)this.recordBuffer.remove(0);
                if (message.length() > 0 && this.meteredStream.written + message.length() >= this.maxFileSize) {
                    if (Debug.messageEnabled()) {
                        Debug.message(this.fileName + ":FileHandler: Rotation condition reached");
                    }
                    this.rotate();
                }
                try {
                    if (!this.headerWritten) {
                        this.writer.write(this.getHeaderString());
                        this.headerWritten = true;
                    }
                    this.writer.write(message);
                }
                catch (IOException ex) {
                    Debug.error(this.fileName + ":FileHandler: could not write to file: ", ex);
                }
                this.cleanup();
            }
        }
    }

    private void rotate() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception ex) {
                Debug.error(this.fileName + ":FileHandler: " + "Error closing writer", ex);
            }
        }
        for (int i = this.count - 2; i >= 0; --i) {
            boolean renameSuccess;
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                try {
                    f2.delete();
                }
                catch (SecurityException secex) {
                    Debug.error(this.fileName + ":FileHandler: could not delete file. msg = " + secex.getMessage());
                }
            }
            if (renameSuccess = f1.renameTo(f2)) continue;
            this.copyFile(f1.toString(), f2.toString());
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            Debug.error(this.fileName + ":FileHandler: error opening file" + ix);
        }
    }

    private void copyFile(String input, String output) {
        if (Debug.messageEnabled()) {
            Debug.message(this.fileName + ":FileHandler: CopyFile Method called");
        }
        try {
            int s;
            FileInputStream fis = new FileInputStream(input);
            FileOutputStream fos = new FileOutputStream(output);
            while ((s = fis.read()) > -1) {
                fos.write(s);
            }
        }
        catch (FileNotFoundException fnfe) {
            Debug.error(this.fileName + ":FileHandler: copyFile: File not found: ", fnfe);
        }
        catch (IOException ioex) {
            Debug.error(this.fileName + ":FileHandler: copyFile: IOException", ioex);
        }
    }

    private void checkForHeaderWritten(String fileName) {
        byte[] bytes = new byte[1024];
        try {
            FileInputStream fins = new FileInputStream(new File(fileName));
            fins.read(bytes);
        }
        catch (IOException ioe) {
            Debug.error(fileName + ":FileHandler: couldnot read file content", ioe);
        }
        String fileContent = new String(bytes);
        fileContent = fileContent.trim();
        this.headerWritten = fileContent.startsWith("#Version");
    }

    private void startTimeBufferingThread() {
        String period = this.lmanager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long interval = period != null || period.length() != 0 ? Long.parseLong(period) : 3600L;
        interval *= 1000L;
        if (this.bufferTask == null) {
            block5: {
                this.bufferTask = new TimeBufferingTask(interval);
                try {
                    SystemTimer.getTimer().schedule((TaskRunnable)this.bufferTask, new Date((System.currentTimeMillis() + interval) / 1000L * 1000L));
                }
                catch (IllegalArgumentException e) {
                    Debug.error(this.fileName + ":FileHandler:BuffTimeArg: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    if (!Debug.messageEnabled()) break block5;
                    Debug.message(this.fileName + ":FileHandler:BuffTimeState: " + e.getMessage());
                }
            }
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTask != null) {
            this.bufferTask.cancel();
            this.bufferTask = null;
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Buffer Timer Stopped");
            }
        }
    }

    private class TimeBufferingTask
    extends GeneralTaskRunnable {
        private long runPeriod;

        public TimeBufferingTask(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message(FileHandler.this.fileName + ":FileHandler:TimeBufferingTask.run() called");
            }
            FileHandler.this.flush();
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.written += b.length;
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            this.written += length;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

