/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.sso.SSOException;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DelegationPrivilege {
    static final Debug debug = DelegationManager.debug;
    static final String RESOURCE = "resource";
    static final String ACTIONS = "actions";
    static final String DELIMITER = "/";
    private String name;
    private Set permissions = new HashSet();
    private Set subjects;

    public DelegationPrivilege(String name, Set permissions, Set subjects) throws DelegationException {
        this.setName(name);
        this.setPermissions(permissions);
        this.setSubjects(subjects);
    }

    public DelegationPrivilege(String name, Set subjects, String orgName) throws DelegationException {
        this.name = name;
        int revisionNum = DelegationUtils.getRevisionNumber();
        try {
            orgName = DNMapper.orgNameToDN(orgName);
            Set permNames = null;
            Map attrs = null;
            if (revisionNum != 10) {
                ServiceConfig priv = null;
                try {
                    if (debug.messageEnabled()) {
                        debug.message("DelegationPrivilege: Getting org privileges; org=" + orgName);
                    }
                    priv = DelegationUtils.getPrivilegeConfig(orgName, name, false);
                }
                catch (DelegationException de) {
                    if (debug.messageEnabled()) {
                        debug.message("DelegationPrivilege: privilege " + name + " not defined in realm " + orgName);
                    }
                    priv = null;
                }
                if (priv == null) {
                    debug.message("DelegationPrivilege<init>: Getting global privileges");
                    try {
                        priv = DelegationUtils.getPrivilegeConfig(null, name, true);
                    }
                    catch (DelegationException de) {
                        debug.error("DelegationPrivilege<init>: privilege " + name + " is not defined in any configuration.", (Throwable)de);
                        Object[] objs = new String[]{name};
                        throw new DelegationException("amDelegation", "privilege_not_configured", objs, null);
                    }
                }
                if (priv == null) {
                    Object[] objs = new String[]{name};
                    throw new DelegationException("amDelegation", "privilege_not_configured", objs, null);
                }
                attrs = priv.getAttributes();
                if (attrs == null || attrs.isEmpty()) {
                    throw new DelegationException("amDelegation", "get_privilege_attrs_failed", null, null);
                }
                permNames = (Set)attrs.get("listOfPermissions");
                if (permNames == null || permNames.isEmpty()) {
                    throw new DelegationException("amDelegation", "no_permission_defined_in_the_privilege", null, null);
                }
            } else {
                permNames = new HashSet<String>();
                permNames.add(name);
            }
            Iterator it = permNames.iterator();
            while (it.hasNext()) {
                String permName = (String)it.next();
                ServiceConfig perm = null;
                try {
                    if (debug.messageEnabled()) {
                        debug.message("DelegationPrivilege: Getting org permissions; org=" + orgName);
                    }
                    perm = DelegationUtils.getPermissionConfig(orgName, permName, false);
                }
                catch (DelegationException de) {
                    if (debug.messageEnabled()) {
                        debug.message("DelegationPrivilege: privilege " + permName + " not defined in realm " + orgName);
                    }
                    perm = null;
                }
                if (perm == null) {
                    if (debug.messageEnabled()) {
                        debug.message("DelegationPrivilege: Getting global permissions");
                    }
                    try {
                        perm = DelegationUtils.getPermissionConfig(null, permName, true);
                    }
                    catch (DelegationException de) {
                        debug.error("DelegationPrivilege: permission " + permName + " is not defined in any configuration.", (Throwable)de);
                        Object[] objs = new String[]{permName};
                        throw new DelegationException("amDelegation", "permission_not_configured", objs, null);
                    }
                }
                if ((attrs = perm.getAttributes()) == null || attrs.isEmpty()) {
                    throw new DelegationException("amDelegation", "get_privilege_attrs_failed", null, null);
                }
                Set resources = (Set)attrs.get(RESOURCE);
                Set actions = (Set)attrs.get(ACTIONS);
                if (resources == null || actions == null || resources.isEmpty() || actions.isEmpty()) {
                    throw new DelegationException("amDelegation", "get_permission_res_or_actions_failed", null, null);
                }
                Iterator iter = resources.iterator();
                String resource = (String)iter.next();
                resource = DelegationUtils.swapRealmTag(orgName, resource);
                StringTokenizer st = new StringTokenizer(resource, DELIMITER);
                String realmName = st.nextToken();
                String serviceName = null;
                String version = null;
                String configType = null;
                String subconfigName = null;
                if (st.hasMoreTokens()) {
                    serviceName = st.nextToken();
                    if (st.hasMoreTokens()) {
                        version = st.nextToken();
                        if (st.hasMoreTokens()) {
                            configType = st.nextToken();
                            if (st.hasMoreTokens()) {
                                subconfigName = st.nextToken();
                                while (st.hasMoreTokens()) {
                                    subconfigName = subconfigName + DELIMITER + st.nextToken();
                                }
                            }
                        }
                    }
                }
                DelegationPermission dp = new DelegationPermission(realmName, serviceName, version, configType, subconfigName, actions, null);
                this.permissions.add(dp);
            }
            this.setSubjects(subjects);
            if (debug.messageEnabled()) {
                debug.message("DelegationPrivilege: org=" + orgName + "; privilege name=" + name + "; permissions=" + this.permissions + "; subjects=" + subjects);
            }
        }
        catch (SSOException sse) {
            debug.error("DelegationPrivilege: ", (Throwable)((Object)sse));
            throw new DelegationException((Throwable)((Object)sse));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws DelegationException {
        this.name = name;
    }

    public Set getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set permissions) throws DelegationException {
        this.permissions = permissions;
    }

    public Set getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Set names) throws DelegationException {
        this.subjects = new HashSet();
        if (names != null) {
            this.subjects.addAll(names);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("DelegationPrivilege Object:");
        sb.append("\nname=");
        sb.append(this.name);
        sb.append("\npermissions=");
        sb.append(this.permissions);
        sb.append("\nsubject=");
        sb.append(this.subjects);
        return sb.toString();
    }
}

