/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.user.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.user.model.UMUserPasswordResetOptionsData;
import com.sun.identity.console.user.model.UMUserPasswordResetOptionsModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UMUserPasswordResetOptionsModelImpl
extends AMModelBase
implements UMUserPasswordResetOptionsModel {
    private OrganizationConfigManager orgCfgMgr;
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();

    public UMUserPasswordResetOptionsModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    private Map getQuestions(String realmName) {
        HashMap<String, String> mapQuestions = null;
        Set questions = this.getAttributeValues(realmName, "iplanet-am-password-reset-question", "iPlanetAMPasswordResetService");
        if (questions != null && !questions.isEmpty()) {
            mapQuestions = new HashMap<String, String>(questions.size() * 2);
            ResourceBundle rb = this.getServiceResourceBundle("iPlanetAMPasswordResetService");
            Iterator iter = questions.iterator();
            while (iter.hasNext()) {
                String val;
                String label = val = (String)iter.next();
                try {
                    label = rb == null ? val : rb.getString(val);
                }
                catch (MissingResourceException mre) {
                    debug.warning("no i18nKey defined for question " + mre.getMessage());
                }
                mapQuestions.put(val, label);
            }
        } else {
            debug.message("UMUserPasswordResetOptionsModelImpl there were no questions defined for this user");
        }
        return mapQuestions;
    }

    public boolean isUserQuestionEnabled(String realmName) {
        Set values = this.getAttributeValues(realmName, "iplanet-am-password-reset-user-personal-question", "iPlanetAMPasswordResetService");
        return ((String)AMAdminUtils.getValue(values)).equalsIgnoreCase("true");
    }

    public int getMaxNumQuestions(String realmName) {
        int maxNum = 1;
        Set set = this.getAttributeValues(realmName, "iplanet-am-password-reset-max-num-of-questions", "iPlanetAMPasswordResetService");
        if (set != null && !set.isEmpty()) {
            String value = (String)set.iterator().next();
            try {
                maxNum = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                debug.warning("UMUserPasswordResetOptionsModelImplxNumQuestions.", (Throwable)e);
            }
        }
        return maxNum;
    }

    public void modifyUserOption(List questionAnswers, String userId, boolean forceReset) throws AMConsoleException {
        HashMap<String, Set> mapData = new HashMap<String, Set>(4);
        if (this.isLoggedInUser(userId)) {
            Set attribVals = this.formatOptionData(questionAnswers);
            mapData.put("iplanet-am-user-password-reset-question-answer", attribVals);
        }
        HashSet<String> set = new HashSet<String>(2);
        set.add(String.valueOf(forceReset));
        mapData.put("iplanet-am-user-password-reset-force-reset", set);
        if (!mapData.isEmpty()) {
            String[] params = new String[]{userId, "iplanet-am-user-password-reset-question-answer"};
            this.logEvent("ATTEMPT_MODIFY_IDENTITY_ATTRIBUTE_VALUE", params);
            try {
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
                amid.setAttributes(mapData);
                amid.store();
                this.logEvent("SUCCEED_MODIFY_IDENTITY_ATTRIBUTE_VALUE", params);
            }
            catch (SSOException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-question-answer", strError};
                this.logEvent("SSO_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
                throw new AMConsoleException(strError);
            }
            catch (IdRepoException e) {
                String strError = this.getErrorString(e);
                String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-question-answer", strError};
                this.logEvent("IDM_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
                throw new AMConsoleException(strError);
            }
        }
    }

    public boolean isForceReset(String userId) {
        boolean forcedReset = false;
        try {
            String[] params = new String[]{userId, "iplanet-am-user-password-reset-force-reset"};
            this.logEvent("ATTEMPT_READ_IDENTITY_ATTRIBUTE_VALUE", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
            Set set = amid.getAttribute("iplanet-am-user-password-reset-force-reset");
            this.logEvent("SUCCEED_READ_IDENTITY_ATTRIBUTE_VALUE", params);
            if (set != null && !set.isEmpty()) {
                forcedReset = ((String)AMAdminUtils.getValue(set)).equalsIgnoreCase("true");
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-force-reset", this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            debug.warning("UMUserPasswordResetOptionsModelImpl.isForceReset", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-force-reset", this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            debug.warning("UMUserPasswordResetOptionsModelImpl.isForceReset", (Throwable)e);
        }
        return forcedReset;
    }

    private Set formatOptionData(List questionAnswers) throws AMConsoleException {
        HashSet<String> attribVals = null;
        if (questionAnswers == null || questionAnswers.isEmpty()) {
            attribVals = new HashSet<String>(2);
            attribVals.add("");
        } else {
            attribVals = new HashSet(questionAnswers.size() * 2);
            Iterator iter = questionAnswers.iterator();
            while (iter.hasNext()) {
                UMUserPasswordResetOptionsData data = (UMUserPasswordResetOptionsData)iter.next();
                data.validate();
                if (data == null) continue;
                String str = data.getQuestion() + "\t" + data.getAnswer() + "\t" + data.getDataStatus();
                String encryptStr = (String)AccessController.doPrivileged(new EncryptAction(str));
                attribVals.add(encryptStr);
            }
        }
        return attribVals;
    }

    public List getUserAnswers(String userId) throws AMConsoleException {
        try {
            String[] params = new String[]{userId, "iplanet-am-user-password-reset-question-answer"};
            this.logEvent("ATTEMPT_READ_IDENTITY_ATTRIBUTE_VALUE", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
            Set questions = amid.getAttribute("iplanet-am-user-password-reset-question-answer");
            this.logEvent("SUCCEED_READ_IDENTITY_ATTRIBUTE_VALUE", params);
            return this.getUserPasswordResetAnswers(amid, questions);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-question-answer", strError};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{userId, "iplanet-am-user-password-reset-question-answer", strError};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    private List getUserPasswordResetAnswers(AMIdentity amid, Set questions) {
        ArrayList<UMUserPasswordResetOptionsData> mapQuestionAnswer = new ArrayList<UMUserPasswordResetOptionsData>();
        String realmName = amid.getRealm();
        boolean showUserQn = this.isUserQuestionEnabled(realmName);
        UMUserPasswordResetOptionsData personalQn = null;
        Map localizedQuestions = this.getQuestions(realmName);
        if (localizedQuestions == null || localizedQuestions.isEmpty()) {
            return mapQuestionAnswer;
        }
        HashSet<String> selectedQns = new HashSet<String>(localizedQuestions.size() * 2);
        Map userAnswers = this.parseUserQuestionAnswers(questions, showUserQn, localizedQuestions);
        Iterator i = localizedQuestions.keySet().iterator();
        while (i.hasNext()) {
            String qn = (String)i.next();
            UMUserPasswordResetOptionsData data = (UMUserPasswordResetOptionsData)userAnswers.get(qn);
            if (data != null) {
                if (data.isPersonalQuestion()) {
                    personalQn = data;
                    continue;
                }
                mapQuestionAnswer.add(data);
                selectedQns.add(qn);
                continue;
            }
            mapQuestionAnswer.add(new UMUserPasswordResetOptionsData(qn, (String)localizedQuestions.get(qn), "", 0));
        }
        if (showUserQn) {
            if (personalQn == null) {
                personalQn = new UMUserPasswordResetOptionsData("", "", "", 2);
            }
            mapQuestionAnswer.add(personalQn);
        }
        return mapQuestionAnswer;
    }

    private Map parseUserQuestionAnswers(Set questions, boolean showUserQn, Map localizedQuestions) {
        HashMap<String, UMUserPasswordResetOptionsData> map = new HashMap<String, UMUserPasswordResetOptionsData>();
        if (questions != null && !questions.isEmpty()) {
            Iterator i = questions.iterator();
            while (i.hasNext()) {
                UMUserPasswordResetOptionsData data;
                String value = (String)i.next();
                String decryptStr = (String)AccessController.doPrivileged(new DecryptAction(value));
                StringTokenizer st = new StringTokenizer(decryptStr, "\t");
                if (st.countTokens() != 3 || (data = this.getPwdResetOptionData(st, localizedQuestions, showUserQn)) == null) continue;
                map.put(data.getQuestion(), data);
            }
        }
        return map;
    }

    private UMUserPasswordResetOptionsData getPwdResetOptionData(StringTokenizer st, Map localizedQuestions, boolean showUserQn) {
        UMUserPasswordResetOptionsData optionsData;
        block7: {
            optionsData = null;
            String question = st.nextToken();
            String answer = st.nextToken();
            String dataStatus = st.nextToken();
            try {
                int status = Integer.parseInt(dataStatus);
                String questionLocalizedName = null;
                switch (status) {
                    case 0: 
                    case 1: {
                        questionLocalizedName = (String)localizedQuestions.get(question);
                    }
                }
                if (questionLocalizedName == null && showUserQn) {
                    questionLocalizedName = question;
                }
                if (questionLocalizedName != null) {
                    optionsData = new UMUserPasswordResetOptionsData(question, questionLocalizedName, answer, status);
                }
            }
            catch (NumberFormatException e) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("UMUserPasswordResetOptionsModelImpl.getUserPasswordResetAnswers: " + dataStatus, (Throwable)e);
            }
        }
        return optionsData;
    }

    private Set getAttributeValues(String realmName, String attributeName, String serviceName) {
        Set values = null;
        try {
            String[] params = new String[]{realmName, serviceName, attributeName};
            this.logEvent("ATTEMPT_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
            OrganizationConfigManager orgMgr = this.getOrganizationConfigManager(realmName);
            Map map = orgMgr.getServiceAttributes(serviceName);
            values = (Set)map.get(attributeName);
            this.logEvent("SUCCEED_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, serviceName, attributeName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", paramsEx);
            values = this.getGlobalAttributeValues(attributeName, serviceName);
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    private Set getGlobalAttributeValues(String attributeName, String serviceName) {
        Set values = null;
        try {
            String[] params = new String[]{serviceName, SchemaType.GLOBAL.getType(), attributeName};
            this.logEvent("ATTEMPT_GET_ATTR_VALUE_SCHEMA_TYPE", params);
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.getUserSSOToken());
            values = AMAdminUtils.getAttribute(mgr, SchemaType.GLOBAL, attributeName);
            this.logEvent("SUCCEED_GET_ATTR_VALUE_SCHEMA_TYPE", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{serviceName, SchemaType.GLOBAL.getType(), attributeName, strError};
            this.logEvent("SSO_EXCEPTION_GET_ATTR_VALUE_SCHEMA_TYPE", paramsEx);
            debug.error("UMUserPasswordResetOptionsModelImpl.getGlobalAttributeValues", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{serviceName, SchemaType.GLOBAL.getType(), attributeName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_SCHEMA_TYPE", paramsEx);
            debug.error("UMUserPasswordResetOptionsModelImpl.getGlobalAttributeValues", (Throwable)e);
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    private OrganizationConfigManager getOrganizationConfigManager(String realmName) {
        if (this.orgCfgMgr == null) {
            try {
                this.orgCfgMgr = new OrganizationConfigManager(adminSSOToken, realmName);
            }
            catch (SMSException e) {
                debug.error("UMUserPasswordResetOptionsModelImpl.getOrganizationConfigManager", (Throwable)e);
            }
        }
        return this.orgCfgMgr;
    }

    public boolean isLoggedInUser(String userId) {
        return userId.equals(this.getUserName());
    }
}

