/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.user;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.CloseWindowViewBean;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.realm.RMRealmViewBeanBase;
import com.sun.identity.console.user.model.UMChangeUserPasswordModel;
import com.sun.identity.console.user.model.UMChangeUserPasswordModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;

public class UMChangeUserPasswordViewBean
extends RMRealmViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/user/UMChangeUserPassword.jsp";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String PAGETITLE = "pgtitle";
    private static final String ATTR_PASSWORD = "tfPassword";
    private static final String REENTER_PASSWORD = "tfConfirmPassword";
    private CCPageTitleModel ptModel;
    protected AMPropertySheetModel propertySheetModel;
    private boolean submitCycle = false;

    public UMChangeUserPasswordViewBean() {
        super("UMChangeUserPassword");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        if (!this.initialized) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)"button.close");
    }

    protected void createPropertyModel() {
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyUserChangePassword.xml"));
        this.propertySheetModel.clear();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String userId = (String)this.getPageSessionAttribute("universalId");
        UMChangeUserPasswordModel model = (UMChangeUserPasswordModel)this.getModel();
        String[] arg = new String[]{AMFormatUtils.getIdentityDisplayName((AMModel)model, userId)};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString("page.title.user.change.password"), arg));
        if (!this.submitCycle) {
            try {
                String pwd = model.getPassword(userId);
                this.propertySheetModel.setValue(ATTR_PASSWORD, pwd);
                this.propertySheetModel.setValue(REENTER_PASSWORD, pwd);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new UMChangeUserPasswordModelImpl(req, this.getPageSessionAttributes());
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String pwd = (String)this.propertySheetModel.getValue(ATTR_PASSWORD);
        String reenter = (String)this.propertySheetModel.getValue(REENTER_PASSWORD);
        pwd = pwd.trim();
        reenter = reenter.trim();
        if (pwd.length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "user.change.password.missing.password.message");
        } else if (!pwd.equals(reenter)) {
            this.setInlineAlertMessage("error", "message.error", "user.change.password.mismatch.password.message");
        } else {
            UMChangeUserPasswordModel model = (UMChangeUserPasswordModel)this.getModel();
            String userId = (String)this.getPageSessionAttribute("universalId");
            try {
                model.changePassword(userId, pwd);
                this.setInlineAlertMessage("info", "message.information", "user.change.password.modified.password.message");
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        CloseWindowViewBean vb = (CloseWindowViewBean)this.getViewBean(CloseWindowViewBean.class);
        vb.forwardTo(this.getRequestContext());
    }
}

