/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.session.model;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.sun.identity.console.session.model.SMProfileModelImpl;
import com.sun.identity.console.session.model.SMSessionData;
import com.sun.identity.shared.debug.Debug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SMSessionCache
implements Serializable {
    private static Debug debug = SMProfileModelImpl.debug;
    private String searchErrorMessage;
    private List sessions = new ArrayList();

    public SMSessionCache(Collection sessions, String searchErrorMsg, SMProfileModelImpl modelImpl) {
        this.searchErrorMessage = searchErrorMsg;
        Map mapSessions = this.retainSessionsWithUserID(sessions, modelImpl);
        this.cacheSessions(mapSessions, modelImpl);
    }

    public String getErrorMessage() {
        return this.searchErrorMessage;
    }

    public List getSessions() {
        return this.sessions;
    }

    private void cacheSessions(Map mapSessions, SMProfileModelImpl modelImpl) {
        ArrayList sorted = new ArrayList(mapSessions.keySet());
        int sz = sorted.size();
        for (int i = 0; i < sz; ++i) {
            this.sessions.add(mapSessions.get(sorted.get(i)));
        }
    }

    private Map retainSessionsWithUserID(Collection sessions, SMProfileModelImpl modelImpl) {
        HashMap<String, SMSessionData> results = new HashMap<String, SMSessionData>(sessions.size() * 2);
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            Session sess = (Session)((Object)iter.next());
            try {
                String userId = sess.getProperty("UserId");
                if (userId == null) continue;
                String id = sess.getID().toString();
                SMSessionData sData = new SMSessionData();
                sData.setUserId(userId);
                sData.setId(id);
                sData.setTimeRemain(sess.getTimeLeft() / 60L);
                sData.setMaxSessionTime(sess.getMaxSessionTime());
                sData.setIdleTime(sess.getIdleTime() / 60L);
                sData.setMaxIdleTime(sess.getMaxIdleTime());
                results.put(userId + id, sData);
            }
            catch (SessionException se) {
                debug.message("SMSessionCache.retainSessionsWithUserID", (Throwable)((Object)se));
            }
        }
        return results;
    }
}

