/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfigXML;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ServerSiteModelImpl
extends AMModelBase
implements ServerSiteModel {
    public ServerSiteModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getSiteNames() throws AMConsoleException {
        String[] param = new String[]{};
        this.logEvent("ATTEMPT_GET_SITE_NAMES", param);
        try {
            Set siteNames = SiteConfiguration.getSites(this.getUserSSOToken());
            this.logEvent("SUCCEED_GET_SITE_NAMES", param);
            return siteNames;
        }
        catch (SMSException e) {
            String[] params = new String[]{e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SITE_NAMES", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SITE_NAMES", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getSitePrimaryURL(String name) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_GET_SITE_PRIMARY_URL", param);
        try {
            String url = SiteConfiguration.getSitePrimaryURL(this.getUserSSOToken(), name);
            this.logEvent("SUCCEED_GET_SITE_PRIMARY_URL", param);
            return url;
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SITE_PRIMARY_URL", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SITE_PRIMARY_URL", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getSiteFailoverURLs(String name) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_GET_SITE_FAILOVER_URLS", param);
        try {
            Set urls = SiteConfiguration.getSiteSecondaryURLs(this.getUserSSOToken(), name);
            this.logEvent("SUCCEED_GET_SITE_FAILOVER_URLS", param);
            return urls;
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SITE_FAILOVER_URLS", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SITE_FAILOVER_URLS", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getSiteServers(String name) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_GET_SITE_MEMBERS", param);
        try {
            Set members = SiteConfiguration.listServers(this.getUserSSOToken(), name);
            this.logEvent("SUCCEED_GET_SITE_MEMBERS", param);
            return members;
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SITE_MEMBERS", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SITE_MEMBERS", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void createSite(String name, String url) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_CREATE_SITE", param);
        try {
            SiteConfiguration.createSite(this.getUserSSOToken(), name, url, Collections.EMPTY_SET);
            this.logEvent("SUCCEED_CREATE_SITE", param);
        }
        catch (ConfigurationException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_CREATE_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_CREATE_SITE", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void createServer(String name) throws AMConsoleException {
        SSOToken ssoToken = this.getUserSSOToken();
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_CREATE_SERVER", param);
        try {
            String svrConfigXML = ServerConfiguration.getServerConfigXML(ssoToken, SystemProperties.getServerInstanceName());
            ServerConfiguration.createServerInstance(ssoToken, name, Collections.EMPTY_MAP, svrConfigXML);
            this.logEvent("SUCCEED_CREATE_SERVER", param);
        }
        catch (UnknownPropertyNameException e) {
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_CREATE_SERVER", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (ConfigurationException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("CONFIGURATION_EXCEPTION_CREATE_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_CREATE_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("IO_EXCEPTION_CREATE_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void deleteSites(Set sites) throws AMConsoleException {
        String siteName = null;
        try {
            if (sites != null && !sites.isEmpty()) {
                SSOToken token = this.getUserSSOToken();
                Iterator i = sites.iterator();
                while (i.hasNext()) {
                    siteName = (String)i.next();
                    String[] param = new String[]{siteName};
                    this.logEvent("ATTEMPT_DELETE_SITE", param);
                    SiteConfiguration.deleteSite(token, siteName);
                    this.logEvent("SUCCEED_DELETE_SITE", param);
                }
            }
        }
        catch (SMSException e) {
            String[] params = new String[]{siteName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_DELETE_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{siteName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_DELETE_SITE", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void modifySite(String siteName, String primaryURL, Set failoverURLs) throws AMConsoleException {
        try {
            SSOToken ssoToken = this.getUserSSOToken();
            String[] param = new String[]{siteName};
            this.logEvent("ATTEMPT_MODIFY_SITE", param);
            SiteConfiguration.setSitePrimaryURL(ssoToken, siteName, primaryURL);
            SiteConfiguration.setSiteSecondaryURLs(ssoToken, siteName, failoverURLs);
            this.logEvent("SUCCEED_MODIFY_SITE", param);
        }
        catch (ConfigurationException e) {
            String[] params = new String[]{siteName, e.getMessage()};
            this.logEvent("CONFIGURATION_EXCEPTION_MODIFY_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{siteName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_MODIFY_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{siteName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_MODIFY_SITE", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getServerNames() throws AMConsoleException {
        String[] param = new String[]{};
        this.logEvent("ATTEMPT_GET_SERVER_NAMES", param);
        try {
            Set names = ServerConfiguration.getServers(this.getUserSSOToken());
            this.logEvent("SUCCEED_GET_SERVER_NAMES", param);
            return names;
        }
        catch (SMSException e) {
            String[] params = new String[]{e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SERVER_NAMES", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SERVER_NAMES", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getServerSite(String name) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_GET_SERVER_SITE", param);
        try {
            String siteName = ServerConfiguration.getServerSite(this.getUserSSOToken(), name);
            this.logEvent("SUCCEED_GET_SERVER_SITE", param);
            return siteName;
        }
        catch (SMSException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SERVER_SITE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{name, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SERVER_SITE", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void deleteServers(Set servers) throws AMConsoleException {
        if (servers.contains(SystemProperties.getServerInstanceName())) {
            throw new AMConsoleException(this.getLocalizedString("exception.cannot.delete.this.server.instance"));
        }
        String serverName = null;
        try {
            if (servers != null && !servers.isEmpty()) {
                SSOToken token = this.getUserSSOToken();
                Iterator i = servers.iterator();
                while (i.hasNext()) {
                    serverName = (String)i.next();
                    String[] param = new String[]{serverName};
                    this.logEvent("ATTEMPT_DELETE_SERVER", param);
                    ServerConfiguration.deleteServerInstance(token, serverName);
                    this.logEvent("SUCCEED_DELETE_SERVER", param);
                }
            }
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_DELETE_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_DELETE_SERVER", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getEditSitePageTitle(String siteName) {
        Object[] param = new Object[]{siteName};
        return MessageFormat.format(this.getLocalizedString("page.title.site.edit"), param);
    }

    public void cloneServer(String origServer, String cloneServer) throws AMConsoleException {
        String[] param = new String[]{origServer, cloneServer};
        this.logEvent("ATTEMPT_CLONE_SERVER", param);
        try {
            ServerConfiguration.cloneServerInstance(this.getUserSSOToken(), origServer, cloneServer);
            this.logEvent("SUCCEED_CLONE_SERVER", param);
        }
        catch (ConfigurationException e) {
            String[] params = new String[]{origServer, cloneServer, e.getMessage()};
            this.logEvent("CONFIGURATION_EXCEPTION_CLONE_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{origServer, cloneServer, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_CLONE_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{origServer, cloneServer, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_CLONE_SERVER", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getEditServerPageTitle(String serverName) {
        Object[] param = new Object[]{serverName};
        return MessageFormat.format(this.getLocalizedString("page.title.server.edit"), param);
    }

    public Map getServerConfiguration(String serverName) throws AMConsoleException {
        String[] param = new String[]{serverName};
        try {
            SSOToken ssoToken = this.getUserSSOToken();
            this.logEvent("ATTEMPT_GET_SERVER_CONFIG", param);
            Properties attrs = ServerConfiguration.getServerInstance(ssoToken, serverName);
            ServerSiteModelImpl.removeHiddenProperties(attrs);
            this.logEvent("SUCCEED_GET_SERVER_CONFIG", param);
            return attrs;
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SERVER_CONFIG", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("IO_EXCEPTION_GET_SERVER_CONFIG", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SERVER_CONFIG", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    private static void removeHiddenProperties(Map attrs) {
        attrs.remove("com.iplanet.am.server.protocol");
        attrs.remove("com.iplanet.am.server.host");
        attrs.remove("com.iplanet.am.server.port");
        attrs.remove("com.iplanet.am.services.deploymentDescriptor");
        attrs.remove("com.iplanet.am.serverMode");
        attrs.remove("com.sun.identity.overrideAMC");
    }

    public Map getServerDefaults() {
        String[] param = new String[]{};
        this.logEvent("ATTEMPT_GET_SERVER_DEFAULT_CONFIG", param);
        Properties map = ServerConfiguration.getDefaults(this.getUserSSOToken());
        this.logEvent("SUCCEED_GET_SERVER_DEFAULT_CONFIG", param);
        return map;
    }

    public void modifyServer(String serverName, String parentSite, Map values) throws AMConsoleException, UnknownPropertyNameException {
        String[] param = new String[]{serverName};
        try {
            String currentSite;
            SSOToken ssoToken = this.getUserSSOToken();
            this.logEvent("ATTEMPT_MODIFY_SERVER", param);
            if (!(parentSite == null || (currentSite = ServerConfiguration.getServerSite(ssoToken, serverName)) != null && currentSite.equals(parentSite))) {
                ServerConfiguration.setServerSite(ssoToken, serverName, parentSite);
            }
            ServerConfiguration.setServerInstance(ssoToken, serverName, values);
            this.logEvent("SUCCEED_MODIFY_SERVER", param);
        }
        catch (ConfigurationException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("CONFIGURATION_EXCEPTION_MODIFY_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("IO_EXCEPTION_MODIFY_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_MODIFY_SERVER", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_MODIFY_SERVER", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void updateServerConfigInheritance(String serverName, Set toInherit, Set notToInherit) throws AMConsoleException {
        String[] param = new String[]{serverName};
        this.logEvent("ATTEMPT_MODIFY_SERVER_INHERITANCE", param);
        try {
            String name;
            Iterator i;
            SSOToken ssoToken = this.getUserSSOToken();
            Properties defaultValues = ServerConfiguration.getDefaults(ssoToken);
            Properties svrProperties = ServerConfiguration.getServerInstance(ssoToken, serverName);
            if (toInherit != null && !toInherit.isEmpty()) {
                HashSet<String> toRemove = new HashSet<String>();
                i = toInherit.iterator();
                while (i.hasNext()) {
                    name = (String)i.next();
                    if (!svrProperties.containsKey(name)) continue;
                    toRemove.add(name);
                }
                if (!toRemove.isEmpty()) {
                    ServerConfiguration.removeServerConfiguration(ssoToken, serverName, toRemove);
                }
            }
            if (notToInherit != null && !notToInherit.isEmpty()) {
                HashMap toAdd = new HashMap();
                i = notToInherit.iterator();
                while (i.hasNext()) {
                    name = (String)i.next();
                    if (svrProperties.containsKey(name)) continue;
                    toAdd.put(name, defaultValues.get(name));
                }
                if (!toAdd.isEmpty()) {
                    try {
                        ServerConfiguration.setServerInstance(ssoToken, serverName, toAdd);
                    }
                    catch (UnknownPropertyNameException ex) {
                        // empty catch block
                    }
                }
            }
            this.logEvent("SUCCEED_MODIFY_SERVER_INHERITANCE", param);
        }
        catch (ConfigurationException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("CONFIGURATION_EXCEPTION_MODIFY_SERVER_INHERITANCE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("IO_EXCEPTION_MODIFY_SERVER_INHERITANCE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_MODIFY_SERVER_INHERITANCE", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_MODIFY_SERVER_INHERITANCE", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public ServerConfigXML getServerConfigObject(String serverName) throws AMConsoleException {
        String[] param = new String[]{serverName};
        this.logEvent("ATTEMPT_GET_SERVER_CONFIG_XML", param);
        ServerConfigXML xmlObject = null;
        try {
            String xml = ServerConfiguration.getServerConfigXML(this.getUserSSOToken(), serverName);
            xmlObject = new ServerConfigXML(xml);
            this.logEvent("SUCCEED_GET_SERVER_CONFIG_XML", param);
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_GET_SERVER_CONFIG_XML", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_GET_SERVER_CONFIG_XML", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (Exception e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("GENERIC_EXCEPTION_GET_SERVER_CONFIG_XML", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return xmlObject;
    }

    public void setServerConfigXML(String serverName, String xml) throws AMConsoleException {
        String[] param = new String[]{serverName};
        this.logEvent("ATTEMPT_SET_SERVER_CONFIG_XML", param);
        try {
            ServerConfiguration.setServerConfigXML(this.getUserSSOToken(), serverName, xml);
            this.logEvent("SUCCEED_SET_SERVER_CONFIG_XML", param);
        }
        catch (SMSException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SMS_EXCEPTION_SET_SERVER_CONFIG_XML", params);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] params = new String[]{serverName, e.getMessage()};
            this.logEvent("SSO_EXCEPTION_SET_SERVER_CONFIG_XML", params);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }
}

