/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.service.model.SCModel;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class SCModelBase
extends AMModelBase
implements SCModel {
    ServiceSchemaManager manager = null;

    public SCModelBase(HttpServletRequest req, Map map) {
        super(req, map);
        this.initializeSchemaManager();
    }

    private void initializeSchemaManager() {
        String error = null;
        try {
            this.manager = new ServiceSchemaManager(this.getServiceName(), this.getUserSSOToken());
        }
        catch (SSOException e) {
            error = e.getMessage();
        }
        catch (SMSException e) {
            error = e.getMessage();
        }
        if (error != null && debug.warningEnabled()) {
            debug.warning("couldn't initialize schema manager for " + this.getServiceName());
            debug.warning("reason: " + error);
        }
    }

    protected Map getAttributeValues(SchemaType type) throws AMConsoleException {
        String serviceName = this.getServiceName();
        String[] params = new String[]{serviceName, type.getType(), "*"};
        this.logEvent("ATTEMPT_GET_ATTR_VALUE_SCHEMA_TYPE", params);
        try {
            Map values = null;
            ServiceSchema schema = this.getServiceSchemaManager().getSchema(type);
            if (schema != null) {
                Set attributes = schema.getAttributeSchemaNames();
                values = this.getAttributeValues(schema, attributes);
                this.logEvent("SUCCEED_GET_ATTR_VALUE_SCHEMA_TYPE", params);
            } else {
                this.logEvent("NO_SCHEMA_GET_ATTR_VALUE_SCHEMA_TYPE", params);
            }
            return values == null ? Collections.EMPTY_MAP : values;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{serviceName, type.getType(), "*", strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{serviceName, type.getType(), "*", strError};
            this.logEvent("SSO_EXCEPTION_GET_ATTR_VALUE_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    protected Map getAttributeValues(SchemaType type, Set attributes) throws AMConsoleException {
        String serviceName = this.getServiceName();
        String attributeNames = AMAdminUtils.getString(attributes, ",", false);
        String[] params = new String[]{serviceName, type.getType(), attributeNames};
        this.logEvent("ATTEMPT_GET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", params);
        try {
            ServiceSchema schema = this.getServiceSchemaManager().getSchema(type);
            Map values = this.getAttributeValues(schema, attributes);
            this.logEvent("SUCCEED_GET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", params);
            return values == null ? Collections.EMPTY_MAP : values;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{serviceName, type.getType(), attributeNames, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{serviceName, type.getType(), attributeNames, strError};
            this.logEvent("SSO_EXCEPTION_GET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Map getAttributeValues(ServiceSchema schema, Set attributes) {
        HashMap<String, Object> values = new HashMap<String, Object>(attributes.size() * 2);
        Iterator x = attributes.iterator();
        while (x.hasNext()) {
            String attributeName = (String)x.next();
            AttributeSchema as = schema.getAttributeSchema(attributeName);
            if (as == null) continue;
            AttributeSchema.Type type = as.getType();
            if (type == AttributeSchema.Type.MULTIPLE_CHOICE || type == AttributeSchema.Type.SINGLE_CHOICE) {
                HashMap<String, Set> m = new HashMap<String, Set>(4);
                m.put("choices", AMAdminUtils.toSet(as.getChoiceValues()));
                m.put("values", as.getDefaultValues());
                values.put(as.getName(), m);
                continue;
            }
            values.put(as.getName(), as.getDefaultValues());
        }
        if (debug.messageEnabled()) {
            debug.message("returning from getAttributeValues " + values);
        }
        return values == null ? Collections.EMPTY_MAP : values;
    }

    protected void setAttributeValues(SchemaType type, Map values) throws AMConsoleException {
        String serviceName = this.getServiceName();
        String attributeNames = AMAdminUtils.getString(values.keySet(), ",", false);
        String[] params = new String[]{serviceName, type.getType(), attributeNames};
        this.logEvent("ATTEMPT_SET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", params);
        try {
            ServiceSchema schema = this.getServiceSchemaManager().getSchema(type);
            schema.setAttributeDefaults(values);
            this.logEvent("SUCCEED_SET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{serviceName, type.getType(), attributeNames, strError};
            this.logEvent("SSO_EXCEPTION_SET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{serviceName, type.getType(), attributeNames, strError};
            this.logEvent("SMS_EXCEPTION_SET_ATTR_VALUE_ATR_SCHEMA_SCHEMA_TYPE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    protected Set getAttributeNames(SchemaType type) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("SCModelBase.getAttributeNames(type)");
            debug.message("trying to find " + type + " attributes for " + this.getServiceName());
        }
        try {
            ServiceSchema schema = this.getServiceSchemaManager().getSchema(type);
            Set attributes = schema.getAttributeSchemaNames();
            return attributes == null ? Collections.EMPTY_SET : attributes;
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    private ServiceSchemaManager getServiceSchemaManager() throws SSOException, SMSException {
        if (this.manager == null) {
            this.manager = new ServiceSchemaManager(this.getServiceName(), this.getUserSSOToken());
        }
        return this.manager;
    }

    public Map getValues() throws AMConsoleException {
        debug.message("SCModelBase.getValues()");
        HashMap tmp = new HashMap();
        tmp.putAll(this.getAttributeValues(SchemaType.GLOBAL));
        tmp.putAll(this.getAttributeValues(SchemaType.ORGANIZATION));
        tmp.putAll(this.getAttributeValues(SchemaType.DYNAMIC));
        return tmp;
    }

    public void setValues(Map modifiedValues) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("SCModelBase.setValues(modifiedValues)");
            debug.message("trying to set the following values for " + this.getServiceName() + "\n" + modifiedValues);
        }
        if (modifiedValues == null || modifiedValues.isEmpty()) {
            debug.message("the modifiedValues map is empty; no changes to set");
            return;
        }
        Map newValues = this.removeAttributes(SchemaType.GLOBAL, modifiedValues);
        if (newValues != null && !newValues.isEmpty()) {
            this.setAttributeValues(SchemaType.GLOBAL, newValues);
        }
        if ((newValues = this.removeAttributes(SchemaType.ORGANIZATION, modifiedValues)) != null && !newValues.isEmpty()) {
            this.setAttributeValues(SchemaType.ORGANIZATION, newValues);
        }
        if (!modifiedValues.isEmpty()) {
            this.setAttributeValues(SchemaType.DYNAMIC, modifiedValues);
        }
    }

    private Map removeAttributes(SchemaType type, Map original) {
        Set names;
        block3: {
            debug.message("SCModelBase.removeAttributes()");
            names = null;
            try {
                names = this.getAttributeNames(type);
            }
            catch (AMConsoleException a) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("SCModelBase.removeAttributes()\ncould not get the " + type + " attribute names");
            }
        }
        HashMap<String, Set> values = new HashMap<String, Set>(original.size() * 2);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String str = (String)i.next();
            Set value = (Set)original.remove(str);
            if (value == null) continue;
            values.put(str, value);
        }
        return values;
    }

    public abstract String getServiceName();
}

