/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.service.model.MAPModelBase;
import com.sun.identity.console.service.model.MAPServiceModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPServiceModelImpl
extends MAPModelBase
implements MAPServiceModel {
    public MAPServiceModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getProfileNames() {
        return this.clientTypesManager != null ? this.clientTypesManager.getBaseProfileNames() : Collections.EMPTY_SET;
    }

    public Set getDeviceNames(String profileName, String styleName, String wildcard) {
        Map map;
        HashSet<String> devices = Collections.EMPTY_SET;
        if (this.clientTypesManager != null && (map = this.clientTypesManager.getClients(profileName, styleName)) != null && !map.isEmpty()) {
            if (wildcard == null) {
                wildcard = "*";
            }
            String[] params = new String[]{profileName, styleName, wildcard};
            this.logEvent("ATTEMPT_CLIENT_DETECTION_GET_DEVICE_NAMES", params);
            Set set = map.keySet();
            devices = new HashSet<String>(set.size() * 2);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (!DisplayUtils.wildcardMatch(s, wildcard)) continue;
                devices.add(s);
            }
            this.logEvent("SUCCEED_CLIENT_DETECTION_GET_DEVICE_NAMES", params);
        }
        return devices;
    }

    public void removeClient(String clientType) throws AMConsoleException {
        String[] param = new String[]{clientType};
        this.logEvent("ATTEMPT_CLIENT_DETECTION_DELETE_CLIENT", param);
        try {
            this.clientTypesManager.removeClientExternal(this.getUserSSOToken(), clientType);
            this.logEvent("SUCCEED_CLIENT_DETECTION_DELETE_CLIENT", param);
        }
        catch (AMClientCapException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{clientType, strError};
            this.logEvent("CLIENT_SDK_EXCEPTION_CLIENT_DETECTION_DELETE_CLIENT", paramsEx);
            throw new AMConsoleException(strError);
        }
    }
}

