/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.service.model.MAPCreateDeviceModel;
import com.sun.identity.console.service.model.MAPModelBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPCreateDeviceModelImpl
extends MAPModelBase
implements MAPCreateDeviceModel {
    private Set createDeviceReqAttrs = null;
    private Map createDeviceDefaultValues = null;

    public MAPCreateDeviceModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public String getCreateDevicePropertyXML(String clientType, String style) throws AMConsoleException {
        String xml = "";
        this.createDeviceReqAttrs = this.getReqAttributeSchemas();
        if (this.createDeviceReqAttrs != null && !this.createDeviceReqAttrs.isEmpty()) {
            this.getCreateDeviceDefaultValues(this.createDeviceReqAttrs, clientType, style);
            String serviceName = this.getClientCapDataIntInstance().getServiceName();
            try {
                PropertyXMLBuilder builder = new PropertyXMLBuilder(serviceName, (AMModel)this, this.createDeviceReqAttrs);
                xml = builder.getXML();
            }
            catch (SMSException e) {
                debug.warning("MAPCreateDeviceModelImpl.getCreateDevicePropertyXML", (Throwable)e);
            }
            catch (SSOException e) {
                debug.warning("MAPCreateDeviceModelImpl.getCreateDevicePropertyXML", (Throwable)((Object)e));
            }
        }
        return xml;
    }

    public Set getCreateDeviceAttributeNames() {
        HashSet<String> names = new HashSet<String>(this.createDeviceReqAttrs.size() * 2);
        Iterator iter = this.createDeviceReqAttrs.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            names.add(as.getName());
        }
        return names;
    }

    public Map getCreateDeviceDefaultValues() {
        return this.createDeviceDefaultValues;
    }

    private void getCreateDeviceDefaultValues(Set attributeSchemas, String clientType, String style) {
        this.createDeviceDefaultValues = new HashMap(attributeSchemas.size());
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext()) {
            HashSet<String> set;
            AttributeSchema as = (AttributeSchema)iter.next();
            String asName = as.getName();
            if (asName.equals("parentId")) {
                set = new HashSet<String>(1);
                set.add(style);
                this.createDeviceDefaultValues.put(asName, set);
                continue;
            }
            if (asName.equals("clientType")) {
                set = new HashSet(1);
                set.add(MAPCreateDeviceModelImpl.canonicalize(clientType));
                this.createDeviceDefaultValues.put(asName, set);
                continue;
            }
            if (asName.equals("userAgent")) {
                set = new HashSet(1);
                set.add(clientType);
                this.createDeviceDefaultValues.put(asName, set);
                continue;
            }
            this.createDeviceDefaultValues.put(as.getName(), as.getDefaultValues());
        }
    }

    private Set getReqAttributeSchemas() {
        Set names;
        Set required = null;
        AMClientCapData ccd = this.getClientCapDataExtInstance();
        if (ccd != null && (names = AMClientCapData.getSchemaElements()) != null && !names.isEmpty()) {
            required = this.getAttributeSchemas(names);
            Iterator iter = required.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                String any = as.getAny();
                if (any != null && any.indexOf("required") != -1) continue;
                iter.remove();
            }
        }
        return required == null ? Collections.EMPTY_SET : required;
    }

    private Set getAttributeSchemas(Set names) {
        HashSet<AttributeSchema> attributeSchemas = new HashSet<AttributeSchema>(names.size());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = this.getAttributeSchema((String)iter.next());
            if (as == null) continue;
            attributeSchemas.add(as);
        }
        return attributeSchemas;
    }

    private AttributeSchema getAttributeSchema(String name) {
        AttributeSchema as = null;
        AMClientCapData internalInstance = this.getClientCapDataIntInstance();
        AMClientCapData externalInstance = this.getClientCapDataExtInstance();
        if (internalInstance != null && externalInstance != null) {
            String i18nKey;
            as = internalInstance.getAttributeSchema(name);
            if (as == null) {
                as = externalInstance.getAttributeSchema(name);
            }
            if (as != null && ((i18nKey = as.getI18NKey()) == null || i18nKey.length() == 0)) {
                as = null;
            }
        }
        return as;
    }

    public void createDevice(Map attrValues) throws AMConsoleException {
        String clientType = (String)AMAdminUtils.getValue((Set)attrValues.get("clientType"));
        String[] param = new String[]{clientType};
        this.logEvent("ATTEMPT_CLIENT_DETECTION_CREATE_CLIENT", param);
        try {
            this.validateClientType(clientType);
            this.clientTypesManager.addClientExternal(this.getUserSSOToken(), attrValues);
            this.logEvent("SUCCEED_CLIENT_DETECTION_CREATE_CLIENT", param);
        }
        catch (AMConsoleException e) {
            String[] paramsEx = new String[]{clientType, e.getMessage()};
            this.logEvent("INVALID_CLIENT_TYPE_CLIENT_DETECTION_CREATE_CLIENT", paramsEx);
            throw e;
        }
        catch (AMClientCapException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{clientType, strError};
            this.logEvent("CLIENT_SDK_EXCEPTION_CLIENT_DETECTION_CREATE_CLIENT", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private void validateClientType(String clientType) throws AMConsoleException {
        if (this.getClientCapDataIntInstance().isClientPresent(clientType)) {
            Object[] param = new String[]{clientType};
            String msg = MessageFormat.format(this.getLocalizedString("mapClientExist.message"), param);
            throw new AMConsoleException(msg);
        }
        if (!MAPCreateDeviceModelImpl.isClientTypeValid(clientType)) {
            throw new AMConsoleException(this.getLocalizedString("mapInvalidClientType.message"));
        }
    }

    public void cloneDevice(String origClientType, String clientType, String deviceName) throws AMConsoleException {
        Map map = this.getCloningProperties(origClientType);
        if (map == null) {
            throw new AMConsoleException(this.getLocalizedString("mapCloneFailed.message"));
        }
        String[] param = new String[]{clientType};
        this.logEvent("ATTEMPT_CLIENT_DETECTION_CREATE_CLIENT", param);
        try {
            this.validateClientType(clientType);
            HashSet<String> set = new HashSet<String>(1);
            set.add(clientType);
            map.put("clientType", set);
            set = new HashSet(1);
            set.add(deviceName);
            map.put("userAgent", set);
            this.clientTypesManager.addClientExternal(this.getUserSSOToken(), map);
            this.logEvent("SUCCEED_CLIENT_DETECTION_CREATE_CLIENT", param);
        }
        catch (AMConsoleException e) {
            String[] paramsEx = new String[]{clientType, e.getMessage()};
            this.logEvent("INVALID_CLIENT_TYPE_CLIENT_DETECTION_CREATE_CLIENT", paramsEx);
            throw e;
        }
        catch (AMClientCapException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{clientType, strError};
            this.logEvent("CLIENT_SDK_EXCEPTION_CLIENT_DETECTION_CREATE_CLIENT", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Map getCloningProperties(String clientType) {
        AMClientCapData ccd = this.getClientCapDataIntInstance();
        Map iMap = ccd.getProperties(clientType);
        AMClientCapData eCD = this.getClientCapDataExtInstance();
        Map eMap = eCD.getProperties(clientType);
        Map merged = null;
        if (iMap != null) {
            merged = iMap;
            if (eMap != null) {
                merged.putAll(eMap);
            }
        } else if (eMap != null) {
            merged = eMap;
        }
        return merged;
    }
}

