/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMServiceProfileViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMServiceProfileModel;
import com.sun.identity.console.realm.ServicesAddViewBean;
import com.sun.identity.console.realm.ServicesEditViewBean;
import com.sun.identity.console.service.G11NCharsetAliasAddViewBean;
import com.sun.identity.console.service.G11NCharsetAliasEditViewBean;
import com.sun.identity.console.service.G11NSupportedCharsetsAddViewBean;
import com.sun.identity.console.service.G11NSupportedCharsetsEditViewBean;
import com.sun.identity.console.service.SCConfigViewBean;
import com.sun.identity.console.service.model.CharsetAliasEntry;
import com.sun.identity.console.service.model.LocaleSupportedCharsetsEntry;
import com.sun.identity.console.service.model.SMG11NModelImpl;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SMG11NViewBean
extends AMServiceProfileViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/service/SMG11N.jsp";
    public static final String PAGE_MODIFIED = "pageModified";
    private static final String TEMPLATE = "template";
    private static final String TBL_SUPPORTED_CHARSETS_COL_CHARSETS = "tblSupportedCharsetsColCharsets";
    private static final String TBL_SUPPORTED_CHARSETS_COL_LOCALE = "tblSupportedCharsetsColLocale";
    private static final String TBL_SUPPORTED_CHARSETS_DATA_LOCALE = "tblSupportedCharsetsDataLocale";
    private static final String TBL_SUPPORTED_CHARSETS_DATA_CHARSETS = "tblSupportedCharsetsDataCharsets";
    private static final String TBL_SUPPORTED_CHARSETS_HREF_ACTION = "tblSupportedCharsetsHrefAction";
    private static final String TBL_SUPPORTED_CHARSETS_ADD_BTN = "tblSupportedCharsetsButtonAdd";
    private static final String TBL_SUPPORTED_CHARSETS_DELETE_BTN = "tblSupportedCharsetsButtonDelete";
    private static final String TBL_CHARSET_ALIAS_COL_MIMENAME = "tblCharsetAliasColMimeName";
    private static final String TBL_CHARSET_ALIAS_COL_JAVANAME = "tblCharsetAliasColJavaName";
    private static final String TBL_CHARSET_ALIAS_DATA_MIMENAME = "tblCharsetAliasDataMimeName";
    private static final String TBL_CHARSET_ALIAS_DATA_JAVANAME = "tblCharsetAliasDataJavaName";
    private static final String TBL_CHARSET_ALIAS_HREF_ACTION = "tblCharsetAliasHrefAction";
    private static final String TBL_CHARSET_ALIAS_ADD_BTN = "tblCharsetAliasButtonAdd";
    private static final String TBL_CHARSET_ALIAS_DELETE_BTN = "tblCharsetAliasButtonDelete";
    private boolean tablePopulated = false;

    public SMG11NViewBean() {
        super("SMG11N", DEFAULT_DISPLAY_URL, "iPlanetG11NSettings");
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        HttpServletRequest req = reqContext.getRequest();
        String template = req.getParameter("Template");
        if (template != null && template.equals("true")) {
            String operation = req.getParameter("Op");
            AMServiceProfileViewBeanBase vb = null;
            if (operation.equals("add")) {
                vb = (AMServiceProfileViewBeanBase)this.getViewBean(ServicesAddViewBean.class);
            } else {
                vb = (AMServiceProfileViewBeanBase)this.getViewBean(ServicesEditViewBean.class);
                vb.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)"com.sun.identity.console.realm.ServicesViewBean"));
            }
            vb.setPageSessionAttribute("currentRealm", (Serializable)((Object)req.getParameter("Location")));
            vb.setPageSessionAttribute("serviceName", (Serializable)((Object)req.getParameter("ServiceName")));
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(reqContext);
        } else {
            super.forwardTo(reqContext);
        }
    }

    protected View createChild(String name) {
        if (!this.tablePopulated) {
            this.prePopulateTable();
        }
        return super.createChild(name);
    }

    protected void createPropertyModel() {
        super.createPropertyModel();
        this.createSupportedCharsetsTableModel();
        this.createCharsetAliasTableModel();
    }

    private void createSupportedCharsetsTableModel() {
        CCActionTableModel tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblG11NSupportedCharsets.xml"));
        tblModel.setTitleLabel("label.items");
        tblModel.setActionValue(TBL_SUPPORTED_CHARSETS_COL_LOCALE, (Object)"globalization.service.table.SupportedCharsets.locale");
        tblModel.setActionValue(TBL_SUPPORTED_CHARSETS_COL_CHARSETS, (Object)"globalization.service.table.SupportedCharsets.charsets");
        tblModel.setActionValue(TBL_SUPPORTED_CHARSETS_ADD_BTN, (Object)"globalization.service.table.SupportedCharsets.add.button");
        tblModel.setActionValue(TBL_SUPPORTED_CHARSETS_DELETE_BTN, (Object)"globalization.service.table.SupportedCharsets.delete.button");
        this.propertySheetModel.setModel("sun-identity-g11n-settings-locale-charset-mapping", tblModel);
    }

    private void createCharsetAliasTableModel() {
        CCActionTableModel tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblG11NCharsetAlias.xml"));
        tblModel.setTitleLabel("label.items");
        tblModel.setActionValue(TBL_CHARSET_ALIAS_COL_MIMENAME, (Object)"globalization.service.table.CharsetAlias.mimeName");
        tblModel.setActionValue(TBL_CHARSET_ALIAS_COL_JAVANAME, (Object)"globalization.service.table.CharsetAlias.javaName");
        tblModel.setActionValue(TBL_CHARSET_ALIAS_ADD_BTN, (Object)"globalization.service.table.CharsetAlias.add.button");
        tblModel.setActionValue(TBL_CHARSET_ALIAS_DELETE_BTN, (Object)"globalization.service.table.CharsetAlias.delete.button");
        this.propertySheetModel.setModel("sun-identity-g11n-settings-charset-alias-mapping", tblModel);
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        try {
            return new SMG11NModelImpl(req, this.serviceName, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            return null;
        }
    }

    private void prePopulateTable() {
        Map attributeValues = (Map)this.removePageSessionAttribute("propertyAttributes");
        if (attributeValues != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
            ps.setAttributeValues(attributeValues, this.getModel());
        }
        this.prePopulateSupportedCharsetsTable(attributeValues);
        this.prePopulateCharsetAliasTable(attributeValues);
    }

    private void prePopulateSupportedCharsetsTable(Map attributeValues) {
        Set supportedCharsets = null;
        if (attributeValues != null) {
            supportedCharsets = (Set)attributeValues.get("sun-identity-g11n-settings-locale-charset-mapping");
            if (supportedCharsets == null) {
                supportedCharsets = Collections.EMPTY_SET;
            }
        } else {
            supportedCharsets = (Set)this.removePageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping");
        }
        if (supportedCharsets != null) {
            this.populateSupportedCharsetsTable(supportedCharsets);
        }
    }

    private void prePopulateCharsetAliasTable(Map attributeValues) {
        Set charsetAlias = null;
        if (attributeValues != null) {
            charsetAlias = (Set)attributeValues.get("sun-identity-g11n-settings-charset-alias-mapping");
            if (charsetAlias == null) {
                charsetAlias = Collections.EMPTY_SET;
            }
        } else {
            charsetAlias = (Set)this.removePageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping");
        }
        if (charsetAlias != null) {
            this.populateCharsetAliasTable(charsetAlias);
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        String flag;
        AMServiceProfileModel model;
        super.beginDisplay(event);
        this.resetButtonState(TBL_SUPPORTED_CHARSETS_DELETE_BTN);
        this.resetButtonState(TBL_CHARSET_ALIAS_DELETE_BTN);
        if (!this.tablePopulated && !this.isSubmitCycle() && (model = (AMServiceProfileModel)this.getModel()) != null) {
            OrderedSet supportedCharsets = new OrderedSet();
            supportedCharsets.addAll(model.getAttributeValues("sun-identity-g11n-settings-locale-charset-mapping"));
            this.populateSupportedCharsetsTable((Set)supportedCharsets);
            OrderedSet charsetAlias = new OrderedSet();
            charsetAlias.addAll(model.getAttributeValues("sun-identity-g11n-settings-charset-alias-mapping"));
            this.populateCharsetAliasTable((Set)charsetAlias);
        }
        if (!this.isInlineAlertMessageSet() && (flag = (String)this.getPageSessionAttribute(PAGE_MODIFIED)) != null && flag.equals("1")) {
            this.setInlineAlertMessage("info", "message.information", "message.profile.modified");
        }
    }

    private void populateSupportedCharsetsTable(Set charsets) {
        this.tablePopulated = true;
        CCActionTableModel tblModel = (CCActionTableModel)this.propertySheetModel.getModel("sun-identity-g11n-settings-locale-charset-mapping");
        tblModel.clearAll();
        boolean firstEntry = true;
        int counter = 0;
        Iterator iter = charsets.iterator();
        while (iter.hasNext()) {
            String c = (String)iter.next();
            LocaleSupportedCharsetsEntry entry = new LocaleSupportedCharsetsEntry(c);
            if (entry.isValid()) {
                if (!firstEntry) {
                    tblModel.appendRow();
                } else {
                    firstEntry = false;
                }
                tblModel.setValue(TBL_SUPPORTED_CHARSETS_DATA_LOCALE, (Object)entry.strLocale);
                tblModel.setValue(TBL_SUPPORTED_CHARSETS_DATA_CHARSETS, (Object)entry.strCharsets);
                tblModel.setValue(TBL_SUPPORTED_CHARSETS_HREF_ACTION, (Object)Integer.toString(counter));
            }
            ++counter;
        }
        this.setPageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping", (Serializable)((OrderedSet)charsets));
    }

    private void populateCharsetAliasTable(Set charsets) {
        this.tablePopulated = true;
        CCActionTableModel tblModel = (CCActionTableModel)this.propertySheetModel.getModel("sun-identity-g11n-settings-charset-alias-mapping");
        tblModel.clearAll();
        boolean firstEntry = true;
        int counter = 0;
        Iterator iter = charsets.iterator();
        while (iter.hasNext()) {
            String c = (String)iter.next();
            CharsetAliasEntry entry = new CharsetAliasEntry(c);
            if (entry.isValid()) {
                if (!firstEntry) {
                    tblModel.appendRow();
                } else {
                    firstEntry = false;
                }
                tblModel.setValue(TBL_CHARSET_ALIAS_DATA_MIMENAME, (Object)entry.strMimeName);
                tblModel.setValue(TBL_CHARSET_ALIAS_DATA_JAVANAME, (Object)entry.strJavaName);
                tblModel.setValue(TBL_CHARSET_ALIAS_HREF_ACTION, (Object)Integer.toString(counter));
            }
            ++counter;
        }
        this.setPageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping", (Serializable)((OrderedSet)charsets));
    }

    protected boolean onBeforeSaveProfile(Map attrValues) {
        Set charsetAlias;
        Set supportedCharsets = (Set)this.getPageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping");
        if (supportedCharsets != null && !supportedCharsets.isEmpty()) {
            attrValues.put("sun-identity-g11n-settings-locale-charset-mapping", supportedCharsets);
        }
        if ((charsetAlias = (Set)this.getPageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping")) != null && !charsetAlias.isEmpty()) {
            attrValues.put("sun-identity-g11n-settings-charset-alias-mapping", charsetAlias);
        }
        return true;
    }

    protected void onBeforeResetProfile() {
        this.removePageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping");
        this.removePageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping");
        this.tablePopulated = false;
    }

    public void handleTblSupportedCharsetsButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        this.setSubmitCycle(true);
        CCActionTable table = (CCActionTable)this.getChild("sun-identity-g11n-settings-locale-charset-mapping");
        table.restoreStateData();
        CCActionTableModel tblModel = (CCActionTableModel)this.propertySheetModel.getModel("sun-identity-g11n-settings-locale-charset-mapping");
        Integer[] selected = tblModel.getSelectedRows();
        if (selected != null && selected.length > 0) {
            OrderedSet tblValues = (OrderedSet)this.getPageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping");
            tblValues.removeAll(selected);
            this.setPageSessionAttribute("sun-identity-g11n-settings-locale-charset-mapping", (Serializable)tblValues);
            this.populateSupportedCharsetsTable((Set)tblValues);
        }
        this.forwardTo();
    }

    public void handleTblSupportedCharsetsButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        try {
            Map values = this.getValues();
            this.onBeforeSaveProfile(values);
            this.setPageSessionAttribute("propertyAttributes", (HashMap)values);
            G11NSupportedCharsetsAddViewBean vb = (G11NSupportedCharsetsAddViewBean)this.getViewBean(G11NSupportedCharsetsAddViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleTblSupportedCharsetsHrefActionRequest(RequestInvocationEvent event) throws ModelControlException {
        try {
            Map values = this.getValues();
            this.onBeforeSaveProfile(values);
            this.setPageSessionAttribute("propertyAttributes", (HashMap)values);
            G11NSupportedCharsetsEditViewBean vb = (G11NSupportedCharsetsEditViewBean)this.getViewBean(G11NSupportedCharsetsEditViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.populateValues((String)this.getDisplayFieldValue(TBL_SUPPORTED_CHARSETS_HREF_ACTION));
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleTblCharsetAliasButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        this.setSubmitCycle(true);
        CCActionTable table = (CCActionTable)this.getChild("sun-identity-g11n-settings-charset-alias-mapping");
        table.restoreStateData();
        CCActionTableModel tblModel = (CCActionTableModel)this.propertySheetModel.getModel("sun-identity-g11n-settings-charset-alias-mapping");
        Integer[] selected = tblModel.getSelectedRows();
        if (selected != null && selected.length > 0) {
            OrderedSet tblValues = (OrderedSet)this.getPageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping");
            tblValues.removeAll(selected);
            this.setPageSessionAttribute("sun-identity-g11n-settings-charset-alias-mapping", (Serializable)tblValues);
            this.populateCharsetAliasTable((Set)tblValues);
        }
        this.forwardTo();
    }

    public void handleTblCharsetAliasButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        try {
            Map values = this.getValues();
            this.onBeforeSaveProfile(values);
            this.setPageSessionAttribute("propertyAttributes", (HashMap)values);
            G11NCharsetAliasAddViewBean vb = (G11NCharsetAliasAddViewBean)this.getViewBean(G11NCharsetAliasAddViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleTblCharsetAliasHrefActionRequest(RequestInvocationEvent event) throws ModelControlException {
        try {
            Map values = this.getValues();
            this.onBeforeSaveProfile(values);
            this.setPageSessionAttribute("propertyAttributes", (HashMap)values);
            G11NCharsetAliasEditViewBean vb = (G11NCharsetAliasEditViewBean)this.getViewBean(G11NCharsetAliasEditViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.populateValues((String)this.getDisplayFieldValue(TBL_CHARSET_ALIAS_HREF_ACTION));
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.removePageSessionAttribute(PAGE_MODIFIED);
        super.handleButton1Request(event);
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.removePageSessionAttribute(PAGE_MODIFIED);
        super.handleButton2Request(event);
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        this.backTrail();
        try {
            String name = (String)this.getPageSessionAttribute("returnToViewBean");
            SCConfigViewBean vb = (SCConfigViewBean)this.getViewBean(Class.forName(name));
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            debug.warning("SMG11NViewBean.handleButton3Request:", (Throwable)e);
        }
    }

    protected String getBreadCrumbDisplayName() {
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        Object[] arg = new String[]{model.getLocalizedServiceName("iPlanetG11NSettings")};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.services.edit"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

