/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.realm.ServicesAddViewBean;
import com.sun.identity.console.realm.ServicesViewBean;
import com.sun.identity.console.realm.model.ServicesModel;
import com.sun.identity.console.realm.model.ServicesModelImpl;
import com.sun.identity.console.service.model.SCUtils;
import com.sun.identity.shared.locale.Locale;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServicesSelectViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/ServicesSelect.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ATTR_SERVICE_LIST = "cbServiceList";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;

    public ServicesSelectViewBean() {
        super("ServicesSelect");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.next");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyRMServicesSelect.xml"));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new ServicesModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.disableButton("button1", true);
        try {
            ServicesModel model = (ServicesModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            Map assignables = model.getAssignableServiceNames(curRealm);
            CCRadioButton rb = (CCRadioButton)this.getChild(ATTR_SERVICE_LIST);
            OptionList optList = AMFormatUtils.getSortedOptionList(assignables, model.getUserLocale());
            rb.setOptions(optList);
            String val = (String)rb.getValue();
            if (val == null || val.length() == 0) {
                rb.setValue((Object)optList.getValue(0));
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        ServicesViewBean vb = (ServicesViewBean)this.getViewBean(ServicesViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        ServicesModel model = (ServicesModel)this.getModel();
        String serviceName = (String)this.getDisplayFieldValue(ATTR_SERVICE_LIST);
        if ((serviceName = serviceName.trim()).length() > 0) {
            SCUtils utils = new SCUtils(serviceName, model);
            String propertiesViewBeanURL = utils.getServiceDisplayURL();
            if (propertiesViewBeanURL != null && propertiesViewBeanURL.trim().length() > 0) {
                String curRealm = (String)this.getPageSessionAttribute("currentRealm");
                if (curRealm == null) {
                    curRealm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
                }
                try {
                    String pageTrailID = (String)this.getPageSessionAttribute("pageTrailID");
                    propertiesViewBeanURL = propertiesViewBeanURL + "?ServiceName=" + serviceName + "&Location=" + Locale.URLEncodeField((String)curRealm, (String)this.getCharset(model)) + "&Template=true&Op=" + "add" + "&" + "pageTrailID" + "=" + pageTrailID;
                    HttpServletResponse response = this.getRequestContext().getResponse();
                    this.backTrail();
                    response.sendRedirect(propertiesViewBeanURL);
                }
                catch (UnsupportedEncodingException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                    this.forwardTo();
                }
                catch (IOException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                    this.forwardTo();
                }
            } else {
                ServicesAddViewBean vb = (ServicesAddViewBean)this.getViewBean(ServicesAddViewBean.class);
                this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
                this.unlockPageTrailForSwapping();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
        } else {
            this.setInlineAlertMessage("error", "message.error", "services.missing.servicename");
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.realm.services.selectService";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

