/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SubConfigPropertyXMLBuilder
extends PropertyXMLBuilderBase {
    private ServiceSchema serviceSchema;

    public SubConfigPropertyXMLBuilder(String serviceName, ServiceSchema serviceSchema, AMModel model) throws SMSException, SSOException {
        this.model = model;
        this.serviceSchema = serviceSchema;
        this.serviceName = serviceName;
        this.svcSchemaManager = new ServiceSchemaManager(serviceName, model.getUserSSOToken());
        this.getServiceResourceBundle();
        if (this.serviceBundle != null) {
            this.mapTypeToAttributeSchema = this.getSubConfigAttributeSchemas();
        }
    }

    private Map getSubConfigAttributeSchemas() throws SMSException, SSOException {
        Set set;
        HashMap<SchemaType, Set> map = new HashMap<SchemaType, Set>();
        Object sectionTitle = mapSchemaTypeToName.get(SchemaType.GLOBAL);
        if (sectionTitle != null && (set = this.getSubConfigAttributeSchema()) != null && !set.isEmpty()) {
            map.put(SchemaType.GLOBAL, set);
        }
        return map;
    }

    private Set getSubConfigAttributeSchema() {
        HashSet<AttributeSchema> results = null;
        Set attributes = this.serviceSchema.getAttributeSchemas();
        if (attributes != null && !attributes.isEmpty()) {
            results = new HashSet<AttributeSchema>(attributes.size() * 2);
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                String i18nKey = as.getI18NKey();
                if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                results.add(as);
            }
        }
        return results != null ? results : Collections.EMPTY_SET;
    }

    public String getXML() throws SMSException, SSOException {
        Set attributeSchema;
        StringBuffer xml = new StringBuffer(1000);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n");
        if (this.supportSubConfig) {
            String configTable = "<section name=\"subconfig\" defaultValue=\"subconfig.section.header\"><property span=\"true\"><cc name=\"tblSubConfig\" tagclass=\"com.sun.web.ui.taglib.table.CCActionTableTag\"><attribute name=\"title\" value=\"services.subconfig.table.title\" /><attribute name=\"empty\" value=\"services.subconfig.table.empty.message\" /><attribute name=\"showPaginationControls\" value=\"false\" /><attribute name=\"selectionType\" value=\"multiple\" /><attribute name=\"showAdvancedSortingIcon\" value=\"false\" /><attribute name=\"showLowerActions\" value=\"false\" /><attribute name=\"showPaginationControls\" value=\"false\" /><attribute name=\"showPaginationIcon\" value=\"false\" /><attribute name=\"showSelectionIcons\" value=\"true\" /><attribute name=\"showSelectionSortIcon\" value=\"false\" /><attribute name=\"showSortingRow\" value=\"true\" /><attribute name=\"selectionJavascript\" value=\"toggleTblButtonState('<viewBean>', '<viewBean>.tblSubConfig', 'tblButton', '<viewBean>.tblSubConfigButtonDelete', this)\" /></cc></property></section>";
            configTable = this.tagSwap(configTable, "<viewBean>", this.viewBeanName);
            xml.append(configTable);
        }
        if ((attributeSchema = (Set)this.mapTypeToAttributeSchema.get(SchemaType.GLOBAL)) != null && !attributeSchema.isEmpty()) {
            String display = this.model.getLocalizedString((String)mapSchemaTypeToName.get(SchemaType.GLOBAL));
            this.buildSchemaTypeXML(display, attributeSchema, xml, this.model, this.serviceBundle, Collections.EMPTY_SET);
        }
        xml.append("</propertysheet>\n");
        return xml.toString();
    }
}

