/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertyXMLBuilder
extends PropertyXMLBuilderBase {
    private Set schemaTypes;

    public PropertyXMLBuilder(String serviceName, Set schemaTypes, AMModel model) throws SMSException, SSOException {
        this.model = model;
        this.schemaTypes = schemaTypes;
        this.serviceName = serviceName;
        this.svcSchemaManager = new ServiceSchemaManager(serviceName, model.getUserSSOToken());
        this.getServiceResourceBundle();
        if (this.serviceBundle != null) {
            this.mapTypeToAttributeSchema = this.getAttributeSchemas(serviceName);
        }
    }

    public PropertyXMLBuilder(ServiceSchema serviceSchema, AMModel model) throws SMSException, SSOException {
        this.model = model;
        this.serviceName = serviceSchema.getServiceName();
        this.getServiceResourceBundle(serviceSchema);
        if (this.serviceBundle != null) {
            this.mapTypeToAttributeSchema = new HashMap();
            this.mapTypeToAttributeSchema.put(serviceSchema.getServiceType(), serviceSchema.getAttributeSchemas());
        }
    }

    public PropertyXMLBuilder(String serviceName, AMModel model, Set attributeSchemas) throws SMSException, SSOException {
        this.model = model;
        this.serviceName = serviceName;
        this.svcSchemaManager = new ServiceSchemaManager(serviceName, model.getUserSSOToken());
        this.getServiceResourceBundle();
        if (this.serviceBundle != null) {
            this.mapTypeToAttributeSchema = new HashMap(attributeSchemas.size() * 2);
            this.mapTypeToAttributeSchema.put("null", attributeSchemas);
        }
    }

    public PropertyXMLBuilder(ServiceSchema serviceSchema, AMModel model, Set attributeSchemas) throws SMSException, SSOException {
        this.model = model;
        this.serviceName = serviceSchema.getServiceName();
        this.getServiceResourceBundle(serviceSchema);
        if (this.serviceBundle != null) {
            this.mapTypeToAttributeSchema = new HashMap(attributeSchemas.size() * 2);
            this.mapTypeToAttributeSchema.put("null", attributeSchemas);
        }
    }

    public String getXML() throws SMSException, SSOException, AMConsoleException {
        return this.getXML(Collections.EMPTY_SET, true);
    }

    public String getXML(String realmName) throws SMSException, SSOException, AMConsoleException {
        this.currentRealm = realmName;
        return this.getXML(Collections.EMPTY_SET, true);
    }

    public String getXML(boolean bPropertySheetElementNode) throws SMSException, SSOException, AMConsoleException {
        return this.getXML(Collections.EMPTY_SET, bPropertySheetElementNode);
    }

    public String getXML(Set readonly) throws SMSException, SSOException, AMConsoleException {
        return this.getXML(readonly, true);
    }

    public String getXML(Set readonly, boolean bPropertySheetElementNode) throws SMSException, SSOException, AMConsoleException {
        StringBuffer xml = new StringBuffer(1000);
        this.onBeforeBuildingXML(this.mapTypeToAttributeSchema);
        if (bPropertySheetElementNode) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n");
        }
        if (this.supportSubConfig) {
            String configTable = "<section name=\"subconfig\" defaultValue=\"subconfig.section.header\"><property span=\"true\"><cc name=\"tblSubConfig\" tagclass=\"com.sun.web.ui.taglib.table.CCActionTableTag\"><attribute name=\"title\" value=\"services.subconfig.table.title\" /><attribute name=\"empty\" value=\"services.subconfig.table.empty.message\" /><attribute name=\"showPaginationControls\" value=\"false\" /><attribute name=\"selectionType\" value=\"multiple\" /><attribute name=\"showAdvancedSortingIcon\" value=\"false\" /><attribute name=\"showLowerActions\" value=\"false\" /><attribute name=\"showPaginationControls\" value=\"false\" /><attribute name=\"showPaginationIcon\" value=\"false\" /><attribute name=\"showSelectionIcons\" value=\"true\" /><attribute name=\"showSelectionSortIcon\" value=\"false\" /><attribute name=\"showSortingRow\" value=\"true\" /><attribute name=\"selectionJavascript\" value=\"toggleTblButtonState('<viewBean>', '<viewBean>.tblSubConfig', 'tblButton', '<viewBean>.tblSubConfigButtonDelete', this)\" /></cc></property></section>";
            configTable = this.tagSwap(configTable, "<viewBean>", this.viewBeanName);
            xml.append(configTable);
        }
        if (!this.supportSubConfig && this.hasNoAttributes()) {
            throw new AMConsoleException(this.model.getLocalizedString("propertysheet.no.attributes.message"));
        }
        Set attributeSchema = (Set)this.mapTypeToAttributeSchema.get("null");
        if (attributeSchema != null && !attributeSchema.isEmpty()) {
            String display = "blank.header";
            this.buildSchemaTypeXML(display, attributeSchema, xml, this.model, this.serviceBundle, readonly);
        }
        Iterator iter = orderDisplaySchemaType.iterator();
        while (iter.hasNext()) {
            SchemaType type = (SchemaType)iter.next();
            attributeSchema = (Set)this.mapTypeToAttributeSchema.get(type);
            if (attributeSchema == null || attributeSchema.isEmpty()) continue;
            String display = this.model.getLocalizedString((String)mapSchemaTypeToName.get(type));
            this.buildSchemaTypeXML(display, attributeSchema, xml, this.model, this.serviceBundle, readonly);
        }
        if (bPropertySheetElementNode) {
            xml.append("</propertysheet>\n");
        }
        return xml.toString();
    }

    private boolean hasNoAttributes() {
        boolean no = true;
        if (this.mapTypeToAttributeSchema != null && !this.mapTypeToAttributeSchema.isEmpty()) {
            Iterator i = this.mapTypeToAttributeSchema.keySet().iterator();
            while (i.hasNext() && no) {
                Set set = (Set)this.mapTypeToAttributeSchema.get(i.next());
                no = set == null || set.isEmpty();
            }
        }
        return no;
    }

    private Map getAttributeSchemas(String serviceName) throws SMSException, SSOException {
        HashMap<SchemaType, Set> map = new HashMap<SchemaType, Set>();
        if (this.schemaTypes == null) {
            this.schemaTypes = this.svcSchemaManager.getSchemaTypes();
        }
        Iterator iter = this.schemaTypes.iterator();
        while (iter.hasNext()) {
            Set set;
            SchemaType type = (SchemaType)iter.next();
            Object sectionTitle = mapSchemaTypeToName.get(type);
            if (sectionTitle == null || (set = this.getAttributeSchemas(type)) == null || set.isEmpty()) continue;
            map.put(type, set);
        }
        return map;
    }

    private Set getAttributeSchemas(SchemaType type) throws SMSException {
        Set attributes;
        HashSet<AttributeSchema> results = null;
        ServiceSchema schema = this.svcSchemaManager.getSchema(type);
        if (schema != null && (attributes = schema.getAttributeSchemas()) != null && !attributes.isEmpty()) {
            results = new HashSet<AttributeSchema>(attributes.size() * 2);
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                String i18nKey = as.getI18NKey();
                if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                results.add(as);
            }
        }
        return results;
    }

    protected void onBeforeBuildingXML(Map map) {
    }

    public void discardAttribute(Set discard) {
        Iterator i = this.mapTypeToAttributeSchema.keySet().iterator();
        while (i.hasNext()) {
            SchemaType type = (SchemaType)i.next();
            Set attributeSchema = (Set)this.mapTypeToAttributeSchema.get(type);
            if (attributeSchema == null || attributeSchema.isEmpty()) continue;
            Iterator j = attributeSchema.iterator();
            while (j.hasNext()) {
                AttributeSchema as = (AttributeSchema)j.next();
                if (!discard.contains(as.getName())) continue;
                j.remove();
            }
        }
    }
}

