/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.console.authentication.model.AuthConfigurationModelImpl;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthToServiceHelper {
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    public static final String ATTR_FILTER = "tfSearch";
    public static final String ATTR_REALM = "Realm";
    public static final String ATTR_SERVICE = "AuthenticateToService";
    private static AuthToServiceHelper instance = new AuthToServiceHelper();

    private AuthToServiceHelper() {
    }

    public static AuthToServiceHelper getInstance() {
        return instance;
    }

    public void setPropertiesValues(Map values, AMPropertySheetModel propertySheetModel) {
        String propName;
        Set val;
        if (values != null && !values.isEmpty() && (val = (Set)values.get(propName = (String)values.keySet().iterator().next())) != null && !val.isEmpty() && propName.equals(ATTR_SERVICE)) {
            String str = (String)val.iterator().next();
            propertySheetModel.setValue(ATTR_REALM, AMAuthUtils.getRealmFromRealmQualifiedData(str));
            propertySheetModel.setValue(ATTR_SERVICE, AMAuthUtils.getDataFromRealmQualifiedData(str));
        }
    }

    public Map getConditionValues(PolicyModel model, AMPropertySheetModel propertySheetModel) throws AMConsoleException {
        String realmValue = (String)propertySheetModel.getValue(ATTR_REALM);
        String service = (String)propertySheetModel.getValue(ATTR_SERVICE);
        if (service == null || service.length() == 0) {
            throw new AMConsoleException(model.getLocalizedString("policy.condition.missing.auth.service"));
        }
        HashSet<String> set = new HashSet<String>(2);
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>(2);
        set.add(AMAuthUtils.toRealmQualifiedAuthnData(realmValue, service));
        map.put(ATTR_SERVICE, set);
        return map;
    }

    public Set getRealmNames(String filter, PolicyModel model) throws AMConsoleException {
        filter = filter == null || filter.length() == 0 ? (filter = "*") : filter.trim();
        return model.getRealmNames("/", filter);
    }

    public Set getAssignedServiceNamesInRealm(String base, PolicyModel model) throws AMConsoleException {
        return AuthConfigurationModelImpl.getNamedConfigurations(adminSSOToken, base);
    }
}

