/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.idm.model.BackwardCompSupport;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.RequiredValueValidator;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class EntitiesModelImpl
extends AMModelBase
implements EntitiesModel {
    private static final String AGENT_ATTRIBUTE_LIST = "sunIdentityServerDeviceKeyValue";
    private static final String RADIO_AGENT_TYPE = "rbAgentType";
    private static final String RADIO_AGENT_TYPE_GENERIC = "generic";
    private static final String RADIO_AGENT_TYPE_WSC = "wsc";
    private static final String RADIO_AGENT_TYPE_WSP = "wsp";
    private static boolean isWSSEnabled = false;
    private boolean endUser = false;
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();
    private static RequiredValueValidator reqValidator = new RequiredValueValidator();
    private Map requiredAttributeNames = new HashMap();
    private String type = null;

    public EntitiesModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        this.type = (String)map.get("entityTypeName");
    }

    public String getEntityType() {
        return this.type;
    }

    public void setEndUser(boolean endUser) {
        this.endUser = endUser;
    }

    public IdSearchResults getEntityNames(String realmName, String strType, String pattern) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("EntitiesModelImpl.getEntityNames\n\tsearching for: " + strType + " in " + realmName + " matching " + pattern);
        }
        if (realmName == null) {
            realmName = "/";
        }
        int sizeLimit = this.getSearchResultLimit();
        int timeLimit = this.getSearchTimeOutLimit();
        String[] params = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit)};
        try {
            IdSearchControl idsc = new IdSearchControl();
            idsc.setMaxResults(sizeLimit);
            idsc.setTimeOut(timeLimit);
            idsc.setAllReturnAttributes(false);
            IdType type = IdUtils.getType(strType);
            if (type.equals(IdType.USER) && !pattern.equals("*")) {
                HashMap searchMap = new HashMap(2);
                HashSet<String> patternSet = new HashSet<String>(2);
                patternSet.add(pattern);
                searchMap.put(this.getUserSearchAttribute(), patternSet);
                idsc.setSearchModifiers(IdSearchOpModifier.OR, searchMap);
                pattern = "*";
            }
            this.logEvent("ATTEMPT_SEARCH_IDENTITY", params);
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            IdSearchResults results = repo.searchIdentities(type, pattern, idsc);
            this.logEvent("SUCCEED_SEARCH_IDENTITY", params);
            return results;
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_SEARCH_IDENTITY", paramsEx);
            if (debug.warningEnabled()) {
                debug.warning("EntitiesModelImpl.getEntityNames " + this.getErrorString(e));
            }
            throw new AMConsoleException("no.properties");
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_SEARCH_IDENTITY", paramsEx);
            debug.warning("EntitiesModelImpl.getEntityNames ", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Map getAttributeValues(String universalId, boolean bCreate) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("EntitiesModel.getAttributeValues for " + universalId);
        }
        String[] param = new String[]{universalId, "*"};
        this.logEvent("ATTEMPT_READ_IDENTITY_ATTRIBUTE_VALUE", param);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            CaseInsensitiveHashMap tempMap = new CaseInsensitiveHashMap();
            tempMap.putAll(amid.getAttributes());
            this.validateUserStatusEntry(tempMap);
            HashMap<String, Set<Object>> values = new HashMap<String, Set<Object>>();
            Set attributeSchemas = this.getAttributeSchemas(amid.getType().getName(), bCreate);
            HashSet<String> attributeNames = new HashSet<String>();
            Iterator<Object> iter = attributeSchemas.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                String name = as.getName();
                if (!tempMap.containsKey(name)) {
                    values.put(name, Collections.EMPTY_SET);
                } else {
                    values.put(name, (Set<Object>)tempMap.get(name));
                }
                attributeNames.add(name);
            }
            iter = values.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (attributeNames.contains(name)) continue;
                iter.remove();
            }
            this.logEvent("SUCCEED_READ_IDENTITY_ATTRIBUTE_VALUE", param);
            if (debug.messageEnabled()) {
                debug.message("returning " + values);
            }
            return values;
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, "*", this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            debug.warning("EntitiesModelImpl.getAttributeValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{universalId, "*", this.getErrorString(e)};
            this.logEvent("SMS_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            debug.warning("EntitiesModelImpl.getAttributeValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, "*", this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            debug.warning("EntitiesModelImpl.getAttributeValues", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getPropertyXMLString(String realmName, String idType, boolean bCreate, String viewbeanClassName) throws AMConsoleException {
        String xmlFile;
        this.setLocationDN(realmName);
        String xml = null;
        try {
            Set attributeSchemas = this.getAttributeSchemas(idType, bCreate);
            String serviceName = this.getSvcNameForIdType(idType);
            if (serviceName != null) {
                DelegationConfig dConfig;
                PropertyXMLBuilder builder = new PropertyXMLBuilder(serviceName, (AMModel)this, attributeSchemas);
                this.cacheAttributeValidators(attributeSchemas);
                if (!bCreate && !(dConfig = DelegationConfig.getInstance()).hasPermission(realmName, null, "MODIFY", this, viewbeanClassName)) {
                    builder.setAllAttributeReadOnly(true);
                }
                xml = builder.getXML();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("EntitiesModelImpl.getPropertyXMLString", (Throwable)e);
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getPropertyXMLString", (Throwable)e);
        }
        catch (SMSException e) {
            debug.warning("EntitiesModelImpl.getPropertyXMLString", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.getPropertyXMLString", (Throwable)((Object)e));
        }
        if (bCreate) {
            xmlFile = isWSSEnabled && idType.equalsIgnoreCase("agent") ? "com/sun/identity/console/propertyEntitiesAddAgentType.xml" : "com/sun/identity/console/propertyEntitiesAdd.xml";
            String header = AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xmlFile));
            xml = xml != null ? PropertyXMLBuilder.prependXMLProperty(xml, header) : PropertyXMLBuilder.formPropertySheetXML(header);
        } else {
            xmlFile = "com/sun/identity/console/propertyEntitiesEdit.xml";
            String extra = AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xmlFile));
            xml = xml != null ? PropertyXMLBuilder.appendXMLProperty(xml, extra) : PropertyXMLBuilder.formPropertySheetXML(extra, true);
        }
        return xml;
    }

    private void cacheAttributeValidators(Set attributeSchemas) {
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            Iterator iter = attributeSchemas.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                if (!this.isRequiredAttribute(as)) continue;
                this.requiredAttributeNames.put(as.getName(), as);
            }
        }
    }

    private boolean isRequiredAttribute(AttributeSchema as) {
        boolean isReqd = false;
        String any = as.getAny();
        if (any != null && any.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(any, "|");
            while (st.hasMoreTokens() && !isReqd) {
                String token = st.nextToken();
                isReqd = token.equals("required");
            }
        }
        return isReqd;
    }

    public Map getDefaultAttributeValues(String idType, boolean bCreate) throws AMConsoleException {
        try {
            Set attributeSchemas = this.getAttributeSchemas(idType, bCreate);
            HashMap<String, Set> values = new HashMap<String, Set>(attributeSchemas.size() * 2);
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                values.put(as.getName(), as.getDefaultValues());
            }
            if (isWSSEnabled && bCreate && idType.equalsIgnoreCase("agent")) {
                HashSet<String> set = new HashSet<String>(2);
                set.add(RADIO_AGENT_TYPE_GENERIC);
                values.put(RADIO_AGENT_TYPE, set);
            }
            return values;
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getDefaultAttributeValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            debug.warning("EntitiesModelImpl.getDefaultAttributeValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.getDefaultAttributeValues", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    private Set getAttributeSchemas(String idType, boolean bCreate) throws SMSException, SSOException, IdRepoException {
        Set attributeSchemas = null;
        String serviceName = this.getSvcNameForIdType(idType);
        if (serviceName != null) {
            String[] show;
            Set any;
            AttributeSchema as;
            Iterator i;
            ServiceSchemaManager svcSchemaMgr = new ServiceSchemaManager(serviceName, this.getUserSSOToken());
            ServiceSchema svcSchema = svcSchemaMgr.getSchema(idType);
            attributeSchemas = svcSchema != null ? svcSchema.getAttributeSchemas() : Collections.EMPTY_SET;
            if (bCreate) {
                i = attributeSchemas.iterator();
                while (i.hasNext()) {
                    as = (AttributeSchema)i.next();
                    any = AMAdminUtils.getDelimitedValues(as.getAny(), "|");
                    if (any.contains("required") || any.contains("optional")) continue;
                    i.remove();
                }
            }
            if (this.endUser) {
                i = attributeSchemas.iterator();
                while (i.hasNext()) {
                    as = (AttributeSchema)i.next();
                    any = AMAdminUtils.getDelimitedValues(as.getAny(), "|");
                    if (!any.contains("adminDisplay")) continue;
                    i.remove();
                }
            }
            if (bCreate) {
                show = new String[]{"required", "optional"};
                PropertyXMLBuilder.filterAttributes(attributeSchemas, show);
                this.beforeDisplay(idType, attributeSchemas);
            } else {
                show = new String[]{"display", "adminDisplay"};
                PropertyXMLBuilder.filterAttributes(attributeSchemas, show);
            }
        }
        return attributeSchemas != null ? attributeSchemas : Collections.EMPTY_SET;
    }

    public void createEntity(String realmName, String entityName, String idType, Map values) throws AMConsoleException {
        if (entityName.trim().length() == 0) {
            String msg = this.getLocalizedString("entities.missing.entityName");
            Object[] param = new String[]{this.getLocalizedString(idType)};
            throw new AMConsoleException(MessageFormat.format(msg, param));
        }
        if (realmName == null) {
            realmName = "/";
        }
        this.validateAttributes(values);
        this.setAgentDefaultValues(values);
        try {
            String[] params = new String[]{entityName, idType, realmName};
            this.logEvent("ATTEMPT_IDENTITY_CREATION", params);
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            this.beforeCreate(idType, entityName, values);
            repo.createIdentity(IdUtils.getType(idType), entityName, values);
            this.logEvent("IDENTITY_CREATED", params);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] params = new String[]{entityName, idType, realmName, strError};
            this.logEvent("IDM_EXCEPTION_IDENTITY_CREATION", params);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] params = new String[]{entityName, idType, realmName, strError};
            this.logEvent("SSO_EXCEPTION_IDENTITY_CREATION", params);
            throw new AMConsoleException(strError);
        }
    }

    private void setAgentDefaultValues(Map values) throws AMConsoleException {
        Set setAgentType = (Set)values.get(RADIO_AGENT_TYPE);
        if (setAgentType != null && !setAgentType.isEmpty()) {
            String agentType = (String)setAgentType.iterator().next();
            if (agentType.equals(RADIO_AGENT_TYPE_WSC)) {
                HashSet<String> agentValues = new HashSet<String>(6);
                agentValues.add("SecurityMech=urn:sun:wss:security:null:Anonymous");
                agentValues.add("useDefaultStore=true");
                agentValues.add("Type=wsc");
                values.put(AGENT_ATTRIBUTE_LIST, agentValues);
            } else if (agentType.equals(RADIO_AGENT_TYPE_WSP)) {
                try {
                    Class<?> clazz = Class.forName("com.sun.identity.wss.security.SecurityMechanism");
                    Method mtd = clazz.getDeclaredMethod("getAllWSPSecurityMechanisms", null);
                    Method mtdGetURI = clazz.getDeclaredMethod("getURI", null);
                    List securityMech = (List)mtd.invoke(null, null);
                    StringBuffer securityMechStr = new StringBuffer();
                    boolean first = true;
                    Iterator i = securityMech.iterator();
                    while (i.hasNext()) {
                        Object mech = i.next();
                        if (first) {
                            first = false;
                        } else {
                            securityMechStr.append(",");
                        }
                        securityMechStr.append((String)mtdGetURI.invoke(mech, null));
                    }
                    HashSet<String> agentValues = new HashSet<String>(6);
                    agentValues.add("SecurityMech=" + securityMechStr);
                    agentValues.add("useDefaultStore=true");
                    agentValues.add("Type=wsp");
                    values.put(AGENT_ATTRIBUTE_LIST, agentValues);
                }
                catch (ClassNotFoundException e) {
                    throw new AMConsoleException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new AMConsoleException(e);
                }
                catch (IllegalAccessException e) {
                    throw new AMConsoleException(e);
                }
                catch (InvocationTargetException e) {
                    throw new AMConsoleException(e);
                }
            }
            values.remove(RADIO_AGENT_TYPE);
        }
    }

    public void modifyEntity(String realmName, String universalId, Map values) throws AMConsoleException {
        if (values != null && !values.isEmpty()) {
            this.validateAttributes(values);
            String attrNames = AMAdminUtils.getString(values.keySet(), ",", false);
            String[] param = new String[]{universalId, attrNames};
            try {
                this.logEvent("ATTEMPT_MODIFY_IDENTITY_ATTRIBUTE_VALUE", param);
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
                String entityName = amid.getName();
                String idType = amid.getType().getName();
                if (amid.getType().equals(IdType.AGENT) && values.containsKey(AGENT_ATTRIBUTE_LIST) && amid.getAttribute(AGENT_ATTRIBUTE_LIST) != null) {
                    Set newDeviceKeyValue = (Set)values.get(AGENT_ATTRIBUTE_LIST);
                    Set origDeviceKeyValue = amid.getAttribute(AGENT_ATTRIBUTE_LIST);
                    Iterator items = origDeviceKeyValue.iterator();
                    while (items.hasNext()) {
                        String olValue = (String)items.next();
                        String[] olValues = olValue.split("=");
                        boolean found = false;
                        Iterator nt = newDeviceKeyValue.iterator();
                        while (nt.hasNext()) {
                            String ntValue = (String)nt.next();
                            String[] ntValues = ntValue.split("=");
                            if (!ntValues[0].equalsIgnoreCase(olValues[0])) continue;
                            if (ntValues.length > 1 && ntValues[1].trim().length() == 0) {
                                nt.remove();
                            }
                            found = true;
                            break;
                        }
                        if (found) continue;
                        newDeviceKeyValue.add(olValue);
                    }
                }
                this.beforeModify(idType, entityName, values);
                amid.setAttributes(values);
                amid.store();
                this.logEvent("SUCCEED_MODIFY_IDENTITY_ATTRIBUTE_VALUE", param);
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{universalId, attrNames, this.getErrorString(e)};
                this.logEvent("IDM_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
                throw new AMConsoleException(this.getErrorString(e));
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{universalId, attrNames, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("SSO_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
        }
    }

    private void validateAttributes(Map values) throws AMConsoleException {
        Iterator iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            if (!this.requiredAttributeNames.keySet().contains(attrName) || reqValidator.validate((Set)values.get(attrName))) continue;
            AttributeSchema as = (AttributeSchema)this.requiredAttributeNames.get(attrName);
            String serviceName = as.getServiceSchema().getServiceName();
            String expMsg = this.getLocalizedString("entity-values-missing");
            ResourceBundle rb = this.getServiceResourceBundle(serviceName);
            Object[] arg = new String[]{Locale.getString((ResourceBundle)rb, (String)as.getI18NKey(), (Debug)debug)};
            throw new AMConsoleException(MessageFormat.format(expMsg, arg));
        }
    }

    public void deleteEntities(String realmName, Set names) throws AMConsoleException {
        if (names != null && !names.isEmpty()) {
            String idNames = AMFormatUtils.toCommaSeparatedFormat(names);
            String[] params = new String[]{realmName, idNames};
            this.logEvent("ATTEMPT_DELETE_IDENTITY", params);
            try {
                AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
                repo.deleteIdentities(this.getAMIdentity(names));
                this.logEvent("SUCCEED_DELETE_IDENTITY", params);
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString(e)};
                this.logEvent("IDM_EXCEPTION_DELETE_IDENTITY", paramsEx);
                throw new AMConsoleException(this.getErrorString(e));
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("SSO_EXCEPTION_DELETE_IDENTITY", paramsEx);
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
        }
    }

    public boolean canAssignService(String realmName, String idType) {
        boolean can = false;
        try {
            AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realmName);
            Set allowedOperations = repo.getAllowedIdOperations(IdUtils.getType(idType));
            can = allowedOperations.contains(IdOperation.SERVICE);
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.canAssignService", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.canAssignService", (Throwable)((Object)e));
        }
        return can;
    }

    public Set getIdTypeMemberOf(String realmName, String idType) throws AMConsoleException {
        try {
            IdType type = IdUtils.getType(idType);
            HashSet memberOfs = new HashSet();
            memberOfs.addAll(type.canBeMemberOf());
            this.discardUnsupportedIdType(realmName, memberOfs);
            Iterator i = memberOfs.iterator();
            while (i.hasNext()) {
                IdType t = (IdType)i.next();
                Set canAdd = t.canAddMembers();
                if (canAdd.contains(type)) continue;
                i.remove();
            }
            return memberOfs;
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getIdTypeMemberOf", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Set getIdTypeBeMemberOf(String realmName, String idType) throws AMConsoleException {
        try {
            IdType type = IdUtils.getType(idType);
            HashSet beMemberOfs = new HashSet();
            beMemberOfs.addAll(type.canHaveMembers());
            this.discardUnsupportedIdType(realmName, beMemberOfs);
            return beMemberOfs;
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getIdTypeBeMemberOf", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public boolean canAddMember(String realmName, String idType, String containerIDType) throws AMConsoleException {
        boolean can = false;
        try {
            IdType type = IdUtils.getType(idType);
            Set canAdd = type.canAddMembers();
            IdType ctype = IdUtils.getType(containerIDType);
            can = canAdd.contains(ctype);
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.canAddMember", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return can;
    }

    private void discardUnsupportedIdType(String realmName, Set set) {
        if (set != null && !set.isEmpty()) {
            Set supported = this.getSupportedEntityTypes(realmName).keySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                IdType type = (IdType)iter.next();
                if (supported.contains(type.getName())) continue;
                iter.remove();
            }
        }
    }

    private Set getAMIdentity(Set names) throws IdRepoException {
        HashSet<AMIdentity> identities = new HashSet<AMIdentity>(names.size() * 2);
        SSOToken ssoToken = this.getUserSSOToken();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            identities.add(IdUtils.getIdentity(ssoToken, (String)iter.next()));
        }
        return identities;
    }

    public String getServiceNameForIdType(String idType) {
        String serviceName = null;
        try {
            serviceName = this.getSvcNameForIdType(idType);
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getServiceNameForIdType", (Throwable)e);
        }
        return serviceName;
    }

    private String getSvcNameForIdType(String idType) throws IdRepoException {
        String serviceName = IdUtils.getServiceName(IdUtils.getType(idType));
        if ((serviceName == null || serviceName.trim().length() == 0) && ServiceManager.isCoexistenceMode()) {
            BackwardCompSupport support = BackwardCompSupport.getInstance();
            serviceName = support.getServiceName(idType);
        }
        return serviceName;
    }

    private void beforeDisplay(String idType, Set attributeSchemas) throws IdRepoException {
        BackwardCompSupport support = BackwardCompSupport.getInstance();
        support.beforeDisplay(idType, attributeSchemas);
    }

    private void beforeModify(String idType, String entityName, Map values) throws IdRepoException {
    }

    private void beforeCreate(String idType, String entityName, Map values) throws IdRepoException {
        BackwardCompSupport support = BackwardCompSupport.getInstance();
        support.beforeCreate(idType, entityName, values);
    }

    public Set getMembership(String realmName, String universalId, String type) throws AMConsoleException {
        String[] params = new String[]{universalId, type};
        this.logEvent("ATTEMPT_READ_IDENTITY_MEMBERSHIP", params);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set results = amid.getMemberships(IdUtils.getType(type));
            this.logEvent("SUCCEED_READ_IDENTITY_MEMBERSHIP", params);
            return results;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_MEMBERSHIP", paramsEx);
            debug.warning("EntitiesModelImpl.getMembership", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, type, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_MEMBERSHIP", paramsEx);
            debug.warning("EntitiesModelImpl.getMembership", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Set getMembers(String realmName, String universalId, String type) throws AMConsoleException {
        String[] params = new String[]{universalId, type};
        this.logEvent("ATTEMPT_READ_IDENTITY_MEMBER", params);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set results = amid.getMembers(IdUtils.getType(type));
            this.logEvent("SUCCEED_READ_IDENTITY_MEMBER", params);
            return results;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.getMembers", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, type, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.getMembers", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void addMemberships(String universalId, Set membership) throws AMConsoleException {
        if (membership == null || membership.isEmpty()) {
            throw new AMConsoleException("entities.membership.add.no.selection.message");
        }
        SSOToken ssoToken = this.getUserSSOToken();
        String currentId = "";
        try {
            AMIdentity amid = IdUtils.getIdentity(ssoToken, universalId);
            String[] params = new String[2];
            params[1] = universalId;
            Iterator iter = membership.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AMIdentity amidentity = IdUtils.getIdentity(ssoToken, id);
                currentId = id;
                params[0] = id;
                this.logEvent("ATTEMPT_ADD_IDENTITY_MEMBER", params);
                amidentity.addMember(amid);
                this.logEvent("SUCCEED_ADD_IDENTITY_MEMBER", params);
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{currentId, universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_ADD_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.addMemberships", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{currentId, universalId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_ADD_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.addMemberships", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void addMembers(String universalId, Set names) throws AMConsoleException {
        if (names == null || names.isEmpty()) {
            throw new AMConsoleException("entities.members.add.no.selection.message");
        }
        SSOToken ssoToken = this.getUserSSOToken();
        String currentId = "";
        try {
            AMIdentity amid = IdUtils.getIdentity(ssoToken, universalId);
            String[] params = new String[2];
            params[0] = universalId;
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AMIdentity amidentity = IdUtils.getIdentity(ssoToken, id);
                currentId = id;
                params[1] = id;
                this.logEvent("ATTEMPT_ADD_IDENTITY_MEMBER", params);
                amid.addMember(amidentity);
                this.logEvent("SUCCEED_ADD_IDENTITY_MEMBER", params);
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, currentId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_ADD_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.addMembers", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, currentId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_ADD_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.addMembers", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void removeMemberships(String universalId, Set membership) throws AMConsoleException {
        if (membership == null || membership.isEmpty()) {
            throw new AMConsoleException("entities.membership.remove.no.selection.message");
        }
        SSOToken ssoToken = this.getUserSSOToken();
        String currentId = "";
        try {
            AMIdentity amid = IdUtils.getIdentity(ssoToken, universalId);
            String[] params = new String[2];
            params[1] = universalId;
            Iterator iter = membership.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AMIdentity amidentity = IdUtils.getIdentity(ssoToken, id);
                currentId = id;
                params[0] = id;
                this.logEvent("ATTEMPT_REMOVE_IDENTITY_MEMBER", params);
                amidentity.removeMember(amid);
                this.logEvent("SUCCEED_REMOVE_IDENTITY_MEMBER", params);
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{currentId, universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_REMOVE_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.removeMemberships", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{currentId, universalId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_REMOVE_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.removeMemberships", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void removeMembers(String universalId, Set names) throws AMConsoleException {
        if (names == null || names.isEmpty()) {
            throw new AMConsoleException("entities.members.remove.no.selection.message");
        }
        SSOToken ssoToken = this.getUserSSOToken();
        String currentId = "";
        try {
            AMIdentity amid = IdUtils.getIdentity(ssoToken, universalId);
            String[] params = new String[2];
            params[0] = universalId;
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AMIdentity amidentity = IdUtils.getIdentity(ssoToken, id);
                currentId = id;
                params[1] = id;
                this.logEvent("ATTEMPT_REMOVE_IDENTITY_MEMBER", params);
                amid.removeMember(amidentity);
                this.logEvent("SUCCEED_REMOVE_IDENTITY_MEMBER", params);
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, currentId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_REMOVE_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.removeMembers", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, currentId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_REMOVE_IDENTITY_MEMBER", paramsEx);
            debug.warning("EntitiesModelImpl.removeMembers", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Set getAssignedMemberships(String universalId, Set memberships) throws AMConsoleException {
        HashSet<AMIdentity> assigned = new HashSet<AMIdentity>(memberships.size() * 2);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Iterator iter = memberships.iterator();
            while (iter.hasNext()) {
                AMIdentity m = (AMIdentity)iter.next();
                if (!amid.isMember(m)) continue;
                assigned.add(m);
            }
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.getAssignedMemberships", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getAssignedMemberships", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return assigned;
    }

    public Set getAssignedMembers(String universalId, Set members) throws AMConsoleException {
        HashSet<AMIdentity> assigned = new HashSet<AMIdentity>(members.size() * 2);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                AMIdentity m = (AMIdentity)iter.next();
                if (!m.isMember(amid)) continue;
                assigned.add(m);
            }
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.getAssignedMembers", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            debug.warning("EntitiesModelImpl.getAssignedMembers", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return assigned;
    }

    public Map getAssignedServiceNames(String universalId) throws AMConsoleException {
        Map assigned = null;
        String[] param = new String[]{universalId};
        this.logEvent("ATTEMPT_READ_IDENTITY_ASSIGNED_SERVICE", param);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set serviceNames = amid.getAssignedServices();
            IdType type = amid.getType();
            if (type.equals(IdType.USER)) {
                serviceNames.remove("iPlanetAMUserService");
                serviceNames.remove("iPlanetAMAuthConfiguration");
            }
            assigned = this.getLocalizedServiceNames(serviceNames);
            this.logEvent("SUCCEED_READ_IDENTITY_ASSIGNED_SERVICE", param);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ASSIGNED_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.getAssignedServiceNames", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ASSIGNED_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.getAssignedServiceNames", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return assigned != null ? assigned : Collections.EMPTY_MAP;
    }

    public Map getAssignableServiceNames(String universalId) throws AMConsoleException {
        Map assignable = null;
        String[] param = new String[]{universalId};
        this.logEvent("ATTEMPT_READ_IDENTITY_ASSIGNABLE_SERVICE", param);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set serviceNames = amid.getAssignableServices();
            IdType type = amid.getType();
            if (type.equals(IdType.USER)) {
                serviceNames.remove("iPlanetAMUserService");
                serviceNames.remove("iPlanetAMAuthConfiguration");
                serviceNames.remove("iPlanetAMSAMLService");
            }
            this.discardServicesWithoutAttributeSchema(serviceNames, amid);
            assignable = this.getLocalizedServiceNames(serviceNames);
            this.logEvent("SUCCEED_READ_IDENTITY_ASSIGNABLE_SERVICE", param);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ASSIGNABLE_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.getAssignableServiceNames", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ASSIGNABLE_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.getAssignableServiceNames", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return assignable != null ? assignable : Collections.EMPTY_MAP;
    }

    private void discardServicesWithoutAttributeSchema(Set serviceNames, AMIdentity amid) {
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            String url = this.getServicePropertiesViewBeanURL(serviceName);
            if (url != null) continue;
            ServiceSchema serviceSchema = AMAdminUtils.getSchemaSchema(serviceName, amid.getType());
            Set attributes = serviceSchema.getAttributeSchemas();
            if (attributes == null || attributes.isEmpty()) {
                iter.remove();
                continue;
            }
            if (this.hasI18nKeys(attributes)) continue;
            iter.remove();
        }
    }

    private boolean hasI18nKeys(Set attributeSchemes) {
        boolean has = false;
        Iterator i = attributeSchemes.iterator();
        while (i.hasNext() && !has) {
            AttributeSchema as = (AttributeSchema)i.next();
            String i18nKey = as.getI18NKey();
            has = i18nKey != null && i18nKey.length() > 0;
        }
        return has;
    }

    private Map getLocalizedServiceNames(Set serviceNames) {
        HashMap<String, String> localized = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            localized = new HashMap<String, String>(serviceNames.size() * 2);
            Iterator i = serviceNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String lname = this.getLocalizedServiceName(name);
                if (lname.equals(name)) continue;
                localized.put(name, lname);
            }
        }
        return localized == null ? Collections.EMPTY_MAP : localized;
    }

    public String getServicePropertySheetXML(String realmName, String serviceName, IdType idType, boolean bCreate, String viewbeanClassName) throws AMConsoleException {
        this.setLocationDN(realmName);
        DelegationConfig dConfig = DelegationConfig.getInstance();
        try {
            boolean canModify;
            ServiceSchema serviceSchema = AMAdminUtils.getSchemaSchema(serviceName, idType);
            HashSet<SchemaType> set = new HashSet<SchemaType>(2);
            set.add(serviceSchema.getServiceType());
            PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(serviceName, set, this);
            if (!bCreate && !(canModify = dConfig.hasPermission(realmName, serviceName, "MODIFY", this, viewbeanClassName))) {
                xmlBuilder.setAllAttributeReadOnly(true);
            }
            return xmlBuilder.getXML();
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public void assignService(String universalId, String serviceName, Map values) throws AMConsoleException {
        try {
            String[] params = new String[]{universalId, serviceName};
            this.logEvent("ATTEMPT_IDENTITY_ASSIGN_SERVICE", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            amid.assignService(serviceName, values);
            this.logEvent("SUCCEED_IDENTITY_ASSIGN_SERVICE", params);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_IDENTITY_ASSIGN_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.assignService", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            debug.error("EntitiesModelImpl.assignService", (Throwable)e);
            String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_IDENTITY_ASSIGN_SERVICE", paramsEx);
            debug.warning("EntitiesModelImpl.assignService", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getDefaultValues(String idType, String serviceName) throws AMConsoleException {
        HashMap<String, Set> map = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.getUserSSOToken());
            ServiceSchema svcSchema = mgr.getSchema(idType);
            ServiceSchema schema = mgr.getSchema(svcSchema.getServiceType());
            Set attributeSchemas = schema.getAttributeSchemas();
            map = new HashMap<String, Set>(attributeSchemas.size() * 2);
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                String i18nKey = as.getI18NKey();
                if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                Set values = as.getDefaultValues();
                if (values != null && !values.isEmpty()) {
                    map.put(as.getName(), values);
                    continue;
                }
                map.put(as.getName(), Collections.EMPTY_SET);
            }
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public void unassignServices(String universalId, Set serviceNames) throws AMConsoleException {
        if (serviceNames != null && !serviceNames.isEmpty()) {
            String[] params = new String[2];
            params[0] = universalId;
            String currentSvc = "";
            try {
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
                Iterator iter = serviceNames.iterator();
                while (iter.hasNext()) {
                    params[1] = currentSvc = (String)iter.next();
                    this.logEvent("ATTEMPT_IDENTITY_UNASSIGN_SERVICE", params);
                    amid.unassignService(currentSvc);
                    this.logEvent("SUCCEED_IDENTITY_UNASSIGN_SERVICE", params);
                }
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{universalId, currentSvc, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("SSO_EXCEPTION_IDENTITY_UNASSIGN_SERVICE", paramsEx);
                debug.warning("EntitiesModelImpl.unassignServices", (Throwable)((Object)e));
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{universalId, currentSvc, this.getErrorString(e)};
                this.logEvent("IDM_EXCEPTION_IDENTITY_UNASSIGN_SERVICE", paramsEx);
                debug.warning("EntitiesModelImpl.unassignServices", (Throwable)e);
                throw new AMConsoleException(this.getErrorString(e));
            }
        }
    }

    public String getPropertiesViewBean(String name) {
        String url = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(name, adminSSOToken);
            ServiceSchema schema = mgr.getSchema(SchemaType.USER);
            Set attributeSchemas = schema.getAttributeSchemas();
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext() && url == null) {
                AttributeSchema as = (AttributeSchema)i.next();
                if (!as.getName().equals(name)) continue;
                url = as.getPropertiesViewBeanURL();
            }
        }
        catch (SMSException e) {
            debug.warning("EntitiesModelImpl.getDefaultValues", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.getDefaultValues", (Throwable)((Object)e));
        }
        return url;
    }

    public Map getServiceAttributeValues(String universalId, String serviceName) throws AMConsoleException {
        Map values = null;
        try {
            String[] params = new String[]{universalId, serviceName};
            this.logEvent("ATTEMPT_IDENTITY_READ_SERVICE_ATTRIBUTE_VALUES", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            values = amid.getServiceAttributes(serviceName);
            values = this.correctAttributeNames(amid, serviceName, values);
            this.logEvent("SUCCEED_IDENTITY_READ_SERVICE_ATTRIBUTE_VALUES", params);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_IDENTITY_READ_SERVICE_ATTRIBUTE_VALUES", paramsEx);
            debug.warning("EntitiesModelImpl.getServiceAttributeValues", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString(e)};
            this.logEvent("IDM_EXCEPTION_IDENTITY_READ_SERVICE_ATTRIBUTE_VALUES", paramsEx);
            debug.warning("EntitiesModelImpl.getServiceAttributeValues", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        return values != null ? values : Collections.EMPTY_MAP;
    }

    private Map correctAttributeNames(AMIdentity amid, String serviceName, Map values) {
        HashMap correctedValues = new HashMap(values.size());
        ServiceSchema serviceSchema = AMAdminUtils.getSchemaSchema(serviceName, amid.getType());
        Set attributes = serviceSchema.getAttributeSchemas();
        HashSet<String> emptySet = new HashSet<String>();
        emptySet.add("");
        if (attributes != null && !attributes.isEmpty()) {
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                String attrName = as.getName();
                Object val = values.get(attrName.toLowerCase());
                if (val == null) continue;
                correctedValues.put(attrName, val);
            }
        }
        return correctedValues;
    }

    public void setServiceAttributeValues(String universalId, String serviceName, Map values) throws AMConsoleException {
        if (values != null && !values.isEmpty()) {
            try {
                String[] params = new String[]{universalId, serviceName};
                this.logEvent("ATTEMPT_IDENTITY_WRITE_SERVICE_ATTRIBUTE_VALUES", params);
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
                amid.modifyService(serviceName, values);
                this.logEvent("SUCCEED_IDENTITY_WRITE_SERVICE_ATTRIBUTE_VALUES", params);
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("SSO_EXCEPTION_IDENTITY_WRITE_SERVICE_ATTRIBUTE_VALUES", paramsEx);
                debug.warning("EntitiesModelImpl.setServiceAttributeValues", (Throwable)((Object)e));
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{universalId, serviceName, this.getErrorString(e)};
                this.logEvent("IDM_EXCEPTION_IDENTITY_WRITE_SERVICE_ATTRIBUTE_VALUES", paramsEx);
                debug.warning("EntitiesModelImpl.setServiceAttributeValues", (Throwable)e);
                throw new AMConsoleException(this.getErrorString(e));
            }
        }
    }

    public boolean hasUserAttributeSchema(String serviceName) {
        return this.hasAttributeSchema(serviceName, SchemaType.USER);
    }

    public boolean hasDisplayableAttributes(String serviceName) {
        SchemaType st = SchemaType.USER;
        if (this.getEntityType() != null && !this.getEntityType().equals("user")) {
            st = SchemaType.DYNAMIC;
        }
        return this.hasAttributeSchema(serviceName, st);
    }

    private boolean hasAttributeSchema(String serviceName, SchemaType type) {
        boolean hasAttributes = false;
        try {
            Set attributeSchemas;
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.getUserSSOToken());
            ServiceSchema schema = mgr.getSchema(type);
            if (schema != null && (attributeSchemas = schema.getAttributeSchemas()) != null && !attributeSchemas.isEmpty()) {
                hasAttributes = this.hasI18nKeys(attributeSchemas);
            }
        }
        catch (SMSException e) {
            debug.warning("EntitiesModelImpl.hasAttributeSchema", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("EntitiesModelImpl.hasAttributeSchema", (Throwable)((Object)e));
        }
        return hasAttributes;
    }

    public Set getAuthenticationChains(String realm) throws AMConsoleException {
        if (realm == null || realm.trim().length() == 0) {
            realm = "/";
        }
        try {
            return AMAuthConfigUtils.getAllNamedConfig(realm, this.getUserSSOToken());
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.identity.wss.security.SecurityMechanism");
            isWSSEnabled = clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

