/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm.model;

import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.AttributeSchema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BackwardCompSupport {
    private static BackwardCompSupport instance = new BackwardCompSupport();
    private Map mapIdTypeToServiceName = new HashMap();
    private Map mapIdTypeToSchemaType = new HashMap();
    private Map mapIdTypeToSubSchemaName = new HashMap();
    private String namingAttribute = null;

    private BackwardCompSupport() {
        this.mapIdTypeToServiceName.put(IdType.USER.getName(), "iPlanetAMUserService");
        this.mapIdTypeToSchemaType.put(IdType.USER.getName(), "user");
        this.mapIdTypeToServiceName.put(IdType.AGENT.getName(), "iPlanetAMAgentService");
        this.mapIdTypeToSchemaType.put(IdType.AGENT.getName(), "user");
        this.mapIdTypeToServiceName.put(IdType.GROUP.getName(), "iPlanetAMEntrySpecificService");
        this.mapIdTypeToSubSchemaName.put(IdType.GROUP.getName(), "Group");
        this.mapIdTypeToServiceName.put(IdType.ROLE.getName(), "iPlanetAMEntrySpecificService");
        this.mapIdTypeToSubSchemaName.put(IdType.ROLE.getName(), "Role");
        this.mapIdTypeToServiceName.put(IdType.FILTEREDROLE.getName(), "iPlanetAMEntrySpecificService");
        this.mapIdTypeToSubSchemaName.put(IdType.FILTEREDROLE.getName(), "FilteredRole");
        this.namingAttribute = AdminInterfaceUtils.getNamingAttribute(1, AMModelBase.debug);
    }

    public static BackwardCompSupport getInstance() {
        return instance;
    }

    public String getServiceName(String idType) {
        return (String)this.mapIdTypeToServiceName.get(idType);
    }

    public String getSchemaType(String idType) {
        return (String)this.mapIdTypeToSchemaType.get(idType);
    }

    public String getSubSchemaName(String idType) {
        return (String)this.mapIdTypeToSubSchemaName.get(idType);
    }

    public void beforeDisplay(String idType, Set attributeSchemas) {
        if (idType != null && idType.equalsIgnoreCase(IdType.USER.getName())) {
            this.beforeDisplayUser(attributeSchemas);
        }
    }

    private void beforeDisplayUser(Set attributeSchemas) {
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            String name = as.getName();
            if (!name.equals(this.namingAttribute) && !name.equals("ChangePassword")) continue;
            iter.remove();
        }
    }

    public void beforeCreate(String idType, String entityName, Map values) {
        if (idType.equalsIgnoreCase(IdType.USER.getName())) {
            this.beforeCreateUser(idType, entityName, values);
        }
    }

    public void beforeModify(String idType, String entityName, Map values) {
        if (idType.equalsIgnoreCase(IdType.USER.getName())) {
            this.beforeModifyUser(idType, entityName, values);
        }
    }

    private void beforeCreateUser(String idType, String entityName, Map values) {
        HashSet<String> set = new HashSet<String>(2);
        set.add(entityName);
        values.put(this.namingAttribute, set);
    }

    private void beforeModifyUser(String idType, String entityName, Map values) {
        HashSet<String> set = new HashSet<String>(2);
        set.add(entityName);
        values.put(this.namingAttribute, set);
    }
}

