/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.idm.EntityEditViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdUtils;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EntityMembershipViewBean
extends EntityEditViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/EntityMembership.jsp";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String ADD_REMOVE_MEMBERS = "addRemoveMembers";
    private boolean canModify;
    private boolean submitCycle;
    private String filter;
    private List assignedMembers;
    private OptionList cacheAssigned;

    public EntityMembershipViewBean() {
        super("EntityMembership", DEFAULT_DISPLAY_URL);
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
    }

    protected void registerChildren() {
        super.registerChildren();
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.getMemberships();
    }

    private void getMemberships() {
        if (!this.submitCycle) {
            try {
                String curRealm = (String)this.getPageSessionAttribute("currentRealm");
                String type = (String)this.getPageSessionAttribute("memberType");
                String universalId = (String)this.getPageSessionAttribute("universalId");
                if (this.cacheAssigned != null) {
                    this.assignedMembers = AMAdminUtils.toList(this.cacheAssigned);
                } else {
                    EntitiesModel model = (EntitiesModel)this.getModel();
                    this.assignedMembers = new ArrayList();
                    this.assignedMembers.addAll(model.getMembership(curRealm, universalId, type));
                }
                if (this.canModify) {
                    CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)this.propertySheetModel.getModel(ADD_REMOVE_MEMBERS);
                    addRemoveModel.clear();
                    if (this.cacheAssigned != null) {
                        addRemoveModel.setSelectedOptionList(this.cacheAssigned);
                    } else {
                        addRemoveModel.setSelectedOptionList(this.getOptionListForEntities(this.assignedMembers));
                    }
                    addRemoveModel.setAvailableOptionList(this.getAssignableMembership());
                } else {
                    this.propertySheetModel.setValue(ADD_REMOVE_MEMBERS, AMAdminUtils.getString(this.getEntityDisplayNames(this.assignedMembers), ",", false));
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            if (this.canModify) {
                CCAddRemove addRemove = (CCAddRemove)this.getChild(ADD_REMOVE_MEMBERS);
                addRemove.resetStateData();
            }
        }
    }

    private OptionList getAssignableMembership() {
        OptionList avail = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        if (this.filter == null || this.filter.trim().length() == 0) {
            this.filter = "*";
            this.setDisplayFieldValue(TF_FILTER, "*");
        }
        this.setDisplayFieldValue(TF_FILTER, this.filter);
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            String searchType = (String)this.getPageSessionAttribute("memberType");
            IdSearchResults results = model.getEntityNames(curRealm, searchType, this.filter);
            int errorCode = results.getErrorCode();
            switch (errorCode) {
                case 1: {
                    this.setInlineAlertMessage("warning", "message.warning", "message.sizelimit.exceeded");
                    break;
                }
                case 2: {
                    this.setInlineAlertMessage("warning", "message.warning", "message.timelimit.exceeded");
                }
            }
            Set members = results.getSearchResults();
            String universalId = (String)this.getPageSessionAttribute("universalId");
            this.removeAlreadyAssignedMembers(members);
            avail = this.getOptionListForEntities(members);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return avail;
    }

    private void removeAlreadyAssignedMembers(Set assignable) {
        Iterator i = this.assignedMembers.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof AMIdentity) {
                assignable.remove(obj);
                continue;
            }
            boolean removed = false;
            Iterator iter = assignable.iterator();
            while (iter.hasNext() && !removed) {
                AMIdentity amid = (AMIdentity)iter.next();
                if (!IdUtils.getUniversalId(amid).equalsIgnoreCase((String)obj)) continue;
                iter.remove();
                removed = true;
            }
        }
    }

    protected void setSelectedTab() {
    }

    protected AMPropertySheetModel createPropertySheetModel(String type) {
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        DelegationConfig dConfig = DelegationConfig.getInstance();
        this.canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        String xmlFile = !this.canModify ? "com/sun/identity/console/propertyEntityMembership_Readonly.xml" : "com/sun/identity/console/propertyEntityMembership.xml";
        AMPropertySheetModel psModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xmlFile));
        if (this.canModify) {
            psModel.setModel(ADD_REMOVE_MEMBERS, this.createAddRemoveModel());
        }
        return psModel;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel("tab.sub.subjects.label"));
    }

    private CCAddRemoveModel createAddRemoveModel() {
        CCAddRemoveModel addRemoveModel = new CCAddRemoveModel();
        addRemoveModel.setOrientation("horizontal");
        addRemoveModel.setListboxHeight("10");
        return addRemoveModel;
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.submitCycle = false;
        CCAddRemove addRemove = (CCAddRemove)this.getChild(ADD_REMOVE_MEMBERS);
        addRemove.restoreStateData();
        CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)this.propertySheetModel.getModel(ADD_REMOVE_MEMBERS);
        this.cacheAssigned = addRemoveModel.getSelectedOptionList();
        this.filter = (String)this.getDisplayFieldValue(TF_FILTER);
        this.filter = this.filter.trim();
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.submitCycle = true;
        CCAddRemove child = (CCAddRemove)this.getChild(ADD_REMOVE_MEMBERS);
        child.restoreStateData();
        CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)this.propertySheetModel.getModel(ADD_REMOVE_MEMBERS);
        OptionList os = addRemoveModel.getSelectedOptionList();
        EntitiesModel model = (EntitiesModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute("universalId");
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        String type = (String)this.getPageSessionAttribute("memberType");
        try {
            Set entities = this.getEntitiesID(model.getMembership(curRealm, universalId, type));
            Set selected = EntityMembershipViewBean.getValues(os);
            HashSet toAdd = new HashSet(selected);
            toAdd.removeAll(entities);
            entities.removeAll(selected);
            if (!toAdd.isEmpty()) {
                model.addMemberships(universalId, toAdd);
            }
            if (!entities.isEmpty()) {
                model.removeMemberships(universalId, entities);
            }
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }
}

