/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.RoleModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RoleModelImpl
extends DMModelBase
implements RoleModel {
    private static final String USERS = "users";
    private final String CONTAINER_DEFAULT_TEMPLATE_ROLE = "cn=ContainerDefaultTemplateRole,";
    private Set roles = null;
    private AMRole role = null;
    private Map defaultACIMap = null;
    private String roleName = null;
    private ServiceSchemaManager userSvcMgr = null;
    private boolean filter = false;
    private static final int ACI_DESCRIPTION = 0;
    private static final int DEFAULT_PERMISSION = 1;
    private static final String NS_ROLE_FILTER = "nsRoleFilter";
    private Map mapAttributeValues = null;
    private static final String CREATE_PROPERTIES = "<section name=\"general\" defaultValue=\"\" > <property required=\"true\"> <label name=\"roleNameLabel\" labelFor=\"entryName\" defaultValue=\"create.role.name.label\" /> <cc name=\"entryName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" > <attribute name=\"size\" value=\"75\" /> </cc> </property> <property> <label name=\"roleDescriptionLabel\" defaultValue=\"create.role.description.label\" labelFor=\"iplanet-am-role-description\" /> <cc name=\"iplanet-am-role-description\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" > <attribute name=\"size\" value=\"75\" /> </cc> </property> <property required=\"true\"> <label name=\"roleTypeLabel\" defaultValue=\"create.role.type.label\" labelFor=\"iplanet-am-role-type\" /> <cc name=\"iplanet-am-role-type\" tagclass=\"com.sun.web.ui.taglib.html.CCDropDownMenuTag\"> </cc> </property> <property required=\"true\"> <label name=\"rolePermissionLabel\" defaultValue=\"create.role.permission.label\" labelFor=\"iplanet-am-role-aci-list\" /> <cc name=\"iplanet-am-role-aci-list\" tagclass=\"com.sun.web.ui.taglib.html.CCDropDownMenuTag\"> </cc> </property>";
    private static final String PROFILE_PROPERTIES = "<property><label name=\"roleDescriptionLabel\" defaultValue=\"create.role.description.label\" labelFor=\"iplanet-am-role-description\" /> <cc name=\"iplanet-am-role-description\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" > <attribute name=\"size\" value=\"75\" /></cc></property>  <property><label name=\"rolePermissionLabel\" defaultValue=\"create.role.permission.label\" labelFor=\"iplanet-am-role-aci-description\" /> <cc name=\"iplanet-am-role-aci-description\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" > <attribute name=\"size\" value=\"75\" /></cc></property>";
    private static final String FILTER_ATTRIBUTE = "<property> <label name=\"filterLabel\" labelFor=\"nsRoleFilter\" defaultValue=\"role.properties.name.filter\" /> <cc name=\"nsRoleFilter\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" > <attribute name=\"size\" value=\"75\" /> </cc> </property>";
    private static final String START_SECTION = "<section name=\"general\" defaultValue=\"\" >";

    public RoleModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Map getDataMap(int type) {
        HashMap<String, Set> data = new HashMap<String, Set>(20);
        if (type == 8) {
            Iterator it = this.getFilterAttributeNames().iterator();
            while (it.hasNext()) {
                data.put((String)it.next(), Collections.EMPTY_SET);
            }
        }
        data.put(NS_ROLE_FILTER, Collections.EMPTY_SET);
        data.put("entryName", Collections.EMPTY_SET);
        data.put("iplanet-am-role-description", Collections.EMPTY_SET);
        data.put("iplanet-am-role-type", Collections.EMPTY_SET);
        data.put("iplanet-am-role-aci-list", Collections.EMPTY_SET);
        return data;
    }

    public void removeUsers(String location, Set names) throws AMConsoleException {
        String userNames = AMAdminUtils.getString(names, ",", false);
        try {
            if (this.getObjectType(location) == 8) {
                throw new AMConsoleException(this.getLocalizedString("unsupported.operation"));
            }
            String[] params = new String[]{location, userNames};
            this.logEvent("ATTEMPT_DIR_MGR_REMOVE_USERS_FROM_ROLE", params);
            AMRole role = (AMRole)this.getAMObject(location);
            role.removeUsers(names);
            this.logEvent("SUCCEED_DIR_MGR_REMOVE_USERS_FROM_ROLE", params);
        }
        catch (AMException ex) {
            String strError = this.getErrorString(ex);
            String[] paramsEx = new String[]{location, userNames, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_REMOVE_USERS_FROM_ROLE", paramsEx);
            debug.warning("RoleModel.removeUsers failed", (Throwable)ex);
            throw new AMConsoleException(strError);
        }
        catch (SSOException ex) {
            String strError = this.getErrorString((Throwable)((Object)ex));
            String[] paramsEx = new String[]{location, userNames, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_REMOVE_USERS_FROM_ROLE", paramsEx);
            debug.warning("RoleModel.removeUsers failed", (Throwable)((Object)ex));
            throw new AMConsoleException(strError);
        }
    }

    private Set getDescriptionValue(AMRole role) {
        HashSet<String> description = new HashSet<String>(2);
        try {
            String value = role.getStringAttribute("iplanet-am-role-description");
            if (value != null && value.length() > 0) {
                String tmp = value.trim().replace(' ', '-');
                String localized = this.getLocalizedString(tmp);
                if (!localized.equals(tmp)) {
                    value = localized;
                }
                description.add(value);
            }
        }
        catch (AMException ame) {
            debug.warning("couldn't get role description", (Throwable)ame);
        }
        catch (SSOException soe) {
            debug.warning("couldn't get role description", (Throwable)((Object)soe));
        }
        return description == null ? Collections.EMPTY_SET : description;
    }

    private Set getPermissionValue(AMRole role) {
        HashSet<String> permission = new HashSet<String>(2);
        try {
            String value = role.getStringAttribute("iplanet-am-role-aci-description");
            if (value != null && value.length() > 0) {
                String tmp = value.trim().replace(' ', '-');
                String localized = this.getLocalizedString(tmp);
                if (!localized.equals(tmp)) {
                    value = localized;
                }
                permission.add(value);
            }
        }
        catch (AMException dpe) {
            debug.warning("couldn't get role aci description");
        }
        catch (SSOException dpe) {
            debug.warning("couldn't get role aci description");
        }
        return permission == null ? Collections.EMPTY_SET : permission;
    }

    public Map getValues(String name) throws AMConsoleException {
        HashMap<String, Set> values = new HashMap<String, Set>(6);
        Object ex = null;
        String[] params = new String[]{name};
        this.logEvent("ATTEMPT_DIR_MGR_GET_ROLE_ATTR_VALUES", params);
        try {
            AMRole role = (AMRole)this.getAMObject(name);
            values.put("iplanet-am-role-description", this.getDescriptionValue(role));
            values.put("iplanet-am-role-aci-description", this.getPermissionValue(role));
            if (this.getObjectType(name) == 8) {
                HashSet<String> hs = new HashSet<String>(2);
                hs.add(((AMFilteredRole)role).getFilter());
                values.put(NS_ROLE_FILTER, hs);
            }
            this.logEvent("SUCCEED_DIR_MGR_GET_ROLE_ATTR_VALUES", params);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ROLE_ATTR_VALUES", paramsEx);
            debug.error("RoleModelImpl.getValues", (Throwable)e);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ROLE_ATTR_VALUES", paramsEx);
            debug.error("RoleModelImpl.getValues", (Throwable)((Object)e));
            throw new AMConsoleException(strError);
        }
        return values == null ? Collections.EMPTY_MAP : values;
    }

    public void updateRole(String name, Map values) throws AMConsoleException {
        try {
            String[] param = new String[]{name};
            this.logEvent("ATTEMPT_DIR_MGR_MODIFY_ROLE", param);
            AMRole role = (AMRole)this.getAMObject(name);
            role.setAttributes(values);
            role.store();
            this.logEvent("SUCCEED_DIR_MGR_MODIFY_ROLE", param);
        }
        catch (AMException e) {
            String[] paramsEx = new String[]{name, this.getErrorString(e)};
            this.logEvent("AM_EXCEPTION_DIR_MGR_MODIFY_ROLE", paramsEx);
            debug.warning("RoleModel.updateRole", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{name, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_MODIFY_ROLE", paramsEx);
            debug.warning("RoleModel.updateRole", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getMembers(String location, String pattern) throws AMConsoleException {
        try {
            String[] params = new String[]{location, pattern};
            this.logEvent("ATTEMPT_DIR_MGR_GET_ROLE_MEMBERS", params);
            AMSearchControl searchControl = new AMSearchControl();
            this.setSearchControlLimits(searchControl);
            this.setSearchControlAttributes(searchControl, this.getValidUserAttributes(this.getSearchReturnValue()));
            AMRole role = (AMRole)this.getAMObject(location);
            AMSearchResults searchResults = role.searchUsers(searchControl, this.createUserSearchFilter(pattern));
            this.setSearchResults(searchResults);
            this.logEvent("SUCCEED_DIR_MGR_GET_ROLE_MEMBERS", params);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, pattern, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ROLE_MEMBERS", paramsEx);
            debug.warning("RoleModel.getMembers", (Throwable)e);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, pattern, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ROLE_MEMBERS", paramsEx);
            debug.warning("RoleModel.getMembers", (Throwable)((Object)e));
            throw new AMConsoleException(strError);
        }
        return this.getSearchResults();
    }

    public String getServiceXML(String service) {
        if (debug.messageEnabled()) {
            debug.message("RoleModel.getServiceXML - beginning...");
            debug.message("getting display string for " + service);
        }
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n");
        try {
            ServiceSchema ss = this.getServiceSchema(service, SchemaType.DYNAMIC);
            if (ss != null) {
                Set as = ss.getAttributeSchemas();
                Iterator iter = as.iterator();
                while (iter.hasNext()) {
                    AttributeSchema tmp = (AttributeSchema)iter.next();
                    String i18n = tmp.getI18NKey();
                    if (i18n != null && i18n.trim().length() != 0) continue;
                    iter.remove();
                }
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(service, (AMModel)this, as);
                buff.append(xmlBuilder.getXML(false));
            }
        }
        catch (SMSException s) {
            debug.error("RoleModelImpl.getServiceXML", (Throwable)s);
        }
        catch (SSOException s) {
            debug.error("RoleModelImpl.getServiceXML", (Throwable)((Object)s));
        }
        catch (AMConsoleException s) {
            debug.error("RoleModelImpl.getServiceXML", (Throwable)s);
        }
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public String getRoleProfileXML(int type) {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(START_SECTION).append(PROFILE_PROPERTIES);
        if (type == 8) {
            buff.append(FILTER_ATTRIBUTE);
        }
        buff.append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    public String getRoleCreateXML(int type) {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(CREATE_PROPERTIES);
        if (type == 8) {
            buff.append(this.getFilterAttributesXML());
        }
        buff.append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    public Set getRoles(String location, String filter) {
        if (this.roles == null) {
            AMSearchResults results = null;
            this.locationType = this.getObjectType(location);
            this.locationDN = location;
            AMSearchControl searchControl = new AMSearchControl();
            searchControl.setSearchScope(2);
            this.setSearchControlLimits(searchControl);
            this.setSearchControlAttributes(this.locationDN, "FilteredRole", 6, searchControl, "roles");
            boolean bOrganization = false;
            String[] params = new String[]{location, filter};
            try {
                switch (this.locationType) {
                    case 2: {
                        bOrganization = true;
                        this.logEvent("ATTEMPT_DIR_MGR_GET_ROLES_IN_ORG", params);
                        AMOrganization org = this.getAMStoreConnection().getOrganization(this.locationDN);
                        results = org.searchAllRoles(filter, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_GET_ROLES_IN_ORG", params);
                        break;
                    }
                    case 3: {
                        this.logEvent("ATTEMPT_DIR_MGR_GET_ROLES_IN_CONTAINER", params);
                        AMOrganizationalUnit orgUnit = this.getAMStoreConnection().getOrganizationalUnit(this.locationDN);
                        results = orgUnit.searchAllRoles(filter, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_GET_ROLES_IN_CONTAINER", params);
                        break;
                    }
                    default: {
                        if (debug.warningEnabled()) {
                            debug.warning("RoleModelImpl.getRoles invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{location, filter, strError};
                String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_GET_ROLES_IN_ORG" : "SSO_EXCEPTION_DIR_MGR_GET_ROLES_IN_CONTAINER";
                this.logEvent(msgId, paramsEx);
                debug.warning("RoleModelImpl.getRoles", (Throwable)((Object)e));
            }
            catch (AMException e) {
                this.searchErrorMsg = this.getErrorString(e);
                String[] paramsEx = new String[]{location, filter, this.searchErrorMsg};
                String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_GET_ROLES_IN_ORG" : "AM_EXCEPTION_DIR_MGR_GET_ROLES_IN_CONTAINER";
                this.logEvent(msgId, paramsEx);
                debug.warning("RoleModelImpl.getRoles", (Throwable)e);
            }
            this.roles = this.setSearchResults(results);
        }
        if (this.roles == null) {
            this.roles = Collections.EMPTY_SET;
        } else {
            this.roles.remove("cn=ContainerDefaultTemplateRole," + location);
        }
        return this.roles;
    }

    public Set getAttrList() {
        return this.roles;
    }

    public void setAttrList(Set set) {
        this.roles = set;
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean valid = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                valid = true;
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("RoleModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return valid;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes(null, 6, "roles");
    }

    private Set getRoleAttributeNames() {
        Set set = Collections.EMPTY_SET;
        try {
            String namingAttr = AdminInterfaceUtils.getNamingAttribute(5, debug);
            String temp = namingAttr + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.getLocationDN();
            String roleDN = AdminInterfaceUtils.getNamingAttribute(6, debug) + "=" + temp.replace(',', '_') + "," + this.getLocationDN();
            AMRole role = this.getAMStoreConnection().getRole(roleDN);
            Map map = role.getAttributes();
            if (map != null && !map.isEmpty()) {
                set = map.keySet();
            }
        }
        catch (SSOException ssoe) {
            debug.error("RoleModelImpl.getRoleAttributeNames", (Throwable)((Object)ssoe));
        }
        catch (AMException ae) {
            debug.error("RoleModelImpl.getRoleAttributeNames", (Throwable)ae);
        }
        return set;
    }

    protected List getValidatedAttributes(String returnAttr, String schemaName, int objectType, String type) {
        List list;
        ArrayList<String> searchAttrs = Collections.EMPTY_LIST;
        if (returnAttr != null && returnAttr.length() > 0 && (list = this.getObjectDisplayList(returnAttr, type)) != null && !list.isEmpty()) {
            searchAttrs = new ArrayList(list.size());
            Set roleAttrs = this.getRoleAttributeNames();
            Set filteredRoleAttrs = this.getFilteredRoleAttributeNames();
            int validAttrSize = 0;
            if (roleAttrs != null && !roleAttrs.isEmpty()) {
                validAttrSize = roleAttrs.size();
            }
            if (filteredRoleAttrs != null && !filteredRoleAttrs.isEmpty()) {
                validAttrSize += filteredRoleAttrs.size();
            }
            if (validAttrSize > 0) {
                HashSet set = new HashSet(validAttrSize);
                set.addAll(roleAttrs);
                set.addAll(filteredRoleAttrs);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    if (!set.contains(str) || searchAttrs.contains(str)) continue;
                    searchAttrs.add(str);
                }
            }
        }
        if (searchAttrs == null || searchAttrs.isEmpty()) {
            searchAttrs = new ArrayList<String>(1);
            searchAttrs.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
        }
        return searchAttrs;
    }

    public String getAttributeLocalizedName(String name) {
        return this.getAttributeLocalizedName(name, "FilteredRole");
    }

    private Set getFilteredRoleAttributeNames() {
        ServiceSchemaManager mgr = null;
        try {
            mgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
        }
        catch (SSOException e) {
            debug.error("RoleModelImpl.getFilteredRoleAttributeNames", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("RoleModelImpl.getFilteredRoleAttributeNames", (Throwable)e);
        }
        Set attrSchemaSet = this.getAttributesToDisplay(mgr, SchemaType.GLOBAL, "FilteredRole");
        HashSet<String> set = Collections.EMPTY_SET;
        if (attrSchemaSet != null && !attrSchemaSet.isEmpty()) {
            Iterator iter = attrSchemaSet.iterator();
            set = new HashSet<String>(attrSchemaSet.size());
            while (iter.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)iter.next();
                String name = attrSchema.getName();
                set.add(name);
            }
        }
        return set;
    }

    private AMFilteredRole getFilteredRoleObject(String dn) {
        AMFilteredRole role = null;
        try {
            role = this.getAMStoreConnection().getFilteredRole(dn);
            if (role == null || !role.isExists()) {
                if (debug.warningEnabled()) {
                    debug.warning("RoleModelImpl.getFilteredRoleObject role does not exists " + dn);
                }
                role = null;
            }
        }
        catch (SSOException ssoe) {
            debug.warning("RoleModelImpl.getFilteredRoleObject", (Throwable)((Object)ssoe));
        }
        return role;
    }

    private Set getFilteredRoleAttributeValues(String dn) {
        Set attrSchemaSet;
        ServiceSchemaManager mgr = null;
        try {
            this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
        }
        catch (SSOException e) {
            debug.error("RoleModelImpl.getFilteredRoleAttributeValues", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("RoleModelImpl.getFilteredRoleAttributeValues", (Throwable)e);
        }
        AMFilteredRole role = this.getFilteredRoleObject(dn);
        HashSet<String> values = Collections.EMPTY_SET;
        if (mgr != null && role != null && (attrSchemaSet = this.getAttributesToDisplay(mgr, SchemaType.GLOBAL, "FilteredRole")) != null && !attrSchemaSet.isEmpty()) {
            Iterator iter = attrSchemaSet.iterator();
            while (iter.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)iter.next();
                String name = attrSchema.getName();
                try {
                    if (name.equals("filterinfo")) {
                        values = new HashSet<String>(1);
                        values.add(role.getFilter());
                        continue;
                    }
                    values = role.getAttribute(name);
                }
                catch (AMException ame) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Could not get value for " + name, (Throwable)ame);
                }
                catch (SSOException sso) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Could not get value for " + name, (Throwable)((Object)sso));
                }
            }
        }
        return values;
    }

    public void createRole(String location, Map data) throws AMConsoleException {
        if (data == null || data.isEmpty()) {
            debug.error("null or missing data values");
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        Set pSet = (Set)data.get("iplanet-am-role-aci-list");
        String permission = (String)pSet.iterator().next();
        this.addACIDescription(data);
        int roleType = this.getRoleType(data);
        Map dataSet = this.getCreateRoleMap(data, location);
        String name = (String)dataSet.keySet().iterator().next();
        Set roles = Collections.EMPTY_SET;
        String[] params = new String[]{location, name};
        boolean bOrganization = false;
        try {
            if (this.getObjectType(location) == 2) {
                bOrganization = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_ROLES_IN_ORG", params);
                AMOrganization parent = this.getAMStoreConnection().getOrganization(location);
                if (roleType == 8) {
                    this.createFilter(data, dataSet);
                    roles = parent.createFilteredRoles(dataSet);
                } else {
                    roles = parent.createRoles(dataSet);
                }
            } else {
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_ROLES_IN_CONTAINER", params);
                AMOrganizationalUnit parent = this.getAMStoreConnection().getOrganizationalUnit(location);
                if (roleType == 8) {
                    this.createFilter(data, dataSet);
                    roles = parent.createFilteredRoles(dataSet);
                } else {
                    roles = parent.createRoles(dataSet);
                }
            }
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_ROLES_IN_ORG" : "AM_EXCEPTION_DIR_MGR_CREATE_ROLES_IN_CONTAINER";
            this.logEvent(msgId, paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_CREATE_ROLES_IN_ORG" : "SSO_EXCEPTION_DIR_MGR_CREATE_ROLES_IN_CONTAINER";
            this.logEvent(msgId, paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private void addACIDescription(Map dataIn) {
        String permission = "";
        String aciDescription = null;
        Set tmpSet = (Set)dataIn.get("iplanet-am-role-aci-list");
        String tmp = (String)tmpSet.iterator().next();
        if (tmp == null) {
            permission = (String)dataIn.remove("aciField");
            aciDescription = (String)dataIn.remove("aciDescription");
        } else {
            if (this.defaultACIMap == null) {
                this.createACIMap();
            }
            List ll = (List)this.defaultACIMap.get(tmp);
            permission = (String)ll.get(1);
            aciDescription = (String)ll.get(0);
        }
        HashSet<String> permSet = Collections.EMPTY_SET;
        if (permission != null) {
            permSet = new HashSet<String>(2);
            permSet.add(permission);
        }
        dataIn.put("iplanet-am-role-aci-list", permSet);
        HashSet<String> descSet = Collections.EMPTY_SET;
        if (aciDescription != null) {
            descSet = new HashSet<String>(2);
            descSet.add(aciDescription);
        }
        dataIn.put("iplanet-am-role-aci-description", descSet);
    }

    private Map getCreateRoleMap(Map roleMap, String loc) {
        Set type = (Set)roleMap.get("iplanet-am-role-type");
        String val = (String)type.iterator().next();
        if (val.equals("2")) {
            HashSet<String> x = new HashSet<String>(2);
            x.add(loc);
            roleMap.put("iplanet-am-role-managed-container-dn", x);
        }
        Set tmp = (Set)roleMap.remove("entryName");
        String roleName = (String)tmp.iterator().next();
        HashMap<String, Map> newRole = new HashMap<String, Map>(2);
        newRole.put(roleName, roleMap);
        return newRole;
    }

    private int getRoleType(Map dataIn) {
        int roleType = 6;
        String str = (String)dataIn.remove("role-page-type");
        if (str != null && str.length() != 0) {
            try {
                roleType = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                debug.warning("RoleModel.getRoleType", (Throwable)e);
            }
        }
        return roleType;
    }

    private void createFilter(Map dataIn, Map dataSet) {
        Set los = (Set)dataIn.remove("logicalOp");
        String logicalOp = los != null && !los.isEmpty() ? (String)los.iterator().next() : "AND";
        Set filterSet = (Set)dataIn.remove("filterinfo");
        String filterInfo = null;
        if (filterSet != null && !filterSet.isEmpty()) {
            filterInfo = (String)filterSet.iterator().next();
            if (!filterInfo.startsWith("(") && !filterInfo.endsWith(")")) {
                filterInfo = "(" + filterInfo + ")";
            }
        } else {
            HashMap filterData = new HashMap(dataIn);
            StringBuffer avPairs = new StringBuffer(100);
            Iterator iter = this.getFilterAttributeNames().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Set value = (Set)dataIn.remove(key);
                if (value == null || value.isEmpty()) {
                    if (!key.equals("uid")) continue;
                    avPairs.append("(" + key + "=*)");
                    continue;
                }
                Iterator valIter = value.iterator();
                String val = (String)valIter.next();
                if (key.equalsIgnoreCase("inetuserstatus")) {
                    if (val.equalsIgnoreCase("Active")) {
                        avPairs.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                        continue;
                    }
                    avPairs.append("(").append("inetuserstatus").append("=").append(val).append(")");
                    continue;
                }
                if (val.length() > 0) {
                    avPairs.append("(").append(key).append("=").append(val).append(")");
                    continue;
                }
                if (!key.equals("uid")) continue;
                avPairs.append("(uid=*)");
            }
            StringBuffer avFilter = new StringBuffer(100);
            avFilter.append("(&(objectclass=inetorgperson)");
            if (avPairs.length() != 0) {
                if (filterData.size() > 1) {
                    if (logicalOp != null && logicalOp.equalsIgnoreCase("AND")) {
                        avFilter.append("(&");
                    } else {
                        avFilter.append("(|");
                    }
                    avFilter.append(avPairs + ")");
                } else {
                    avFilter.append(avPairs);
                }
            }
            avFilter.append(")");
            filterInfo = avFilter.toString();
        }
        if (filterInfo != null && filterInfo.length() > 0) {
            HashSet<String> attrValue = new HashSet<String>(2);
            attrValue.add(filterInfo);
            String tmp = (String)dataSet.keySet().iterator().next();
            Map roleMap = (Map)dataSet.get(tmp);
            roleMap.put(NS_ROLE_FILTER, attrValue);
        }
    }

    public Set getDefaultPermissions() {
        if (this.defaultACIMap == null) {
            this.createACIMap();
        }
        return this.defaultACIMap.keySet();
    }

    public Map getDefaultTypes() {
        HashMap<String, String> dt = new HashMap<String, String>(2);
        dt.put(this.getLocalizedString("roleType.2"), Integer.toString(2));
        dt.put(this.getLocalizedString("roleType.3"), Integer.toString(3));
        return dt;
    }

    private void createACIMap() {
        try {
            ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema schema = mgr.getSchema(SchemaType.GLOBAL);
            Map serviceAttrs = schema.getAttributeDefaults();
            Set ACISet = (Set)serviceAttrs.get("iplanet-am-admin-console-role-default-acis");
            Iterator it = ACISet.iterator();
            this.defaultACIMap = new HashMap(ACISet.size());
            while (it.hasNext()) {
                String entry = (String)it.next();
                int start = 0;
                int end = entry.indexOf("|");
                if (end == -1) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("invalid default aci entry found: " + entry);
                    continue;
                }
                String permissionName = entry.substring(start, end);
                start = end + 1;
                if ((end = entry.indexOf("|", start)) == -1) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("invalid default aci entry found: " + entry);
                    continue;
                }
                String description = entry.substring(start, end);
                start = end + 1;
                end = entry.length();
                String aci = entry.substring(start, end);
                ArrayList<String> valSet = new ArrayList<String>(2);
                valSet.add(0, description);
                valSet.add(1, aci);
                this.defaultACIMap.put(permissionName, valSet);
            }
        }
        catch (SMSException e) {
            debug.error("RoleModelImpl.createACIMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("RoleModelImpl.createACIMap", (Throwable)((Object)e));
        }
    }

    public String getEmptyPermission() {
        return "No Permission";
    }

    public String getOptionString(String option) {
        String localized;
        String original = option;
        if ((option = option.trim().replace(' ', '-')).equals(localized = this.getLocalizedString(option))) {
            localized = original;
            if (debug.warningEnabled()) {
                debug.warning("RoleModelImpl.getOptionString() no localized value for " + option);
            }
        }
        return localized;
    }

    private boolean hasDynamicAttributes(String serviceName) {
        Set as;
        ServiceSchema dynamic = null;
        try {
            dynamic = this.getServiceSchema(serviceName, SchemaType.DYNAMIC);
        }
        catch (SMSException e) {
            debug.warning("RoleModelImpl.hasDynamicAttributes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("RoleModelImpl.hasDynamicAttributes", (Throwable)((Object)e));
        }
        boolean display = false;
        if (dynamic != null && (as = dynamic.getAttributeSchemas()) != null && !as.isEmpty()) {
            Iterator i = as.iterator();
            while (i.hasNext() && !display) {
                if (!this.isDisplayed((AttributeSchema)i.next())) continue;
                display = true;
            }
        }
        return display;
    }

    public Map getAssignedServices(String location) {
        HashMap<String, String> names = null;
        try {
            AMOrganization org = this.getAMStoreConnection().getOrganization(location);
            Set tmp = org.getRegisteredServiceNames();
            if (tmp != null && !tmp.isEmpty()) {
                names = new HashMap<String, String>(tmp.size() * 2);
                Iterator iter = tmp.iterator();
                while (iter.hasNext()) {
                    String displayName;
                    String name = (String)iter.next();
                    if (name.equals("iPlanetAMAuthConfiguration") || name.equals(displayName = this.getLocalizedServiceName(name)) || !this.hasDynamicAttributes(name)) continue;
                    names.put(name, displayName);
                }
            }
        }
        catch (SSOException ssoe) {
            debug.warning("OrganizationModel.getOrganizations", (Throwable)((Object)ssoe));
        }
        catch (AMException ame) {
            debug.warning("OrganizationModel.getOrganizations", (Throwable)ame);
        }
        return names == null ? Collections.EMPTY_MAP : names;
    }

    public boolean isFilteredRole(String roleName) {
        return this.getObjectType(roleName) == 8;
    }
}

