/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.PeopleContainerModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PeopleContainerModelImpl
extends DMModelBase
implements PeopleContainerModel {
    private Set containers = null;
    private static final String CREATE_PROPERTIES = "<section name=\"attributes\" defaultValue=\"\" ><property><label name=\"lblPcName\" defaultValue=\"label.name\" labelFor=\"tfPCName\" /><cc name=\"tfPCName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /></property></section>";

    public PeopleContainerModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getPeopleContainers(String location, String filter) {
        if (this.containers == null) {
            AMStoreConnection sc = this.getAMStoreConnection();
            AMSearchResults results = null;
            AMSearchControl searchControl = new AMSearchControl();
            searchControl.setSearchScope(2);
            this.setSearchControlLimits(searchControl);
            this.setSearchControlAttributes(location, "PeopleContainer", 5, searchControl, "peopleContainers");
            String[] params = new String[]{location, filter};
            boolean bOrganization = false;
            boolean bContainer = false;
            try {
                switch (this.getObjectType(location)) {
                    case 2: {
                        bOrganization = true;
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_ORG", params);
                        AMOrganization org = sc.getOrganization(location);
                        results = org.searchPeopleContainers(filter, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_ORG", params);
                        break;
                    }
                    case 3: {
                        bContainer = true;
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_CONTAINER", params);
                        AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(location);
                        results = orgUnit.searchPeopleContainers(filter, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_CONTAINER", params);
                        break;
                    }
                    case 5: {
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_PEOPLE_PPLE_CONTS_IN_PPLE_CONT", params);
                        AMPeopleContainer peopleContainer = sc.getPeopleContainer(location);
                        this.containers = peopleContainer.searchSubPeopleContainers(filter, 1);
                        this.createResultsMap(this.containers);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_PEOPLE_PPLE_CONTS_IN_PPLE_CONT", params);
                        break;
                    }
                    default: {
                        if (debug.warningEnabled()) {
                            debug.warning("PeopleContainerModel.getPeopleContainersinvalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{location, filter, strError};
                String msgId = null;
                msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_CONTAINER" : "SSO_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_PPLE_CONTS_IN_PPLE_CONT");
                this.logEvent(msgId, paramsEx);
                debug.warning("PeopleContainerModel.getPeopleContainers", (Throwable)((Object)e));
            }
            catch (AMException e) {
                this.searchErrorMsg = this.getErrorString(e);
                String[] paramsEx = new String[]{location, filter, this.searchErrorMsg};
                String msgId = null;
                msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_CONTAINERS_IN_CONTAINER" : "AM_EXCEPTION_DIR_MGR_SEARCH_PEOPLE_PPLE_CONTS_IN_PPLE_CONT");
                this.logEvent(msgId, paramsEx);
                debug.warning("PeopleContainerModel.getPeopleContainers", (Throwable)e);
            }
            if (results != null) {
                this.containers = results.getSearchResults();
                this.resultsMap = results.getResultAttributes();
                this.searchErrorMsg = this.getSearchResultWarningMessage(results);
            }
        }
        return this.containers;
    }

    private void createResultsMap(Set pcSet) {
        this.resultsMap = new HashMap();
        Iterator iter = pcSet.iterator();
        while (iter.hasNext()) {
            String dn = (String)iter.next();
            HashMap map = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(this.DNToName(dn, false));
            map.put(dn.substring(0, dn.indexOf(61)), set);
            this.resultsMap.put(dn, map);
        }
    }

    public boolean deletePeopleContainers(Set pcDNSet) {
        boolean delete;
        block6: {
            delete = false;
            if (pcDNSet != null) {
                try {
                    Map failedPCMap = this.deleteObject(pcDNSet);
                    if (!failedPCMap.isEmpty()) {
                        Iterator it = failedPCMap.keySet().iterator();
                        this.setErrorMessage(this.getLocalizedString("deletePCFailed.message"));
                        while (it.hasNext()) {
                            String failedPCDN = (String)it.next();
                            String failedPCName = this.DNToName(failedPCDN, false);
                            String errMessage = (String)failedPCMap.get(failedPCDN);
                            this.setErrorMessage(failedPCName + " - " + errMessage);
                        }
                        break block6;
                    }
                    delete = true;
                }
                catch (AMConsoleException ace) {
                    this.setErrorMessage(this.getErrorString(ace));
                }
            } else {
                this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
            }
        }
        return delete;
    }

    public String getCreatePeopleContainerXML() {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(CREATE_PROPERTIES);
        this.getPropertyXML("iPlanetAMEntrySpecificService", "PeopleContainer", SchemaType.GLOBAL, buff);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            Set attrSchemas;
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, "PeopleContainer");
            if (sub != null && (attrSchemas = sub.getAttributeSchemas()) != null) {
                Iterator i = attrSchemas.iterator();
                while (i.hasNext()) {
                    AttributeSchema as = (AttributeSchema)i.next();
                    map.put(as.getName().toLowerCase(), Collections.EMPTY_SET);
                }
            }
            map.put("tfPCName", Collections.EMPTY_SET);
        }
        catch (SMSException e) {
            debug.error("PeopleContainerModel.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("PeopleContainerModel.getDataMap", (Throwable)((Object)e));
        }
        return map;
    }

    public void createPeopleContainer(String location, Map data) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("PeopleContainerModel.createPeopleContainer");
            debug.message("data = " + data);
            debug.message("parent = " + location);
        }
        if (data == null || data.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        Set tmp = (Set)data.remove("tfPCName");
        if (tmp == null || tmp.isEmpty()) {
            debug.error("Model detected missing name");
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        String name = (String)tmp.iterator().next();
        if (name == null || name.length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        this.validateRequiredAttributes(data);
        HashMap<String, Map> input = new HashMap<String, Map>(2);
        input.put(name, data);
        String[] params = new String[]{location, name};
        boolean bOrganization = false;
        boolean bContainer = false;
        AMStoreConnection sc = this.getAMStoreConnection();
        try {
            int locType = this.getObjectType(location);
            if (locType == 2) {
                bOrganization = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_ORG", params);
                AMOrganization parent = sc.getOrganization(location);
                parent.createPeopleContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_ORG", params);
            } else if (locType == 3) {
                bContainer = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_CONTAINER", params);
                AMOrganizationalUnit parent = sc.getOrganizationalUnit(location);
                parent.createPeopleContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_CONTAINER", params);
            } else {
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_PPLE_CONT", params);
                AMPeopleContainer parent = sc.getPeopleContainer(location);
                parent.createSubPeopleContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_PPLE_CONT", params);
            }
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            String msgId = null;
            msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_CONTAINER" : "AM_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_PPLE_CONT");
            this.logEvent(msgId, paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            String msgId = null;
            msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_CONTAINER" : "SSO_EXCEPTION_DIR_MGR_CREATE_PEOPLE_CONTAINER_IN_PPLE_CONT");
            this.logEvent(msgId, paramsEx);
        }
    }

    protected void getPropertyXML(String serviceName, String subSchemaName, SchemaType type, StringBuffer buff) {
        debug.message("PeopleContainerModel.getPropertyXML");
        try {
            ServiceSchema sub = this.getSubSchema(serviceName, type, subSchemaName);
            if (sub != null) {
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(sub, this);
                buff.append(xmlBuilder.getXML(false));
                this.setMandatoryAttributes(xmlBuilder.getAttributeSchemas());
            }
        }
        catch (SSOException e) {
            debug.error("PeopleContainerModelImpl.getPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PeopleContainerModelImpl.getPropertyXML", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.error("PeopleContainerModelImpl.getPropertyXML", (Throwable)e);
        }
    }

    protected ServiceSchema getServiceSchema(String serviceName, SchemaType type) throws SMSException, SSOException {
        ServiceSchemaManager manager = this.getServiceSchemaManager(serviceName);
        ServiceSchema ss = manager.getSchema(type);
        return ss;
    }

    protected ServiceSchema getSubSchema(String serviceName, SchemaType type, String subschema) throws SMSException, SSOException {
        ServiceSchema service = this.getServiceSchema(serviceName, type);
        ServiceSchema tmp = service.getSubSchema(subschema);
        return tmp;
    }

    public boolean hasDisplayProperties() {
        Map tmp = this.getDataMap();
        tmp.remove("tfPCName");
        return !tmp.isEmpty();
    }
}

