/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.GroupModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class GroupModelImpl
extends DMModelBase
implements GroupModel {
    private Set groups = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;
    private String errorMessage = "";
    private AMGroup amGroup = null;
    private static final String CREATE_PROPERTIES = "<section name=\"general\" defaultValue=\"\"><property required=\"true\"><label name=\"lblPcName\" defaultValue=\"label.name\" labelFor=\"entryName\" /><cc name=\"entryName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /></property>";

    public GroupModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public void setManagedGroups(Set groupDNs) {
        this.groups = groupDNs == null || groupDNs.isEmpty() ? Collections.EMPTY_SET : groupDNs;
    }

    public Set getGroups(String location, String filter) {
        if (this.groups != null) {
            return this.groups;
        }
        this.locationType = this.getObjectType(location);
        this.locationDN = location;
        AMSearchResults results = null;
        AMGroup group = null;
        Object groupContainers = null;
        Object gcIter = null;
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(2);
        this.setSearchControlLimits(searchControl);
        this.setSearchControlAttributes(this.locationDN, "Group", 9, searchControl, "groups");
        boolean bOrganization = false;
        boolean bContainer = false;
        boolean bDynGroup = false;
        boolean bAssDynGroup = false;
        AMStoreConnection sc = this.getAMStoreConnection();
        try {
            String[] params = new String[]{this.locationDN, filter};
            switch (this.locationType) {
                case 2: {
                    bOrganization = true;
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUPS_UNDER_ORG", params);
                    AMOrganization org = sc.getOrganization(this.locationDN);
                    results = org.searchGroups(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUPS_UNDER_ORG", params);
                    break;
                }
                case 3: {
                    bContainer = true;
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUPS_UNDER_CONTAINER", params);
                    AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(this.locationDN);
                    results = orgUnit.searchGroups(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUPS_UNDER_CONTAINER", params);
                    break;
                }
                case 4: {
                    AMGroupContainer gc = sc.getGroupContainer(this.locationDN);
                    results = gc.searchGroups(filter, null, searchControl);
                    break;
                }
                case 9: 
                case 10: {
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUPS_UNDER_STATIC_GRP", params);
                    group = sc.getStaticGroup(this.locationDN);
                    results = group.searchGroups(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUPS_UNDER_STATIC_GRP", params);
                    break;
                }
                case 11: {
                    bDynGroup = true;
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUPS_UNDER_DYNAMIC_GRP", params);
                    group = sc.getDynamicGroup(this.locationDN);
                    results = group.searchGroups(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUPS_UNDER_DYNAMIC_GRP", params);
                    break;
                }
                case 12: {
                    bAssDynGroup = true;
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUPS_UNDER_ASSIGNABLE_DYNAMIC_GRP", params);
                    group = sc.getAssignableDynamicGroup(this.locationDN);
                    results = group.searchGroups(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUPS_UNDER_ASSIGNABLE_DYNAMIC_GRP", params);
                    break;
                }
                default: {
                    if (debug.warningEnabled()) {
                        debug.warning("GroupModelImpl.getManagedGroup invalid location " + this.locationType);
                    }
                    break;
                }
            }
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.locationDN, filter, strError};
            String msgId = null;
            msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_CONTAINER" : (bDynGroup ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_DYNAMIC_GRP" : (bAssDynGroup ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_ASSIGNABLE_DYNAMIC_GRP" : "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_STATIC_GRP")));
            this.logEvent(msgId, paramsEx);
            debug.warning("GroupModelImpl.getManagedGroup", (Throwable)((Object)e));
        }
        catch (AMException e) {
            this.searchErrorMsg = this.getErrorString(e);
            String[] paramsEx = new String[]{this.locationDN, filter, this.searchErrorMsg};
            String msgId = null;
            msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_CONTAINER" : (bDynGroup ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_DYNAMIC_GRP" : (bAssDynGroup ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_ASSIGNABLE_DYNAMIC_GRP" : "AM_EXCEPTION_DIR_MGR_SEARCH_GROUPS_UNDER_STATIC_GRP")));
            this.logEvent(msgId, paramsEx);
            debug.warning("GroupModelImpl.getManagedGroup", (Throwable)e);
        }
        this.groups = results != null ? this.removeHiddenGroups(this.setSearchResults(results)) : Collections.EMPTY_SET;
        return this.groups;
    }

    private Set removeHiddenGroups(Set compliantGroupDNs) {
        if (this.isAdminGroupsEnabled() || this.locationType != 2 && this.locationType != 3 && this.locationType != 4) {
            return compliantGroupDNs;
        }
        OrderedSet groupDNs = new OrderedSet();
        String groupDN = null;
        String groupName = null;
        Iterator iter = compliantGroupDNs.iterator();
        while (iter.hasNext()) {
            groupDN = (String)iter.next();
            groupName = AMFormatUtils.DNToName(this, groupDN);
            if (groupName.equalsIgnoreCase("DomainAdministrators") || groupName.equalsIgnoreCase("DomainHelpDeskAdministrators") || groupName.equalsIgnoreCase("ServiceAdministrators") || groupName.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
            groupDNs.add(groupDN);
        }
        return groupDNs;
    }

    public Set getAttrList() {
        return this.groups;
    }

    public void setAttrList(Set set) {
        this.setManagedGroups(set);
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean valid = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                valid = true;
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("GroupModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return valid;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes("Group", 9, "groups");
    }

    protected List getValidatedAttributes(String returnAttr, String schemaName, int objectType, String type) {
        List list;
        ArrayList<String> searchAttrs = Collections.EMPTY_LIST;
        if (returnAttr != null && returnAttr.length() > 0 && (list = this.getObjectDisplayList(returnAttr, type)) != null && !list.isEmpty()) {
            searchAttrs = new ArrayList(list.size());
            Set groupAttrs = this.getObjectAttributeNames(schemaName, objectType);
            Set filteredGroupAttrs = this.getFilteredGroupAttributeNames();
            int validAttrSize = 0;
            if (groupAttrs != null && !groupAttrs.isEmpty()) {
                validAttrSize = groupAttrs.size();
            }
            if (filteredGroupAttrs != null && !filteredGroupAttrs.isEmpty()) {
                validAttrSize += filteredGroupAttrs.size();
            }
            if (validAttrSize > 0) {
                HashSet set = new HashSet(validAttrSize);
                set.addAll(groupAttrs);
                set.addAll(filteredGroupAttrs);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    if (!set.contains(str) || searchAttrs.contains(str)) continue;
                    searchAttrs.add(str);
                }
            }
        }
        if (searchAttrs == null || searchAttrs.isEmpty()) {
            searchAttrs = new ArrayList<String>(1);
            searchAttrs.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
        }
        return searchAttrs;
    }

    public String getAttributeValue(String groupDN, String attribute) {
        Map values;
        String value = "";
        if (this.resultsMap != null && !this.resultsMap.isEmpty() && (values = (Map)this.resultsMap.get(groupDN)) != null && !values.isEmpty()) {
            Set attrValues = (Set)values.get(attribute);
            if (attrValues == null || attrValues.isEmpty()) {
                if (this.getObjectType(groupDN) == 11 && this.getFilteredGroupAttributeNames().contains(attribute)) {
                    attrValues = this.getFilteredGroupAttributeValues(groupDN);
                    value = this.getMultiValue(attrValues);
                }
            } else {
                value = this.getMultiValue(attrValues);
            }
        }
        return value;
    }

    public String getAttributeLocalizedName(String name) {
        return this.getAttributeLocalizedName(name, "Group");
    }

    private Set getFilteredGroupAttributeNames() {
        ServiceSchemaManager mgr = null;
        try {
            mgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
        }
        catch (SSOException e) {
            debug.error("GroupModelImpl.getFilteredGroupAttributeNames", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("GroupModelImpl.getFilteredGroupAttributeNames", (Throwable)e);
        }
        Set attrSchemaSet = this.getAttributesToDisplay(mgr, SchemaType.GLOBAL, "DynamicGroup");
        HashSet<String> set = Collections.EMPTY_SET;
        if (attrSchemaSet != null && !attrSchemaSet.isEmpty()) {
            set = new HashSet<String>(attrSchemaSet.size());
            Iterator iter = attrSchemaSet.iterator();
            while (iter.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)iter.next();
                String name = attrSchema.getName();
                set.add(name);
            }
        }
        return set;
    }

    private AMDynamicGroup getFilteredGroupObject(String dn) {
        AMDynamicGroup group = null;
        try {
            group = this.getAMStoreConnection().getDynamicGroup(dn);
            if (group == null || !group.isExists()) {
                if (debug.warningEnabled()) {
                    debug.warning("UMRoleNavModelImpl.getFilteredGroupObject group does not exists " + dn);
                }
                group = null;
            }
        }
        catch (SSOException ssoe) {
            debug.warning("UMRoleNavModelImpl.getFilteredGroupObject", (Throwable)((Object)ssoe));
        }
        return group;
    }

    private Set getFilteredGroupAttributeValues(String dn) {
        Set attrSchemaSet;
        ServiceSchemaManager mgr = null;
        try {
            mgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
        }
        catch (SSOException e) {
            debug.error("GroupModelImpl.getFilteredGroupAttributeValues " + dn, (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("GroupModelImpl.getFilteredGroupAttributeValues " + dn, (Throwable)e);
        }
        AMDynamicGroup group = this.getFilteredGroupObject(dn);
        HashSet<String> values = Collections.EMPTY_SET;
        if (mgr != null && group != null && (attrSchemaSet = this.getAttributesToDisplay(mgr, SchemaType.GLOBAL, "DynamicGroup")) != null && !attrSchemaSet.isEmpty()) {
            Iterator iter = attrSchemaSet.iterator();
            while (iter.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)iter.next();
                String name = attrSchema.getName();
                try {
                    if (name.equals("filterinfo")) {
                        values = new HashSet<String>(1);
                        values.add(group.getFilter());
                        continue;
                    }
                    values = group.getAttribute(name);
                }
                catch (AMException ame) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Could not get value for " + name, (Throwable)ame);
                }
                catch (SSOException sso) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Could not get value for " + name, (Throwable)((Object)sso));
                }
            }
        }
        return values;
    }

    public void updateGroup(String name, Map values) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("GroupModel.updateGroup saving properties for " + name);
        }
        AMGroup group = this.getAMGroup(name);
        try {
            this.modify(group, values);
        }
        catch (AMException a) {
            debug.warning("GroupModelImpl.updateGroups ", (Throwable)a);
        }
        catch (SSOException a) {
            debug.error("GroupModelImpl.updateGroups ", (Throwable)((Object)a));
        }
    }

    public Map getValues(String name) throws AMConsoleException {
        Map values = null;
        Object ex = null;
        AMGroup group = this.getAMGroup(name);
        try {
            values = group.getAttributes();
            if (this.getObjectType(name) == 11) {
                HashSet<String> hs = new HashSet<String>(2);
                hs.add(((AMDynamicGroup)group).getFilter());
                values.put("filterinfo", hs);
            }
        }
        catch (AMException s) {
            debug.warning("GroupModel.getValues ", (Throwable)s);
            ex = s;
        }
        catch (SSOException s) {
            debug.error("getting values for group", (Throwable)((Object)s));
            ex = s;
        }
        if (ex != null) {
            throw new AMConsoleException(this.getErrorString((Throwable)ex));
        }
        return values == null ? Collections.EMPTY_MAP : values;
    }

    public String getCreateStaticGroupXML() {
        String attributes = this.getPropertyXML("iPlanetAMEntrySpecificService", "Group", SchemaType.GLOBAL, false);
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(CREATE_PROPERTIES).append(this.removeSectionTags(attributes)).append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    public String getCreateDynamicGroupXML() {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(CREATE_PROPERTIES).append(this.getFilterAttributesXML()).append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    public String getGroupProfileXML(String viewbeanClassName, int type) {
        boolean canModify = false;
        try {
            AMOrganization org = this.getAMStoreConnection().getOrganization(this.locationDN);
            DelegationConfig dConfig = DelegationConfig.getInstance();
            canModify = dConfig.hasPermission(org.getDN(), null, "MODIFY", this, viewbeanClassName);
        }
        catch (SSOException e) {
            debug.warning("GroupModelImpl.getGroupProfileXML", (Throwable)((Object)e));
        }
        String schema = "Group";
        if (type == 11) {
            schema = "DynamicGroup";
        }
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n");
        buff.append(this.getPropertyXML("iPlanetAMEntrySpecificService", schema, SchemaType.GLOBAL, !canModify));
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public Map getDataMap(String name) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            int type = this.getObjectType(name);
            String schema = "Group";
            if (type == 11) {
                schema = "DynamicGroup";
                map.put("filterinfo", Collections.EMPTY_SET);
            }
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, schema);
            Set attrSchemas = sub.getAttributeSchemas();
            Iterator iter = attrSchemas.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                map.put(as.getName().toLowerCase(), Collections.EMPTY_SET);
            }
            Iterator i = this.getFilterAttributeNames().iterator();
            while (i.hasNext()) {
                map.put((String)i.next(), Collections.EMPTY_SET);
            }
            map.put("entryName", Collections.EMPTY_SET);
        }
        catch (SMSException e) {
            debug.warning("GroupModelImpl.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("GroupModelImpl.getDataMap", (Throwable)((Object)e));
        }
        return map;
    }

    private String appendGroupContainer(String loc) {
        int type = this.getObjectType(loc);
        if (!(type != 2 && type != 3 || this.showGroupContainers())) {
            StringBuffer tmp = new StringBuffer(128);
            tmp.append(AdminInterfaceUtils.getNamingAttribute(4, debug)).append("=").append(AdminInterfaceUtils.defaultGroupContainerName()).append(",").append(loc);
            loc = tmp.toString();
            if (debug.messageEnabled()) {
                debug.message("new location dn = " + loc);
            }
        }
        return loc;
    }

    private String getGroupContainers(String loc) {
        Set gcDNs = Collections.EMPTY_SET;
        boolean bOrganization = false;
        try {
            String[] params = new String[]{loc, "*"};
            switch (this.getObjectType(loc)) {
                case 2: {
                    bOrganization = true;
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG", params);
                    AMOrganization org = this.getAMStoreConnection().getOrganization(loc);
                    gcDNs = org.getGroupContainers(1);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG", params);
                    break;
                }
                case 3: {
                    this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER", params);
                    AMOrganizationalUnit orgUnit = this.getAMStoreConnection().getOrganizationalUnit(loc);
                    gcDNs = orgUnit.getGroupContainers(1);
                    this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER", params);
                }
            }
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{loc, "*", strError};
            String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG" : "AM_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER";
            this.logEvent(msgId, paramsEx);
            debug.warning("failed to get group containers", (Throwable)e);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{loc, "*", strError};
            String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG" : "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER";
            this.logEvent(msgId, paramsEx);
            debug.warning("failed to get group containers", (Throwable)((Object)e));
        }
        return gcDNs == null ? "" : (String)gcDNs.iterator().next();
    }

    public boolean createGroup(String location, Map dataIn) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("GroupModel.createGroup " + location + " values = " + dataIn);
            debug.message("data input is " + dataIn);
        }
        boolean created = false;
        Object e = null;
        Set tmp = (Set)dataIn.get("entryName");
        String groupName = (String)tmp.iterator().next();
        location = this.appendGroupContainer(location);
        boolean bOrganization = false;
        boolean bGrpContainer = false;
        boolean bContainer = false;
        boolean bDynamic = false;
        boolean bAssDynamic = false;
        try {
            switch (this.getObjectType(location)) {
                case 4: {
                    bGrpContainer = true;
                    AMGroupContainer gc = this.getAMStoreConnection().getGroupContainer(location);
                    created = this.createGroup(gc, dataIn);
                    break;
                }
                case 2: {
                    bOrganization = true;
                    AMOrganization org = (AMOrganization)this.getAMObject(location);
                    created = this.createGroup(org, dataIn);
                    break;
                }
                case 3: {
                    bContainer = true;
                    AMOrganizationalUnit unit = (AMOrganizationalUnit)this.getAMObject(location);
                    created = this.createGroup(unit, dataIn);
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup sgroup = (AMStaticGroup)this.getAMObject(location);
                    created = this.createSubGroup(sgroup, dataIn);
                    break;
                }
                case 11: {
                    bDynamic = true;
                    AMDynamicGroup dgroup = (AMDynamicGroup)this.getAMObject(location);
                    created = this.createSubGroup(dgroup, dataIn);
                    break;
                }
                case 12: {
                    bAssDynamic = true;
                    AMAssignableDynamicGroup agroup = (AMAssignableDynamicGroup)this.getAMObject(location);
                    created = this.createSubGroup(agroup, dataIn);
                }
            }
        }
        catch (AMException ame) {
            debug.warning("create of group failed", (Throwable)ame);
            e = ame;
            String[] paramsEx = new String[]{location, groupName, this.getErrorString((Throwable)e)};
            String msgId = null;
            msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER" : (bGrpContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER" : (bDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP" : (bAssDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP" : "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP"))));
            this.logEvent(msgId, paramsEx);
        }
        catch (SSOException soe) {
            debug.warning("create of group failed", (Throwable)((Object)soe));
            e = soe;
            String[] paramsEx = new String[]{location, groupName, this.getErrorString((Throwable)e)};
            String msgId = null;
            msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER" : (bGrpContainer ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER" : (bDynamic ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP" : (bAssDynamic ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP" : "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP"))));
            this.logEvent(msgId, paramsEx);
        }
        catch (AMConsoleException ace) {
            debug.warning("create of group failed", (Throwable)ace);
            e = ace;
            String[] paramsEx = new String[]{location, groupName, this.getErrorString((Throwable)e)};
            String msgId = null;
            msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER" : (bGrpContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER" : (bDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP" : (bAssDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP" : "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP"))));
            this.logEvent(msgId, paramsEx);
        }
        if (e != null) {
            throw new AMConsoleException(this.getErrorString((Throwable)e));
        }
        return created;
    }

    private void modify(AMGroup group, Map dataIn) throws AMException, SSOException, AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("modifying group with " + dataIn);
        }
        this.validateRequiredAttributes(dataIn);
        String[] param = new String[]{group.getDN()};
        this.logEvent("ATTEMPT_DIR_MGR_MODIFY_GROUP", param);
        try {
            Set filter = (Set)dataIn.remove("filterinfo");
            if (filter != null && !filter.isEmpty()) {
                String t = (String)filter.iterator().next();
                ((AMDynamicGroup)group).setFilter(t);
            }
            group.setAttributes(dataIn);
            group.store();
            this.logEvent("SUCCEED_DIR_MGR_MODIFY_GROUP", param);
        }
        catch (AMException amc) {
            String strError = this.getErrorString(amc);
            String[] paramsEx = new String[]{group.getDN(), strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_MODIFY_GROUP", paramsEx);
            debug.warning("GroupModelImpl.modify", (Throwable)amc);
        }
    }

    private boolean createGroup(AMGroupContainer parent, Map dataIn) throws AMException, SSOException, AMConsoleException {
        boolean created = false;
        Set ns = null;
        int groupType = this.getGroupType(dataIn);
        Set tmp = (Set)dataIn.remove("entryName");
        String groupName = (String)tmp.iterator().next();
        HashSet<String> sGroupNames = new HashSet<String>(2);
        sGroupNames.add(groupName);
        String[] params = new String[]{parent.getDN(), groupName};
        this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER", params);
        switch (groupType) {
            case 9: 
            case 10: {
                try {
                    ns = parent.createStaticGroups(sGroupNames);
                    if (ns != null && !ns.isEmpty()) {
                        AMStaticGroup group = (AMStaticGroup)ns.iterator().next();
                        this.modify(group, dataIn);
                        created = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                }
                catch (IllegalArgumentException iae) {
                    this.errorMessage = this.getErrorString(iae);
                }
                break;
            }
            case 11: {
                HashMap<String, Map> dynamicGroup = new HashMap<String, Map>(1);
                dataIn.putAll(this.createMemberURL(parent.getDN(), dataIn));
                dynamicGroup.put(groupName, dataIn);
                try {
                    ns = parent.createDynamicGroups(dynamicGroup);
                    if (ns != null && !ns.isEmpty()) {
                        created = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                }
                catch (IllegalArgumentException iae) {
                    this.errorMessage = this.getErrorString(iae);
                }
                break;
            }
            case 12: {
                try {
                    ns = parent.createAssignableDynamicGroups(sGroupNames);
                    if (ns != null && !ns.isEmpty()) {
                        AMAssignableDynamicGroup adGroup = (AMAssignableDynamicGroup)ns.iterator().next();
                        this.modify(adGroup, dataIn);
                        created = true;
                        break;
                    }
                    this.errorMessage = this.getLocalizedString("createGroupFailed.message");
                    break;
                }
                catch (IllegalArgumentException iae) {
                    this.errorMessage = this.getErrorString(iae);
                }
            }
        }
        if (created) {
            this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER", params);
        } else {
            String[] paramsEx = new String[]{parent.getDN(), groupName, ""};
            this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_GRP_CONTAINER", paramsEx);
        }
        return created;
    }

    private boolean createSubGroup(AMGroup parent, Map dataIn) throws AMException, SSOException, AMConsoleException {
        Set ns = null;
        int groupType = this.getGroupType(dataIn);
        Set tmp = (Set)dataIn.remove("entryName");
        String groupName = (String)tmp.iterator().next();
        HashMap<String, Map> groupMap = new HashMap<String, Map>(2);
        boolean bDynamic = false;
        boolean bAssDynamic = false;
        String[] params = new String[]{parent.getDN(), groupName};
        switch (groupType) {
            case 9: 
            case 10: {
                Iterator iter;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP", params);
                Set sgMemberDNs = (Set)dataIn.remove("uniquemember");
                groupMap.put(groupName, dataIn);
                ns = parent.createStaticGroups(groupMap);
                if (sgMemberDNs == null || sgMemberDNs.isEmpty() || !(iter = ns.iterator()).hasNext()) break;
                AMStaticGroup sgroup = (AMStaticGroup)iter.next();
                sgroup.addUsers(sgMemberDNs);
                break;
            }
            case 11: {
                bDynamic = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP", params);
                dataIn.putAll(this.createMemberURL(parent.getDN(), dataIn));
                groupMap.put(groupName, dataIn);
                ns = parent.createDynamicGroups(groupMap);
                break;
            }
            case 12: {
                Iterator iter;
                bAssDynamic = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP", params);
                Set agMemberDNs = (Set)dataIn.remove("uniquemember");
                groupMap.put(groupName, dataIn);
                ns = parent.createAssignableDynamicGroups(groupMap);
                if (agMemberDNs == null || agMemberDNs.isEmpty() || !(iter = ns.iterator()).hasNext()) break;
                AMAssignableDynamicGroup agroup = (AMAssignableDynamicGroup)iter.next();
                agroup.addUsers(agMemberDNs);
                break;
            }
            default: {
                if (!debug.messageEnabled()) break;
                debug.message("invalid group " + groupType);
            }
        }
        if (ns == null || ns.isEmpty()) {
            String[] paramsEx = new String[]{parent.getDN(), groupName, ""};
            String msgId = null;
            msgId = bDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP" : (bAssDynamic ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP" : "SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP");
            this.logEvent(msgId, paramsEx);
            return false;
        }
        String msgId = null;
        msgId = bDynamic ? "SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_DYNAMIC_GRP" : (bAssDynamic ? "SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_ASSIGN_DYN_GRP" : "SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_STATIC_GRP");
        this.logEvent(msgId, params);
        return true;
    }

    private boolean createGroup(AMOrganization parent, Map dataIn) throws AMException, SSOException, AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("GroupModel.createGroup");
            debug.message("creating group in organization : " + parent.getDN());
        }
        Set ns = null;
        int groupType = this.getGroupType(dataIn);
        Set tmp = (Set)dataIn.remove("entryName");
        String groupName = (String)tmp.iterator().next();
        if (debug.messageEnabled()) {
            debug.message("creating group named " + groupName);
        }
        HashSet<String> sGroupNames = new HashSet<String>(1);
        sGroupNames.add(groupName);
        boolean bDynamic = false;
        boolean bAssDynamic = false;
        String[] params = new String[]{parent.getDN(), groupName};
        this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_ORG", params);
        switch (groupType) {
            case 9: 
            case 10: {
                ns = parent.createStaticGroups(sGroupNames);
                Iterator sgiter = ns.iterator();
                if (!sgiter.hasNext()) break;
                AMStaticGroup group = (AMStaticGroup)sgiter.next();
                this.modify(group, dataIn);
                break;
            }
            case 11: {
                dataIn.putAll(this.createMemberURL(parent.getDN(), dataIn));
                HashMap<String, Map> dynamicGroup = new HashMap<String, Map>(1);
                dynamicGroup.put(groupName, dataIn);
                ns = parent.createDynamicGroups(dynamicGroup);
                break;
            }
            case 12: {
                ns = parent.createAssignableDynamicGroups(sGroupNames);
                Iterator adIter = ns.iterator();
                if (!adIter.hasNext()) break;
                AMAssignableDynamicGroup adGroup = (AMAssignableDynamicGroup)adIter.next();
                this.modify(adGroup, dataIn);
                break;
            }
            default: {
                debug.message("unknown group type specified");
            }
        }
        if (ns == null || ns.isEmpty()) {
            String[] paramsEx = new String[]{parent.getDN(), groupName, ""};
            this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_ORG", paramsEx);
            return false;
        }
        this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_ORG", params);
        return true;
    }

    private boolean createGroup(AMOrganizationalUnit parent, Map dataIn) throws AMException, SSOException, AMConsoleException {
        debug.message("creating group in orgunit : " + parent.getDN());
        Set ns = null;
        Set tmp = (Set)dataIn.remove("entryName");
        String groupName = (String)tmp.iterator().next();
        HashSet<String> sGroupNames = new HashSet<String>(2);
        sGroupNames.add(groupName);
        String[] params = new String[]{parent.getDN(), groupName};
        this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER", params);
        int groupType = this.getGroupType(dataIn);
        switch (groupType) {
            case 9: 
            case 10: {
                debug.message("static group");
                ns = parent.createStaticGroups(sGroupNames);
                Iterator sgiter = ns.iterator();
                if (!sgiter.hasNext()) break;
                AMStaticGroup group = (AMStaticGroup)sgiter.next();
                this.modify(group, dataIn);
                break;
            }
            case 11: {
                debug.message("dynamic group");
                dataIn.putAll(this.createMemberURL(parent.getDN(), dataIn));
                HashMap<String, Map> dynamicGroup = new HashMap<String, Map>(1);
                dynamicGroup.put(groupName, dataIn);
                ns = parent.createDynamicGroups(dynamicGroup);
                break;
            }
            case 12: {
                debug.message("assignable group");
                ns = parent.createAssignableDynamicGroups(sGroupNames);
                Iterator adIter = ns.iterator();
                if (!adIter.hasNext()) break;
                AMAssignableDynamicGroup adGroup = (AMAssignableDynamicGroup)adIter.next();
                this.modify(adGroup, dataIn);
            }
        }
        if (ns == null || ns.isEmpty()) {
            String[] paramsEx = new String[]{parent.getDN(), groupName, ""};
            this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER", paramsEx);
            return false;
        }
        this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_UNDER_CONTAINER", params);
        return true;
    }

    private int getGroupType(Map dataIn) {
        int groupType;
        block3: {
            groupType = this.getGroupConfiguration();
            String str = (String)dataIn.remove("group");
            if (str != null && str.length() != 0) {
                try {
                    groupType = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    if (!debug.warningEnabled()) break block3;
                    debug.warning("getGroupType defaulting to " + groupType, (Throwable)e);
                }
            }
        }
        return groupType;
    }

    private Map createMemberURL(String parentDN, Map dataIn) {
        String filterInfo = null;
        if (dataIn.containsKey("logicalOp")) {
            filterInfo = this.createFilter(dataIn);
            if (debug.messageEnabled()) {
                debug.message("returned filter " + filterInfo);
            }
        } else {
            Set tmp = (Set)dataIn.remove("filterinfo");
            filterInfo = tmp == null || tmp.isEmpty() ? AdminInterfaceUtils.getNamingAttribute(9, debug) + "=*" : (String)tmp.iterator().next();
        }
        HashSet<String> attrValue = new HashSet<String>(1);
        attrValue.add("ldap:///" + parentDN + "??sub?" + filterInfo);
        HashMap<String, HashSet<String>> attrMap = new HashMap<String, HashSet<String>>(1);
        attrMap.put("memberurl", attrValue);
        return attrMap;
    }

    private String createFilter(Map dataIn) {
        Set set = (Set)dataIn.remove("logicalOp");
        String logicalOp = (String)set.iterator().next();
        HashMap filterData = new HashMap(dataIn);
        StringBuffer avPairs = new StringBuffer(100);
        Iterator iter = filterData.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Set value = (Set)dataIn.remove(key);
            if (value == null || value.isEmpty()) {
                if (!key.equals("uid")) continue;
                avPairs.append("(" + key + "=*)");
                continue;
            }
            Iterator valIter = value.iterator();
            String val = (String)valIter.next();
            if (key.equalsIgnoreCase("inetuserstatus")) {
                if (val.equalsIgnoreCase("Active")) {
                    avPairs.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                    continue;
                }
                avPairs.append("(").append("inetuserstatus").append("=").append(val).append(")");
                continue;
            }
            if (val.length() > 0) {
                avPairs.append("(").append(key).append("=").append(val).append(")");
                continue;
            }
            if (!key.equals("uid")) continue;
            avPairs.append("(uid=*)");
        }
        StringBuffer avFilter = new StringBuffer(100);
        avFilter.append("(&(objectclass=inetorgperson)");
        if (avPairs.length() != 0) {
            if (filterData.size() > 1) {
                if (logicalOp != null && logicalOp.equalsIgnoreCase("AND")) {
                    avFilter.append("(&");
                } else {
                    avFilter.append("(|");
                }
                avFilter.append(avPairs + ")");
            } else {
                avFilter.append(avPairs);
            }
        }
        avFilter.append(")");
        return avFilter.toString();
    }

    public String getManagedGroupType() {
        return Integer.toString(this.getGroupConfiguration());
    }

    private Set searchUsersInGroup(String pattern) throws AMException, SSOException {
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(1);
        this.setSearchControlLimits(searchControl);
        this.setSearchControlAttributes(searchControl, this.getValidUserAttributes(this.getSearchReturnValue()));
        String[] params = new String[]{this.amGroup.getDN(), pattern};
        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_USERS_IN_GROUP", params);
        AMSearchResults searchResults = this.amGroup.searchUsers(searchControl, this.createUserSearchFilter(pattern));
        this.logEvent("SUCCEED_DIR_MGR_SEARCH_USERS_IN_GROUP", params);
        return this.setSearchResults(searchResults);
    }

    public Set getMembers(String pattern, String groupDN) throws AMConsoleException {
        Set<String> results = Collections.EMPTY_SET;
        this.amGroup = this.getAMGroup(groupDN);
        if (this.amGroup != null) {
            boolean usersSearched = false;
            results = new HashSet();
            try {
                results = this.searchUsersInGroup(pattern);
                usersSearched = true;
                String[] params = new String[]{groupDN};
                this.logEvent("ATTEMPT_DIR_MGR_GET_NESTED_GROUPS", params);
                Set set = this.amGroup.getNestedGroupDNs();
                this.logEvent("SUCCEED_DIR_MGR_GET_NESTED_GROUPS", params);
                if (set != null && !set.isEmpty()) {
                    Iterator iter = set.iterator();
                    while (iter.hasNext()) {
                        String dn = (String)iter.next();
                        String name = AMFormatUtils.DNToName(this, dn);
                        if (!DisplayUtils.wildcardMatch(name, pattern)) continue;
                        results.add(dn);
                    }
                }
            }
            catch (SSOException ssoe) {
                String msgId = !usersSearched ? "SSO_EXCEPTION_DIR_MGR_SEARCH_USERS_IN_GROUP" : "SSO_EXCEPTION_DIR_MGR_GET_NESTED_GROUPS";
                String strError = this.getErrorString((Throwable)((Object)ssoe));
                String[] paramsEx = new String[]{groupDN, pattern, strError};
                this.logEvent(msgId, paramsEx);
                debug.warning("GroupModelImpl.getMembers", (Throwable)((Object)ssoe));
            }
            catch (AMException ame) {
                String msgId = !usersSearched ? "AM_EXCEPTION_DIR_MGR_SEARCH_USERS_IN_GROUP" : "AM_EXCEPTION_DIR_MGR_GET_NESTED_GROUPS";
                String strError = this.getErrorString(ame);
                String[] paramsEx = new String[]{groupDN, pattern, strError};
                this.logEvent(msgId, paramsEx);
                debug.warning("GroupModelImpl.getMembers", (Throwable)ame);
                throw new AMConsoleException(strError);
            }
        }
        return results;
    }

    protected String getPropertyXML(String serviceName, String subSchemaName, SchemaType type, boolean readonly) {
        debug.message("DMModeBase.getPropertyXML");
        String xml = "";
        try {
            ServiceSchema sub = this.getSubSchema(serviceName, type, subSchemaName);
            if (sub != null) {
                Set attributes = sub.getAttributeSchemas();
                if (subSchemaName.equals("Group")) {
                    Iterator it = attributes.iterator();
                    while (it.hasNext()) {
                        AttributeSchema as = (AttributeSchema)it.next();
                        if (!as.getName().equalsIgnoreCase("uniquemember")) continue;
                        it.remove();
                        break;
                    }
                }
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(sub, (AMModel)this, attributes);
                if (readonly) {
                    xmlBuilder.setAllAttributeReadOnly(true);
                }
                xml = xmlBuilder.getXML(false);
            }
        }
        catch (SSOException e) {
            debug.error("GroupModelImpl.getPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("GroupModelImpl.getPropertyXML", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.error("GroupModelImpl.getPropertyXML", (Throwable)e);
        }
        return xml;
    }

    public void removeMembers(String location, Set setDNs) throws AMConsoleException {
        if (setDNs != null && !setDNs.isEmpty()) {
            String strError;
            String DNs = AMAdminUtils.getString(setDNs, ",", false);
            String[] params = new String[]{location, DNs};
            this.logEvent("ATTEMPT_DIR_MGR_REMOVE_USERS_FROM_GROUP", params);
            HashSet<String> userDNs = new HashSet<String>(setDNs.size() * 2);
            HashSet<String> groupDNs = new HashSet<String>(setDNs.size() * 2);
            Iterator i = setDNs.iterator();
            while (i.hasNext()) {
                String dn = (String)i.next();
                if (this.isUser(dn)) {
                    userDNs.add(dn);
                    continue;
                }
                groupDNs.add(dn);
            }
            try {
                AMGroup group = this.getAMGroup(location);
                if (!groupDNs.isEmpty()) {
                    group.removeNestedGroups(groupDNs);
                }
                if (!userDNs.isEmpty()) {
                    switch (this.getObjectType(location)) {
                        case 9: 
                        case 10: {
                            ((AMStaticGroup)group).removeUsers(userDNs);
                            break;
                        }
                        case 12: {
                            ((AMAssignableDynamicGroup)group).removeUsers(userDNs);
                        }
                    }
                }
                this.logEvent("SUCCEED_DIR_MGR_REMOVE_USERS_FROM_GROUP", params);
            }
            catch (SSOException e) {
                strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{location, DNs, strError};
                this.logEvent("SSO_EXCEPTION_DIR_MGR_REMOVE_USERS_FROM_GROUP", paramsEx);
                debug.warning("GroupModel.removeMembers", (Throwable)((Object)e));
                throw new AMConsoleException(strError);
            }
            catch (AMException e) {
                strError = this.getErrorString(e);
                String[] paramsEx = new String[]{location, DNs, strError};
                this.logEvent("AM_EXCEPTION_DIR_MGR_REMOVE_USERS_FROM_GROUP", paramsEx);
                debug.warning("GroupModel.removeMembers", (Throwable)e);
                throw new AMConsoleException(strError);
            }
        }
    }

    public boolean isDynamicGroup(String dn) {
        return this.getObjectType(dn) == 11;
    }

    public boolean isUser(String dn) {
        return this.getObjectType(dn) == 1;
    }
}

