/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.dm.DMTypeBase;
import com.sun.identity.console.dm.NewUserViewBean;
import com.sun.identity.console.dm.UserGeneralViewBean;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.identity.console.dm.model.UserModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.util.DN;

public class UserViewBean
extends DMTypeBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/User.jsp";
    UserModel model = null;

    public UserViewBean() {
        super("User");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void setAddButtonState(String location) {
        if (!this.model.createUser(location)) {
            this.disableButton("tblButtonAdd", true);
        }
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        return new UserModelImpl(rc.getRequest(), this.getPageSessionAttributes());
    }

    protected Set getEntries() {
        String filter = this.getFilter();
        String location = (String)this.getPageSessionAttribute("currentOrganization");
        this.model = (UserModel)this.getModel();
        Set values = this.model.getUsers(location, filter);
        return values;
    }

    protected void populateTableModel(Set realmNames) {
        this.tblModel.clearAll();
        UserModel model = (UserModel)this.getModel();
        this.tblModel.setMaxRows(model.getPageSize());
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        DN userDN = new DN(model.getUserDN());
        if (realmNames != null && !realmNames.isEmpty()) {
            boolean firstEntry = true;
            Iterator iter = realmNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String dn = (String)iter.next();
                this.tblModel.setValue("tblDataName", (Object)model.getUserDisplayValue(dn));
                this.tblModel.setSelectionVisible(!userDN.equals(new DN(dn)));
                this.tblModel.setValue("tblDataActionHref", (Object)dn);
                this.tblModel.setValue("tblDataPath", (Object)this.getPath(model, dn));
                this.tblModel.setValue("tblDataHref", (Object)dn);
            }
            szCache.setValue((Serializable)((Object)realmNames));
        } else {
            szCache.setValue(null);
        }
    }

    protected String getTableXML() {
        return "com/sun/identity/console/tblDMUser.xml";
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        NewUserViewBean vb = (NewUserViewBean)this.getViewBean(NewUserViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        String tmp = (String)this.getDisplayFieldValue("tblDataActionHref");
        this.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)tmp));
        tmp = (String)this.getPageSessionAttribute(this.getTrackingTabIDName());
        this.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
        UserGeneralViewBean vb = (UserGeneralViewBean)this.getViewBean(UserGeneralViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected void createTableModel() {
        this.model = (UserModel)this.getModel();
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getTableXML()));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue("tblButtonAdd", (Object)"table.dm.button.new");
        this.tblModel.setActionValue("tblButtonDelete", (Object)"table.dm.button.delete");
        this.tblModel.setActionValue("tblColName", (Object)this.model.getNameColumnLabel());
        this.tblModel.setActionValue("tblColPath", (Object)"table.dm.path.column.name");
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.directorymanager.user";
    }
}

