/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.am.util.Locale;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.dm.RolePropertiesBase;
import com.sun.identity.console.dm.model.RoleModel;
import com.sun.identity.console.dm.model.RoleModelImpl;
import com.sun.identity.console.realm.ServicesEditViewBean;
import com.sun.identity.console.service.model.SCUtils;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RoleServicesViewBean
extends RolePropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/RoleServices.jsp";
    protected static final String PAGE_TITLE = "pgtitle";
    protected static final String TBL_SEARCH = "tblSearch";
    protected static final String TBL_COL_NAME = "tblColName";
    protected static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    protected static final String TBL_DATA_NAME = "tblDataName";
    protected CCActionTableModel tblModel = null;

    public RoleServicesViewBean() {
        super("RoleServices");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createTableModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGE_TITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((Map)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.populateTableModel(this.getEntries());
        this.setPageTitle("page.title.role.services");
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new RoleModelImpl(req, this.getPageSessionAttributes());
    }

    protected Map getEntries() {
        String location = (String)this.getPageSessionAttribute("currentOrganization");
        RoleModel model = (RoleModel)this.getModel();
        if (location == null) {
            location = model.getStartDSDN();
        }
        return model.getAssignedServices(location);
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/simplePageTitle.xml"));
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblRoleServices.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.dm.name.column.name");
    }

    protected void populateTableModel(Map services) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (services != null && !services.isEmpty()) {
            boolean firstEntry = true;
            Iterator i = services.keySet().iterator();
            while (i.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = (String)i.next();
                this.tblModel.setValue(TBL_DATA_NAME, services.get(name));
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)name);
            }
            szCache.setValue((Serializable)((Object)services));
        } else {
            szCache.setValue(null);
        }
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        RoleModel model;
        String serviceName = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF);
        SCUtils utils = new SCUtils(serviceName, model = (RoleModel)this.getModel());
        String propertiesViewBeanURL = utils.getServiceDisplayURL();
        if (propertiesViewBeanURL != null && propertiesViewBeanURL.trim().length() > 0) {
            String org = (String)this.getPageSessionAttribute("currentOrganization");
            if (org == null) {
                org = model.getStartDSDN();
            }
            try {
                String pageTrailID = (String)this.getPageSessionAttribute("pageTrailID");
                propertiesViewBeanURL = propertiesViewBeanURL + "?ServiceName=" + serviceName + "&Location=" + Locale.URLEncodeField(org, this.getCharset(model)) + "&Template=true&Op=" + "edit" + "&" + "pageTrailID" + "=" + pageTrailID;
                HttpServletResponse response = this.getRequestContext().getResponse();
                response.sendRedirect(propertiesViewBeanURL);
            }
            catch (UnsupportedEncodingException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            ServicesEditViewBean vb = (ServicesEditViewBean)this.getViewBean(ServicesEditViewBean.class);
            this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
            this.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.location = (String)this.getPageSessionAttribute("currentOrganization");
            vb.forwardTo(this.getRequestContext());
        }
    }
}

