/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.dm.RolePropertiesBase;
import com.sun.identity.console.dm.SearchUsersViewBean;
import com.sun.identity.console.dm.model.RoleModel;
import com.sun.identity.console.dm.model.RoleModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RoleMembersViewBean
extends RolePropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/RoleMembers.jsp";
    protected static final String TF_FILTER = "tfFilter";
    protected static final String BTN_SEARCH = "btnSearch";
    protected static final String BTN_SHOW = "btnShowMenu";
    protected static final String PAGE_TITLE = "pgtitle";
    protected static final String TBL_SEARCH = "tblSearch";
    protected static final String TBL_COL_NAME = "tblColName";
    protected static final String TBL_DATA_NAME = "tblDataName";
    protected static final String TBL_COL_PATH = "tblColPath";
    protected static final String TBL_DATA_PATH = "tblDataPath";
    protected static final String ACTION_MENU = "actionMenu";
    protected CCActionTableModel tblModel = null;
    private static final String ADD_USERS = "role.add.user";
    private static final String REMOVE_MEMBERS = "role.remove.member";
    private static final String SELECT_ACTION = "role.members.action";
    RoleModel model = null;

    public RoleMembersViewBean() {
        super("RoleMembers");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createTableModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGE_TITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(BTN_SHOW, CCButton.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.populateTableModel(this.getEntries());
        this.setMemberActions();
        this.setPageTitle("page.title.role.members");
    }

    protected AMModel getModelInternal() {
        if (this.model == null) {
            RequestContext rc = RequestManager.getRequestContext();
            this.model = new RoleModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        }
        return this.model;
    }

    protected void setMemberActions() {
        String roleName = (String)this.getPageSessionAttribute("CurrentProfileView");
        this.model = (RoleModel)this.getModel();
        if (!this.model.isFilteredRole(roleName)) {
            OptionList permList = new OptionList();
            permList.add(this.model.getLocalizedString(SELECT_ACTION), "");
            permList.add(this.model.getLocalizedString(ADD_USERS), ADD_USERS);
            permList.add(this.model.getLocalizedString(REMOVE_MEMBERS), REMOVE_MEMBERS);
            CCDropDownMenu cb = (CCDropDownMenu)this.getChild(ACTION_MENU);
            cb.setOptions(permList);
        }
    }

    protected Set getEntries() {
        Set members = Collections.EMPTY_SET;
        try {
            CCTextField tf = (CCTextField)this.getChild(TF_FILTER);
            String filter = (String)tf.getValue();
            if (filter == null || filter.length() == 0) {
                filter = "*";
            }
            String role = (String)this.getPageSessionAttribute("CurrentProfileView");
            this.model = (RoleModel)this.getModel();
            members = this.model.getMembers(role, filter);
        }
        catch (AMConsoleException a) {
            this.setInlineAlertMessage("error", "message.error", a.getMessage());
        }
        return members;
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.forwardToRoleView(event);
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblRoleMembers.xml"));
        this.model = (RoleModel)this.getModel();
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)this.model.getNameColumnLabel());
        this.tblModel.setActionValue(TBL_COL_PATH, (Object)"table.dm.path.column.name");
    }

    protected void populateTableModel(Collection members) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        this.model = (RoleModel)this.getModel();
        this.tblModel.setMaxRows(this.model.getPageSize());
        String roleName = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (this.model.isFilteredRole(roleName)) {
            this.tblModel.setSelectionType("none");
        }
        if (members != null && !members.isEmpty()) {
            ArrayList<String> cache = new ArrayList<String>(members.size() * 2);
            boolean firstEntry = true;
            boolean rowIdx = false;
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = (String)iter.next();
                this.tblModel.setValue(TBL_DATA_NAME, (Object)this.model.getUserDisplayValue(name));
                this.tblModel.setValue(TBL_DATA_PATH, (Object)this.model.getDisplayPath(name));
                cache.add(name);
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnShowMenuRequest(RequestInvocationEvent event) throws ModelControlException {
        String action = (String)this.getDisplayFieldValue(ACTION_MENU);
        if (action.equals(ADD_USERS)) {
            this.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
            SearchUsersViewBean vb = (SearchUsersViewBean)this.getViewBean(SearchUsersViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else if (action.equals(REMOVE_MEMBERS)) {
            this.removeMembers();
        } else {
            this.forwardTo();
        }
    }

    private void removeMembers() {
        this.model = (RoleModel)this.getModel();
        try {
            CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
            table.restoreStateData();
        }
        catch (ModelControlException m) {
            debug.error("RoleMembersViewBean.removeMembers ", (Throwable)m);
        }
        Integer[] selected = this.tblModel.getSelectedRows();
        if (selected.length < 1) {
            this.setInlineAlertMessage("error", "message.error", this.model.getLocalizedString("no.entries.selected"));
        } else {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            List cache = (List)szCache.getSerializedObj();
            HashSet names = new HashSet(selected.length * 2);
            for (int i = 0; i < selected.length; ++i) {
                names.add(cache.get(selected[i]));
            }
            try {
                String role = (String)this.getPageSessionAttribute("CurrentProfileView");
                this.model.removeUsers(role, names);
                String message = "message.delete.entries";
                this.setInlineAlertMessage("info", "message.information", this.model.getLocalizedString(message));
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("error", "message.error", a.getMessage());
            }
        }
        this.forwardTo();
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public boolean beginActionMenuDisplay(ChildDisplayEvent event) {
        this.model = (RoleModel)this.getModel();
        String roleName = (String)this.getPageSessionAttribute("CurrentProfileView");
        return !this.model.isFilteredRole(roleName);
    }
}

