/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.delegation;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.delegation.DelegationPropertiesViewBean;
import com.sun.identity.console.delegation.model.DelegationModel;
import com.sun.identity.console.delegation.model.DelegationModelImpl;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DelegationViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/delegation/Delegation.jsp";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_SPACER = "tblColSpacer";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_SPACER = "tblSpacer";
    private static final String TBL_DATA_UNIVERSALNAME = "tblDataUniversalName";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String PAGETITLE = "pgtitle";
    private CCActionTableModel tblModel = null;
    private boolean tblModelPopulated = false;

    public DelegationViewBean() {
        super("Delegation");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        if (!this.initialized) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createTableModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            this.populateTableModelEx();
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        DelegationModel model = (DelegationModel)this.getModel();
        this.setPageTitle(model, "page.title.delegation");
        this.tblModel.setTitle("table.delegation.title.name");
        this.tblModel.setTitleLabel("table.delegation.title.name");
        this.tblModel.setSummary("table.delegation.summary");
        this.getSubjects();
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new DelegationModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblDelegation.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.delegation.name.column.name");
    }

    private void getSubjects() {
        DelegationModel model = (DelegationModel)this.getModel();
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        if (filter == null || filter.length() == 0) {
            filter = "*";
            this.setDisplayFieldValue(TF_FILTER, "*");
        } else {
            filter = filter.trim();
        }
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            this.populateTableModel(model.getSubjects(curRealm, filter));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateTableModelEx() {
        if (!this.tblModelPopulated) {
            this.tblModelPopulated = true;
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            List cache = (List)szCache.getSerializedObj();
            if (cache != null && !cache.isEmpty()) {
                this.populateTableModel(cache);
            }
        }
    }

    private void populateTableModel(Collection DelegationNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (DelegationNames != null && !DelegationNames.isEmpty()) {
            ArrayList<String> cache = new ArrayList<String>(DelegationNames.size());
            DelegationModel model = (DelegationModel)this.getModel();
            SSOToken ssoToken = model.getUserSSOToken();
            boolean firstEntry = true;
            Iterator iter = DelegationNames.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                try {
                    AMIdentity entity = IdUtils.getIdentity(ssoToken, id);
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        this.tblModel.appendRow();
                    }
                    String name = AMFormatUtils.getIdentityDisplayName((AMModel)model, entity);
                    this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
                    this.tblModel.setValue(TBL_DATA_UNIVERSALNAME, (Object)id);
                    this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)id);
                    cache.add(id);
                }
                catch (IdRepoException e) {}
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) {
        String name = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF);
        this.setPageSessionAttribute("currentIdentity", (Serializable)((Object)name));
        DelegationPropertiesViewBean vb = (DelegationPropertiesViewBean)this.getViewBean(DelegationPropertiesViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }
}

