/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.base.model.SMSubConfig;
import com.sun.identity.console.base.model.SMSubConfigComparator;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SubConfigMeta {
    public static final String SUBCONFIG_ID_DELIMITER = "/";
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();
    private String serviceName;
    private AMModel amModel;
    ServiceConfig globalConfig;
    ServiceSchema globalSchema;
    private ResourceBundle serviceResourceBundle;
    private Set globalSubSchemaNames;
    private Map mapServiceSchemaNameToL10NName;
    private Set singleInstanceGlobalSubSchemas;
    private Set creatableGlobalSubSchemas;
    private ServiceSchema corrSchema;
    private ServiceConfig parentConfig;
    private List globalSubConfigurations;

    public SubConfigMeta(String serviceName, AMModel model) {
        this.serviceName = serviceName;
        this.amModel = model;
        this.initialize();
    }

    private void resetMeta() {
        this.globalSubSchemaNames = null;
        this.mapServiceSchemaNameToL10NName = null;
        this.singleInstanceGlobalSubSchemas = null;
        this.creatableGlobalSubSchemas = null;
        this.corrSchema = null;
        this.parentConfig = null;
        this.globalSubConfigurations = null;
    }

    public boolean hasGlobalSubSchema() {
        return this.globalSubSchemaNames != null && !this.globalSubSchemaNames.isEmpty();
    }

    public List getSubConfigurations() {
        return this.globalSubConfigurations != null ? this.globalSubConfigurations : new ArrayList();
    }

    public Map getCreateableSubSchemaNames() {
        HashMap map = new HashMap(this.creatableGlobalSubSchemas.size() * 2);
        Iterator i = this.creatableGlobalSubSchemas.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            map.put(s, this.mapServiceSchemaNameToL10NName.get(s));
        }
        return map;
    }

    public ServiceSchema getServiceSchema() {
        return this.corrSchema;
    }

    public ServiceSchema getServiceSchema(String name) throws SMSException {
        return this.corrSchema.getSubSchema(name);
    }

    public Map getServiceSchemaDefaultValues(String name) throws SMSException {
        HashMap<String, Set> defaultValues = new HashMap<String, Set>();
        ServiceSchema ss = this.corrSchema.getSubSchema(name);
        Set attributeSchemas = ss.getAttributeSchemas();
        Iterator i = attributeSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            Set values = as.getDefaultValues();
            if (values == null) continue;
            defaultValues.put(as.getName(), values);
        }
        return defaultValues;
    }

    private void initialize() {
        try {
            ServiceConfigManager mgr = new ServiceConfigManager(this.serviceName, adminSSOToken);
            this.globalConfig = mgr.getGlobalConfig(null);
            if (this.globalConfig != null) {
                ServiceSchemaManager schemaMgr = new ServiceSchemaManager(this.serviceName, adminSSOToken);
                this.globalSchema = schemaMgr.getGlobalSchema();
                String rbName = schemaMgr.getI18NFileName();
                if (rbName != null && rbName.trim().length() > 0) {
                    this.serviceResourceBundle = AMResBundleCacher.getBundle(rbName, this.amModel.getUserLocale());
                }
            }
        }
        catch (SSOException e) {
            AMModelBase.debug.error("SubConfigMeta.getGlobalSchema", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            AMModelBase.debug.error("SubConfigMeta.getGlobalSchema", (Throwable)e);
        }
    }

    private boolean validInstance() {
        return this.globalSchema != null && this.globalConfig != null && this.serviceResourceBundle != null;
    }

    public void setParentId(String parentId) {
        if (this.validInstance()) {
            this.resetMeta();
            try {
                this.getCorrespondingSchema(parentId);
                this.getSupportedGlobalSubSchema();
                if (this.globalSubSchemaNames != null && !this.globalSubSchemaNames.isEmpty()) {
                    this.creatableGlobalSubSchemas = new HashSet();
                    this.creatableGlobalSubSchemas.addAll(this.globalSubSchemaNames);
                    this.getSubConfigurationsFromConfig();
                }
            }
            catch (SSOException e) {
                AMModelBase.debug.error("SubConfigMeta.getParentId", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                AMModelBase.debug.error("SubConfigMeta.getParentId", (Throwable)e);
            }
        }
    }

    private void getSupportedGlobalSubSchema() {
        try {
            this.globalSubSchemaNames = this.corrSchema.getSubSchemaNames();
            if (this.globalSubSchemaNames != null && !this.globalSubSchemaNames.isEmpty()) {
                this.mapServiceSchemaNameToL10NName = new HashMap();
                this.singleInstanceGlobalSubSchemas = new HashSet();
                Iterator i = this.globalSubSchemaNames.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    ServiceSchema ss = this.corrSchema.getSubSchema(name);
                    String i18nKey = ss.getI18NKey();
                    if (i18nKey == null || i18nKey.trim().length() == 0) {
                        i.remove();
                        continue;
                    }
                    this.mapServiceSchemaNameToL10NName.put(name, Locale.getString((ResourceBundle)this.serviceResourceBundle, (String)i18nKey, (Debug)AMModelBase.debug));
                    if (ss.supportsMultipleConfigurations()) continue;
                    this.singleInstanceGlobalSubSchemas.add(name);
                }
            }
        }
        catch (SMSException e) {
            AMModelBase.debug.error("SubConfigMeta.getSupportedGlobalSubSchema", (Throwable)e);
        }
    }

    private void getCorrespondingSchema(String parentId) throws SSOException, SMSException {
        this.corrSchema = this.globalSchema;
        this.parentConfig = this.globalConfig;
        StringTokenizer st = new StringTokenizer(parentId, SUBCONFIG_ID_DELIMITER);
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            String configId = st.nextToken();
            configId = AMAdminUtils.replaceString(configId, "%2F", SUBCONFIG_ID_DELIMITER);
            configId = AMAdminUtils.replaceString(configId, "%25", "%");
            this.parentConfig = this.parentConfig.getSubConfig(configId);
            this.corrSchema = this.corrSchema.getSubSchema(this.parentConfig.getSchemaID());
        }
    }

    private void getSubConfigurationsFromConfig() {
        try {
            String[] params = new String[]{this.serviceName, this.parentConfig.getComponentName()};
            this.amModel.logEvent("ATTEMPT_READ_GLOBAL_SUB_CONFIGURATION_NAMES", params);
            Set names = this.parentConfig.getSubConfigNames();
            if (names != null && !names.isEmpty()) {
                Collator collator = Collator.getInstance(this.amModel.getUserLocale());
                TreeSet<SMSubConfig> set = new TreeSet<SMSubConfig>(new SMSubConfigComparator(collator));
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    ServiceConfig conf = this.parentConfig.getSubConfig(name);
                    String schemaID = conf.getSchemaID();
                    if (!this.globalSubSchemaNames.contains(schemaID)) continue;
                    String displayType = (String)this.mapServiceSchemaNameToL10NName.get(schemaID);
                    set.add(new SMSubConfig(conf.getComponentName(), name, displayType));
                    if (!this.singleInstanceGlobalSubSchemas.contains(schemaID)) continue;
                    this.creatableGlobalSubSchemas.remove(schemaID);
                }
                if (!set.isEmpty()) {
                    this.globalSubConfigurations = new ArrayList(set.size());
                    this.globalSubConfigurations.addAll(set);
                }
            }
            this.amModel.logEvent("SUCCEED_READ_GLOBAL_SUB_CONFIGURATION_NAMES", params);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), this.amModel.getErrorString((Throwable)((Object)e))};
            this.amModel.logEvent("SSO_EXCEPTION_READ_GLOBAL_SUB_CONFIGURATION_NAMES", paramsEx);
            AMModelBase.debug.error("SubConfigMeta.getSubConfigurations", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), this.amModel.getErrorString(e)};
            this.amModel.logEvent("SMS_EXCEPTION_READ_GLOBAL_SUB_CONFIGURATION_NAMES", paramsEx);
            AMModelBase.debug.error("SubConfigMeta.getSubConfigurations", (Throwable)e);
        }
    }

    public void deleteSubConfigurations(Set names) throws AMConsoleException {
        String curName = null;
        try {
            if (this.parentConfig != null) {
                String[] params = new String[3];
                params[0] = this.serviceName;
                params[1] = this.parentConfig.getComponentName();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    params[2] = curName = (String)iter.next();
                    this.amModel.logEvent("ATTEMPT_DELETE_GLOBAL_SUB_CONFIGURATION", params);
                    this.parentConfig.removeSubConfig(curName);
                    this.removeFromSubConfigList(curName);
                    this.amModel.logEvent("SUCCEED_DELETE_GLOBAL_SUB_CONFIGURATION", params);
                }
            }
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), curName, this.amModel.getErrorString((Throwable)((Object)e))};
            this.amModel.logEvent("SSO_EXCEPTION_DELETE_GLOBAL_SUB_CONFIGURATION", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), curName, this.amModel.getErrorString(e)};
            this.amModel.logEvent("SMS_EXCEPTION_DELETE_GLOBAL_SUB_CONFIGURATION", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString(e));
        }
    }

    private void removeFromSubConfigList(String name) {
        boolean removed = false;
        Iterator i = this.globalSubConfigurations.iterator();
        while (i.hasNext() && !removed) {
            SMSubConfig sc = (SMSubConfig)i.next();
            if (!sc.getName().equals(name)) continue;
            i.remove();
            removed = true;
        }
    }

    public void createSubConfig(String name, String schemaName, Map values) throws AMConsoleException {
        String[] params = new String[]{this.serviceName, this.parentConfig.getComponentName(), name, schemaName};
        try {
            this.amModel.logEvent("ATTEMPT_CREATE_GLOBAL_SUB_CONFIGURATION", params);
            this.parentConfig.addSubConfig(name, schemaName, 0, values);
            this.amModel.logEvent("SUCCEED_CREATE_GLOBAL_SUB_CONFIGURATION", params);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), name, schemaName, this.amModel.getErrorString((Throwable)((Object)e))};
            this.amModel.logEvent("SSO_EXCEPTION_CREATE_GLOBAL_SUB_CONFIGURATION", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), name, schemaName, this.amModel.getErrorString(e)};
            this.amModel.logEvent("SMS_EXCEPTION_CREATE_GLOBAL_SUB_CONFIGURATION", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString(e));
        }
    }

    public Map getSubConfigAttributeValues() throws AMConsoleException {
        String[] params = new String[]{this.serviceName, this.parentConfig.getComponentName()};
        this.amModel.logEvent("SUCCEED_READ_GLOBAL_SUB_CONFIGURATION_ATTRIBUTE_VALUES", params);
        return this.parentConfig.getAttributes();
    }

    public void setSubConfigAttributeValues(Map values) throws AMConsoleException {
        try {
            String[] params = new String[]{this.serviceName, this.parentConfig.getComponentName()};
            this.amModel.logEvent("ATTEMPT_WRITE_GLOBAL_SUB_CONFIGURATION_ATTRIBUTE_VALUES", params);
            this.parentConfig.setAttributes(values);
            this.amModel.logEvent("SUCCEED_WRITE_GLOBAL_SUB_CONFIGURATION_ATTRIBUTE_VALUES", params);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), this.amModel.getErrorString((Throwable)((Object)e))};
            this.amModel.logEvent("SSO_EXCEPTION_WRITE_GLOBAL_SUB_CONFIGURATION_ATTRIBUTE_VALU", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{this.serviceName, this.parentConfig.getComponentName(), this.amModel.getErrorString(e)};
            this.amModel.logEvent("SMS_EXCEPTION_WRITE_GLOBAL_SUB_CONFIGURATION_ATTRIBUTE_VALU", paramsEx);
            throw new AMConsoleException(this.amModel.getErrorString(e));
        }
    }
}

