/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.console.base.model.AMAdminLog;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMAttrSchemaComparator;
import com.sun.identity.console.base.model.AMAuthUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMI18NUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.base.model.AMSystemConfig;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.EncryptAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.security.AccessController;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class AMModelBase
implements AMModel {
    public static Debug debug = Debug.getInstance((String)"amConsole");
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();
    private static String LOG_PROVIDER = "Console";
    protected String locationDN = null;
    private ResourceBundle resBundle = null;
    private SSOToken ssoToken = null;
    private String userDN = null;
    protected java.util.Locale locale = null;
    private static Random random = new Random();
    private Map mapUserInfo;
    private Map consoleAttributes = null;
    private Map mapSvcSchemaMgrs = new HashMap(10);
    private String consoleJSPDirectory = null;
    private String rbName = "amConsole";
    private ISLocaleContext localeContext = new ISLocaleContext();
    private static int svcRevisionNumber;

    public AMModelBase(HttpServletRequest req) {
        this.initialize(req, null);
    }

    public AMModelBase(HttpServletRequest req, String rbName) {
        this.initialize(req, rbName);
    }

    public AMModelBase(HttpServletRequest req, String rbName, Map map) {
        this.mapUserInfo = map;
        this.initialize(req, rbName);
    }

    public AMModelBase(HttpServletRequest req, Map map) {
        this.mapUserInfo = map;
        this.initialize(req, null);
    }

    public void setLocationDN(String DN2) {
        try {
            this.locationDN = DN2 != null ? DN2 : this.getStartDSDN();
            this.ssoToken.setProperty("com-iplanet-am-console-location-dn", this.locationDN);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.setLocationDN", (Throwable)((Object)e));
        }
    }

    public String getLocationDN() {
        return this.locationDN != null ? this.locationDN : this.getStartDSDN();
    }

    protected void getUserInfo(HttpServletRequest req) {
        this.userDN = this.getUniversalID();
        this.setUserLocale(req);
        this.resBundle = AMResBundleCacher.getBundle(this.rbName, this.locale);
        this.locale = this.resBundle.getLocale();
    }

    public String getUniversalID() {
        String univId = null;
        try {
            univId = this.ssoToken.getProperty("sun.am.UniversalIdentifier");
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getUniversalID", (Throwable)((Object)e));
        }
        return univId != null ? univId : null;
    }

    public java.util.Locale getUserLocale() {
        return this.locale;
    }

    public SSOToken getUserSSOToken() {
        return this.ssoToken;
    }

    private void setUserLocale(HttpServletRequest req) {
        this.localeContext.setLocale(req);
        this.locale = this.localeContext.getLocale();
    }

    protected void initialize(HttpServletRequest req, String rbName) {
        try {
            if (rbName != null) {
                this.rbName = rbName;
            }
            this.ssoToken = AMAuthUtils.getSSOToken(req);
            this.getUserInfo(req);
            ServiceSchemaManager idRepoServiceSchemaManager = new ServiceSchemaManager(this.ssoToken, "sunIdentityRepositoryService", "1.0");
            svcRevisionNumber = idRepoServiceSchemaManager.getRevisionNumber();
        }
        catch (SMSException smse) {
            debug.warning("AMModelBase.initialize", (Throwable)smse);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.initialize", (Throwable)((Object)e));
        }
    }

    public String getClientType() {
        return AMI18NUtils.getClientType(this.ssoToken);
    }

    public String getRandomString() {
        StringBuffer sb = new StringBuffer(30);
        byte[] keyRandom = new byte[5];
        random.nextBytes(keyRandom);
        sb.append(System.currentTimeMillis());
        sb.append(Base64.encode((byte[])keyRandom));
        return sb.toString().replace('/', '.');
    }

    public String getUserDisplayAttribute() {
        String searchAttribute = null;
        Map attributes = this.getConsoleAttributes();
        Set values = (Set)attributes.get("iplanet-am-admin-console-user-return-attribute");
        if (values != null && !values.isEmpty()) {
            String tmp = (String)values.iterator().next();
            StringTokenizer tokenizer = new StringTokenizer(tmp);
            searchAttribute = tokenizer.nextToken();
        }
        return searchAttribute;
    }

    public String getUserSearchAttribute() {
        String searchAttribute = null;
        Map attributes = this.getConsoleAttributes();
        Set values = (Set)attributes.get("iplanet-am-admin-console-user-search-key");
        if (values != null && !values.isEmpty()) {
            searchAttribute = (String)values.iterator().next();
        }
        return searchAttribute;
    }

    public String getUserDN() {
        String dn = "";
        if (this.userDN != null) {
            try {
                dn = IdUtils.getDN(IdUtils.getIdentity(this.ssoToken));
            }
            catch (SSOException e) {
                debug.error("AMModelBase.getUserDN", (Throwable)((Object)e));
            }
            catch (IdRepoException e) {
                debug.error("AMModelBase.getUserDN", (Throwable)e);
            }
        }
        return dn;
    }

    public String getUserName() {
        return this.userDN;
    }

    public String getUserOrganization() {
        String orgDN = "";
        if (this.userDN != null) {
            try {
                AMIdentity amid = IdUtils.getIdentity(this.ssoToken);
                orgDN = amid.getRealm();
            }
            catch (SSOException e) {
                debug.error("AMModelBase.getUserOrganization", (Throwable)((Object)e));
            }
            catch (IdRepoException e) {
                debug.error("AMModelBase.getUserOrganization", (Throwable)e);
            }
        }
        return orgDN;
    }

    public String getErrorString(Throwable ex) {
        String message = null;
        message = ex instanceof L10NMessage ? ((L10NMessage)ex).getL10NMessage(this.locale) : ex.getMessage();
        return message;
    }

    public void logEvent(String id, String[] data) {
        try {
            LogMessageProvider provider = MessageProviderFactory.getProvider(LOG_PROVIDER);
            LogRecord rec = provider.createLogRecord(id, data, this.ssoToken);
            if (rec != null) {
                AMAdminLog.getInstance().doLog(rec);
            } else {
                debug.error("AMModelBase.logEvent: missing log entry, " + id);
            }
        }
        catch (IOException e) {
            debug.error("AMModelBase.logEvent", (Throwable)e);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public String getLocalizedString(String key) {
        return Locale.getString((ResourceBundle)this.resBundle, (String)key, (Debug)debug);
    }

    public int getPageSize() {
        int pageSize = this.getLimitAttributeValue("iplanet-am-admin-console-paging-size");
        return pageSize != -1 ? pageSize : this.getGlobalPageSize();
    }

    public String getConsoleDirectory() {
        Set jspDirectory;
        Map m;
        if (this.consoleJSPDirectory == null && (m = this.getConsoleAttributes()) != null && (jspDirectory = (Set)m.get("iplanet-am-admin-console-custom-jsp-dir")) != null && !jspDirectory.isEmpty()) {
            this.consoleJSPDirectory = (String)jspDirectory.iterator().next();
        }
        return this.consoleJSPDirectory;
    }

    protected Map getConsoleAttributes() {
        if (this.consoleAttributes == null) {
            try {
                AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, this.getStartDN());
                AMIdentity realmIdentity = repo.getRealmIdentity();
                Set servicesFromIdRepo = realmIdentity.getAssignedServices();
                if (servicesFromIdRepo.contains("iPlanetAMAdminConsoleService")) {
                    this.consoleAttributes = realmIdentity.getServiceAttributes("iPlanetAMAdminConsoleService");
                } else {
                    OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminSSOToken, this.getStartDN());
                    this.consoleAttributes = orgCfgMgr.getServiceAttributes("iPlanetAMAdminConsoleService");
                }
            }
            catch (SSOException e) {
                debug.error("AMModelBase.getConsoleAttributes", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                debug.error("AMModelBase.getConsoleAttributes", (Throwable)e);
            }
            catch (IdRepoException e) {
                debug.error("AMModelBase.getConsoleAttributes", (Throwable)e);
            }
        }
        return this.consoleAttributes;
    }

    private int getLimitAttributeValue(String attributeName) {
        Set values;
        int limit = -1;
        Map map = this.getConsoleAttributes();
        if (map != null && !map.isEmpty() && (values = (Set)map.get(attributeName)) != null && !values.isEmpty()) {
            String val = (String)values.iterator().next();
            try {
                limit = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                debug.error("AMModelBase.getLimitAttributeValue, attributeName=" + attributeName, (Throwable)e);
            }
        }
        return limit;
    }

    public int getGlobalPageSize() {
        return this.getGlobalIntegerConsoleAttribute("iplanet-am-admin-console-paging-size", SchemaType.ORGANIZATION, 1, 25);
    }

    public int getSearchResultLimit() {
        int limit = this.getLimitAttributeValue("iplanet-am-admin-console-search-limit");
        return limit != -1 ? limit : this.getGlobalSearchResultLimit();
    }

    public int getGlobalSearchResultLimit() {
        return this.getGlobalIntegerConsoleAttribute("iplanet-am-admin-console-search-limit", SchemaType.ORGANIZATION, 1, 5);
    }

    public int getSearchTimeOutLimit() {
        int limit = this.getLimitAttributeValue("iplanet-am-admin-console-search-timeout");
        return limit != -1 ? limit : this.getGlobalSearchTimeOutLimit();
    }

    public int getGlobalSearchTimeOutLimit() {
        return this.getGlobalIntegerConsoleAttribute("iplanet-am-admin-console-search-timeout", SchemaType.ORGANIZATION, 1, 5);
    }

    private int getGlobalIntegerConsoleAttribute(String attrName, SchemaType schemaType, int lowerLimit, int defaultValue) {
        int value = 0;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMAdminConsoleService", this.ssoToken);
            value = AMAdminUtils.getIntegerAttribute(mgr, schemaType, attrName);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getGlobalIntegerConsoleAttribute", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMModelBase.getGlobalIntegerConsoleAttribute", (Throwable)e);
        }
        catch (NumberFormatException e) {
            debug.warning("AMModelBase.getGlobalIntegerConsoleAttribute", (Throwable)e);
        }
        return value < lowerLimit ? defaultValue : value;
    }

    public String getLocalizedServiceName(String service) {
        return this.getLocalizedServiceName(service, service);
    }

    public String getLocalizedServiceName(String service, String defaultValue) {
        String i18nName = defaultValue;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(service, this.ssoToken);
            String rbName = mgr.getI18NFileName();
            if (rbName != null && rbName.trim().length() > 0) {
                SchemaType type;
                ServiceSchema schema;
                ResourceBundle rb = AMResBundleCacher.getBundle(rbName, this.locale);
                String i18nKey = null;
                Set types = mgr.getSchemaTypes();
                if (!types.isEmpty() && (schema = mgr.getSchema(type = (SchemaType)types.iterator().next())) != null) {
                    i18nKey = schema.getI18NKey();
                }
                if (i18nKey != null && i18nKey.length() > 0) {
                    i18nName = Locale.getString((ResourceBundle)rb, (String)i18nKey, (Debug)debug);
                }
            }
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getLocalizedServiceName", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMModelBase.getLocalizedServiceName", (Throwable)e);
        }
        catch (MissingResourceException e) {
            debug.warning("AMModelBase.getLocalizedServiceName", (Throwable)e);
        }
        return i18nName;
    }

    protected ResourceBundle getServiceResourceBundle(String serviceName) {
        ResourceBundle rb = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.ssoToken);
            String rbName = mgr.getI18NFileName();
            if (rbName != null && rbName.trim().length() > 0) {
                rb = AMResBundleCacher.getBundle(rbName, this.locale);
            }
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getServiceResourceBundle", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMModelBase.getServiceResourceBundle", (Throwable)e);
        }
        return rb;
    }

    public String getServicePropertiesViewBeanURL(String serviceName) {
        String url = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.ssoToken);
            url = mgr.getPropertiesViewBeanURL();
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getServicePropertiesViewBeanURL", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMModelBase.getServicePropertiesViewBeanURL", (Throwable)e);
        }
        return url;
    }

    public static String getLogoutURL() {
        StringBuffer url = new StringBuffer(30);
        url.append(AMSystemConfig.serverDeploymentURI).append("/UI/Logout");
        if (AMSystemConfig.isConsoleRemote) {
            url.insert(0, AMSystemConfig.serverURL);
        }
        return url.toString();
    }

    public Map getSupportedEntityTypes(String realmName) {
        HashMap<String, String> map = null;
        if (realmName == null) {
            realmName = "/";
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentityRepository repo = new AMIdentityRepository(adminToken, realmName);
            Set supportedTypes = repo.getSupportedIdTypes();
            map = new HashMap<String, String>(supportedTypes.size() * 2);
            Iterator iter = supportedTypes.iterator();
            while (iter.hasNext()) {
                IdType type = (IdType)iter.next();
                if ((type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENTGROUP) || type.equals(IdType.AGENT)) && (!type.equals(IdType.AGENT) || svcRevisionNumber >= 30)) continue;
                map.put(type.getName(), this.getLocalizedString(type.getName()));
            }
        }
        catch (IdRepoException e) {
            debug.warning("AMModelBase.getSupportedTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getSupportedTypes", (Throwable)((Object)e));
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public Map getSupportedAgentTypes() {
        HashMap<String, String> map = null;
        try {
            Set types = AgentConfiguration.getAgentTypes();
            map = new HashMap<String, String>(types.size() * 2);
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                map.put(name, this.getLocalizedString("agenttype." + name));
            }
        }
        catch (SMSException e) {
            debug.warning("AMModelBase.getSupportedTypes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getSupportedTypes", (Throwable)((Object)e));
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public String getStartDN() {
        String startDN = "/";
        try {
            startDN = DNMapper.orgNameToRealmName(this.ssoToken.getProperty("Organization"));
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getStartDN", (Throwable)((Object)e));
        }
        return startDN;
    }

    public String getStartDSDN() {
        String startDN = "/";
        try {
            startDN = this.ssoToken.getProperty("Organization");
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getStartDSDN", (Throwable)((Object)e));
        }
        return startDN;
    }

    protected Set getAttributesToDisplay(ServiceSchemaManager mgr, SchemaType schemaType, String schemaName) {
        ServiceSchema schema = null;
        try {
            schema = mgr.getSchema(schemaType);
        }
        catch (SMSException smse) {
            debug.warning("error getting schema", (Throwable)smse);
        }
        if (schema == null) {
            return Collections.EMPTY_SET;
        }
        ServiceSchema subSchema = null;
        try {
            subSchema = schema.getSubSchema(schemaName);
        }
        catch (SMSException smse) {
            debug.warning("error getting subschema", (Throwable)smse);
        }
        if (subSchema == null) {
            return Collections.EMPTY_SET;
        }
        TreeSet<AttributeSchema> attrSchemaSet = Collections.EMPTY_SET;
        Set attrSchemaNames = subSchema.getAttributeSchemaNames();
        if (attrSchemaNames != null) {
            Collator collator = Collator.getInstance(this.getUserLocale());
            attrSchemaSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
            Iterator asnIterator = attrSchemaNames.iterator();
            while (asnIterator.hasNext()) {
                String asn = (String)asnIterator.next();
                AttributeSchema attrSchema = subSchema.getAttributeSchema(asn);
                if (!this.isDisplayed(attrSchema)) continue;
                attrSchemaSet.add(attrSchema);
            }
        }
        return attrSchemaSet;
    }

    protected boolean isDisplayed(AttributeSchema attrSchema) {
        boolean displayed = true;
        if (attrSchema == null || attrSchema.getI18NKey() == null || attrSchema.getI18NKey().length() == 0) {
            displayed = false;
        }
        return displayed;
    }

    protected ServiceSchemaManager getServiceSchemaManager(String name) throws SSOException, SMSException {
        ServiceSchemaManager mgr = (ServiceSchemaManager)this.mapSvcSchemaMgrs.get(name);
        if (mgr == null) {
            mgr = new ServiceSchemaManager(name, this.getUserSSOToken());
            this.mapSvcSchemaMgrs.put(name, mgr);
        }
        return mgr;
    }

    public Set encryptString(Set values) {
        String tmp = "";
        if (!values.isEmpty()) {
            tmp = (String)values.iterator().next();
        }
        HashSet<String> rs = new HashSet<String>(2);
        rs.add((String)AccessController.doPrivileged(new EncryptAction(tmp)));
        return rs;
    }

    public static String getStartDN(HttpServletRequest req) {
        String startDN = "/";
        try {
            SSOToken token = AMAuthUtils.getSSOToken(req);
            startDN = DNMapper.orgNameToRealmName(token.getProperty("Organization"));
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getStartDN", (Throwable)((Object)e));
        }
        return startDN;
    }

    public String getAuthenticatedOrgDN() {
        return AMAuthUtils.getAuthenticatedOrgDN(this.ssoToken);
    }

    protected void validateUserStatusEntry(Map data) {
        Set h = (Set)data.get("inetuserstatus");
        if (h != null && !h.isEmpty()) {
            String tmp = (String)h.iterator().next();
            tmp = tmp.equalsIgnoreCase("Active") ? "Active" : "Inactive";
            h.clear();
            h.add(tmp);
            data.put("inetuserstatus", h);
        }
    }

    public boolean ignoreUserProfile() {
        String profile = null;
        try {
            profile = this.ssoToken.getProperty("UserProfile");
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.ignoreUserProfile", (Throwable)((Object)e));
        }
        return profile != null && profile.equals("Ignore");
    }

    public String getUserDisplayName(AMIdentity id) {
        String name = "";
        try {
            Set a = id.getAttribute(this.getUserSearchAttribute());
            if (a != null && a.size() > 0) {
                StringBuffer tmp = new StringBuffer(56);
                Iterator i = a.iterator();
                tmp.append((String)i.next());
                while (i.hasNext()) {
                    tmp.append("; ").append((String)i.next());
                }
                name = tmp.toString();
            }
        }
        catch (IdRepoException idr) {
            debug.warning("AMModelBase.getUserDisplayName ", (Throwable)idr);
        }
        catch (SSOException sso) {
            debug.warning("AMModelBase.getUserDisplayName ", (Throwable)((Object)sso));
        }
        return name.length() > 0 ? name : id.getName();
    }

    public Set getSpecialUsers(String realmName) {
        Set identities = null;
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            IdSearchResults results = repo.getSpecialIdentities(IdType.USER);
            identities = results.getSearchResults();
        }
        catch (IdRepoException e) {
            debug.warning("AMModelBase.getSpecialUsers", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("AMModelBase.getSpecialUsers", (Throwable)((Object)e));
        }
        return identities == null ? Collections.EMPTY_SET : identities;
    }

    public Set getRealmNames(String base, String filter) throws AMConsoleException {
        if (base == null || base.length() == 0) {
            base = this.getStartDN();
        }
        String[] param = new String[]{base};
        this.logEvent("ATTEMPT_GET_REALM_NAMES", param);
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), base);
            this.logEvent("SUCCEED_GET_REALM_NAMES", param);
            return this.appendBaseDN(base, orgMgr.getSubOrganizationNames(filter, true), filter);
        }
        catch (SMSException e) {
            if (e.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                HashSet<String> result = new HashSet<String>(2);
                result.add(base);
                return result;
            }
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{base, strError};
            this.logEvent("SMS_EXCEPTION_GET_REALM_NAMES", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Set appendBaseDN(String base, Set results, String filter) {
        HashSet<String> altered = new HashSet<String>();
        String displayName = null;
        if (base.equals("/")) {
            displayName = AMFormatUtils.DNToName(this, this.getStartDSDN());
        } else {
            int idx = base.lastIndexOf("/");
            String string = displayName = idx != -1 ? base.substring(idx + 1) : base;
        }
        if (DisplayUtils.wildcardMatch(displayName, filter)) {
            altered.add(base);
        }
        if (results != null && !results.isEmpty()) {
            Iterator i = results.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.charAt(0) != '/') {
                    if (base.charAt(base.length() - 1) == '/') {
                        altered.add(base + name);
                        continue;
                    }
                    altered.add(base + "/" + name);
                    continue;
                }
                if (base.charAt(base.length() - 1) == '/') {
                    altered.add(base.substring(0, base.length() - 1) + name);
                    continue;
                }
                altered.add(base + name);
            }
        }
        return altered;
    }

    public boolean isAMSDKEnabled() {
        try {
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", AMAdminUtils.getSuperAdminSSOToken());
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            Set names = orgSchema.getSubSchemaNames();
            return names != null && names.contains("amSDK");
        }
        catch (SMSException e) {
            debug.error("AMModelBase.isAMSDKEnabled", (Throwable)e);
            return false;
        }
        catch (SSOException e) {
            debug.error("AMModelBase.isAMSDKEnabled", (Throwable)((Object)e));
            return false;
        }
    }
}

