/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.sun.identity.console.base.AMAdminFrameViewBean;
import com.sun.identity.console.base.AMLogoutCommand;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.HelpConfig;
import com.sun.identity.console.base.PageTrail;
import com.sun.identity.console.base.PageTrailManager;
import com.sun.identity.console.base.model.AMCommonNameGenerator;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.idm.EndUserViewBean;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCMastheadModel;
import com.sun.web.ui.model.CCMastheadModelInterface;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import com.sun.web.ui.view.masthead.CCPrimaryMasthead;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AMPrimaryMastHeadViewBean
extends AMViewBeanBase
implements CCNodeEventHandlerInterface {
    public static final String PG_SESSION_PAGE_TRAIL_ID = "pageTrailID";
    protected static final String PG_SESSION_TAB_ID = "primaryMastHeadTabID";
    protected static Set retainPageSessionsBtwTabs = new HashSet();
    private static final String BREAD_CRUMB = "breadCrumb";
    private static final String BREAD_CRUMB_HREF = "breadCrumbHref";
    public static final String MH_COMMON = "mhCommon";
    public static final String HDR_COMMON = "hdrCommon";
    public static final String TAB_COMMON = "tabCommon";
    protected CCTabsModel tabModel = null;

    public AMPrimaryMastHeadViewBean(String name) {
        super(name);
    }

    public void setRequestContext(RequestContext rc) {
        super.setRequestContext(rc);
        String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (realmName != null) {
            this.createTabModel();
        }
    }

    public void forwardTo(RequestContext rc) {
        if (!this.handleRealmNameInTabSwitch(rc)) {
            super.forwardTo(rc);
        }
    }

    protected boolean handleRealmNameInTabSwitch(RequestContext rc) {
        boolean forwarded = false;
        String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (realmName == null) {
            String startDN = AMModelBase.getStartDN(rc.getRequest());
            this.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)startDN));
        }
        this.createTabModel();
        DelegationConfig dConfig = DelegationConfig.getInstance();
        if (!(dConfig.isUncontrolledViewBean(((Object)((Object)this)).getClass().getName()) || this.tabModel != null && this.tabModel.getNodeCount() != 0)) {
            EndUserViewBean vb = (EndUserViewBean)this.getViewBean(EndUserViewBean.class);
            vb.forwardTo(rc);
            forwarded = true;
        }
        return forwarded;
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(MH_COMMON, CCPrimaryMasthead.class);
        this.registerChild(BREAD_CRUMB, CCBreadCrumbs.class);
        this.registerChild(BREAD_CRUMB_HREF, HREF.class);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TAB_COMMON)) {
            view = new CCTabs((View)this, (CCTabsModelInterface)this.tabModel, name);
        } else if (name.equals(MH_COMMON)) {
            CCPrimaryMasthead mh = new CCPrimaryMasthead((ContainerView)this, (CCMastheadModelInterface)this.createMastheadModel(), name);
            mh.setLogoutCommand(AMLogoutCommand.class);
            mh.setUserName(this.getUserDisplayName());
            view = mh;
        } else {
            view = name.equals(BREAD_CRUMB) ? this.createBreadCrumb(name) : (name.equals(BREAD_CRUMB_HREF) ? new HREF((ContainerView)this, name, null) : super.createChild(name));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        this.beginDisplay(event, true);
    }

    protected void beginDisplay(DisplayEvent event, boolean setSelectedTabNode) throws ModelControlException {
        super.beginDisplay(event);
        String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (realmName == null) {
            String startDN = AMModelBase.getStartDN(this.getRequestContext().getRequest());
            this.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)startDN));
        }
        if (setSelectedTabNode) {
            this.setSelectedTabNode(realmName);
        }
    }

    protected void setSelectedTabNode(String realmName) {
        HttpServletRequest req = this.getRequestContext().getRequest();
        String strID = (String)this.getPageSessionAttribute(this.getTrackingTabIDName());
        int id = 1;
        if (strID == null || strID.trim().length() == 0) {
            strID = req.getParameter(this.getTrackingTabIDName());
            this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)strID));
        }
        if (strID == null || strID.trim().length() == 0) {
            id = this.getDefaultTabId(realmName, req);
        } else {
            try {
                id = Integer.parseInt(strID);
            }
            catch (NumberFormatException e) {
                AMModelBase.debug.error("AMPrimaryMastHeadVB.setSelectedTabNode", (Throwable)e);
            }
        }
        this.tabModel.clear();
        this.setPageSessionAttribute("CCTabs.SelectedTabId", (Serializable)((Object)Integer.toString(id)));
        this.tabModel.setSelectedNode(id);
    }

    protected int getDefaultTabId(String realmName, HttpServletRequest req) {
        return AMViewConfig.getInstance().getDefaultTabId(realmName, req);
    }

    private CCMastheadModel createMastheadModel() {
        HelpConfig helpConfig;
        String helpFileName;
        CCMastheadModel mm = new CCMastheadModel();
        AMModel model = this.getModel();
        String consoleDirectory = model.getConsoleDirectory();
        String logo = "../" + consoleDirectory + "/images/PrimaryProductName.png";
        mm.setSrc(logo);
        mm.setVersionProductNameSrc(logo);
        mm.setShowDate(false);
        mm.setShowServer(true);
        mm.setShowUserRole(true);
        mm.setVersionFileName("help/version.html");
        mm.setHelpType("help2");
        if (model != null) {
            mm.setHelpStatus(model.getLocalizedString("masthead.button.help.status"));
            mm.setHelpTooltip(model.getLocalizedString("masthead.button.help.tooltip"));
            mm.setHelpWindowTitle(model.getLocalizedString("help.title"));
        }
        String helpID = this.getHelpID();
        if (AMModelBase.debug.messageEnabled()) {
            String[] arg = new String[]{helpID};
            mm.setHelpTooltip(MessageFormat.format(model.getLocalizedString("masthead.button.help.tooltip.debug"), arg));
        }
        if (helpID != null && (helpFileName = (helpConfig = HelpConfig.getInstance()).getHelpFileName(helpID = helpID.toLowerCase())) != null) {
            mm.setHelpFileName(helpFileName);
            String helpAnchor = helpConfig.getHelpAnchor(helpID);
            if (helpAnchor != null) {
                mm.setHelpAnchor(helpAnchor);
            }
        }
        return mm;
    }

    private String getUserDisplayName() {
        String name = "";
        AMModel model = this.getModel();
        if (model != null) {
            String userId = model.getUserName();
            AMCommonNameGenerator gen = AMCommonNameGenerator.getInstance();
            name = gen.generateCommonName(userId, model);
        }
        return name;
    }

    protected void createTabModel() {
        String realmName;
        if (this.tabModel == null && (realmName = (String)this.getPageSessionAttribute("CurrentProfileView")) != null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            this.tabModel = amconfig.getTabsModel(realmName, this.getRequestContext().getRequest());
            this.registerChild(TAB_COMMON, CCTabs.class);
        }
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean(null, nodeID);
            this.passPgSessionMapEx((ViewBean)vb);
            vb.resetView();
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            AMModelBase.debug.error("AMPrimaryMastHeadViewBean.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    public void passPgSessionMapEx(ViewBean other) {
        Map attributes = this.getPageSessionAttributes();
        Iterator i = retainPageSessionsBtwTabs.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            other.setPageSessionAttribute(key, (Serializable)attributes.get(key));
        }
        other.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)attributes.get(this.getTrackingTabIDName()));
    }

    protected AMViewBeanBase getTabNodeAssociatedViewBean(String tabSetName, int nodeID) throws AMConsoleException {
        Object v = null;
        AMViewConfig amconfig = AMViewConfig.getInstance();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        if (curRealm == null) {
            curRealm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        AMPrimaryMastHeadViewBean vb = tabSetName == null ? (AMPrimaryMastHeadViewBean)amconfig.getTabViewBean(this, curRealm, this.getModel(), nodeID, this.getChildNodeId(nodeID)) : (AMPrimaryMastHeadViewBean)amconfig.getTabViewBean(this, curRealm, this.getModel(), tabSetName, nodeID, this.getChildNodeId(nodeID));
        this.setPageSessionAttribute(vb.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(nodeID)));
        return vb;
    }

    private int getChildNodeId(int nodeID) {
        List children;
        int childNodeId = -1;
        CCNavNodeInterface node = this.tabModel.getNodeById(nodeID);
        if (node != null && (children = node.getChildren()) != null && !children.isEmpty()) {
            CCNavNodeInterface c = (CCNavNodeInterface)children.get(0);
            childNodeId = c.getId();
        }
        return childNodeId;
    }

    protected String getTrackingTabIDName() {
        return "opensso.SelectedTabId";
    }

    protected String getHelpID() {
        String prefix = "com.sun.identity.console.";
        String suffix = "ViewBean";
        int pLen = "com.sun.identity.console.".length();
        int sLen = "ViewBean".length();
        String cName = ((Object)((Object)this)).getClass().getName();
        if (cName.startsWith("com.sun.identity.console.") && cName.endsWith("ViewBean")) {
            return cName.substring(pLen, cName.length() - sLen);
        }
        return null;
    }

    protected boolean isRootRealm(String realm, String startDN) {
        boolean isRoot = false;
        if (realm == null || realm.length() == 0 || realm.equals("/") || realm.equals(startDN)) {
            isRoot = true;
        }
        return isRoot;
    }

    private PageTrail getPageTrail() {
        String pageTrailID = this.getPageTrailID();
        PageTrailManager mgr = PageTrailManager.getInstance();
        AMModel model = this.getModel();
        return mgr.getTrail(model.getUserSSOToken(), pageTrailID);
    }

    private String getPageTrailID() {
        String pageTrailID = (String)this.getPageSessionAttribute(PG_SESSION_PAGE_TRAIL_ID);
        if (pageTrailID == null) {
            HttpServletRequest req = this.getRequestContext().getRequest();
            pageTrailID = req.getParameter(PG_SESSION_PAGE_TRAIL_ID);
            this.setPageSessionAttribute(PG_SESSION_PAGE_TRAIL_ID, (Serializable)((Object)pageTrailID));
        }
        return pageTrailID;
    }

    protected void initPageTrail() throws AMConsoleException {
        boolean swap;
        Object initPageTrail = this.getPageSessionAttribute("initPageTrail");
        boolean bl = swap = initPageTrail != null && initPageTrail.equals("2");
        if (swap) {
            initPageTrail = null;
        }
        if (initPageTrail == null) {
            String displayName;
            this.lockPageTrail();
            AMModel model = this.getModel();
            String pageTrailID = this.getPageTrailID();
            PageTrailManager mgr = PageTrailManager.getInstance();
            PageTrail trail = null;
            if (pageTrailID != null) {
                trail = mgr.getTrail(model.getUserSSOToken(), pageTrailID);
            }
            if (trail == null && !this.startPageTrail()) {
                throw new AMConsoleException("unable to get page trail");
            }
            if (trail == null) {
                trail = new PageTrail();
                pageTrailID = mgr.registerTrail(model.getUserSSOToken(), trail);
                this.setPageSessionAttribute(PG_SESSION_PAGE_TRAIL_ID, (Serializable)((Object)pageTrailID));
            }
            if ((displayName = this.getBreadCrumbDisplayName()) != null) {
                if (swap) {
                    trail.swap(displayName, ((Object)((Object)this)).getClass().getName(), this.getPageSessionAttributes());
                } else if (this.startPageTrail()) {
                    trail.set(displayName, ((Object)((Object)this)).getClass().getName(), this.getPageSessionAttributes());
                } else {
                    trail.add(displayName, ((Object)((Object)this)).getClass().getName(), this.getPageSessionAttributes());
                }
            }
        }
    }

    protected void setPageTrail(String displayName, String viewBeanClassName) {
        PageTrail trail = this.getPageTrail();
        trail.set(displayName, viewBeanClassName, this.getPageSessionAttributes());
    }

    protected void addPageTrail(String displayName, String viewBeanClassName) {
        PageTrail trail = this.getPageTrail();
        trail.add(displayName, viewBeanClassName, this.getPageSessionAttributes());
    }

    protected PageTrail.Marker backTrail() {
        PageTrail trail = this.getPageTrail();
        return trail != null ? trail.pop() : null;
    }

    private CCBreadCrumbs createBreadCrumb(String name) {
        PageTrail trail = this.getPageTrail();
        CCBreadCrumbsModel model = null;
        if (trail != null) {
            List markers = trail.getMarkers();
            int size = markers.size();
            if (size >= 1) {
                PageTrail.Marker marker = (PageTrail.Marker)markers.get(size - 1);
                model = new CCBreadCrumbsModel(marker.getDisplayName());
                model.setUseGrayBg("true");
                --size;
                for (int i = 0; i < size; ++i) {
                    marker = (PageTrail.Marker)markers.get(i);
                    model.appendRow();
                    model.setValue("label", (Object)marker.getDisplayName());
                    model.setValue("commandField", (Object)BREAD_CRUMB_HREF);
                    model.setValue("value", (Object)Integer.toString(i));
                }
            } else {
                model = new CCBreadCrumbsModel("dummy");
            }
        } else {
            model = new CCBreadCrumbsModel("dummy");
        }
        return new CCBreadCrumbs((View)this, (CCBreadCrumbsModelInterface)model, name);
    }

    protected String getBreadCrumbDisplayName() {
        return null;
    }

    protected boolean startPageTrail() {
        return true;
    }

    public void unlockPageTrail() {
        this.removePageSessionAttribute("initPageTrail");
    }

    public void unlockPageTrailForSwapping() {
        this.setPageSessionAttribute("initPageTrail", (Serializable)((Object)"2"));
    }

    public void lockPageTrail() {
        this.setPageSessionAttribute("initPageTrail", (Serializable)((Object)"1"));
    }

    public void handleBreadCrumbHrefRequest(RequestInvocationEvent event) {
        String idx = (String)this.getDisplayFieldValue(BREAD_CRUMB_HREF);
        PageTrail trail = this.getPageTrail();
        if (trail != null) {
            try {
                PageTrail.Marker marker = trail.backTo(Integer.parseInt(idx));
                try {
                    Class<?> clazz = Class.forName(marker.getViewBeanClassName());
                    AMPrimaryMastHeadViewBean vb = (AMPrimaryMastHeadViewBean)this.getViewBean(clazz);
                    this.passPgSessionMap((ViewBean)vb, marker.getPageSessionAttributeValues());
                    vb.forwardTo(this.getRequestContext());
                }
                catch (ClassNotFoundException e) {
                    this.forwardTo();
                }
            }
            catch (AMConsoleException e) {
                AMAdminFrameViewBean vb = (AMAdminFrameViewBean)this.getViewBean(AMAdminFrameViewBean.class);
                vb.forwardTo(this.getRequestContext());
            }
        } else {
            AMAdminFrameViewBean vb = (AMAdminFrameViewBean)this.getViewBean(AMAdminFrameViewBean.class);
            vb.forwardTo(this.getRequestContext());
        }
    }

    static {
        retainPageSessionsBtwTabs.add(PG_SESSION_TAB_ID);
        retainPageSessionsBtwTabs.add("currentRealm");
        retainPageSessionsBtwTabs.add("currentOrganization");
        retainPageSessionsBtwTabs.add("previousRealm");
        retainPageSessionsBtwTabs.add("entitytype");
    }
}

