/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.console.authentication.AuthConfigViewBean;
import com.sun.identity.console.authentication.CoreAttributesViewBean;
import com.sun.identity.console.authentication.EditAuthTypeViewBean;
import com.sun.identity.console.authentication.NewAuthConfigViewBean;
import com.sun.identity.console.authentication.NewAuthInstanceViewBean;
import com.sun.identity.console.authentication.model.AuthConfigurationModel;
import com.sun.identity.console.authentication.model.AuthConfigurationModelImpl;
import com.sun.identity.console.authentication.model.AuthPropertiesModel;
import com.sun.identity.console.authentication.model.AuthPropertiesModelImpl;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AuthPropertiesViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/authentication/AuthProperties.jsp";
    public static final String INSTANCE_MSG = "missingInstanceMessage";
    public static final String REALM_AUTH = "realm_authentication";
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private boolean tablePopulated = false;
    private boolean initialized = false;
    private static final String PGTITLE_TWO_BTNS = "pageTitle";
    private AMPropertySheetModel propertySheetModel;
    private static final String AUTH_INSTANCE_TABLE = "authenticationModuleInstanceTable";
    private static final String CREATE_INSTANCE_BUTTON = "createInstanceButton";
    private static final String DELETE_INSTANCE_BUTTON = "deleteInstanceButton";
    private static final String NAME_COLUMN_LABEL = "nameColumnLabel";
    private static final String NAME_COLUMN_DATA = "nameColumnData";
    private static final String NAME_COLUMN_DATA_NO_HREF = "nameColumnDataNoHref";
    private static final String TYPE_COLUMN_LABEL = "typeColumnLabel";
    private static final String TYPE_COLUMN_DATA = "typeColumnData";
    private static final String ACTION_COLUMN_LABEL = "actionColumnLabel";
    private static final String ACTION_COLUMN_HREF = "actionColumnHREF";
    private static final String ACTION_COLUMN_HREF_LABEL = "actionColumnHREFLabel";
    private static final String AUTH_CONFIG_TABLE = "authenticationConfigurationTable";
    private static final String CREATE_CONFIG_BUTTON = "createConfigButton";
    private static final String DELETE_CONFIG_BUTTON = "deleteConfigButton";
    private static final String CONFIG_NAME_COLUMN_LABEL = "configNameColumnLabel";
    private static final String CONFIG_NAME_COLUMN_DATA = "configNameColumnData";
    private static final String CONFIG_ACTION_COLUMN_LABEL = "configActionColumnLabel";
    private static final String CONFIG_ACTION_COLUMN_HREF = "configActionColumnHREF";
    private static final String CONFIG_ACTION_COLUMN_HREF_LABEL = "configActionColumnHREFLabel";
    private static final String AUTH_CONFIG = "iplanet-am-auth-org-config";
    private static final String ADMIN_AUTH_CONFIG = "iplanet-am-auth-admin-auth-module";
    private static final String INSTANCES_REMOVED = "instancesRemoved";

    public AuthPropertiesViewBean() {
        super("AuthProperties");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("CurrentProfileView")) != null) {
            this.initialized = true;
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel(realmName);
            this.createInstanceTable();
            this.createConfigurationTable();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    protected View createChild(String name) {
        if (!this.tablePopulated) {
            this.populateConfigTable();
            this.populateInstanceTable();
        }
        Object view = null;
        view = name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        String msg;
        super.beginDisplay(event);
        this.resetButtonState(DELETE_CONFIG_BUTTON);
        this.resetButtonState(DELETE_INSTANCE_BUTTON);
        AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            try {
                ps.setAttributeValues(model.getValues(), model);
                this.populateConfigTable();
                this.populateInstanceTable();
                this.populateConfigMenu();
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
            }
            this.setPageTitle(this.getModel(), "page.title.realms.authentication");
        }
        if ((msg = (String)this.removePageSessionAttribute(INSTANCE_MSG)) != null) {
            this.setInlineAlertMessage("warning", "message.warning", msg);
        }
    }

    private void populateConfigTable() {
        this.tablePopulated = true;
        CCActionTableModel tableModel = (CCActionTableModel)this.propertySheetModel.getModel(AUTH_CONFIG_TABLE);
        tableModel.clearAll();
        OrderedSet configSet = (OrderedSet)this.removePageSessionAttribute(AUTH_CONFIG_TABLE);
        if (configSet == null || configSet.isEmpty()) {
            AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
            String realm = (String)this.getPageSessionAttribute("currentRealm");
            if (realm == null || realm.length() == 0) {
                realm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
            }
            configSet = new OrderedSet();
            configSet.addAll(AuthConfigurationModelImpl.getNamedConfigurations(model.getUserSSOToken(), realm));
        }
        boolean firstEntry = true;
        Iterator i = configSet.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!firstEntry) {
                tableModel.appendRow();
            } else {
                firstEntry = false;
            }
            tableModel.setValue(CONFIG_NAME_COLUMN_DATA, (Object)name);
            tableModel.setValue(CONFIG_ACTION_COLUMN_HREF, (Object)name);
            tableModel.setValue(CONFIG_ACTION_COLUMN_HREF_LABEL, (Object)"authentication.module.instances.action.label");
        }
        this.setPageSessionAttribute(AUTH_CONFIG_TABLE, (Serializable)configSet);
    }

    private void populateConfigMenu() {
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        if (realm == null || realm.length() == 0) {
            realm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
        OrderedSet configs = new OrderedSet();
        configs.addAll(AuthConfigurationModelImpl.getNamedConfigurations(model.getUserSSOToken(), realm));
        OptionList containers = new OptionList();
        Iterator i = configs.iterator();
        while (i.hasNext()) {
            String entry = (String)i.next();
            containers.add(entry, entry);
        }
        CCDropDownMenu ac = (CCDropDownMenu)this.getChild(AUTH_CONFIG);
        ac.setOptions(containers);
        CCDropDownMenu aac = (CCDropDownMenu)this.getChild(ADMIN_AUTH_CONFIG);
        aac.setOptions(containers);
    }

    private void populateInstanceTable() {
        String name;
        this.tablePopulated = true;
        CCActionTableModel tableModel = (CCActionTableModel)this.propertySheetModel.getModel(AUTH_INSTANCE_TABLE);
        tableModel.clearAll();
        boolean firstEntry = true;
        HashMap<String, AMAuthenticationInstance> instanceMap = new HashMap<String, AMAuthenticationInstance>();
        AuthPropertiesModelImpl model = (AuthPropertiesModelImpl)this.getModel();
        Set tmp = model.getAuthInstances();
        Set removedInstances = (Set)this.removePageSessionAttribute(INSTANCES_REMOVED);
        Iterator i = tmp.iterator();
        while (i.hasNext()) {
            AMAuthenticationInstance inst = (AMAuthenticationInstance)i.next();
            name = inst.getName();
            if (removedInstances != null && removedInstances.contains(name)) continue;
            instanceMap.put(name, inst);
        }
        OrderedSet instanceSet = (OrderedSet)this.removePageSessionAttribute(AUTH_INSTANCE_TABLE);
        if (instanceSet == null) {
            instanceSet = new OrderedSet();
            instanceSet.addAll(instanceMap.keySet());
        }
        Iterator i2 = instanceSet.iterator();
        while (i2.hasNext()) {
            name = (String)i2.next();
            AMAuthenticationInstance instance = (AMAuthenticationInstance)instanceMap.get(name);
            if (instance == null) continue;
            if (!firstEntry) {
                tableModel.appendRow();
            } else {
                firstEntry = false;
            }
            String type = instance.getType();
            if (model.hasAuthAttributes(type)) {
                tableModel.setValue(NAME_COLUMN_DATA, (Object)name);
                tableModel.setValue(ACTION_COLUMN_HREF, (Object)name);
                tableModel.setValue(NAME_COLUMN_DATA_NO_HREF, (Object)"");
            } else {
                tableModel.setValue(NAME_COLUMN_DATA, (Object)"");
                tableModel.setValue(ACTION_COLUMN_HREF, (Object)name);
                tableModel.setValue(NAME_COLUMN_DATA_NO_HREF, (Object)name);
            }
            tableModel.setValue(TYPE_COLUMN_DATA, (Object)type);
        }
        this.setPageSessionAttribute(AUTH_INSTANCE_TABLE, (Serializable)instanceSet);
    }

    private AMModel getConfigModel() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new AuthConfigurationModelImpl(req, this.getPageSessionAttributes());
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new AuthPropertiesModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    private void createPropertyModel(String realmName) {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        String xmlFile = canModify ? "com/sun/identity/console/propertyRealmAuth.xml" : "com/sun/identity/console/propertyRealmAuth_Readonly.xml";
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xmlFile));
        this.propertySheetModel.clear();
    }

    private void createInstanceTable() {
        CCActionTableModel tableModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblAuthInstance.xml"));
        tableModel.setTitleLabel("label.items");
        tableModel.setActionValue(NAME_COLUMN_LABEL, (Object)"authentication.instance.table.name.column");
        tableModel.setActionValue(TYPE_COLUMN_LABEL, (Object)"authentication.instance.table.type.column");
        tableModel.setActionValue(ACTION_COLUMN_LABEL, (Object)"authentication.instance.table.action.column");
        tableModel.setActionValue(CREATE_INSTANCE_BUTTON, (Object)"authentication.instance.table.create.button");
        tableModel.setActionValue(DELETE_INSTANCE_BUTTON, (Object)"authentication.instance.table.delete.button");
        this.propertySheetModel.setModel(AUTH_INSTANCE_TABLE, tableModel);
    }

    private void createConfigurationTable() {
        CCActionTableModel tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblAuthConfiguration.xml"));
        tblModel.setTitleLabel("label.items");
        tblModel.setActionValue(CONFIG_NAME_COLUMN_LABEL, (Object)"authentication.configuration.table.name.column");
        tblModel.setActionValue(CONFIG_ACTION_COLUMN_LABEL, (Object)"authentication.configuration.table.action.column");
        tblModel.setActionValue(CREATE_CONFIG_BUTTON, (Object)"authentication.configuration.table.create.button");
        tblModel.setActionValue(DELETE_CONFIG_BUTTON, (Object)"authentication.configuration.table.delete.button");
        this.propertySheetModel.setModel(AUTH_CONFIG_TABLE, tblModel);
    }

    public void handleAdvancedOptionButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        CoreAttributesViewBean vb = (CoreAttributesViewBean)this.getViewBean(CoreAttributesViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleCreateConfigButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        NewAuthConfigViewBean vb = (NewAuthConfigViewBean)this.getViewBean(NewAuthConfigViewBean.class);
        this.removePageSessionAttribute(AUTH_CONFIG_TABLE);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleDeleteConfigButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(AUTH_CONFIG_TABLE);
        table.restoreStateData();
        CCActionTableModel tableModel = (CCActionTableModel)this.propertySheetModel.getModel(AUTH_CONFIG_TABLE);
        Integer[] selected = tableModel.getSelectedRows();
        HashSet<String> configurations = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            tableModel.setRowIndex(selected[i].intValue());
            configurations.add((String)tableModel.getValue(CONFIG_NAME_COLUMN_DATA));
        }
        try {
            AuthConfigurationModel m = (AuthConfigurationModel)this.getConfigModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            if (curRealm == null || curRealm.length() == 0) {
                curRealm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
            }
            m.deleteAuthConfiguration(curRealm, configurations);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "authentication.config.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "authentication.config.deleted.multiple");
            }
            this.removePageSessionAttribute(AUTH_CONFIG_TABLE);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleCreateInstanceButtonRequest(RequestInvocationEvent event) {
        this.removePageSessionAttribute(AUTH_INSTANCE_TABLE);
        NewAuthInstanceViewBean vb = (NewAuthInstanceViewBean)this.getViewBean(NewAuthInstanceViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleDeleteInstanceButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(AUTH_INSTANCE_TABLE);
        table.restoreStateData();
        CCActionTableModel tableModel = (CCActionTableModel)this.propertySheetModel.getModel(AUTH_INSTANCE_TABLE);
        Integer[] selected = tableModel.getSelectedRows();
        HashSet<String> instances = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            tableModel.setRowIndex(selected[i].intValue());
            instances.add((String)tableModel.getValue(NAME_COLUMN_DATA));
        }
        try {
            AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
            model.removeAuthInstance(instances);
            this.setPageSessionAttribute(INSTANCES_REMOVED, instances);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "authentication.instance.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "authentication.instance.deleted.multiple");
            }
            this.removePageSessionAttribute(AUTH_INSTANCE_TABLE);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        try {
            AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
            Map original = model.getValues();
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            model.setValues(ps.getAttributeValues(original, true, model));
            this.setInlineAlertMessage("info", "message.information", "authentication.profile.updated");
        }
        catch (AMConsoleException a) {
            this.setInlineAlertMessage("error", "message.error", a.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleActionColumnHREFRequest(RequestInvocationEvent event) throws ModelControlException {
        String type = (String)this.getDisplayFieldValue(ACTION_COLUMN_HREF);
        AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
        if (model.getServiceName(type) == null) {
            this.setPageSessionAttribute(INSTANCE_MSG, (Serializable)((Object)model.getLocalizedString("no.module.instance")));
            this.forwardTo();
        } else {
            this.setPageSessionAttribute("authServiceType", (Serializable)((Object)type));
            this.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)((String)this.getPageSessionAttribute("currentRealm"))));
            EditAuthTypeViewBean vb = (EditAuthTypeViewBean)this.getViewBean(EditAuthTypeViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    public void handleConfigActionColumnHREFRequest(RequestInvocationEvent event) throws ModelControlException {
        String name = (String)this.getDisplayFieldValue(CONFIG_ACTION_COLUMN_HREF);
        AuthConfigViewBean vb = (AuthConfigViewBean)this.getViewBean(AuthConfigViewBean.class);
        this.setPageSessionAttribute("authConfigurationEntryName", (Serializable)((Object)name));
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        String tmp = (String)this.getPageSessionAttribute("currentRealm");
        AuthPropertiesModel m = (AuthPropertiesModel)this.getModel();
        m.setCurrentRealm(tmp);
        this.removePageSessionAttribute(AUTH_INSTANCE_TABLE);
        this.removePageSessionAttribute(AUTH_CONFIG_TABLE);
        super.forwardTo(reqContext);
    }
}

