/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.agentconfig.AgentGroupMembersViewBean;
import com.sun.identity.console.agentconfig.AgentProfileViewBean;
import com.sun.identity.console.agentconfig.AgentTabManager;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.property.AgentPropertyXMLBuilder;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class GenericAgentProfileViewBean
extends AgentProfileViewBean {
    static final String DEFAULT_DISPLAY_URL = "/console/agentconfig/GenericAgentProfile.jsp";
    static final String PS_TABNAME = "agentTabName";
    static final String TAB_PREFIX = "4600";
    static final int TAB_GENERAL_ID = 4600;
    static final int TAB_GROUP_ID = 4601;
    private Set attributeSchemas;

    public GenericAgentProfileViewBean(String name) {
        super(name);
    }

    public GenericAgentProfileViewBean() {
        super("GenericAgentProfile");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void setSelectedTabNode(String realmName) {
        String strID = (String)this.getPageSessionAttribute(this.getTrackingTabIDName());
        int id = 4600;
        if (strID == null || strID.trim().length() == 0) {
            HttpServletRequest req = this.getRequestContext().getRequest();
            strID = req.getParameter(this.getTrackingTabIDName());
            this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)strID));
        }
        if (strID != null && strID.trim().length() > 0) {
            id = Integer.parseInt(strID);
            this.tabModel.clear();
            this.tabModel.setSelectedNode(id);
        }
    }

    protected AMPropertySheetModel createPropertySheetModel(String type) {
        String agentType = this.getAgentType();
        AgentsModel model = (AgentsModel)this.getModel();
        String tabName = (String)this.getPageSessionAttribute(PS_TABNAME);
        String choice = (String)this.getPageSessionAttribute("localornot");
        AgentPropertyXMLBuilder blder = null;
        try {
            if (this.isLocalConfig(agentType)) {
                agentType = "2.2_Agent";
                blder = new AgentPropertyXMLBuilder(agentType, this.isGroup, true, tabName, model);
            } else {
                blder = new AgentPropertyXMLBuilder(agentType, this.isGroup, this.is2dot2Agent(), tabName, model);
            }
            this.attributeSchemas = blder.getAttributeSchemas();
            return new AMPropertySheetModel(blder.getXML(this.inheritedPropertyNames, choice));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        catch (SMSException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        catch (SSOException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return null;
    }

    protected void setDefaultValues(String type) throws AMConsoleException {
        if (this.propertySheetModel != null) {
            AgentsModel model = (AgentsModel)this.getModel();
            String universalId = (String)this.getPageSessionAttribute("universalId");
            try {
                if (!this.submitCycle) {
                    String curRealm = (String)this.getPageSessionAttribute("currentRealm");
                    Map attrValues = model.getAttributeValues(curRealm, universalId, !this.isGroup);
                    this.propertySheetModel.clear();
                    AMPropertySheet prop = (AMPropertySheet)this.getChild("propertyAttributes");
                    prop.setAttributeValues(attrValues, model);
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.disableButton("button1", true);
            }
            Object[] uuid = new String[]{universalId};
            this.propertySheetModel.setValues("tfUUID", uuid, model);
        }
    }

    protected Map getFormValues() throws AMConsoleException, ModelControlException {
        AMPropertySheet prop = (AMPropertySheet)this.getChild("propertyAttributes");
        return prop.getAttributeValues(this.getPropertyNames());
    }

    protected HashSet getPropertyNames() {
        String agentType = this.getAgentType();
        HashSet<String> names = new HashSet<String>();
        Iterator i = this.attributeSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            names.add(as.getName());
        }
        if (this.isLocalConfig(agentType)) {
            names.remove(AgentsViewBean.DEVICE_KEY);
            names.remove(AgentsViewBean.DESCRIPTION);
        }
        return names;
    }

    protected void createTabModel() {
        String agentType = this.getAgentType();
        if (this.isLocalConfig(agentType)) {
            agentType = "2.2_Agent";
        }
        if (agentType != null) {
            super.createTabModel();
            AgentsModel model = (AgentsModel)this.getModel();
            AgentTabManager mgr = AgentTabManager.getInstance();
            List tabs = mgr.getTabs(agentType);
            if (tabs != null && !tabs.isEmpty()) {
                for (int i = 0; i < tabs.size(); ++i) {
                    String tabName = (String)tabs.get(i);
                    this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(Integer.parseInt(TAB_PREFIX + i), model.getLocalizedString("tab.label." + agentType + "." + tabName), "", ""));
                }
            } else {
                this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(4600, "tab.general", "", ""));
            }
            String group = (String)this.getPageSessionAttribute("isGroup");
            if (group != null && group.equals("true")) {
                this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(4601, "tab.group", "", ""));
            }
        }
    }

    public boolean beginBtnInheritDisplay(ChildDisplayEvent event) {
        String choice = (String)this.getPageSessionAttribute("localornot");
        return super.beginBtnInheritDisplay(event) && !this.is2dot2Agent() && !this.isLocalConfig(this.getAgentType());
    }

    public boolean beginTabCommonDisplay(ChildDisplayEvent event) {
        return this.tabModel.getNodeCount() > 1;
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        String agentType = this.getAgentType();
        AgentTabManager mgr = AgentTabManager.getInstance();
        boolean forward = false;
        if (nodeID == 4600) {
            this.removePageSessionAttribute(PS_TABNAME);
            this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(nodeID)));
        } else if (nodeID == 4601) {
            AgentGroupMembersViewBean vb = (AgentGroupMembersViewBean)this.getViewBean(AgentGroupMembersViewBean.class);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
            forward = true;
        } else {
            List tabs = mgr.getTabs(agentType);
            String strIdx = Integer.toString(nodeID);
            strIdx = strIdx.substring(TAB_PREFIX.length());
            int idx = Integer.parseInt(strIdx);
            String tabName = (String)tabs.get(idx);
            this.setPageSessionAttribute(PS_TABNAME, (Serializable)((Object)tabName));
            this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(nodeID)));
        }
        if (!forward) {
            try {
                Class clazz = AgentsViewBean.getAgentCustomizedViewBean(agentType);
                AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(clazz);
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
            catch (ClassNotFoundException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected boolean isFirstTab() {
        String agentType = this.getAgentType();
        String tabName = (String)this.getPageSessionAttribute(PS_TABNAME);
        return AgentTabManager.getInstance().isFirstTab(agentType, tabName);
    }

    protected boolean handleRealmNameInTabSwitch(RequestContext rc) {
        return false;
    }

    private boolean isLocalConfig(String agentType) {
        String choice = (String)this.getPageSessionAttribute("localornot");
        return choice != null && choice.equals("local") && (agentType.equals("WebAgent") || agentType.equals("J2EEAgent"));
    }

    protected String getAgentType() {
        return (String)this.getPageSessionAttribute("superagenttype");
    }
}

