/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.agentconfig.AgentConfigInheritViewBean;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.agentconfig.model.AgentsModelImpl;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public abstract class AgentProfileViewBean
extends AMPrimaryMastHeadViewBean {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PG_SESSION_AGENT_TAB = "pgAgentConfigTab";
    private static final String UPDATED_PROFILE = "uProfile";
    static final String UNIVERSAL_ID = "universalId";
    static final String IS_GROUP = "isGroup";
    static final String PROPERTY_UUID = "tfUUID";
    static final String CHILD_AGENT_GROUP = "agentgroup";
    static final String BTN_INHERIT = "btnInherit";
    protected CCPageTitleModel ptModel;
    protected AMPropertySheetModel propertySheetModel;
    protected boolean submitCycle;
    protected Set inheritedPropertyNames;
    protected boolean isGroup;
    protected boolean rcSet;

    AgentProfileViewBean(String pageName) {
        super(pageName);
    }

    protected void setRequestContentInitialize(RequestContext rc) {
        HttpServletRequest req = rc.getRequest();
        Map map = req.getParameterMap();
        boolean bTab = false;
        Iterator i = map.keySet().iterator();
        while (i.hasNext() && !bTab) {
            String key = (String)i.next();
            bTab = key.endsWith("tabCommon.TabHref");
        }
        if (bTab) {
            if (!this.rcSet) {
                this.rcSet = true;
                this.createTabModel();
                this.registerChild("tabCommon", CCTabs.class);
            }
        } else {
            this.initialize();
        }
    }

    protected void initialize() {
        String universalId;
        if (!this.initialized && (universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID)) != null && universalId.length() > 0) {
            this.isGroup = ((AgentsModel)this.getModel()).isAgentGroup(universalId);
            if (this.isGroup) {
                this.setPageSessionAttribute(IS_GROUP, (Serializable)((Object)"true"));
            } else {
                this.setPageSessionAttribute(IS_GROUP, (Serializable)((Object)"false"));
            }
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.createTabModel();
                this.registerChildren();
            }
        }
    }

    protected boolean createPropertyModel() {
        boolean created = false;
        String type = this.getAgentType();
        if (type != null && type.trim().length() > 0) {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            AgentsModel model = (AgentsModel)this.getModel();
            String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
            String choice = (String)this.getPageSessionAttribute("localornot");
            this.inheritedPropertyNames = this.checkAgentType(type) ? (!this.isGroup && !this.is2dot2Agent() && !choice.equals("local") ? model.getInheritedPropertyNames(curRealm, universalId) : Collections.EMPTY_SET) : (!this.isGroup && !this.is2dot2Agent() ? model.getInheritedPropertyNames(curRealm, universalId) : Collections.EMPTY_SET);
            AMPropertySheetModel psModel = this.createPropertySheetModel(type);
            if (psModel != null) {
                this.propertySheetModel = psModel;
                this.propertySheetModel.clear();
            }
            created = true;
        }
        return created;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new AgentsModelImpl(req, this.getPageSessionAttributes());
    }

    protected void registerChildren() {
        super.registerChildren();
        if (this.ptModel != null) {
            this.ptModel.registerChildren((ContainerViewBase)this);
        }
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(BTN_INHERIT, CCButton.class);
        this.registerChild("tabCommon", CCTabs.class);
        if (this.propertySheetModel != null) {
            this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
            this.propertySheetModel.registerChildren((ContainerViewBase)this);
        }
    }

    protected View createChild(String name) {
        Object view = null;
        view = this.ptModel != null && this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (name.equals("dynLink") ? new HREF((ContainerView)this, name, (Object)"") : (name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name)))));
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected String getBackButtonLabel() {
        return this.getModel().getLocalizedString("agentconfig.btn.back");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.setPropertySheetValues();
        this.setAgentTitle();
        String updated = (String)this.removePageSessionAttribute(UPDATED_PROFILE);
        if (updated != null && updated.equals("true")) {
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
    }

    protected void setPropertySheetValues() {
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        String agentType = this.getAgentType();
        AgentsModel model = (AgentsModel)this.getModel();
        try {
            this.setDefaultValues(agentType);
            String choice = (String)this.getPageSessionAttribute("localornot");
            if (this.checkAgentType(agentType)) {
                if (choice != null && !choice.equals("local") && !this.isGroup && !this.is2dot2Agent() && this.isFirstTab()) {
                    this.setProperty(model, agentType, universalId);
                }
            } else if (!this.isGroup && !this.is2dot2Agent() && this.isFirstTab()) {
                this.setProperty(model, agentType, universalId);
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.propertySheetModel.setValue(PROPERTY_UUID, universalId);
    }

    private void setProperty(AgentsModel model, String type, String universalId) throws AMConsoleException {
        HashSet groups = new HashSet();
        HashSet<String> set = new HashSet<String>(2);
        set.add(type);
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        model.getAgentGroupNames(curRealm, set, "*", groups);
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(CHILD_AGENT_GROUP);
        TreeSet<String> groupNames = new TreeSet<String>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            AMIdentity amid = (AMIdentity)i.next();
            groupNames.add(amid.getName());
        }
        OptionList optList = this.createOptionList(groupNames);
        optList.add(0, model.getLocalizedString("agentgroup.none"), "");
        menu.setOptions(optList);
        String group = model.getAgentGroup(curRealm, universalId);
        if (group != null) {
            menu.setValue((Object)group);
        }
    }

    protected void setAgentTitle() {
        AgentsModel model = (AgentsModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        try {
            String title = model.getLocalizedString("edit.agentconfig.title");
            String displayName = model.getDisplayName(universalId);
            Object[] param = new Object[]{displayName};
            this.ptModel.setPageTitleText(MessageFormat.format(title, param));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected static String getValueFromMap(Map attrValues, String name) {
        Set set = (Set)attrValues.get(name);
        return set != null && !set.isEmpty() ? (String)set.iterator().next() : "";
    }

    protected static Set putStringInSet(String value) {
        HashSet<String> set = new HashSet<String>(2);
        set.add(value);
        return set;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        boolean bRefresh = false;
        AgentsModel model = (AgentsModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        String type = this.getAgentType();
        String choice = (String)this.getPageSessionAttribute("localornot");
        try {
            String agentGroup;
            Iterator i;
            Map values = this.getFormValues();
            if (this.checkAgentType(type)) {
                if (!(this.isGroup || this.is2dot2Agent() || choice == null || choice.equals("local"))) {
                    i = this.inheritedPropertyNames.iterator();
                    while (i.hasNext()) {
                        values.remove(i.next());
                    }
                }
            } else if (!this.isGroup && !this.is2dot2Agent()) {
                i = this.inheritedPropertyNames.iterator();
                while (i.hasNext()) {
                    values.remove(i.next());
                }
            }
            model.setAttributeValues(universalId, values);
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            if (this.checkAgentType(type)) {
                if (!this.isGroup && !this.is2dot2Agent() && this.isFirstTab() && choice != null && !choice.equals("local")) {
                    agentGroup = this.getDisplayFieldStringValue(CHILD_AGENT_GROUP);
                    bRefresh = model.setGroup(curRealm, universalId, agentGroup);
                }
            } else if (!this.isGroup && !this.is2dot2Agent() && this.isFirstTab()) {
                agentGroup = this.getDisplayFieldStringValue(CHILD_AGENT_GROUP);
                bRefresh = model.setGroup(curRealm, universalId, agentGroup);
            }
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            bRefresh = false;
        }
        if (bRefresh) {
            this.setPageSessionAttribute(UPDATED_PROFILE, (Serializable)((Object)"true"));
            AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
            this.passPgSessionMap((ViewBean)vb);
            String url = this.getDefaultDisplayURL();
            int idx = url.indexOf("/", 1);
            url = ".." + url.substring(idx);
            vb.setTargetViewBeanURL(url);
            vb.forwardTo(this.getRequestContext());
        } else {
            this.forwardTo();
        }
    }

    public boolean beginBtnInheritDisplay(ChildDisplayEvent event) {
        AgentsModel model = (AgentsModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        this.disableButton(BTN_INHERIT, false);
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            String groupId = model.getAgentGroup(curRealm, universalId);
            if (groupId == null || groupId.trim().length() == 0) {
                this.disableButton(BTN_INHERIT, true);
            }
        }
        catch (AMConsoleException ex) {
            this.disableButton(BTN_INHERIT, true);
        }
        return !this.isGroup;
    }

    public void handleBtnInheritRequest(RequestInvocationEvent event) throws ModelControlException {
        AgentConfigInheritViewBean vb = (AgentConfigInheritViewBean)this.getViewBean(AgentConfigInheritViewBean.class);
        vb.setPageSessionAttribute("pgAttrConfigPage", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        vb.setPageSessionAttribute("pgAttrPropertyNames", this.getPropertyNames());
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        AgentsViewBean vb = (AgentsViewBean)this.getViewBean(AgentsViewBean.class);
        this.removePageSessionAttribute(this.getTrackingTabIDName());
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected void createTabModel() {
        this.tabModel = new CCTabsModel();
    }

    protected String getTrackingTabIDName() {
        return PG_SESSION_AGENT_TAB;
    }

    protected boolean is2dot2Agent() {
        String agentType = this.getAgentType();
        return agentType.equals("2.2_Agent");
    }

    protected boolean checkAgentType(String type) {
        return type.equals("WebAgent") || type.equals("J2EEAgent");
    }

    protected String getAgentType() {
        return (String)this.getPageSessionAttribute("superagenttype");
    }

    protected abstract boolean isFirstTab();

    protected abstract void setDefaultValues(String var1) throws AMConsoleException;

    protected abstract AMPropertySheetModel createPropertySheetModel(String var1);

    protected abstract Map getFormValues() throws AMConsoleException, ModelControlException;

    protected abstract HashSet getPropertyNames();
}

