/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.agentconfig.GenericAgentProfileViewBean;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.web.ui.model.CCPageTitleModel;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AgentGroupMembersViewBean
extends GenericAgentProfileViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/agentconfig/AgentGroupMembers.jsp";
    private static final String CHILD_MEMBERS = "txtMembers";

    public AgentGroupMembersViewBean() {
        super("AgentGroupMembers");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected boolean createPropertyModel() {
        return this.getPageSessionAttribute("agenttype") != null;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    protected void setPropertySheetValues() {
    }

    protected void setAgentTitle() {
        AgentsModel model = (AgentsModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute("universalId");
        String title = model.getLocalizedString("edit.agentconfig.group.members.title");
        try {
            String displayName = model.getDisplayName(universalId);
            Object[] param = new Object[]{displayName};
            this.ptModel.setPageTitleText(MessageFormat.format(title, param));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        AgentsModel model = (AgentsModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute("universalId");
        try {
            Set agents = model.getAgentGroupMembers(universalId);
            if (agents == null || agents.isEmpty()) {
                this.setDisplayFieldValue(CHILD_MEMBERS, model.getLocalizedString("agentconfig.group.members.nomembers"));
            } else {
                String name;
                TreeSet<String> ordered = new TreeSet<String>();
                HashMap<String, String> nameToId = new HashMap<String, String>(agents.size() * 2);
                Iterator i = agents.iterator();
                while (i.hasNext()) {
                    AMIdentity amid = (AMIdentity)i.next();
                    name = amid.getName();
                    ordered.add(name);
                    nameToId.put(name, amid.getUniversalId());
                }
                StringBuffer buff = new StringBuffer();
                Iterator i2 = ordered.iterator();
                while (i2.hasNext()) {
                    name = (String)i2.next();
                    buff.append(name).append(" (").append((String)nameToId.get(name)).append(")<br />");
                }
                this.setDisplayFieldValue(CHILD_MEMBERS, buff.toString());
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        AgentsViewBean vb = (AgentsViewBean)this.getViewBean(AgentsViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected HashSet getPropertyNames() {
        return new HashSet();
    }

    protected Map getFormValues() throws AMConsoleException, ModelControlException {
        return Collections.EMPTY_MAP;
    }

    protected AMPropertySheetModel createPropertySheetModel(String type) {
        return null;
    }

    protected void setDefaultValues(String type) throws AMConsoleException {
    }
}

