/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.realm;

import com.sun.identity.config.pojos.Realm;
import com.sun.identity.config.pojos.RealmRole;
import com.sun.identity.config.pojos.RealmUser;
import com.sun.identity.config.util.AjaxPage;
import com.sun.identity.config.util.LDAPStoreValidator;
import java.util.ArrayList;
import java.util.List;
import net.sf.click.control.ActionLink;

public class Create
extends AjaxPage {
    protected LDAPStoreValidator ldapStoreValidator = new LDAPStoreValidator(this);
    public ActionLink validateRealmNameLink = new ActionLink("validateRealmName", (Object)this, "validateRealmName");
    public ActionLink validateHostNameLink = new ActionLink("validateHostName", (Object)this, "validateHostName");
    public ActionLink validateStoreNameLink = new ActionLink("validateStoreName", (Object)this.ldapStoreValidator, "validateStoreName");
    public ActionLink validateHostLink = new ActionLink("validateHost", (Object)this.ldapStoreValidator, "validateHost");
    public ActionLink validatePortLink = new ActionLink("validatePort", (Object)this.ldapStoreValidator, "validatePort");
    public ActionLink validateLoginLink = new ActionLink("validateLogin", (Object)this.ldapStoreValidator, "validateLogin");
    public ActionLink validatePasswordLink = new ActionLink("validatePassword", (Object)this.ldapStoreValidator, "validatePassword");
    public ActionLink validateBaseDNLink = new ActionLink("validateBaseDN", (Object)this.ldapStoreValidator, "validateBaseDN");

    public boolean validateRealmName() {
        String realmName = this.toString("realmName");
        if (realmName == null) {
            this.writeJsonResponse(false, "Field required");
        } else {
            Realm realm = this.getConfigurator().getRealm(realmName);
            boolean isValid = realm == null;
            this.writeJsonResponse(isValid, isValid ? "Unique Realm name" : "The Realm name is already in use");
        }
        this.setPath(null);
        return false;
    }

    public boolean validateHostName() {
        String hostName = this.toString("hostName");
        if (hostName == null) {
            this.writeJsonResponse(false, "Field required");
        } else {
            boolean isValid = this.getConfigurator().validateHostName(hostName);
            if (isValid) {
                boolean isResolvable;
                this.writeJsonResponse(isResolvable, (isResolvable = this.getConfigurator().resolveHostName(hostName)) ? "Valid and resolvable" : "Valid but not resolvable");
            } else {
                this.writeJsonResponse(isValid, "Invalid hostname");
            }
        }
        this.setPath(null);
        return false;
    }

    public void onPost() {
        String roleName = this.toString("roleName");
        String adminsArray = this.toString("adminsArray");
        String realmUsersArray = this.toString("realmUsersArray");
        String realmName = this.toString("realmName");
        if (adminsArray != null) {
            List adminsList = this.convertToRealmUserList(adminsArray, roleName);
            this.assignAdministrators(realmName, adminsList);
        }
        if (realmUsersArray != null) {
            List realmUsersList = this.convertToRealmUserList(realmUsersArray, null);
            this.removeAdministrators(realmName, realmUsersList);
        }
    }

    protected void assignAdministrators(String realmName, List administrators) {
        Realm realm = new Realm();
        realm.setName(realmName);
        this.getConfigurator().assignAdministrators(realm, administrators);
    }

    protected void removeAdministrators(String realmName, List administrators) {
        Realm realm = new Realm();
        realm.setName(realmName);
        this.getConfigurator().removeAdministrators(realm, administrators);
    }

    protected List convertToRealmUserList(String array, String roleName) {
        ArrayList<RealmUser> result = new ArrayList<RealmUser>();
        String[] values = array.split(",");
        for (int i = 0; i < values.length; ++i) {
            String[] data = values[i].split("\\.");
            RealmRole realmRole = null;
            if (roleName != null) {
                realmRole = new RealmRole();
                realmRole.setName(roleName);
            }
            RealmUser realmUser = new RealmUser();
            realmUser.setFirstName(data[0]);
            realmUser.setLastName(data[1]);
            realmUser.setRealmRole(realmRole);
            result.add(realmUser);
        }
        return result;
    }
}

