/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.tools;

import com.sun.identity.cli.annotation.DefinitionClassInfo;
import com.sun.identity.cli.annotation.Macro;
import com.sun.identity.cli.annotation.SubCommandInfo;
import com.sun.identity.cli.tools.CLIDefinitionGenerator;
import com.sun.identity.cli.tools.StubTemplate;
import com.sun.identity.cli.tools.SubCommandStub;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DefinitionStubCreator {
    private static final String FLD_PRODUCT_NAME = "product";
    private String rbName;
    private String defClassName;
    private List subCommands = new ArrayList();

    private DefinitionStubCreator(String className) {
        this.defClassName = className;
    }

    private void createStub(String outFileName, String packageName) throws Exception {
        Class<?> defClass = Class.forName(this.defClassName);
        StubTemplate stub = new StubTemplate();
        this.getProductName(defClass, stub);
        this.getCommands(defClass, stub);
        stub.createClassFile(outFileName, packageName);
    }

    private void getProductName(Class clazz, StubTemplate stub) throws Exception {
        Field pdtField = clazz.getDeclaredField(FLD_PRODUCT_NAME);
        if (pdtField == null) {
            throw new Exception("Incorrect Definiton: missing product field");
        }
        DefinitionClassInfo classInfo = pdtField.getAnnotation(DefinitionClassInfo.class);
        stub.rbName = classInfo.resourceBundle();
        stub.logName = classInfo.logName();
    }

    private void getCommands(Class clazz, StubTemplate stub) throws Exception {
        Field[] fields;
        for (Field fld : fields = clazz.getDeclaredFields()) {
            SubCommandInfo info = fld.getAnnotation(SubCommandInfo.class);
            if (info == null) continue;
            if (info.implClassName() == null || info.description() == null) {
                throw new Exception("Incorrect Definiton: mandatory fields in command");
            }
            boolean webSupport = info.webSupport().equals("true");
            List mandatoryOptions = CLIDefinitionGenerator.toList(info.mandatoryOptions());
            List optionalOptions = CLIDefinitionGenerator.toList(info.optionalOptions());
            List optionAliases = CLIDefinitionGenerator.toList(info.optionAliases());
            if (info.macro() != null && info.macro().length() > 0) {
                Field fldMarco = clazz.getDeclaredField(info.macro());
                Macro macroInfo = fldMarco.getAnnotation(Macro.class);
                CLIDefinitionGenerator.appendToList(mandatoryOptions, macroInfo.mandatoryOptions());
                CLIDefinitionGenerator.appendToList(optionalOptions, macroInfo.optionalOptions());
                CLIDefinitionGenerator.appendToList(optionAliases, macroInfo.optionAliases());
            }
            String subcmdName = fld.getName().replace('_', '-');
            stub.subCommands.add(new SubCommandStub(subcmdName, info.implClassName(), mandatoryOptions, optionalOptions, optionAliases, webSupport));
        }
    }

    public static void main(String[] args) {
        try {
            DefinitionStubCreator creator = new DefinitionStubCreator(args[0]);
            creator.createStub(args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

